#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ CafeLog : blog.cgi - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);

# 設定ファイル認識
require './init.cgi';
%cf = set_init();

# 基本設定
read_base();

# データ受理
%in = parse_form();

# 基本処理
if ($in{tb}) { recv_tb(); }
if ($in{cm}) { recv_cm(); }
if ($in{q} ne '') { find_log(); }
error('Bad Request!');

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($tb,$buf,$pflg,%in);
	
	# TB受信 (post only)
	if ($ENV{PATH_INFO} =~ m|^/(\d+)$|) {
		$tb = $1;
	}
	
	# フォーム受信
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('Bad Request!') if ($ENV{CONTENT_LENGTH} > $cf{maxuser});
		$pflg++;
		read(STDIN,$buf,$ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	for ( split(/&/,$buf) ) {
		my ($key,$val) = split(/=/);
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
		
		# 排除
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/\r\n/\n/g;
		$val =~ s/\r/\n/g;
		
		# ハッシュ化
		$in{$key} = $val;
	}
	
	# TB
	if ($tb) {
		if (!$pflg) { die "cannot receive"; }
		$in{tb} = $tb;
	}
	
	# 返す
	return %in;
}

#-----------------------------------------------------------
#  記事検索
#-----------------------------------------------------------
sub find_log {
	require './lib/find_log.pl';
	find_list();
}

#-----------------------------------------------------------
#  Trackback受信
#-----------------------------------------------------------
sub recv_tb {
	# TB受信
	require './lib/trackback.pl';
	tb_recv();
}

#-----------------------------------------------------------
#  コメント受信
#-----------------------------------------------------------
sub recv_cm {
	# コメント受信
	require './lib/comment.pl';
	reg_com();
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $msg = shift;
	
	my $body = <<EOM;
<h3>ERROR!</h3>
<p>$msg</p>
<input type="button" onclick="history.back()" value="前画面に戻る" class="btn">
EOM

	open(IN,"$cf{datadir}/tmpl/comconf.html") or error("open err: tmpl/comconf.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s|<!-- form -->.+?<!-- /form -->|$body|s;
	$tmpl =~ s|!css!|$cf{htmlurl}/style.css|;
	$tmpl =~ s|!rss!|$cf{htmlurl}/index.xml|;
	$tmpl =~ s/!title!/エラー画面/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  ホスト取得
#-----------------------------------------------------------
sub get_host {
	# IP/ホスト取得
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};
	if (!$host or $host eq $addr) {
		$host = gethostbyaddr(pack("C4",split(/\./,$addr)),2);
	}
	$host ||= $addr;
	return ($addr,$host);
}

#-----------------------------------------------------------
#  基本設定認識	
#-----------------------------------------------------------
sub read_base {
	open(IN,"$cf{datadir}/base.dat") or error("open err: base.dat");
	while(<IN>) {
		chomp;
		my ($key,$val) = split(/\t/);
		
		$cf{$key} = $val;
	}
	close(IN);
	
	if (!$cf{page_max}) { $cf{page_max} = 5; }
	if (!$cf{tb_log_max}) { $cf{tb_log_max} = 10; }
	if (!$cf{cm_log_max}) { $cf{cm_log_max} = 10; }
}

