#┌─────────────────────────────────
#│ CafeLog : auth_axs.pl - 2021/04/18
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  アクセス認証
#-----------------------------------------------------------
sub check_auth {
	$in{id} =~ s/\W//g;
	$in{pw} =~ s/\W//g;
	
	# ログイン
	if ($in{job} eq 'login' && $in{id} ne '' && $in{pw} ne '') {
		
		if (-e "$cf{datadir}/pwd/$in{id}.lock") {
			auth_err("このログインIDは現在使用できません");
		}
		
		my ($flg,$crypt);
		open(IN,"$cf{datadir}/pass.dat");
		while(<IN>) {
			chomp;
			my ($id,$pw) = split(/\t/);
			
			if ($in{id} eq $id) {
				$flg++;
				$crypt = $pw;
				last;
			}
		}
		close(IN);
		
		if (!$flg) { auth_err("認証できません"); }
		elsif (!decrypt($crypt,$in{pw})) {
			
			if (!-e "$cf{datadir}/pwd/$in{id}.dat") {
				open(DAT,"> $cf{datadir}/pwd/$in{id}.dat");
				close(DAT);
			}
			open(DAT,"+< $cf{datadir}/pwd/$in{id}.dat");
			eval "flock(DAT,2);";
			my $kai = <DAT> + 1;
			seek(DAT,0,0);
			print DAT $kai;
			close(DAT);
			
			if ($kai >= $cf{max_failpass}) {
				rename("$cf{datadir}/pwd/$in{id}.dat","$cf{datadir}/pwd/$in{id}.lock");
				auth_err("一定回数以上間違ったログインをしたためロックしました");
			}
			
			auth_err("認証できません");
		}
		
		# ロックファイルを開放しておく
		unlink("$cf{datadir}/pwd/$in{id}.dat") if (-e "$cf{datadir}/pwd/$in{id}.dat");
		
		# 新規セッション発行
		my $ses = new CGI::Session(undef,undef,{Directory => "$cf{datadir}/ses"}) or die CGI::Session->errstr;
		
		# 有効時間は1時間
		$ses->expire(3600);
		
		# セッションID
		my $sid = $ses->id();
		$in{sid} = $sid;
		
		# 掃除
		ses_clean();
	
	# 入室画面
	} elsif ($in{sid} eq '') {
		enter_form();
	
	# 認証
	} else {
		# セッション認識
		my $ses = CGI::Session->load(undef, $in{sid}, {Directory => "$cf{datadir}/ses"});
		
		# ログアウト
		if ($in{mode} eq 'logoff') {
			$ses->delete();
			
			# 入室画面に戻る
			if ($ENV{PERLXS} eq "PerlIS") {
				print "HTTP/1.0 302 Temporary Redirection\r\n";
				print "Content-type: text/html\n";
			}
			print "Location: $cf{sysurl}/$cf{index_cgi}\n\n";
			exit;
		}
		
		# 期限切れ
		if ( $ses->is_expired or $ses->is_empty ) {
			my $data = qq|<p>[<a href="$cf{sysurl}/$cf{index_cgi}">ログインする</a>]</p>|;
			auth_err("タイムアウトです。再度ログインしてください。$data");
   		}
	}
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	header("入室画面");
	print <<EOM;
<div class="ta-c">
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="job" value="login">
		<fieldset class="login-field">
		<legend>認証画面</legend>
		<p>
			username<br>
			<input type="text" name="id" class="auth">
		</p><p>
			password<br>
			<input type="password" name="pw" class="auth">
		</p>
		<div class="login-btn">
			<input type="image" src="$cf{htmlurl}/tool/login.gif">
		</div>
		</fieldset>
</form>
<script>self.document.forms[0].id.focus();</script>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  認証エラー
#-----------------------------------------------------------
sub auth_err {
	my $msg = shift;
	
	header("認証エラー");
	print <<EOM;
<div class="ta-c" style="width:100%">
<div class="err-box ta-c">
	<p class="err-ttl">
		<img src="$cf{htmlurl}/tool/error.png" alt="error" class="icon"> ERROR!
	</p>
	<p>$msg</p>
	<p><input type="button" value="入力画面へ戻る" onclick="window.open('$cf{index_cgi}','_self')"></p>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  セッションディレクトリ掃除
#-----------------------------------------------------------
sub ses_clean {
	my $time = time;
	
	opendir(DIR,"$cf{datadir}/ses");
	while( my $dir = readdir(DIR) ) {
		next if ($dir eq '.');
		next if ($dir eq '..');
		next if ($dir eq 'index.html');
		
		# ファイル時間取得
		my $mtime = (stat("$cf{datadir}/ses/$dir"))[9];
		
		# 1時間以上経過しているファイルは削除
		unlink("$cf{datadir}/ses/$dir") if ($time - $mtime > 3600);
	}
	closedir(DIR);
}


1;

