#┌─────────────────────────────────
#│ CafeLog : comment.pl - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  コメント受信
#-----------------------------------------------------------
sub reg_com {
	# 入力チェック
	$in{cm} =~ s/\D//g;
	$in{name} =~ s/\n//g;
	$in{comment} =~ s/\n+$//g;
	if ($in{name} eq '' or $in{comment} eq '') {
		error('名前又はコメントが未入力です');
	}
	
	# 記事データの存在を確認
	if (!$in{cm} or !-e "$cf{htmldir}/archives/art/$in{cm}.html") {
		error('コメントは受付できません');
	}
	
	# 受け入れチェック
	my ($sub,$host) = check_recv();
	
	# 確認画面
	if ($in{job} ne 'reg') {
		# 改行はタブにしておく
		$in{comment} =~ s/\t/ /g;
		$in{comment} =~ s/\n/\t/g;
		
		# 確認画面表示
		conf_form();
	
	# 受け付け
	} else {
		$in{comment} =~ s|\t|<br>|g;
	}
	
	# 認証画像
	require $cf{captcha_pl};
	if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
		error("画像認証が入力不備です。<br>投稿フォームに戻って再読込み後、再入力してください");
	}
	
	# 投稿キーチェック
	# -1 : キー不一致
	#  0 : 制限時間オーバー
	#  1 : キー一致
	my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
	if ($chk == 0) {
		error("画像認証が制限時間を超過しました。<br>投稿フォームに戻って再読込み後指定の数字を再入力してください");
	} elsif ($chk == -1) {
		error("画像認証が不正です。<br>投稿フォームに戻って再読込み後再入力してください");
	}
	
	# 時間取得
	my $time = time;
	
	# 一時ファイル書込み
	my $flg;
	open(DB,"+< $cf{datadir}/cm.tmp") or error("open err: cm.tmp");
	eval "flock(DB,2);";
	while(<DB>) {
		my (undef,$num,undef,$hos,$nam,undef,$url,$com) = split(/\t/);
		chomp($com);
		
		if ($in{cm} == $num && $hos eq $host && $in{name} eq $nam && $url eq $in{url} && $com eq $in{comment}) {
			$flg++;
			last;
		}
	}
	if ($flg) {
		close(DB);
		error('二重投稿です');
	}
	seek(DB,0,2);
	print DB "$time\t$in{cm}\t$sub\t$host\t$in{name}\t\t$in{url}\t$in{comment}\n";
	truncate(DB,tell(DB));
	close(DB);
	
	# メール通知
	mail_to($sub,$host) if ($cf{mailing});
	
	# 完了画面
	message('コメントを受理しました。管理者の承認後に表示されます。');
}

#-----------------------------------------------------------
#  確認画面
#-----------------------------------------------------------
sub conf_form {
	# 画像認証作成
	require $cf{captcha_pl};
	my ($str_plain,$str_crypt) = cap::make($cf{captcha_key},$cf{cap_len});
	
	# 表示用メッセージ
	my $comment = $in{comment};
	$comment =~ s|\t|<br>|g;
	
	open(IN,"$cf{datadir}/tmpl/comconf.html") or error("open err: tmpl/comconf.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(blog_cgi|captcha_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!(cm|name|url|comment)!/$in{$1}/g;
	$tmpl =~ s/!com!/$comment/g;
	$tmpl =~ s/!str_crypt!/$str_crypt/g;
	$tmpl =~ s|!css!|$cf{htmlurl}/style.css|;
	$tmpl =~ s|!rss!|$cf{htmlurl}/index.xml|;
	$tmpl =~ s/!title!/コメント確認/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  受け入れチェック
#-----------------------------------------------------------
sub check_recv {
	# 日本語チェック
	if ($cf{jp_word_chk}) {
		if ($in{comment} !~ /(?:[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/x) {
			error("本文に日本語が含まれていません");
		}
	}
	
	# 禁止ワードチェック
	my $flg;
	for ( split(/\s+/,$cf{bad_word}) ) {
		if (index($in{comment},$_) >= 0) {
			$flg++;
			last;
		}
	}
	if ($flg) { error('コメントは受付できません!'); }
	
	# ホストチェック
	my ($addr,$host) = get_host();
	my $flg;
	for ( split(/\s+/,$cf{bad_host}) ) {
		if (index($host,$_) >= 0 or index($addr,$_) >= 0) {
			$flg++;
			last;
		}
	}
	if ($flg) { error('コメントは受付できません!!'); }
	
	# コメント受け入れ可能か
	my ($flg,$sub);
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		my ($no,$date,$time,$ttl,$open,$cat,$tb,$cm) = split(/\t/);
		
		if ($in{cm} == $no && $cm == 1) {
			$sub = $ttl;
			$flg++;
			last;
		}
	}
	close(IN);
	
	# 該当番号なし
	if (!$flg) { error('コメントは受付できません'); }
	
	# indexにて最大数をチェック
	my $cmnum;
	open(DB,"$cf{datadir}/tbcm.dat") or error('open err: tbcm.dat');
	while(<DB>) {
		my ($no,$tb,$cm) = split(/\t/);
		
		if ($in{cm} == $no) {
			chomp($cm);
			$cmnum = $cm;
			last;
		}
	}
	close(DB);
	
	# 超過
	if ($cf{cm_log_max} <= $cmnum) {
		error('コメントはこれ以上受け付けできません');
	}
	
	# 元記事名を返す
	return ($sub,$host);
}

#-----------------------------------------------------------
#  完了画面
#-----------------------------------------------------------
sub message {
	my $msg = shift;
	
	my $body = <<EOM;
<p>$msg</p>
<p><input type="button" value="TOPへ戻る" onclick="window.open('$cf{htmlurl}/index.html','_self')"></p>
EOM

	open(IN,"$cf{datadir}/tmpl/comconf.html") or error("open err: tmpl/comconf.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s|<!-- form -->.+?<!-- /form -->|$body|s;
	$tmpl =~ s|!css!|$cf{htmlurl}/style.css|;
	$tmpl =~ s|!rss!|$cf{htmlurl}/index.xml|;
	$tmpl =~ s/!title!/完了メッセージ/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  メール通知
#-----------------------------------------------------------
sub mail_to {
	my ($sub,$host) = @_;
	
	# 時間
	my $date = chg_date(time);
	
	# 本文
	my $body = <<EOM;
$cf{title}にコメントの受信がありましたので、お知らせします。
管理画面にログインして承認の可否を行ってください。

投稿日時 : $date
対象記事 : $sub
ホスト名 : $host

おなまえ : $in{name}
参照URL  : $in{url}

$in{comment}
EOM

	# 通知
	require './lib/sendmail.pl';
	sendmail("コメント連絡",$body);
}



1;

