#┌─────────────────────────────────
#│ CafeLog : tbcm_add.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール
use File::ReadBackwards;

#-----------------------------------------------------------
#  コメント/TB承認
#-----------------------------------------------------------
sub tbcm_add {
	# POP-UP
	if ($in{det}) { detail_data(); }
	
	# 処理
	my $job = $in{job} ne '' ? $in{job} : 'cm';
	
	my %key;
	if ($job eq 'cm') {
		$key{ttl} = 'コメント';
		$key{ico} = 'com.png';
		$key{tmp} = "$cf{datadir}/cm.tmp";
	} else {
		$key{ttl} = 'トラックバック';
		$key{ico} = 'tb.png';
		$key{tmp} = "$cf{datadir}/tb.tmp";
	}
	
	# 処理
	my ($add,$del);
	for ( keys %in ) {
		if (/^add:(\d+)/) {
			$add = $1;
			last;
		} elsif (/^del:(\d+)/) {
			$del = $1;
			last;
		}
	}
	if ($add) { add_data($add,$key{tmp},$job); }
	elsif ($del) { del_data($del,$key{tmp}); }
	
	# 画面表示
	header("$key{ttl}承認");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<div id="tog-btn">
<form action="#" name="selform">
コメント/TB切替：
<select name="mode" onchange="if(document.selform.mode.value)location.href=document.selform.mode.value;">
EOM

	my %nam = (cm => 'コメント承認', tb => 'トラックバック承認');
	for (qw(cm tb)) {
		if ($job eq $_) {
			print qq|<option value="$cf{index_cgi}?tbcm_add=1&job=$_&sid=$in{sid}" selected>$nam{$_}\n|;
		} else {
			print qq|<option value="$cf{index_cgi}?tbcm_add=1&job=$_&sid=$in{sid}">$nam{$_}\n|;
		}
	}
	
	print <<EOM;
</select>
</form>
</div>
<p class="ttl"><img src="$cf{htmlurl}/tool/$key{ico}" class="icon"> $key{ttl}承認</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="tbcm_add" value="1">
<input type="hidden" name="job" value="$job">
<p>・ 承認又は削除ボタンを押してください。</p>
<table class="list">
<tr>
	<th>処理</th>
	<th>投稿日</th>
	<th>元記事</th>
	<th>名前</th>
	<th>内容</th>
	<th>ホスト</th>
</tr>
EOM

	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my $i;
	my $bw = File::ReadBackwards->new( $key{tmp} ) or error("open err: $key{tmp}");
	while( defined( my $log = $bw->readline ) ) {
		chomp($log);
		my ($time,$num,$sub,$host,$name,$ttl,$url,$com) = split(/\t/,$log);
		$name = qq|<a href="$url" target="_blank">$name</a>| if ($url);
		
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{list_max});
		
		print qq|<tr><td class="ws-no"><input type="submit" name="add:$time" value="承認" onclick="return confirm('承認しますか？');">\n|;
		print qq|<input type="submit" name="del:$time" value="削除" onclick="return confirm('削除しますか？');"></td>|;
		print qq|<td>| . chg_date($time,'s') . qq|</td>|;
		print qq|<td><a href="$cf{htmlurl}/archives/art/$num.html" target="_blank">| . cut_str($sub,20) . qq|</a></td>|;
		print qq|<td><b>$name</b></td>|;
		print qq|<td class="w-350"><input type="button" value="全文" onclick="window.open('$cf{index_cgi}?tbcm_add=1&det=$time&job=$job&sid=$in{sid}','pop','width=450,height=450,scrollbars=1');">\n| . cut_str($com,25) . qq|</td>|;
		print qq|<td>$host</td></tr>\n|;
	}
	
	if (!$i) {
		print qq|<tr><td colspan="6" class="ta-c">該当データはありません</td></tr>\n|;
	}
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,$job);
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  TB/コメント削除
#-----------------------------------------------------------
sub del_data {
	my ($del,$tmp) = @_;
	
	# 一時ファイルから削除
	my @log;
	open(DB,"+< $tmp");
	while(<DB>) {
		my ($time) = (split(/\t/))[0];
		next if ($del == $time);
		
		push(@log,$_);
	}
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
}

#-----------------------------------------------------------
#  TB/コメント承認
#-----------------------------------------------------------
sub add_data {
	my ($add,$tmp,$job) = @_;
	
	# 一時ファイルから削除
	my ($log,@log);
	open(DB,"+< $tmp");
	eval "flock(DB,2);";
	while(<DB>) {
		my ($time) = (split(/\t/))[0];
		
		if ($add == $time) {
			$log = $_;
			next;
		}
		push(@log,$_);
	}
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
	
	# 新規データ分解
	chomp($log);
	my ($tim,$num,$sub,$host,$nam,$ttl,$url,$msg) = split(/\t/,$log);
	
	# --- 切替
	my ($file,$tmpl);
	if ($job eq 'cm') {
		$file = "com/$num.txt";
		$tmpl = "$cf{datadir}/tmpl/comment.html";
	} else {
		$file = "tb/$num.txt";
		$tmpl = "$cf{datadir}/tmpl/trackback.html";
	}
	
	# テンプレート読込
	open(IN,"$tmpl");
	my $loop = join('',<IN>);
	close(IN);
	
	if (!-e "$cf{datadir}/$file") {
		open(DB,"> $cf{datadir}/$file");
		close(DB);
	}
	
	# データ更新
	my $list;
	@log = ();
	open(DB,"+< $cf{datadir}/$file");
	eval "flock(DB,2);";
	
	# 追加ファイル
	push(@log,"$tim\t$nam\t$ttl\t$url\t$msg\t$host\n");
	$nam = qq|<a href="$url" target="_blank">$nam</a>| if ($url);
	
	my $tmp = $loop;
	$tmp =~ s/!(name|blog_name)!/$nam/g;
	$tmp =~ s/!(date)!/chg_date($tim)/eg;
	$tmp =~ s/!(message|excerpt)!/$msg/g;
	$tmp =~ s/!title!/$ttl/g;
	$list .= $tmp;
	
	# 展開
	while(<DB>) {
		my ($tim,$nam,$ttl,$url,$msg,$host) = split(/\t/);
		$nam = qq|<a href="$url" target="_blank">$nam</a>| if ($url);
		
		my $tmp = $loop;
		$tmp =~ s/!date!/chg_date($tim)/eg;
		$tmp =~ s/!(name|blog_name)!/$nam/g;
		$tmp =~ s/!(message|excerpt)!/$msg/g;
		$tmp =~ s/!title!/$ttl/g;
		$list .= $tmp;
		
		push(@log,$_);
	}
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
	
	# 総数
	my $all = @log;
	
	# index更新
	my $flg;
	@log = ();
	open(DB,"+< $cf{datadir}/tbcm.dat");
	eval "flock(DB,2);";
	while(<DB>) {
		chomp;
		my ($no,$tb,$cm) = split(/\t/);
		
		if ($num == $no) {
			$flg++;
			if ($job eq 'cm') {
				$_ = "$no\t$tb\t$all";
			} else {
				$_ = "$no\t$all\t$cm";
			}
		}
		push(@log,"$_\n");
	}
	
	# 新規
	if (!$flg) {
		my ($tb,$cm) = $job eq 'cm' ? (0,$all) : ($all,0);
		push(@log,"$num\t$tb\t$cm\n");
	}
	
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
	
	# 固定リンクファイル更新
	open(DB,"+< $cf{htmldir}/archives/art/$num.html");
	eval "flock(DB,2);";
	my $html = join('',<DB>);
	
	# COM
	if ($job eq 'cm') {
		$html =~ s/(<!-- cmlink -->.*)\(\d+\)(.*<!-- cmlink -->)/$1($all)$2/s;
		$html =~ s/(<!-- com_list -->).*(<!-- com_list -->)/$1 . $list . $2/se;
	# TB
	} else {
		$html =~ s/(<!-- tblink -->.*)\(\d+\)(.*<!-- tblink -->)/$1($all)$2/s;
		$html =~ s/(<!-- tb_list -->).*(<!-- tb_list -->)/$1 . $list . $2/se;
	}
	
	seek(DB,0,0);
	print DB $html;
	truncate(DB,tell(DB));
	close(DB);
	
	# 関連ファイルindex
	my $idx;
	open(IN,"$cf{datadir}/index.dat");
	while(<IN>) {
		my ($no) = split(/\t/);
		
		if ($num == $no) {
			chomp;
			$idx = $_;
			last;
		}
	}
	close(IN);
	
	# 関連ファイルコメント数更新
	my @idx = split(/\t/,$idx);
	shift(@idx);
	for (@idx) {
		my ($key,$val) = split(/:/);
		next if ($key eq 'art');
		
		my $file = $key eq 'top' ? "$cf{htmldir}/$val" : "$cf{htmldir}/archives/$key/$val";
		
		open(DB,"+< $cf{htmldir}/$file");
		eval "flock(DB,2);";
		my $html = join('',<DB>);
		
		# COM
		if ($job eq 'cm') {
			$html =~ s/(<!-- \[$num\].*?<!-- cmlink -->.*?)\(\d+\)(.*<!-- cmlink -->.*?<!-- \/ \[$num\])/$1($all)$2/s;
		
		# TB
		} else {
			$html =~ s/(<!-- \[$num\].*?<!-- tblink -->.*?)\(\d+\)(.*<!-- tblink -->.*?<!-- \/ \[$num\])/$1($all)$2/s;
		}
		
		seek(DB,0,0);
		print DB $html;
		truncate(DB,tell(DB));
		close(DB);
	}
}

#-----------------------------------------------------------
#  POP-UP画面
#-----------------------------------------------------------
sub detail_data {
	my $file = $in{job} eq 'cm' ? 'cm.tmp' : 'tb.tmp';
	
	my $msg;
	open(IN,"$cf{datadir}/$file") or error("open err: $file");
	while(<IN>) {
		chomp;
		my ($time,$num,$sub,$host,$name,$eml,$url,$com) = split(/\t/);
		
		if ($in{det} == $time) {
			$msg = $com;
			last;
		}
	}
	close(IN);
	
	# 画面表示
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{htmlurl}/tool/admin.css" rel="stylesheet">
<title>全文</title>
</head>
<body>
<div id="main">
<p class="ttl">全文表示</p>
<p>$msg</p>
<input type="button" value="閉じる" onclick="window.close()">
</div>
EOM
	footer();
}


1;

