#┌─────────────────────────────────
#│ CafeLog : tmpl_mgr.pl - 2023/07/08
#│ copyright (c) kentweb, 1997-2023
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  テンプレート編集
#-----------------------------------------------------------
sub tmpl_mgr {
	# 対象ファイル判定
	my $file =
			$in{file} eq 'css' ? "style.css" :
			$in{file} eq 'cal' ? "calendar.html" :
			$in{file} eq 'com' ? "comment.html" :
			$in{file} eq 'tb'  ? "trackback.html" :
			"index.html";
	
	# --- 編集実行
	if ($in{edit}) {
		if ($in{sel} !~ /^\w+\.\w+$/) { error("対象ファイルが不正です"); }
		
		# 改行
		$in{body} =~ s/\r\n/\n/g;
		$in{body} =~ s/\r/\n/g;
		
		# タグ復元
		$in{body} = chg_tag($in{body});
		
		# 更新
		open(DAT,"> $cf{datadir}/tmpl/$in{sel}");
		print DAT $in{body};
		close(DAT);
		
		# 完了画面
		echo_msg('編集を完了しました','tmpl_mgr',$in{fl});
	}
	if ($in{file} eq '') { $in{file} = 'tmpl'; }
	
	# 対象ファイル読み込み
	open(IN,"$cf{datadir}/tmpl/$file") or error("open err: $file");
	my $data = join('',<IN>);
	close(IN);
	
	# タグ変換
	$data = esc_tag($data);
	
	# 画面表示
	header("テンプレート編集");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/layout_edit.png" class="icon"> テンプレート編集</p>
<p>・ テンプレートファイルの編集を行います。</p>
<form action="$cf{index_cgi}" method="post" name="selform">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="tmpl_mgr" value="1">
<input type="hidden" name="sel" value="$file">
<input type="hidden" name="fl" value="$in{file}">
<table class="list">
<tr>
	<th class="ta-c">ファイル</th>
	<td>
		<select name="file" onchange="if(document.selform.file.value)location.href=document.selform.file.value;">
EOM

	# ファイル名
	my %fnam = (
			tmpl => '本体ファイル',
			cal  => 'カレンダー',
			com  => 'コメント',
			tb   => 'トラックバック',
			css  => 'CSSファイル',
		);
	for (qw(tmpl cal com tb css)) {
		if ($in{file} eq $_) {
			print qq|<option value="$cf{index_cgi}?tmpl_mgr=1&file=$_&sid=$in{sid}" selected>$fnam{$_}\n|;
		} else {
			print qq|<option value="$cf{index_cgi}?tmpl_mgr=1&file=$_&sid=$in{sid}">$fnam{$_}\n|;
		}
	}

	print <<EOM;
		</select> &nbsp; [プルダウン切替]
	</td>
</tr><tr>
	<th class="ta-c">内容</th>
	<td><textarea name="body" style="width:700px;height:30em;">$data</textarea></td>
</tr>
</table>
<input type="submit" name="edit" value="編集する" class="bigbtn">
</form>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  タグ変換
#-----------------------------------------------------------
sub esc_tag {
	local($_) = @_;
	
	s/&/&amp;/g;
	s/"/&quot;/g;
	s/</&lt;/g;
	s/>/&gt;/g;
	$_;
}


1;
