#┌─────────────────────────────────
#│ CafeLog : trackback.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  Trackback送信
#-----------------------------------------------------------
sub tb_send {
	my ($num,$tb,$nam,$ttl,$url,$exc) = @_;
	$exc =~ s/[\r\n]//g;
	$nam = del_tag($nam);
	$exc = del_tag($exc);
	$ttl = del_tag($ttl);
	
	# excerptは255バイト以内
	if (length($exc) > 255) {
		$exc = strcutbytes_utf8($exc,252) . '...';
	}
	
	# モジュール
	use LWP::UserAgent;
	use HTTP::Request::Common;
	
	my $ua = LWP::UserAgent->new;
	$ua->timeout(15);
	$ua->agent('CafeNoteTrackBack/1.0');
	
	# POST送信定義
	my $req = POST($tb,
			[
				blog_name => $nam,
				title     => $ttl,
				url       => $url,
				excerpt   => $exc,
				charset   => 'utf-8',
			],
		);
		
	# 結果
	my $res = $ua->request($req);
	
	# 受信成功
	my ($err,$msg);
	if ($res->is_success) {
		$err = $res->content =~ m|<error>(\d+).*</error>|s && $1;
		$msg = $res->content =~ m|<message>(.*)</message>|s && $1;
	
	# 受信失敗
	} else {
		$err = -1;
		$msg = $res->status_line;
	}
	
	$msg =~ s/[\r\n]//g;
	$msg =~ s/\t/ /g;
	$msg =~ s/&/&amp;/g;
	$msg =~ s/</&lt;/g;
	$msg =~ s/>/&gt;/g;
	$msg =~ s/"/&quot;/g;
	$msg =~ s/'/&#39;/g;
	
	# ログ保存
	my $time = time;
	open(DAT,">> $cf{datadir}/tb/$num.dat");
	eval "flock(DAT,2);";
	print DAT "$time\t$tb\t$err\t$msg\n";
	close(DAT);
}

#-----------------------------------------------------------
#  Trackback受信
#-----------------------------------------------------------
sub tb_recv {
	$in{tb} =~ s/\D//g;
	
	# 記事データの存在を確認
	if (!$in{tb} or !-e "$cf{htmldir}/archives/art/$in{tb}.html") {
		echo_xml(1,'cannot receive');
	}
	
	# 設定確認
	my ($flg,$sub);
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		my ($no,$date,$time,$ttl,$open,$cat,$tb,$cm) = split(/\t/);
		
		if ($in{tb} == $no && $tb == 1) {
			$sub = $ttl;
			$flg++;
			last;
		}
	}
	close(IN);
	
	# 該当記事なし
	if (!$flg) { echo_xml(1,'cannot receive'); }
	
	# 各データチェック（全項目必須）
	my $flg;
	for (qw(blog_name title url excerpt)) {
		$in{$_} =~ s/[\r\n]//g;
		$in{$_} = del_tag($in{$_});
		if ($in{$_} eq '') {
			$flg++;
			last;
		}
	}
	if ($flg) { echo_xml(1,'not complete!'); }
	
	# 受け入れチェック
	my $host = check_tb();
	
	# 文字コード : charsetがutf-8以外は変換する
	$in{charset} =~ tr/A-Z/a-z/;
	if ($in{charset} ne 'utf-8') {
		my %char = (
			'shift_jis'   => 'sjis',
			'euc-jp'      => 'euc',
			'iso-2022-jp' => 'jis',
		);
		
		# コード変換
		require './lib/jacode.pl';
		jcode::convert(\$in{blog_name},'utf8', $char{$in{charset}});
		jcode::convert(\$in{title},    'utf8', $char{$in{charset}});
		jcode::convert(\$in{excerpt},  'utf8', $char{$in{charset}});
	}
	# excerptは255バイト以内
	if (length($in{excerpt}) > 255) {
		$in{excerpt} = strcutbytes_utf8($in{excerpt},252) . '...';
	}
	
	# indexファイル
	my $tbnum;
	open(DB,"$cf{datadir}/tbcm.dat");
	while(<DB>) {
		my ($no,$tb,$cm) = split(/\t/);
		
		if ($in{tb} == $no) {
			$tbnum = $tb;
			last;
		}
	}
	close(DB);
	
	# 最大数超
	if ($cf{tb_log_max} <= $tbnum) {
		echo_xml(1,'cannot receive');
	}
	
	# 時間取得
	my $time = time;
	
	# 一時ファイル保存
	my $flg;
	open(DB,"+< $cf{datadir}/tb.tmp") or die;
	eval "flock(DB,2);";
	while(<DB>) {
		my (undef,$num,undef,$hos,$nam,$ttl,$url,$exc) = split(/\t/);
		chomp($exc);
		
		if ($in{tb} == $num && $hos eq $host && $in{blog_name} eq $nam && $ttl eq $in{title} && $url eq $in{url} && $exc eq $in{excerpt}) {
			$flg++;
			last;
		}
	}
	if ($flg) {
		close(DB);
		echo_xml(1,'cannot receive');
	}
	seek(DB,0,2);
	print DB "$time\t$in{tb}\t$sub\t$host\t$in{blog_name}\t$in{title}\t$in{url}\t$in{excerpt}\n";
	truncate(DB,tell(DB));
	close(DB);
	
	# メール通知
	mail_to($sub,$host) if ($cf{mailing});
	
	# OK!
	echo_xml(0);
}

#-----------------------------------------------------------
#  XML出力
#-----------------------------------------------------------
sub echo_xml {
	my ($err,$msg) = @_;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<?xml version="1.0" encoding="iso-8859-1"?>
<response>
<error>$err</error>
EOM

	print qq|<message>$msg</message>\n| if ($msg);
	print qq|</response>\n|;
	exit;
}

#-----------------------------------------------------------
#  文字バイト数カット for utf-8
#-----------------------------------------------------------
# [ref] http://linkage.white-void.net/development/server/perl-utf8-strcut.html
sub strcutbytes_utf8 {
	my ($src,$maxlen) = @_;
	my $srclen = length($src);
	my $srcpos = 0;
	while($srcpos < $srclen) {
		my $character = substr($src, $srcpos, 1);
		my $value = ord($character);
		if ($value < 0x80) { # ASCII characters
			$srcpos++;
			next;
		}
		my $width = 6;
		$width = 5 if ($value < 0xFC);
		$width = 4 if ($value < 0xF8);
		$width = 3 if ($value < 0xF0);
		$width = 2 if ($value < 0xE0);
		my $nextpos = $srcpos + $width;
		last if ($nextpos > $maxlen);
		last if ($nextpos > $srclen); # sequence is incomplete
		$srcpos = $nextpos;
	}
	return substr($src, 0, $srcpos);
}

#-----------------------------------------------------------
#  受け入れチェック
#-----------------------------------------------------------
sub check_tb {
	# 禁止ワードチェック
	my $flg;
	for ( split(/\s+/,$cf{bad_word}) ) {
		if (index($in{excerpt},$_) >= 0) {
			$flg++;
			last;
		}
	}
	if ($flg) { echo_xml(1,'cannot receive'); }
	
	# ホストチェック
	my ($addr,$host) = get_host();
	my $flg;
	for ( split(/\s+/,$cf{bad_host}) ) {
		if (index($host,$_) >= 0 or index($addr,$_) >= 0) {
			$flg++;
			last;
		}
	}
	if ($flg) { echo_xml(1,'cannot receive'); }
	
	return $host;
}

#-----------------------------------------------------------
#  メール通知
#-----------------------------------------------------------
sub mail_to {
	my ($sub,$host) = @_;
	
	# 時間
	my $date = chg_date(time);
	
	# 本文
	my $body = <<EOM;
$cf{title}にトラックバックの受信がありましたので、お知らせします。
管理画面にログインして承認の可否を行ってください。

投稿日時 : $date
対象記事 : $sub
ホスト名 : $host

ブログ名 : $in{blog_name}
タイトル : $in{title}
参照URL  : $in{url}

$in{excerpt}
EOM

	# 通知
	require './lib/sendmail.pl';
	sendmail("トラックバック連絡",$body);
}

#-----------------------------------------------------------
#  タグ除去
#-----------------------------------------------------------
sub del_tag {
	my $text = shift;
	
	$text =~ s/&amp;/&/g;
	$text =~ s/&lt;/</g;
	$text =~ s/&gt;/>/g;
	$text =~ s/&quot;/"/g;
	$text =~ s/&#39;/'/g;
	
	# HTMLタグ [ref] http://www.din.or.jp/~ohzaki/perl.htm#HTML_Tag
	my $tag_regex_ = q{[^"'<>]*(?:"[^"]*"[^"'<>]*|'[^']*'[^"'<>]*)*(?:>|(?=<)|$(?!\n))};
	my $comment_tag_regex = '<!(?:--[^-]*-(?:[^-]+-)*?-(?:[^>-]*(?:-[^>-]+)*?)??)*(?:>|$(?!\n)|--.*$)';
	$tag_regex = qq{$comment_tag_regex|<$tag_regex_};
	
	$text =~ s/$tag_regex//g;
	return $text;
}


1;

