#┌─────────────────────────────────
#│ CafeLog : base_mgr.pl - 2023/10/09
#│ copyright (c) kentweb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  基本設定
#-----------------------------------------------------------
sub base_mgr {
	# 更新（基本部）
	if ($in{submit_base}) { set_data(); }
	elsif ($in{submit_prof}) { set_prof(); }
	
	$cf{profile} =~ s/<br>/\n/g;
	
	# 画面表示
	header("基本設定");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/data_gear.png" class="icon"> 基本設定</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="base_mgr" value="1">
<p>・ 基本情報の設定</p>
<table class="list">
<tr>
	<th>主タイトル</th>
	<td><input type="text" name="title" size="45" value="$cf{title}"></td>
</tr><tr>
	<th>副タイトル</th>
	<td><input type="text" name="subttl" size="45" value="$cf{subttl}"></td>
</tr><tr>
	<th>新着記事リンク数</th>
	<td><input type="text" name="new_art" size="3" value="$cf{new_art}"></td>
</tr><tr>
	<th>トップ記事表示件数</th>
	<td><input type="text" name="topg_max" size="3" value="$cf{topg_max}"></td>
</tr><tr>
	<th>アーカイブ表示件数</th>
	<td><input type="text" name="page_max" size="3" value="$cf{page_max}"></td>
</tr><tr>
	<th>TB最大数</th>
	<td><input type="text" name="tb_log_max" size="3" value="$cf{tb_log_max}"> (1記事当り)</td>
</tr><tr>
	<th>コメント最大数</th>
	<td><input type="text" name="cm_log_max" size="3" value="$cf{cm_log_max}"> (1記事当り)</td>
</tr><tr>
	<th>ページ当り表示件数</th>
	<td><input type="text" name="list_max" size="3" value="$cf{list_max}"> (管理画面：ページ/画像管理)</td>
</tr><tr>
	<th>禁止ワード</th>
	<td>
		(コメント/TB受信時：半角スペースで複数を区切る)<br>
		<input type="text" name="bad_word" size="45" value="$cf{bad_word}"></td>
</tr><tr>
	<th>日本語有無チェック</th>
	<td>(コメント受信時)
EOM

	my %ox = (0 => 'しない', 1 => 'する');
	for (0,1) {
		if ($cf{jp_word_chk} == $_) {
			print qq|<input type="radio" name="jp_word_chk" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="jp_word_chk" value="$_">$ox{$_}\n|;
		}
	}
	
	print <<EOM;
		</td>
</tr><tr>
	<th>禁止ホスト名</th>
	<td>(コメント/TB受信時：半角スペースで複数を区切る)<br>
		<input type="text" name="bad_host" size="45" value="$cf{bad_host}"></td>
</tr><tr>
	<th>記事画像</th>
	<td>
		縮小画像作成：
EOM

	if ($cf{img_mini} == 1) {
		print qq|<input type="checkbox" name="img_mini" value="1" checked>|;
	} else {
		print qq|<input type="checkbox" name="img_mini" value="1">|;
	}
	
	print <<EOM;
		<br>
		[縦・横] <input type="text" name="img_size" value="$cf{img_size}" size="3">
		pixに縦横比を保って縮小
	</td>
</tr><tr>
	<th></th>
	<td><input type="submit" name="submit_base" value="設定更新"></td>
</tr>
</table>
</form>
<p>・ プロフィールの設定</p>
<form action="$cf{index_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="base_mgr" value="1">
<table class="list">
<tr>
	<th>プロフ</th>
	<td><textarea name="profile" cols="50" rows="2">$cf{profile}</textarea></td>
</tr><tr>
	<th>画像</th>
	<td>
		横サイズ：<input type="text" name="prof_img_w" size="3" value="$cf{prof_img_w}"> pix
		（このサイズで固定表示）<br>
		<input type="file" name="upfile" size="30">
EOM

	if ($cf{prof_img}) {
		print qq|[<a href="$cf{htmlurl}/img/$cf{prof_img}" target="_blank">画像</a>]\n|;
		print qq|<input type="checkbox" name="imgdel" value="1">削除\n|;
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th></th>
	<td><input type="submit" name="submit_prof" value="プロフ更新"></td>
</tr>
</table>
</form>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  基本データ更新
#-----------------------------------------------------------
sub set_data {
	my @log;
	for (qw(title subttl new_art topg_max page_max tb_log_max cm_log_max list_max bad_word jp_word_chk bad_host img_mini img_size)) {
		push(@log,"$_\t$in{$_}\n");
	}
	for (qw(profile prof_img prof_img_w)) {
		push(@log,"$_\t$cf{$_}\n");
	}
	
	# 基本データ保存
	open(DAT,"> $cf{datadir}/base.dat");
	print DAT @log;
	close(DAT);
	
	# 完了画面
	echo_msg('基本設定を更新しました','base_mgr');
}

#-----------------------------------------------------------
#  プロフデータ更新
#-----------------------------------------------------------
sub set_prof {
	# 画像削除
	if ($in{imgdel} == 1) {
		unlink("$cf{htmldir}/img/$cf{prof_img}");
		$cf{prof_img} = '';
	}
	
	# アップロードファイル取得
	my $upfile = $cgi->param('upfile');
	if ($upfile) {
		# 拡張子取得
		my $ext = $upfile =~ /.+\.(jpe?g|gif|png)$/i
				? $1 : error("拡張子が不明です");
		$ext =~ tr/A-Z/a-z/;
		if ($ext eq 'jpeg') { $ext = 'jpg'; }
		
		my $upname = "$cf{htmldir}/img/profile.$ext";
		my $buf;
		my $fh = $cgi->upload($upfile);
		if ($fh eq '') { error($cgi->cgi_error); }
		open(UP,"> $upname") or error("up err: $upname");
		binmode(UP);
		print UP $buf while read( $fh, $buf, 4096 );
		close(UP);
		
		if ($cf{prof_img}) {
			my $ex = $cf{prof_img} =~ /\.(\w+)$/ && $1;
			if ($ex ne $ext) { unlink("$cf{htmldir}/img/profile.$ex"); }
		}
		
		$in{prof_img} = "profile.$ext";
	} else {
		$in{prof_img} = $cf{prof_img};
	}
	
	# 改行処理
	$in{profile} =~ s/\r\n/<br>/g;
	$in{profile} =~ s/\r/<br>/g;
	$in{profile} =~ s/\n/<br>/g;
	$in{profile} =~ s/(<br>)+$//;
	
	my @log;
	for (qw(title subttl new_art topg_max page_max tb_log_max cm_log_max list_max bad_word jp_word_chk bad_host)) {
		push(@log,"$_\t$cf{$_}\n");
	}
	for (qw(profile prof_img prof_img_w)) {
		push(@log,"$_\t$in{$_}\n");
	}
	
	# 基本データ保存
	open(DAT,"> $cf{datadir}/base.dat");
	print DAT @log;
	close(DAT);
	
	# 完了画面
	echo_msg('基本設定を更新しました','base_mgr');
}


1;

