#┌─────────────────────────────────
#│ CafeLog : img_mgr.pl - 2024/07/28
#│ copyright (c) kentweb, 1997-2024
#│ https://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  画像管理
#-----------------------------------------------------------
sub img_mgr {
	# 新規
	if ($in{job_new}) {
		# 新規作成
		if ($in{add}) { make_img(); }
		
		# フォーム
		img_form();
	}
	
	# ボタン押下認識
	my $del;
	for ( keys %in ) {
		if (/^del:(.+)/) {
			$del = $1;
			last;
		}
	}
	# 削除
	if ($del) {
		my @log;
		open(DAT,"+< $cf{datadir}/img.dat") or error('open err: img.dat');
		while(<DAT>) {
			my ($id,$ex,$w,$h) = split(/\t/);
			
			# 画像削除
			if ($del eq "$id.$ex") {
				unlink("$cf{htmldir}/img/$id.$ex");
				unlink("$cf{htmldir}/img/$id-s.jpg") if (-f "$cf{htmldir}/img/$id-s.jpg");
				next;
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	# 画面表示
	header("画像管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/image_edit.png" class="icon"> 画像管理</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="img_mgr" value="1">
<p>
	・ サムネイル画像をクリックすると原寸大の画像が表示されます。<br>
	・ 新規に画像を追加する場合は「新規作成」ボタンを押してください。<br>
	・ オリジナルのファイル名でアップしますが、英数字、アンダーバー、ハイフン、ドット、括弧以外が含まれる場合は数字羅列とします。
</p>
<input type="submit" name="job_new" value="新規作成">
<table class="list">
<tr>
	<th>画像</th>
	<th>ファイル名</th>
	<th>容量</th>
	<th>縦横サイズ</th>
	<th>登録日</th>
	<th>操作</th>
</tr>
EOM

	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my $i = 0;
	open(IN,"$cf{datadir}/img.dat") or error('open err: img.dat');
	while(<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{list_max});
		
		# 行分割
		my ($id,$ex,$w,$h,$w2,$h2) = split(/\t/);
		
		# サイズ取得
		my $size = -s "$cf{htmldir}/img/$id.$ex";
		$size = int($size / 1024) . 'KB';
		
		# プレビュー用
		my $img = -f "$cf{htmldir}/img/$id-s.jpg" ? "$id-s.jpg" : "$id.$ex";
		my ($w3,$h3) = resize($w,$h,40);
		
		# 日付
		my $last = (stat("$cf{htmldir}/img/$id.$ex"))[9];
		$last = chg_date($last);
		
		print qq|<tr><td class="ta-c"><a href="$cf{htmlurl}/img/$id.$ex" target="_blank">|;
		print qq|<img src="$cf{htmlurl}/img/$img" alt="" width="$w3" height="$h3"></a></td>|;
		print qq|<td>$id.$ex</td>|;
		print qq|<td class="ta-r">$size</td>|;
		print qq|<td class="ta-c">$h x $w</td>|;
		print qq|<td class="ta-c">$last</td>|;
		print qq|<td class="ta-c"><input type="submit" name="del:$id.$ex" value="削除" onclick="return confirm('削除しますか？');"></td></tr>\n|;
	}
	close(IN);
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,'img_mgr');
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  画像投稿フォーム
#-----------------------------------------------------------
sub img_form {
	# 画面表示
	header("画像投稿フォーム","uppy");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/image_add.png" class="icon"> 画像投稿フォーム</p>
<!--
<div class="ta-r">
<input type="button" value="&lt; 前画面に戻る" onclick="javascript:window.location='$cf{index_cgi}?img_mgr=1&sid=$in{sid}'">
</div>
-->
<form action="$cf{index_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="img_mgr" value="1">
<input type="hidden" name="job_new" value="1">
<input type="hidden" name="head" value="1">
<div class="sub-ttl">1. ヘッダー画像（JPEGのみ）</div>
<table class="list">
<tr>
	<th>画像指定</th>
	<td>
		<input type="file" name="upfile" size="35">
		<input type="submit" name="add" value="アップロード">
	</td>
</tr>
</table>
</form>
<div class="sub-ttl">2. 記事画像（JPEG/PNG/GIF）</div>
<p class="img-memo">
	・アップするには「フォーム表示」ボタンを押してください。一度に複数アップできます。<br>
	・縮小サイズ（$cf{img_size}px）も同時作成しますが、「基本設定」でその有無やサイズ調整が可能です。
</p>
<div id="drag-drop-area"></div>
<button id="uppy-select-files">フォームを表示</button>
<script src="https://transloadit.edgly.net/releases/uppy/v1.2.0/uppy.min.js"></script>
<script src="https://transloadit.edgly.net/releases/uppy/locales/v1.4.0/ja_JP.min.js"></script>
<script>
var uppy = Uppy.Core({debug:true,
		restrictions: {
		//maxNumberOfFiles: 5,
		maxFileSize: $cf{maxdata},
		allowedFileTypes:['image/jpeg','image/png','image/gif'] }
		}).
		use(Uppy.Dashboard,{
			target: '#drag-drop-area',
			trigger: '#uppy-select-files',
			locale: Uppy.locales.ja_JP }
		).
		use(Uppy.XHRUpload,{
			endpoint: '$cf{index_cgi}',
			fieldName: 'upfile',
			formData: true,
		}).
		setMeta({ sid:'$in{sid}', img_mgr:1, job_new:1, head:0, mini:1, size:'$cf{thum_size}', add:1 });
</script>
<div class="backimg-btn">
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="img_mgr" value="1">
<input type="submit" value="&lt; 前画面へ戻る">
</form>
</div>
</div>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  画像投稿
#-----------------------------------------------------------
sub make_img {
	# アップロードファイル取得
	my $upfile = $cgi->param('upfile') or error('画像が指定されていません');
	
	# 拡張子取得
	my ($fname,$ext) = $upfile =~ /(.+)\.(jpe?g|gif|png)$/i
			? ($1,$2)
			: error("拡張子が不明です");
	$ext =~ tr/A-Z/a-z/;
	if ($ext eq 'jpeg') { $ext = 'jpg'; }
	
	# ヘッダはJPEGのみ
	if ($in{head} && $ext ne 'jpg') { error('ヘッダ画像はJPEGのみです'); }
	
	# アップファイル定義
	if ($in{head}) {
		$fname = 'header';
	} elsif ($fname =~ /[^\w\-\.\(\)]/) {
		$fname = time;
	} elsif (-e "$cf{htmldir}/img/$fname.$ext") {
		error("<b>$fname.$ext</b> は既に存在するファイル名です");
	}
	my $upname = "$cf{htmldir}/img/$fname.$ext";
	
	# アップロード
	my $buf;
	my $fh = $cgi->upload($upfile);
	if ($fh eq '') { error($cgi->cgi_error); }
	open(UP,"> $upname") or error("up err: $upname");
	binmode(UP);
	print UP $buf while read( $fh, $buf, 4096 );
	close(UP);
	
	# サイズ取得
	my ($w,$h);
	if ($ext eq 'gif') { ($w,$h) = g_size($upname); }
	elsif ($ext eq 'png') { ($w,$h) = p_size($upname); }
	else { ($w,$h) = j_size($upname); }
	
	# サムネイル縮小
	my ($w2,$h2);
	if ($cf{img_mini} && !$in{head}) {
		# モジュール読込
		require ImgResize;
		
		# 縮小サイズ定義
		if ($cf{img_size} eq '') { $cf{img_size} = 280; }
		($w2,$h2) = resize($w,$h,$cf{img_size});
		
		# サムネイル（引数 -1 は画像モジュール自動認識）
		my $image = new ImgResize( -1 );
		$image->{width}    = $w2;
		$image->{height}   = $h2;
		$image->{quality}  =  75;
		$image->{ext}      = '.jpg';
		$image->{in}       = $upname;
		$image->{out}      = "$cf{htmldir}/img/$fname-s.jpg";
		$image->{exif_cut} =   1;
		
		# リサイズ
		$image->resize;
	}
	
	# 画像index更新
	my @log;
	open(DAT,"+< $cf{datadir}/img.dat") or error('open err: img.dat');
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($id,$ex,$w,$h,$w2,$h2) = split(/\t/);
		next if ($in{head} && $id eq 'header');
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT "$fname\t$ext\t$w\t$h\t$w2\t$h2\n";
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了メッセージ
	echo_msg('画像をアップしました','img_mgr');
}

#-----------------------------------------------------------
#  ポップアップ画像
#-----------------------------------------------------------
sub img_pop {
	# 下記JavaScriptコードは以下の公開コードを参考にしました。
	# http://web1.kcn.jp/senpu_ki/cgi-bin/blog/archive.cgi?20110221051706
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{htmlurl}/tool/admin.css" rel="stylesheet">
<script>
function getAreaRangeText(obj) {
	var pos = new Object();
	var win = opener;
	
	if (isIE) {
		obj.focus();
		var range = win.document.selection.createRange();
		var clone = range.duplicate();
		
		clone.moveToElementText(obj);
		clone.setEndPoint( 'EndToEnd', range );
		
		pos.start = clone.text.length - range.text.length;
		pos.end   = clone.text.length - range.text.length + range.text.length;
  	}
	else if(window.getSelection()) {
		pos.start = obj.selectionStart;
		pos.end   = obj.selectionEnd;
	}
	return pos;
}
function getCodeStr(data){
	var str = data;
	var elmName = document.insert_code.insert_to.value;
	textInsertHTML(str,elmName);
	window.close();
	return false;
}
function textInsertHTML(str,obj){
	var win = opener;
	var target = win.document.getElementById(obj);
	var pos = getAreaRangeText(target);
	var val = target.value;		
	var range = val.slice(pos.start, pos.end);
    var beforeNode = val.slice(0, pos.start);
    var afterNode  = val.slice(pos.end);
	var insertNode;	
    if (pos.start == pos.end) {
       	insertNode = str;
       	target.value = beforeNode + insertNode + afterNode;
    }
    window.close();
    return false;
}
var isIE = (navigator.appName.toLowerCase().indexOf('internet explorer')+1?1:0);
</script>
<title>画像貼付</title>
</head>
<body>
<div id="main">
<p class="ttl">■ 画像貼付</p>
<p>・ 貼り付ける画像（幅 x 高さ）を選択してください。</p>
<form name="insert_code" onsubmit="getCodeStr();">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="insert_to" value="myArea3">
<table class="list">
<tr>
	<th class="ta-c">画像</th>
	<th class="ta-c">原寸サイズ</th>
	<th class="ta-c">縮小サイズ</th>
</tr>
EOM

	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my $i = 0;
	open(IN,"$cf{datadir}/img.dat");
	while(<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{list_max});
		
		my ($id,$ex,$w,$h,$w2,$h2) = split(/\t/);
		
		# 表示画像
		my ($img,$stag);
		if (-f "$cf{htmldir}/img/$id-s.jpg") {
			$img = "$id-s.jpg";
			$stag = qq|<a href="javascript:getCodeStr('| . qq|&lt;a href=&quot;$cf{htmlurl}/img/$id.$ex&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;$cf{htmlurl}/img/$id-s.jpg&quot; border=&quot;0&quot; alt=&quot;&quot;&gt;&lt;/a&gt;| . qq|')">[$w2 x $h2]</a>|;
		} else {
			$img = "$id.$ex";
			$stag = '-';
		}
		
		# 原寸画像タグ
		my $tag  = "&lt;a href=&quot;$cf{htmlurl}/img/$id.$ex&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;$cf{htmlurl}/img/$id.$ex&quot; border=&quot;0&quot; alt=&quot;&quot;&gt;&lt;/a&gt;";
		
		my ($w3,$h3) = resize($w,$h,40);
		print qq|<tr><td class="ta-c"><img src="$cf{htmlurl}/img/$img" alt="" width="$w3" height="$h3"></td>|;
		print qq|<td class="ta-c"><a href="javascript:getCodeStr('$tag')">[$w x $h]</a></td>|;
		print qq|<td class="ta-c">$stag</td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</tr>
</table>
</form>
EOM

	# 繰越ボタン
	print make_pgbtn($i,$pg,'img_pop');
	
	print <<EOM;
<div style="margin-top:2.5em;text-align:center">
<input type="button" value="閉じる" onclick="window.close()">
</div>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h,$w,$t);
	open(IMG,"$jpg");
	binmode(IMG);
	read(IMG,$t,2);
	while (1) {
		read(IMG,$t,4);
		my ($m,$c,$l) = unpack("a a n",$t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG, $t, 5);
			($h,$w) = unpack("xnn",$t);
			last;
		} else {
			read(IMG,$t,($l - 2));
		}
	}
	close(IMG);
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,"$gif");
	binmode(IMG);
	sysread(IMG,$data,10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data, -4); }
	my $w = unpack("v", substr($data,0,2));
	my $h = unpack("v", substr($data,2,2));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,"$png");
	binmode(IMG);
	read(IMG,$data,24);
	close(IMG);
	
	my $w = unpack("N",substr($data,16,20));
	my $h = unpack("N",substr($data,20,24));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  日時換算
#-----------------------------------------------------------
sub chg_date {
	my $time = shift;
	
	my ($mday,$mon,$year) = (localtime($time))[3..6];
	sprintf("%04d/%02d/%02d",$year+1900,$mon+1,$mday);
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h,$size) = @_;
	$size =~ s/\D//g;
	if (!$size) { $size = 150; }
	
	# 画像表示縮小
	if ($w > $size || $h > $size) {
		my $w2 = $size / $w;
		my $h2 = $size / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; } else { $key = $h2; }
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	
	return ($w,$h);
}


1;

