#┌─────────────────────────────────
#│ CafeLog : link_mgr.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  リンク管理
#-----------------------------------------------------------
sub link_mgr {
	# 新規
	if ($in{job_new}) { new_link(); }
	
	# 上下移動
	if ($in{up} or $in{dn}) { sort_link(); }
	
	# ボタン押下認識
	my ($edit,$dele);
	for ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		} elsif (/^del:(\d+)/) {
			$dele = $1;
			last;
		}
	}
	if ($edit) { edit_link($edit); }
	if ($dele) { dele_link($dele); }
	
	# 画面表示
	header("リンク管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/apl_link.png" class="icon"> リンク管理</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="link_mgr" value="1">
<p>・ 新規作成</p>
<table class="list">
<tr>
	<th>リンク</th>
	<th>操作</th>
</tr><tr>
	<td>
		[名称] <input type="text" name="name" size="35"><br>
		[参照] <input type="text" name="url" size="35" value="http://">
	</td>
	<td><input type="submit" name="job_new" value="追加"></td>
</tr>
</table>
<p>・ 修正・削除・並替</p>
<table class="list">
<tr>
	<th>リンク</th>
	<th>操作</th>
</tr>
EOM

	my $i;
	open(IN,"$cf{datadir}/link.dat") or error('open err: link.dat');
	while(<IN>) {
		$i++;
		chomp;
		my ($no,$name,$url) = split(/\t/);
		
		print qq|<tr><td>[名称] <input type="text" name="name:$no" size="35" value="$name"><br>|;
		print qq|[参照] <input type="text" name="url:$no" size="35" value="$url"></td>|;
		print qq|<td><input type="submit" name="edit:$no" value="修正">\n|;
		print qq|<input type="submit" name="del:$no" value="削除" onclick="return confirm('削除しますか？');">\n|;
		print qq|<a href="$cf{index_cgi}?link_mgr=1&up=$no&sid=$in{sid}"><img src="$cf{htmlurl}/tool/up.png" alt="上へ移動" class="icon"></a>\n|;
		print qq|<a href="$cf{index_cgi}?link_mgr=1&dn=$no&sid=$in{sid}"><img src="$cf{htmlurl}/tool/down.png" alt="下へ移動" class="icon"></a>\n|;
		print qq|</td></tr>\n|;
	}
	close(IN);
	
	if (!$i) {
		print qq|<tr><td colspan="2" class="ta-c">リンク情報はありません。</td></tr>\n|;
	}
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,'page_mgr');
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  リンク新規
#-----------------------------------------------------------
sub new_link {
	if ($in{name} eq '' or $in{url} eq 'http://' or $in{url} eq '') {
		error('名称又は参照先が未入力です');
	}
	
	my ($num,@log);
	open(DAT,"+< $cf{datadir}/link.dat") or error('open err: link.dat');
	while(<DAT>) {
		my ($no,undef,undef) = split(/\t/);
		if ($num < $no) { $num = $no; }
		
		push(@log,$_);
	}
	$num++;
	unshift(@log,"$num\t$in{name}\t$in{url}\n");
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了画面
	echo_msg('新規リンクを作成しました','link_mgr');
}

#-----------------------------------------------------------
#  リンク修正
#-----------------------------------------------------------
sub edit_link {
	my $num = shift;
	
	if ($in{"name:$num"} eq '' or $in{"url:$num"} eq 'http://' or $in{"url:$num"} eq '') {
		error('名称又は参照先が未入力です');
	}
	
	my @log;
	open(DAT,"+< $cf{datadir}/link.dat") or error('open err: link.dat');
	while(<DAT>) {
		my ($no,$name,$url) = split(/\t/);
		
		if ($no == $num) {
			$_ = qq|$no\t$in{"name:$num"}\t$in{"url:$num"}\n|;
		}
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了画面
	echo_msg('リンク情報を修正しました','link_mgr');
}

#-----------------------------------------------------------
#  リンク削除
#-----------------------------------------------------------
sub dele_link {
	my $del = shift;
	
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/link.dat") or error('open err: link.dat');
	while(<DAT>) {
		my ($no,$name,$url) = split(/\t/);
		next if ($del == $no);
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  リンク並び替え
#-----------------------------------------------------------
sub sort_link {
	my ($tmp,@log);
	open(DAT,"+< $cf{datadir}/link.dat") or error('open err: link.dat');
	while(<DAT>) {
		my ($no,$name,$url) = split(/\t/);
		
		# 上移動
		if ($no == $in{up}) {
			my $log = pop(@log);
			push(@log,$_);
			push(@log,$log);
			next;
		
		# 下移動
		} elsif ($no == $in{dn}) {
			$tmp = $_;
			next;
		}
		push(@log,$_);
		
		if ($tmp) {
			push(@log,$tmp);
			$tmp = '';
		}
	}
	if ($tmp) { push(@log,$tmp); }
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}


1;

