#┌─────────────────────────────────
#│ CafeLog : ref_chg.pl - 2022/03/21
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  変更反映
#-----------------------------------------------------------
sub ref_chg {
	# 実行
	if ($in{ref}) { ref_page(); }
	
	# 画面表示
	header("変更反映");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/page_refresh.gif" class="icon"> 変更反映</p>
<p>・ 変更を反映するには以下のボタンを押してください。</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="ref_chg" value="1">
<input type="submit" name="ref" value="変更を反映する" class="bigbtn">
</form>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  ページ反映
#-----------------------------------------------------------
sub ref_page {
	my (@idx,%cat);
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		chomp;
		my ($no,$date,$time,$sub,$open,$cat,$tb,$cm) = split(/\t/);
		next if ($open != 1);
		
		if ($cat eq '') { $cat = 0; }
		$cat{$cat}++;
		push(@idx,$_);
	}
	close(IN);
	
	# サイドデータ
	my ($side,$bot,$rss,$link,$cate,$clnk) = read_side(%cat);
	
	# プロフ
	my $profile;
	if ($cf{prof_img}) {
		$profile .= qq|<img src="$cf{htmlurl}/img/$cf{prof_img}" alt="プロフ" width="$cf{prof_img_w}">\n|;
	}
	$profile .= "<p>$cf{profile}</p>\n";
	$profile = qq|<div class="ta-c">$profile</div>|;
	
	# テンプレート読み込み
	my %tmpl;
	for (qw(index trackback comment)) {
		open(IN,"$cf{datadir}/tmpl/$_.html") or error("open err: tmpl/$_.html");
		$tmpl{$_} = join('',<IN>);
		close(IN);
	}
	
	# 文字置き換え
	$tmpl{index} =~ s/!(title|subttl)!/$cf{$1}/g;
	$tmpl{index} =~ s/<!-- sidebody -->/$side/;
	$tmpl{index} =~ s/<!-- footer -->/$bot/;
	$tmpl{index} =~ s/<!-- rss -->/$rss/;
	$tmpl{index} =~ s/<!-- links -->/$link/;
	$tmpl{index} =~ s/<!-- category -->/$cate/;
	$tmpl{index} =~ s|!icon:(\w+\.\w+)!|<img src="$cf{htmlurl}/tool/$1" class="icon" alt="$1">|g;
	$tmpl{index} =~ s|!blog_cgi!|$cf{blog_cgi}|g;
	$tmpl{index} =~ s|!find!||g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl{index});
	undef $tmpl{index};
	
	# TOP/CSS/RSS
	$head =~ s|!top!|$cf{htmlurl}/index.html|;
	$head =~ s|!css!|$cf{htmlurl}/style.css|;
	$head =~ s|!rss!|$cf{htmlurl}/index.xml|;
	
	# TB/COM数
	my ($tbc,$cmc) = read_tbcm();
	
	# ページファイルを展開
	my ($i,$n,$newa,$nohtml,@rss,%body,%cate,%date,%days,%dayno,%mon,%mons,%ym,%ymd,%idx,%ct,%mn,%yn,%sub);
	for (@idx) {
		my ($no,$date,$time,$sub,$open,$cate,$tb,$cm) = split(/\t/);
		if ($cate eq '') { $cate = 0; }
		
		# ページデータ読み込み
		open(LOG,"$cf{datadir}/log/$no.txt");
		my $log = join('',<LOG>);
		close(LOG);
		
		# タグ/改行処理
		my $elog = chg_tag($log);
		$elog =~ s|\n|<br>|g;
		
		# TOPページ数定義
		$i++;
		my $n = $i % $cf{topg_max} == 0 ? $i / $cf{topg_max} : int($i / $cf{topg_max}) + 1;
		
		# 新着記事リンク
		if ($i <= $cf{new_art}) {
			$newa .= qq|<li><a href="$cf{htmlurl}/archives/art/$no.html">$sub</a></li>\n|;
		}
		
		# タイトル
		$sub{$no} = $sub;
		
		# テンプレート文字置き換え
		my $tmp = $loop;
		$tmp =~ s/!subject!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!body!/$elog/g;
		$tmp =~ s/!categ!/$$clnk{$cate}/g;
		$tmp =~ s/!time!/$date $time/g;
		$tmp =~ s|!pmlink!|$cf{htmlurl}/archives/art/$no.html|g;
		$tmp =~ s|!tblink!|$cf{htmlurl}/archives/art/$no.html#tb|g;
		$tmp =~ s|!cmlink!|$cf{htmlurl}/archives/art/$no.html#cm|g;
		
		# TB
		if (!$tb) {
			$tmp =~ s/<!-- tblink -->.+?<!-- tblink -->//s;
		} else {
			$tmp =~ s/!tb_no!/$$tbc{$no} ? $$tbc{$no} : 0/e;
		}
		# COM
		if (!$cm) {
			$tmp =~ s/<!-- cmlink -->.+?<!-- cmlink -->//s;
		} else {
			$tmp =~ s/!cm_no!/$$cmc{$no} ? $$cmc{$no} : 0/e;
		}
		
		# 年月
		my ($y,$m,$d) = $date =~ /^(\d+)\.(\d+)\.(\d+)/ && ($1,$2,$3);
		$ym{"$y$m"}++;
		$ymd{"$y$m$d"}++;
		
		# ページ本文
		$body{$n} .= "<!-- [$no] $y-$m -->$tmp<!-- / [$no] $y-$m -->\n";
		
		# index
		my $fname = $n == 1 ? 'index.html' : "page-$n.html";
		$idx{$no} .= "top:$fname\t";
		
		# カテゴリ本文
		if ($cate eq '') { $cate = 0; }
		$cate{$cate} .= "<!-- [$no] $y-$m -->$tmp<!-- / [$no] $y-$m -->\n\0";
		$ct{$cate}++;
		if ($ct{$cate} % $cf{page_max} == 1) {
			$catno{$cate}++;
		}
		$idx{$no} .= "cat:$cate-$catno{$cate}.html\t";
		
		# 日付本文
		$date{"$y-$m-$d"} .= "<!-- [$no] $tb:$cm -->$tmp<!-- / [$no] $tb:$cm -->\n\0";
		$days{"$y$m$d"}++;
		if ($days{"$y$m$d"} % $cf{page_max} == 1) {
			$dayno{"$y$m$d"}++;
		}
		$idx{$no} .= qq|day:$y$m$d-$dayno{"$y$m$d"}.html\t|;
		
		# 月次本文
		$mon{"$y$m"} .= "<!-- [$no] -->$tmp<!-- / [$no] -->\n\0";
		$mons{"$y$m"}++;
		$mn{"$y$m"}++;
		if ($mn{"$y$m"} % $cf{page_max} == 1) {
			$monno{"$y$m"}++;
		}
		$idx{$no} .= qq|mon:$y$m-$monno{"$y$m"}.html\t|;
		
		# RSS用：10件まで
		push(@rss,"$n\0$sub\0$no\0$log\0$date\0$time") if ($i <= 10);
	}
	if (@idx == 0) { $nohtml++; }
	undef @idx;
	
	# 新着記事リンク/アーカイブ作成
	for ($head,$foot) {
		s/<!-- profile -->/$profile/;
		s|<!-- new_art -->|<ul>\n$newa</ul>|;
		s/<!-- archive -->/make_archv(%mons)/e;
	}
	
	# カレンダ作成
	require './lib/calendar.pl';
	my %cal = make_calen(\%ym,\%ymd);
	
	# 更新前のファイル名を覚えておく
	my @old   = glob("$cf{htmldir}/*.html");
	my @old_c = glob("$cf{htmldir}/archives/cat/*.html");
	my @old_m = glob("$cf{htmldir}/archives/mon/*.html");
	my @old_d = glob("$cf{htmldir}/archives/day/*.html");
	my @old_a = glob("$cf{htmldir}/archives/art/*.html");
	
	# 基本ページ書き出し
	my %new;
	for my $n ( keys %body ) {
		# ファイル名定義
		my $fname = $n == 1 ? 'index.html' : "page-$n.html";
		
		# ページ繰越ボタン作成
		my $bot = $foot;
		$bot =~ s/<!-- pages -->/make_pager($i,$n,'','top')/e;
		
		# カレンダ
		my ($num,$y,$m) = $body{$n} =~ /^<!-- \[(\d+)\] (\d+)-(\d+)/ && ($1,$2,$3);
		my $top = $head;
		for ($top,$bot) {
			s/<!-- calendar -->/$cal{"$y$m"}/;
			s/<!-- tb_area -->.+?<!-- tb_area -->//s;
			s/<!-- com_area -->.+?<!-- com_area -->//s;
		}
		
		# 更新ファイル名を覚える
		$new{body}{"$cf{htmldir}/$fname"}++;
		
		# 更新ファイル生成
		open(DAT,"> $cf{htmldir}/$fname");
		print DAT $top,$body{$n},make_foot($bot);
		close(DAT);
	}
	undef %body;
	
	# カテゴリページ書き出し
	for my $n ( keys %cate ) {
		my ($i,$no,$body);
		for my $cb ( split(/\0/,$cate{$n}) ) {
			$body .= $cb;
			$i++;
			if ($i % $cf{page_max} == 0) {
				# ファイル名定義
				$no++;
				my $fname = "$n-$no.html";
				
				# ページ繰越ボタン作成
				my $bot = $foot;
				$bot =~ s/<!-- pages -->/make_pager($cat{$n},$no,$n)/e;
				
				# 更新ファイル名を覚える
				$new{cate}{"$cf{htmldir}/archives/cat/$fname"}++;
				
				# 年月取得
				my ($y,$m) = $body =~ /^<!-- \[\d+\] (\d+)-(\d+)/ && ($1,$2);
				
				my $top = $head;
				for ($top,$bot) {
					s/<!-- calendar -->/$cal{"$y$m"}/;
					s/<!-- tb_area -->.+?<!-- tb_area -->//s;
					s/<!-- com_area -->.+?<!-- com_area -->//s;
				}
				
				# 更新ファイル生成
				open(DAT,"> $cf{htmldir}/archives/cat/$fname");
				print DAT $top,$body,make_foot($bot);
				close(DAT);
				
				# クリア
				$body = '';
			}
		}
		# 端数分処理
		if ($i % $cf{page_max} != 0) {
			# ファイル名定義
			$no++;
			my $fname = "$n-$no.html";
			
			# ページ繰越ボタン作成
			my $bot = $foot;
			$bot =~ s/<!-- pages -->/make_pager($cat{$n},$no,$n)/e;
			
			my ($y,$m) = $body =~ /^<!-- \[\d+\] (\d+)-(\d+)/ && ($1,$2);
			my $top = $head;
			for ($top,$bot) {
				s/<!-- calendar -->/$cal{"$y$m"}/;
				s/<!-- tb_area -->.+?<!-- tb_area -->//s;
				s/<!-- com_area -->.+?<!-- com_area -->//s;
			}
			
			# 更新ファイル名を覚える
			$new{cate}{"$cf{htmldir}/archives/cat/$fname"}++;
			
			# 更新ファイル生成
			open(DAT,"> $cf{htmldir}/archives/cat/$fname");
			print DAT $top,$body,make_foot($bot);
			close(DAT);
		}
	}
	undef %cate;
	
	# 月次ページ書き出し
	for my $ym ( keys %mon ) {
		my ($i,$no,$body);
		for my $mb ( split(/\0/,$mon{$ym}) ) {
			$body .= $mb;
			$i++;
			if ($i % $cf{page_max} == 0) {
				# ファイル名定義
				$no++;
				my $fname = "$ym-$no.html";
				
				# ページ繰越ボタン作成
				my $bot = $foot;
				$bot =~ s/<!-- pages -->/make_pager($mons{$ym},$no,$ym)/e;
				
				# 更新ファイル名を覚える
				$new{mon}{"$cf{htmldir}/archives/mon/$fname"}++;
				
				my $top = $head;
				for ($top,$bot) {
					s/<!-- calendar -->/$cal{$ym}/;
					s/<!-- tb_area -->.+?<!-- tb_area -->//s;
					s/<!-- com_area -->.+?<!-- com_area -->//s;
				}
				
				# 更新ファイル生成
				open(DAT,"> $cf{htmldir}/archives/mon/$fname");
				print DAT $top,$body,make_foot($bot);
				close(DAT);
				
				# クリア
				$body = '';
			}
		}
		# 端数分処理
		if ($i % $cf{page_max} != 0) {
			# ファイル名定義
			$no++;
			my $fname = "$ym-$no.html";
			
			# ページ繰越ボタン作成
			my $bot = $foot;
			$bot =~ s/<!-- pages -->/make_pager($mons{$ym},$no,$ym)/e;
			
			my $top = $head;
			for ($top,$bot) {
				s/<!-- calendar -->/$cal{$ym}/;
				s/<!-- tb_area -->.+?<!-- tb_area -->//s;
				s/<!-- com_area -->.+?<!-- com_area -->//s;
			}
			
			# 更新ファイル名を覚える
			$new{mon}{"$cf{htmldir}/archives/mon/$fname"}++;
			
			# 更新ファイル生成
			open(DAT,"> $cf{htmldir}/archives/mon/$fname");
			print DAT $top,$body,make_foot($bot);
			close(DAT);
		}
	}
	undef %mon;
	
	# 日次及び固定ファイル生成
	for my $key ( keys %date ) {
		my ($y,$m,$d) = split(/-/,$key);
		my ($i,$no,$body);
		for my $day ( split(/\0/,$date{$key}) ) {
			$body .= $day;
			$i++;
			if ($i % $cf{page_max} == 0) {
				# ファイル名定義
				$no++;
				my $fname = "$y$m$d-$no.html";
				
				# ページ繰越ボタン作成
				my $bot = $foot;
				$bot =~ s/<!-- pages -->/make_pager($days{"$y$m$d"},$no,"$y$m$d")/e;
				
				# 更新ファイル名を覚える
				$new{date}{"$cf{htmldir}/archives/day/$fname"}++;
				
				my $top = $head;
				for ($top,$bot) {
					s/<!-- calendar -->/$cal{"$y$m"}/;
					s/<!-- tb_area -->.+?<!-- tb_area -->//s;
					s/<!-- com_area -->.+?<!-- com_area -->//s;
				}
				
				# --- 日次ページ
				open(DAT,"> $cf{htmldir}/archives/day/$fname");
				print DAT $top,$body,make_foot($bot);
				close(DAT);
				
				$body = '';
			}
			
			# --- 固定ページ生成
			my ($art,$tb,$cm) = $day =~ /^<!-- \[(\d+)\] (\d*):(\d*)/ && ($1,$2,$3);
			
			# TB/COM
			my ($top,$bot) = ($head,$foot);
			for ($top,$bot) {
				s/!artnum!/$art/g;
				s|!tb_url!|$cf{sysurl}/blog.cgi/$art|g;
				
				# TB
				if ($tb) {
					s/(<!-- tb_list -->).*(<!-- tb_list -->)/$1 . tb_list($art,$tmpl{trackback}) . $2/se;
				} else {
					s/<!-- tb_area -->.+?<!-- tb_area -->//s;
				}
				# COM
				if ($cm) {
					s/(<!-- com_list -->).*(<!-- com_list -->)/$1 . com_list($art,$tmpl{comment}) . $2/se;
				} else {
					s/<!-- com_area -->.+?<!-- com_area -->//s;
				}
			}
			
			$new{art}{"$cf{htmldir}/archives/art/$art.html"}++;
			
			# ページタイトル
			$top =~ s|<title>|<title>$sub{$art} - |;
			
			open(DB,"> $cf{htmldir}/archives/art/$art.html");
			print DB $top,$day,make_foot($bot);
			close(DB);
		}
		# 端数分処理
		if ($i % $cf{page_max} != 0) {
			# ファイル名定義
			$no++;
			my $fname = "$y$m$d-$no.html";
			
			# ページ繰越ボタン作成
			my $bot = $foot;
			$bot =~ s/<!-- pages -->/make_pager($days{"$y$m$d"},$no,"$y$m$d")/e;
			
			# 更新ファイル名を覚える
			$new{date}{"$cf{htmldir}/archives/day/$fname"}++;
			
			my $top = $head;
			for ($top,$bot) {
				s/<!-- calendar -->/$cal{"$y$m"}/;
				s/<!-- tb_area -->.+?<!-- tb_area -->//s;
				s/<!-- com_area -->.+?<!-- com_area -->//s;
			}
			
			# ページタイトル
			$top =~ s|<title>|<title>$sub{$art} - |;
			
			# --- 日次ページ
			open(DAT,"> $cf{htmldir}/archives/day/$fname");
			print DAT $top,$body,make_foot($bot);
			close(DAT);
		}
	}
	undef %date;
	undef %sub;
	
	# index生成
	my @log;
	for ( keys %idx ) {
		push(@log,"$_\t$idx{$_}\n");
	}
	open(DB,"> $cf{datadir}/index.dat");
	print DB @log;
	close(DB);
	
	# 不要ファイル削除
	for (@old) {
		if (!defined $new{body}{$_}) { unlink("$_"); }
	}
	for (@old_c) {
		if (!defined $new{cate}{$_}) { unlink("$_"); }
	}
	for (@old_m) {
		if (!defined $new{mon}{$_}) { unlink("$_"); }
	}
	for (@old_d) {
		if (!defined $new{date}{$_}) { unlink("$_"); }
	}
	for (@old_a) {
		if (!defined $new{art}{$_}) { unlink("$_"); }
	}
	undef %new;
	
	# CSS/RSS更新
	if ($nohtml) {
		unlink("$cf{htmldir}/style.css");
		unlink("$cf{htmldir}/index.xml");
	} else {
		open(TPL,"< $cf{datadir}/tmpl/style.css") or error('open err: tmpl/style.css');
		open(CSS,"> $cf{htmldir}/style.css") or error("write err: $cf{basedir}/style.css");
		while(<TPL>) { print CSS $_; }
		close(CSS);
		close(TPL);
		
		# RSS作成
		make_rss(@rss);
	}
	
	# 完了メッセージ
	my $key = $in{ref} eq 'pg' ? 'page_mgr' : 'ref_chg';
	echo_msg('変更を反映しました',$key);
}

#-----------------------------------------------------------
#  繰越ボタン作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$n,$op,$top) = @_;
	my $max = $top eq 'top' ? $cf{topg_max} : $cf{page_max};
	$max ||= 5;
	my $pg = $n == 1 ? 0 : $max * ($n-1);
	
	# ページ繰越定義
	my $next = $pg + $max;
	my $back = $pg - $max;
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<li><b>$x</b></li>\n!);
			} else {
				my $file = $op ne '' ? "$op-$x" : $x <= 1 ? 'index' : "page-$x";
				push(@pg,qq!<li><a href="$file.html">$x</a></li>\n!);
			}
			$x++;
			$y += $max;
			$z -= $max;
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		my $n = ($back / $max) + 1;
		my $file = $op ne '' ? "$op-$n" :	$n <= 1 ? 'index' :	"page-$n";
		$ret = qq!<li><a href="$file.html">&laquo;</a></li>\n! . $ret;
	}
	if ($next < $i) {
		my $n = ($next / $max) + 1;
		my $file = $op ne '' ? "$op-$n" :	$n <= 1 ? 'index' :	"page-$n";
		$ret .= qq!<li><a href="$file.html">&raquo;</a></li>\n!;
	}
	$ret;
}

#-----------------------------------------------------------
#  サイド・フッタ画面
#-----------------------------------------------------------
sub read_side {
	my %cat = @_;
	
	# サイドデータ
	open(IN,"$cf{datadir}/side.dat") or error('open err: side.dat');
	my $side = join('',<IN>);
	close(IN);
	
	# フッタデータ
	open(IN,"$cf{datadir}/foot.dat") or error('open err: foot.dat');
	my $foot = join('',<IN>);
	close(IN);
	
	# リンクデータ
	my $link;
	open(IN,"$cf{datadir}/link.dat") or error('open err: link.dat');
	while(<IN>) {
		chomp;
		my ($no,$nam,$url) = split(/\t/);
		
		$link .= qq|<li><a href="$url" target="_blank">$nam</a></li>\n|;
	}
	close(IN);
	
	$link = qq|<ul>\n$link</ul>\n|;
	
	# カテゴリ未分類
	my ($cate,%clnk);
	if (defined($cat{0})) {
		$cate .= qq|<li><a href="$cf{htmlurl}/archives/cat/0-1.html">未分類 ($cat{0})</a></li>\n|;
		$clnk{0} = qq|<a href="$cf{htmlurl}/archives/cat/0-1.html">未分類</a>|;
	} else {
		$cate .= qq|<li>未分類 (0)</li>\n|;
		$clnk{0} = "未分類";
	}
	
	# カテゴリデータ
	open(IN,"$cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<IN>) {
		chomp;
		my ($no,$nam) = split(/\t/);
		
		if (defined($cat{$no})) {
			$cate .= qq|<li><a href="$cf{htmlurl}/archives/cat/$no-1.html">$nam ($cat{$no})</a></li>\n|;
			$clnk{$no} = qq|<a href="$cf{htmlurl}/archives/cat/$no-1.html">$nam</a>|;
		} else {
			$cate .= qq|<li>$nam (0)</li>\n|;
			$clnk{$no} = $nam;
		}
	}
	close(IN);
	
	$cate = qq|<ul>\n$cate</ul>\n|;
	
	# タグ/改行
	$side = chg_tag($side);
	$foot = chg_tag($foot);
	$side =~ s|\n|<br>|g;
	$foot =~ s|\n|<br>|g;
	
	# RSSアイコン
	my $rss = qq|<a href="$cf{htmlurl}/index.xml"><img src="$cf{htmlurl}/tool/feed.png" class="icon" alt="RSS 2.0"></a> RSS 2.0|;
	
	# 結果を返す
	return ($side,$foot,$rss,$link,$cate,\%clnk);
}

#-----------------------------------------------------------
#  RSS 2.0 作成
#-----------------------------------------------------------
sub make_rss {
	my @log = @_;
	
	# RSS
	my $rss = <<EOM;
<?xml version="1.0" encoding="UTF-8" ?>
<rss version="2.0">
	<channel>
		<title>$cf{title}</title>
		<link>$cf{htmlurl}</link>
		<description>$cf{subttl}</description>
		<language>ja</language>
		<generator>$cf{version}</generator>
EOM

	# 月/週
	my @mon  = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @week = qw(Sun Mon Tue Wed Thu Fri Sat);
	
	for (@log) {
		my ($n,$sub,$no,$log,$date,$time) = split(/\0/);
		my ($y,$m,$d) = split(/\./,$date);
		
		# 曜日
		my $w = get_week($d,$m,$y);
		
		# 文字カット: description
		my $char = strcutbytes_utf8($log,150);
		
		$rss .= qq|\t\t<item>\n|;
		$rss .= qq|\t\t\t<title>$sub</title>\n|;
		$rss .= qq|\t\t\t<link>$cf{htmlurl}/archives/art/$no.html</link>\n|;
		$rss .= qq|\t\t\t<description>$char</description>\n|;
		$rss .= qq|\t\t\t<pubDate>$week[$w], $d $mon[$m-1] $y $time:00 +0900</pubDate>\n|;
		$rss .= qq|\t\t</item>\n|;
	}
	$rss .= "\t</channel>\n</rss>\n";
	
	# RSS書込
	open(RSS,"> $cf{htmldir}/index.xml");
	print RSS $rss;
	close(RSS);
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#  [quote] http://linkage.white-void.net/development/server/perl-utf8-strcut.html
#-----------------------------------------------------------
sub strcutbytes_utf8 {
	my ($src,$maxlen) = @_;
	$src =~ s/\n//g;
	$src =~ s/&lt;.*?&gt;//g;
	
	my $srclen = length($src);
	my $srcpos = 0;
	while($srcpos < $srclen) {
		my $character = substr($src, $srcpos, 1);
		my $value = ord($character);
		if($value < 0x80) { # ASCII characters
			$srcpos++;
			next;
		}
		my $width = 6;
		$width = 5 if ($value < 0xFC);
		$width = 4 if ($value < 0xF8);
		$width = 3 if ($value < 0xF0);
		$width = 2 if ($value < 0xE0);
		my $nextpos = $srcpos + $width;
		last if($nextpos > $maxlen);
		last if($nextpos > $srclen); # sequence is incomplete
		$srcpos = $nextpos;
	}
	return substr($src, 0, $srcpos);
}

#-----------------------------------------------------------
#  ツェラー公式
#-----------------------------------------------------------
sub get_week {
	my ($day,$month,$year) = @_;
	if ($month == 1 || $month == 2) {
		$year--;
		$month += 12;
	}
	return int($year + int($year/4) - int($year/100) + int($year/400) + int((13*$month+8)/5) + $day) % 7;
}

#-----------------------------------------------------------
#  月間アーカイブ作成
#-----------------------------------------------------------
sub make_archv {
	my %mon = @_;
	
	my $ret = "<ul>\n";
	for ( sort{ $b <=> $a }keys %mon ) {
		/^(\d{4})(\d{2})/;
		
		$ret .= qq|<li><a href="$cf{htmlurl}/archives/mon/$1$2-1.html">$1年$2月 ($mon{$_})</a></li>\n|;
	}
	
	return "$ret</ul>\n";
}

#-----------------------------------------------------------
#  TBリスト
#-----------------------------------------------------------
sub tb_list {
	my ($art,$loop) = @_;
	
	open(IN,"$cf{datadir}/tmpl/trackback.html");
	my $loop = join('',<IN>);
	close(IN);
	
	my $ret;
	open(DB,"$cf{datadir}/tb/$art.txt");
	while(<DB>) {
		chomp;
		my ($time,$bnam,$ttl,$url,$exc) = split(/\t/);
		
		my $tmp = $loop;
		$tmp =~ s/!title!/$ttl/g;
		$tmp =~ s/!blog_name!/$bnam/g;
		$tmp =~ s/!date!/chg_date($time)/eg;
		$tmp =~ s/!excerpt!/$exc/g;
		$tmp =~ s/!url!/$url/g;
		$ret .= $tmp;
	}
	close(DB);
	
	return $ret;
}

#-----------------------------------------------------------
#  コメントリスト
#-----------------------------------------------------------
sub com_list {
	my ($art,$loop) = @_;
	
	open(IN,"$cf{datadir}/tmpl/comment.html");
	my $loop = join('',<IN>);
	close(IN);
	
	my $ret;
	open(DB,"$cf{datadir}/com/$art.txt");
	while(<DB>) {
		chomp;
		my ($time,$nam,$ttl,$url,$msg) = split(/\t/);
		$nam = qq|<a href="$url" target="_blank">$nam</a>| if ($url);
		
		my $tmp = $loop;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!message!/$msg/g;
		$tmp =~ s/!date!/chg_date($time)/eg;
		$ret .= $tmp;
	}
	close(DB);
	
	return $ret;
}

#-----------------------------------------------------------
#  TB/COMカウント
#-----------------------------------------------------------
sub read_tbcm {
	my (%tb,%cm);
	open(DB,"$cf{datadir}/tbcm.dat");
	while(<DB>) {
		chomp;
		my ($no,$tb,$cm) = split(/\t/);
		
		$tb{$no} = $tb;
		$cm{$no} = $cm;
	}
	close(DB);
	
	return (\%tb,\%cm);
}


1;

