#┌─────────────────────────────────
#│ CafeLog : side_mgr.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  サイド・フッタ管理
#-----------------------------------------------------------
sub side_mgr {
	# 対象ファイル判定
	my $file = $in{file} =~ /foot/ ? 'foot.dat' : 'side.dat';
	
	# --- 編集実行
	if ($in{edit}) {
		# 改行
		$in{body} =~ s/\r\n/\n/g;
		$in{body} =~ s/\r/\n/g;
		
		# タグ復元
		$in{body} = chg_tag($in{body});
		
		# 更新
		open(DAT,"> $cf{datadir}/$file") or error("write err: $file");
		print DAT $in{body};
		close(DAT);
		
		# 完了画面
		echo_msg('編集を完了しました','side_mgr');
	}
	
	# 対象ファイル読み込み
	open(IN,"$cf{datadir}/$file") or error("open err: $file");
	my $data = join('',<IN>);
	close(IN);
	
	# 画面表示
	header("サイド画面管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/apl_side.png" class="icon"> サイド画面管理</p>
<p>・ サイド画面の編集を行います。</p>
<form action="$cf{index_cgi}" method="post" name="selform">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="side_mgr" value="1">
<table class="list">
<tr>
	<th class="ta-c">画面</th>
	<td>
		<select name="file" onchange="if(document.selform.file.value)location.href=document.selform.file.value;">
EOM

	# ファイル名
	my %fnam = (side => 'サイド画面', foot => 'フッタ画面');
	for (qw(side foot)) {
		if ($in{file} eq $_) {
			print qq|<option value="$cf{index_cgi}?side_mgr=1&file=$_&sid=$in{sid}" selected>$fnam{$_}\n|;
		} else {
			print qq|<option value="$cf{index_cgi}?side_mgr=1&file=$_&sid=$in{sid}">$fnam{$_}\n|;
		}
	}
	
	print <<EOM;
		</select> &nbsp; [プルダウン切替]
	</td>
</tr><tr>
	<th class="ta-c">内容</th>
	<td>
		<input type="checkbox" onclick="toggleHtmlEditor(this.checked,'myArea3','full')">エディタ機能<br>
		<textarea name="body" style="width:650px;height:25em;" id="myArea3">$data</textarea>
	</td>
</tr>
</table>
<input type="submit" name="edit" value="編集する" class="bigbtn">
</form>
</div>
</div>
EOM

	# nicEdit実行タグ
	nic_edit();
	
	footer();
}



1;

