#┌─────────────────────────────────
#│ CafeLog : tbcm_mgr.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  コメント/TB管理
#-----------------------------------------------------------
sub tbcm_mgr {
	# 処理
	my $job = $in{job} ne '' ? $in{job} : 'cm';
	
	my %key;
	if ($job eq 'cm') {
		$key{ttl} = 'コメント';
		$key{ico} = 'com.png';
	} else {
		$key{ttl} = 'トラックバック';
		$key{ico} = 'tb.png';
	}
	
	# 個別処理
	if ($in{num}) {
		tbcm_form($in{num},$job,\%key);
	} else {
		my $num;
		for ( keys %in ) {
			if (/^num:(\d+)/) {
				$num = $1;
				last;
			}
		}
		if ($num) { tbcm_form($num,$job,\%key); }
	}
	
	my (%tb,%cm);
	open(IN,"$cf{datadir}/tbcm.dat");
	while(<IN>) {
		chomp;
		my ($no,$tb,$cm) = split(/\t/);
		$cm{$no} = $cm;
		$tb{$no} = $tb;
	}
	close(IN);
	
	my %cat;
	open(IN,"$cf{datadir}/cate.dat");
	while(<IN>) {
		chomp;
		my ($no,$cat) = split(/\t/);
		$cat{$no} = $cat;
	}
	close(IN);
	
	# 画面表示
	header("$key{ttl}管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<div id="tog-btn">
<form action="#" name="selform">
コメント/TB切替：
<select name="mode" onchange="if(document.selform.mode.value)location.href=document.selform.mode.value;">
EOM

	my %nam = (cm => 'コメント管理', tb => 'トラックバック管理');
	for (qw(cm tb)) {
		if ($job eq $_) {
			print qq|<option value="$cf{index_cgi}?tbcm_mgr=1&job=$_&sid=$in{sid}" selected>$nam{$_}\n|;
		} else {
			print qq|<option value="$cf{index_cgi}?tbcm_mgr=1&job=$_&sid=$in{sid}">$nam{$_}\n|;
		}
	}

	print <<EOM;
</select>
</form>
</div>
<p class="ttl"><img src="$cf{htmlurl}/tool/$key{ico}" class="icon"> $key{ttl}管理</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="tbcm_mgr" value="1">
<input type="hidden" name="job" value="$job">
<p>・ 以下は$key{ttl}の付いた記事一覧です。</p>
<table class="list">
<tr>
	<th></th>
	<th>日付</th>
	<th>カテゴリ</th>
	<th>件名</th>
	<th>$key{ttl}数</th>
</tr>
EOM

	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my $i;
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		chomp;
		my ($no,$date,$time,$ttl,$open,$cat,$tb,$cm) = split(/\t/);
		next if (!$open);
		next if (!$cm{$no} && $job eq 'cm');
		next if (!$tb{$no} && $job eq 'tb');
		
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{list_max});
		
		# 文字カット
		$ttl = cut_str($ttl,26);
		
		if ($cat{$cat} eq '') { $cat{$cat} = '未分類'; }
		my $cnt = $job eq 'cm' ? $cm{$no} : $tb{$no};
		
		print qq|<tr><td><input type="submit" name="num:$no" value="選択"></td>|;
		print qq|<td>$date $time</td>|;
		print qq|<td class="ta-c">$cat{$cat}</td>|;
		print qq|<td>$ttl</td>|;
		print qq|<td class="ta-c">$cnt</td></tr>\n|;
	}
	close(IN);
	
	if (!$i) {
		print qq|<tr><td colspan="5" class="ta-c">該当記事はありません</td></tr>\n|;
	}
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,$job);
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  個別記事フォーム
#-----------------------------------------------------------
sub tbcm_form {
	my ($num,$job,$key) = @_;
	
	# 削除
	my $del;
	for ( keys %in ) {
		if (/^del:(\d+)/) {
			$del = $1;
			last;
		}
	}
	if ($del) { del_tbcm($del,$job,$key); }
	
	# 画面表示
	header("$$key{ttl}管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/$$key{ico}" class="icon"> $$key{ttl}管理 &gt; $$key{ttl}一覧</p>
<div class="ta-r">
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="tbcm_mgr" value="1">
<input type="hidden" name="job" value="$job">
<input type="submit" value="&lt;&lt; 戻る">
</form>
</div>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="tbcm_mgr" value="1">
<input type="hidden" name="job" value="$job">
<input type="hidden" name="num" value="$num">
<p>・ 以下は$$key{ttl}一覧です。</p>
<table class="list">
<tr>
	<th></th>
	<th>日付</th>
	<th>名前</th>
	<th>コメント</th>
	<th>ホスト名</th>
</tr>
EOM

	my $file = $job eq 'cm' ? "com/$num.txt" : "tb/$num.txt";
	
	open(IN,"$cf{datadir}/$file") or error("open err: $file");
	while(<IN>) {
		my ($tim,$nam,$ttl,$url,$msg,$host) = split(/\t/);
		$msg =~ s|<br>| |g;
		
		print qq|<tr><td><input type="submit" name="del:$tim" value="削除" onclick="return confirm('削除しますか？');"></td>|;
		print qq|<td>| . chg_date($tim) . qq|</td>|;
		print qq|<td>$nam</td>|;
		print qq|<td>| . cut_str($msg,30) . qq|</td>|;
		print qq|<td>$host</td></tr>\n|;
	}
	close(IN);

	print <<EOM;
</table>
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  TB/コメント削除
#-----------------------------------------------------------
sub del_tbcm {
	my ($del,$job,$key) = @_;
	
	# テンプレート
	open(IN,"$cf{datadir}/tmpl/comment.html");
	my $loop = join('',<IN>);
	close(IN);
	
	my $file = $job eq 'cm' ? "com/$in{num}.txt" : "tb/$in{num}.txt";
	
	# コメントデータ削除
	my ($list,@log);
	open(DB,"+< $cf{datadir}/$file") or error("open err: $file");
	eval "flock(DB,2);";
	while(<DB>) {
		my ($tim,$nam,$ttl,$url,$msg,$host) = split(/\t/);
		next if ($del == $tim);
		
		$nam = qq|<a href="$url" target="_blank">$nam</a>| if ($url);
		my $tmp = $loop;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!date!/chg_date($tim)/eg;
		$tmp =~ s/!message!/$msg/g;
		$list .= $tmp;
		
		push(@log,$_);
	}
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
	
	# 残数
	my $all = @log;
	
	# index更新
	@log = ();
	open(DB,"+< $cf{datadir}/tbcm.dat");
	eval "flock(DB,2);";
	while(<DB>) {
		chomp;
		my ($no,$tb,$cm) = split(/\t/);
		
		if ($in{num} == $no) {
			if ($job eq 'cm') {
				$_ = "$no\t$tb\t$all";
			} else {
				$_ = "$no\t$all\t$cm";
			}
		}
		push(@log,"$_\n");
	}
	seek(DB,0,0);
	print DB @log;
	truncate(DB,tell(DB));
	close(DB);
	
	# 固定リンクファイル更新
	open(DB,"+< $cf{htmldir}/archives/art/$in{num}.html");
	eval "flock(DB,2);";
	my $html = join('',<DB>);
	
	# COM
	if ($job eq 'cm') {
		$html =~ s/(<!-- cmlink -->.*)\(\d+\)(.*<!-- cmlink -->)/$1($all)$2/s;
		$html =~ s/(<!-- com_list -->).*(<!-- com_list -->)/$1 . $list . $2/se;
	# TB
	} else {
		$html =~ s/(<!-- tblink -->.*)\(\d+\)(.*<!-- tblink -->)/$1($all)$2/s;
		$html =~ s/(<!-- tb_list -->).*(<!-- tb_list -->)/$1 . $list . $2/se;
	}
	
	seek(DB,0,0);
	print DB $html;
	truncate(DB,tell(DB));
	close(DB);
	
	# 関連ファイルindex
	my $idx;
	open(IN,"$cf{datadir}/index.dat");
	while(<IN>) {
		my ($no) = split(/\t/);
		
		if ($in{num} == $no) {
			chomp;
			$idx = $_;
			last;
		}
	}
	close(IN);
	
	# 関連ファイルコメント数更新
	my @idx = split(/\t/,$idx);
	shift(@idx);
	for (@idx) {
		my ($key,$val) = split(/:/);
		next if ($key eq 'art');
		
		my $file = $key eq 'top' ? "$cf{htmldir}/$val" : "$cf{htmldir}/archives/$key/$val";
		
		open(DB,"+< $cf{htmldir}/$file");
		eval "flock(DB,2);";
		my $html = join('',<DB>);
		
		# COM
		if ($job eq 'cm') {
			$html =~ s/(<!-- \[$in{num}\].*?<!-- cmlink -->.*?)\(\d+\)(.*<!-- cmlink -->.*?<!-- \/ \[$in{num}\])/$1($all)$2/s;
		
		# TB
		} else {
			$html =~ s/(<!-- \[$in{num}\].*?<!-- tblink -->.*?)\(\d+\)(.*<!-- tblink -->.*?<!-- \/ \[$in{num}\])/$1($all)$2/s;
		}
		
		seek(DB,0,0);
		print DB $html;
		truncate(DB,tell(DB));
		close(DB);
	}
}


1;

