#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ CafeLog : check.cgi - 2021/04/17
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 外部ファイル取込み
require './init.cgi';
my %cf = set_init();

print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="utf-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
<li>Perlバージョン : $]
EOM

# データファイル
my %log = (
	"$cf{datadir}/base.dat" => '基本設定データ',
	"$cf{datadir}/page.dat" => 'ページデータ',
	"$cf{datadir}/side.dat" => 'サイドデータ',
	"$cf{datadir}/foot.dat" => 'フッタデータ',
	"$cf{datadir}/img.dat"  => '画像データ',
	"$cf{datadir}/num.dat"  => '通番データ',
	"$cf{datadir}/link.dat" => 'リンクデータ',
	"$cf{datadir}/cate.dat" => 'カテゴリデータ',
	"$cf{datadir}/tbcm.dat" => 'コメント/TBデータ',
	"$cf{datadir}/pass.dat" => 'パスワードデータ',
	"$cf{datadir}/tb.tmp"   => 'TB一時データ',
	"$cf{datadir}/cm.tmp"   => 'コメント一時データ',
	"$cf{datadir}/tmpl/index.html"    => 'テンプレート : index.html',
	"$cf{datadir}/tmpl/calendar.html" => 'テンプレート : calendar.html',
	"$cf{datadir}/tmpl/comment.html"  => 'テンプレート : comment.html',
	"$cf{datadir}/tmpl/trackback.html" => 'テンプレート : trackback.html',
	"$cf{datadir}/tmpl/comconf.html"  => 'テンプレート : comconf.html',
	"$cf{datadir}/tmpl/style.css"     => 'テンプレート : style.css',
	);
for ( keys %log ) {
	if (-f $_) {
		print "<li>$log{$_}パス : OK\n";
		if (-r $_ && -w $_) {
			print "<li>$log{$_}パーミッション : OK\n";
		} else {
			print "<li>$log{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$log{$_}パス : NG\n";
	}
}

# ディレクトリ
my %dir = (
	$cf{datadir}       => 'データディレクトリ',
	"$cf{datadir}/log" => 'ログディレクトリ',
	"$cf{datadir}/ses" => 'セッションディレクトリ',
	"$cf{datadir}/com" => 'コメントディレクトリ',
	"$cf{datadir}/tb"  => 'TBディレクトリ',
	"$cf{datadir}/pwd" => 'パスワードディレクトリ',
	$cf{htmldir}       => 'HTMLディレクトリ',
	"$cf{htmldir}/img" => '画像ディレクトリ',
	"$cf{htmldir}/archives/cat" => 'カテゴリディレクトリ',
	"$cf{htmldir}/archives/mon" => '月次ディレクトリ',
	"$cf{htmldir}/archives/day" => '日次ディレクトリ',
	"$cf{htmldir}/archives/art" => '記事ディレクトリ',
	);
for ( keys %dir ) {
	if (-d $_) {
		print "<li>$dir{$_}パス : OK\n";
		next if ($_ eq $cf{datadir});
		
		if (-r $_ && -w $_ && -x $_) {
			print "<li>$dir{$_}パーミッション : OK\n";
		} else {
			print "<li>$dir{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$dir{$_}パス : NG\n";
	}
}

# モジュール動作確認
my @mod = qw(Image::Magick GD);
foreach (@mod) {
	if ( eval "require $_" ) {
		print "<li>$_ : OK\n";
	} else {
		print "<li>$_ : NG\n";
	}
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;

