# モジュール取込/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ CafeLog : init.cgi - 2024/07/28
#│ copyright (c) kentweb, 1997-2024
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'CafeLog v5.75';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理画面：１回当りの最大投稿サイズ (Bytes)
# [参考] 5242880 = 5MB
$cf{maxdata} = 5242880;

# ユーザ画面：１回当りの最大投稿サイズ (Bytes)
# [参考] 512000 = 500KB
$cf{maxuser} = 512000;

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# HTMLディレクトリ【サーバパス】
$cf{htmldir} = '..';

# HTMLディレクトリ【URLパス】（必ず http://からの絶対パスで）
$cf{htmlurl} = 'http://www.example.com/cafe';

# adminディレクトリ【URLパス】（必ず http://からの絶対パスで）
$cf{sysurl} = 'http://www.example.com/cafe/admin';

# 管理プログラム（ファイル名のみ）
$cf{index_cgi} = 'index.cgi';

# ブログプログラム（ファイル名のみ）
$cf{blog_cgi} = 'blog.cgi';

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# -------------------------------------------------------------- #
# [ 以下は、メール通知（コメント/TB受信時）に関する設定 ]
#
# メール通知する（コメント/TB受信時）
# → 0=no  1=yes
$cf{mailing} = 0;

# メールアドレス
$cf{mailto} = 'xxx@xxx.xx';

# sendmailパス
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailに -f コマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# -------------------------------------------------------------- #
# [ 以下は「画像認証機能」機能（スパム対策）を使用する場合の設定 ]
#
# 画像認証機能の使用
# 1 : ライブラリ版（pngren.pl）
# 2 : モジュール版（GD::SecurityImage + Image::Magick）→ Image::Magick必須
$cf{use_captcha} = 1;

# 認証用画像生成ファイル【URLパス】
$cf{captcha_cgi} = './captcha.cgi';

# 画像認証プログラム【サーバパス】
$cf{captcha_pl} = './lib/captcha.pl';
$cf{captsec_pl} = './lib/captsec.pl';
$cf{pngren_pl}  = './lib/pngren.pl';

# 画像認証機能用暗号化キー（暗号化/復号化をするためのキー）
# → 適当に変更してください。
$cf{captcha_key} = 'CafeNote';

# 投稿キー許容時間（分単位）
# → 投稿フォーム表示後、送信ボタンが押されるまでの可能時間。
$cf{cap_time} = 10;

# 投稿キーの文字数
# ライブラリ版 : 4～8文字で設定
# モジュール版 : 6～8文字で設定
$cf{cap_len} = 6;

# 画像/フォント格納ディレクトリ【サーバパス】
$cf{bin_dir} = './lib/bin';

# [ライブラリ版] 画像ファイル [ ファイル名のみ ]
$cf{si_png} = "casual.png";

# [モジュール版] 画像フォント [ ファイル名のみ ]
$cf{font_ttl} = "tempest.ttf";

#===========================================================
# ■ 設定完了
#===========================================================

# パス定義
$cf{blog_cgi} = "$cf{sysurl}/$cf{blog_cgi}";

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  日時変換
#-----------------------------------------------------------
sub chg_date {
	my ($time,$key) = @_;
	
	my ($min,$hour,$day,$mon,$year) = (localtime($time))[1..5];
	
	if ($key eq 's') {
		sprintf("%02d/%02d/%02d %02d:%02d",$year-100,$mon+1,$day,$hour,$min);
	} else {
		sprintf("%04d年%02d月%02d日 %02d:%02d",$year+1900,$mon+1,$day,$hour,$min);
	}
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub make_foot {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin:2em 0;text-align:center;font-size:10px;">
	- <a href="https://www.kent-web.com/" target="_top">CafeLog</a> -
</p>
EOM

	my $ret;
	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		$ret = "$1$copy$2\n";
	} else {
		$ret .= "$foot$copy\n";
		$ret .= "</body></html>\n";
	}
	return $ret;
}


1;

