#┌─────────────────────────────────
#│ CafeLog : calendar.pl - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  カレンダ作成
#-----------------------------------------------------------
sub make_calen {
	my ($ymh,$ymd) = @_;
	
	# 年月データを新しい順に並べる
	my @ym = sort{ $a <=> $b } keys %{$ymh};
	
	# テンプレート読み込み
	open(IN,"$cf{datadir}/tmpl/calendar.html") or error('open err: calendar.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl);
	
	my %ret;
	for my $ym ( keys %{$ymh} ) {
		my ($y,$m) = $ym =~ /^(\d{4})(\d{2})/ && ($1,$2);
		
		my $week = get_week(1,$m,$y);
		my $last = last_day($y,$m);
		
		my ($day,$end);
		foreach my $k (1 .. 6) {
			
			# 週のテンプレート情報
			my $tmp = $loop;
			
			# 末日のフラグが立った場合はループを終了
			last if ($end);
			
			# 日から土まで7日分をループ
			foreach my $i (0 .. 6) {
				
				# 第１週で初日の週より小のとき、又は終了フラグが立ったときは「空き枠」
				if (($k == 1 && $i < $week) || $end) {
					$tmp =~ s/!$i!/&nbsp;/;
				
				# 実枠あり
				} else {
					# 日を数える
					$day++;
					
					# 枠処理
					my $d = sprintf("%02d",$day);
					my $cday;
					if (defined($$ymd{"$ym$d"})) {
						$cday = qq|<a href="$cf{htmlurl}/archives/day/$y$m$d-1.html">$day</a>|;
					} else {
						$cday = $day;
					}
					$tmp =~ s/!$i!/$cday/;
				}
				
				# 末日に達した場合フラグを立てる
				if ($day >= $last) { $end = 1; }
			}
			$ret{$ym} .= $tmp;
		}
		
		$ret{$ym} = $head . $ret{$ym} . $foot;
		$ret{$ym} =~ s/!year!/$y/g;
		$ret{$ym} =~ s/!month!/$m/g;
		
		# 年月データの中の順番を認識する
		my ($hit,$back,$next,%ym);
		for (0 .. $#ym) {
			if ($ym == $ym[$_]) {
				$hit = $_;
			}
			$ym{$_} = $ym[$_];
		}
		my $back = $hit - 1;
		my $next = $hit + 1;
		
		# 前月ナビ作成
		if ($ym{$back} =~ /^(\d{4})(\d{2})/) {
			my $lnk = "$cf{htmlurl}/archives/mon/$1$2-1.html";
			$ret{$ym} =~ s|!back-link!|$lnk|;
		} else {
			$ret{$ym} =~ s|<a href="!back-link!">.+</a>||;
		}
		# 翌月ナビ作成
		if ($ym{$next} =~ /^(\d{4})(\d{2})/) {
			my $lnk = "$cf{htmlurl}/archives/mon/$1$2-1.html";
			$ret{$ym} =~ s|!next-link!|$lnk|;
		} else {
			$ret{$ym} =~ s|<a href="!next-link!">.+</a>||;
		}
	}
	
	# 結果を返す
	return %ret;
}

#-----------------------------------------------------------
#  ツェラー公式
#-----------------------------------------------------------
sub get_week {
	my ($day,$month,$year) = @_;
	if ($month == 1 || $month == 2) {
		$year--;
		$month += 12;
	}
	return int($year + int($year/4) - int($year/100) + int($year/400) + int((13*$month+8)/5) + $day) % 7;
}

#-----------------------------------------------------------
#  月の末日
#-----------------------------------------------------------
sub last_day {
	my ($y,$m) = @_;
	
	return (31,28,31,30,31,30,31,31,30,31,30,31) [$m - 1]
	+ ($m == 2 && (($y % 4 == 0 && $y % 100 != 0) || $y % 400 == 0));
}



1;

