#┌─────────────────────────────────
#│ CafeLog : cate_mgr.pl - 2023/07/08
#│ copyright (c) kentweb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  カテゴリ管理
#-----------------------------------------------------------
sub cate_mgr {
	# 新規
	if ($in{job_new}) { new_cate(); }
	
	# 上下移動
	if ($in{up} or $in{dn}) { sort_cate(); }
	
	# ボタン押下認識
	my ($edit,$dele);
	for ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		} elsif (/^del:(\d+)/) {
			$dele = $1;
			last;
		}
	}
	if ($edit) { edit_cate($edit); }
	if ($dele) { dele_cate($dele); }
	
	# 画面表示
	header("カテゴリ管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/apl_cate.png" class="icon"> カテゴリ管理</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="cate_mgr" value="1">
<p>・ 新規作成</p>
<table class="list">
<tr>
	<th>カテゴリ名</th>
	<th>操作</th>
</tr><tr>
	<td><input type="text" name="name" size="35"></td>
	<td><input type="submit" name="job_new" value="追加"></td>
</tr>
</table>
<p>・ 修正・削除・並替</p>
<table class="list">
<tr>
	<th>リンク</th>
	<th>操作</th>
</tr>
EOM

	my $i;
	open(IN,"$cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<IN>) {
		$i++;
		chomp;
		my ($no,$name) = split(/\t/);
		
		print qq|<tr><td><input type="text" name="name:$no" size="35" value="$name"></td>|;
		print qq|<td><input type="submit" name="edit:$no" value="修正">\n|;
		print qq|<input type="submit" name="del:$no" value="削除" onclick="return confirm('削除しますか？');">\n|;
		print qq|<a href="$cf{index_cgi}?cate_mgr=1&up=$no&sid=$in{sid}"><img src="$cf{htmlurl}/tool/up.png" alt="上へ移動" class="icon"></a>\n|;
		print qq|<a href="$cf{index_cgi}?cate_mgr=1&dn=$no&sid=$in{sid}"><img src="$cf{htmlurl}/tool/down.png" alt="下へ移動" class="icon"></a>\n|;
		print qq|</td></tr>\n|;
	}
	close(IN);
	
	if (!$i) {
		print qq|<tr><td colspan="2" class="ta-c">カテゴリ情報はありません。</td></tr>\n|;
	}
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,'cate_mgr');
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  カテゴリ新規
#-----------------------------------------------------------
sub new_cate {
	if ($in{name} eq '') { error('カテゴリ名が未入力です'); }
	
	my ($num,@log);
	open(DAT,"+< $cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<DAT>) {
		my ($no,undef) = split(/\t/);
		if ($num < $no) { $num = $no; }
		
		push(@log,$_);
	}
	$num++;
	unshift(@log,"$num\t$in{name}\n");
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了画面
	echo_msg('新規カテゴリを作成しました','cate_mgr');
}

#-----------------------------------------------------------
#  カテゴリ修正
#-----------------------------------------------------------
sub edit_cate {
	my $num = shift;
	
	if ($in{"name:$num"} eq '') { error('名称又は参照先が未入力です'); }
	
	my @log;
	open(DAT,"+< $cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<DAT>) {
		my ($no,undef) = split(/\t/);
		
		if ($no == $num) {
			$_ = qq|$no\t$in{"name:$num"}\n|;
		}
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了画面
	echo_msg('カテゴリ情報を修正しました','cate_mgr');
}

#-----------------------------------------------------------
#  カテゴリ削除
#-----------------------------------------------------------
sub dele_cate {
	my $del = shift;
	
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<DAT>) {
		my ($no,undef) = split(/\t/);
		next if ($del == $no);
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  カテゴリ並び替え
#-----------------------------------------------------------
sub sort_cate {
	my ($tmp,@log);
	open(DAT,"+< $cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<DAT>) {
		my ($no,undef) = split(/\t/);
		
		# 上移動
		if ($no == $in{up}) {
			my $log = pop(@log);
			push(@log,$_);
			push(@log,$log);
			next;
		
		# 下移動
		} elsif ($no == $in{dn}) {
			$tmp = $_;
			next;
		}
		push(@log,$_);
		
		if ($tmp) {
			push(@log,$tmp);
			$tmp = '';
		}
	}
	if ($tmp) { push(@log,$tmp); }
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}


1;

