#┌─────────────────────────────────
#│ CafeLog : find.pl - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  検索リスト
#-----------------------------------------------------------
sub find_list {
	# 入力チェック
	$in{q} =~ s/[\r\n]//g;
	if ($in{q} eq '') { error('no keyword!'); }
	
	# ページ数定義
	$in{pg} =~ s/\D//g;
	my $pg = $in{pg} || 0;
	
	# キーワードを配列化
	$in{q} =~ s/　/ /g;
	my @wd = split(/\s+/,$in{q});
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# indexファイルオープン
	my ($i,$n,$newa,@log,@idx,%cat,%ym,%ymd);
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		chomp;
		my ($no,$date,$time,$sub,$open,$cat,$tbno,$cmno) = split(/\t/);
		next if ($open != 1);
		
		# カテゴリ情報
		if ($cat eq '') { $cat = 0; }
		$cat{$cat}++;
		push(@idx,$_);
		
		# 新着記事リンク
		$n++;
		if ($n <= $cf{new_art}) {
			$newa .= qq|<li><a href="$cf{htmlurl}/archives/art/$no.html">$sub</a></li>\n|;
		}
		
		# 記事データ読み込み
		open(DB,"$cf{datadir}/log/$no.txt");
		my $log = join('',<DB>);
		close(DB);
		
		$log =~ s/\n//g;
		
		# キーワード検索
		my $flg;
		for my $wd (@wd) {
			if ("$sub $log" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
				$flg++;
			} else {
				$flg = 0;
				last;
			}
		}
		next if (!$flg);
		
		# 月次/カレンダ向け
		my ($y,$m,$d) = $date =~ /^(\d+)\.(\d+)\.(\d+)/ && ($1,$2,$3);
		$ym{"$y$m"}++;
		$ymd{"$y$m$d"}++;
		
		# 検索結果：表示用
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{page_max});
		
		push(@log,$_);
	}
	close(IN);
	
	# ページボタン作成
	my $pbtn = make_btn($i,$pg);
	
	# サイドデータ
	my ($side,$bot,$rss,$link,$cate,$clnk) = read_side(%cat);
	
	# TB/コメント数
	my (%tb,%cm);
	open(DB,"$cf{datadir}/tbcm.dat");
	while(<DB>) {
		chomp;
		my ($no,$tb,$cm) = split(/\t/);
		
		$tb{$no} = $tb;
		$cm{$no} = $cm;
	}
	close(DB);
	
	# カレンダ作成
	require './lib/calendar.pl';
	my %cal = make_calen(\%ym,\%ymd);
	
	# テンプレート読み込み
	open(IN,"$cf{datadir}/tmpl/index.html") or error('open err: index.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 置き換え
	$tmpl =~ s/!(title|subttl)!/$cf{$1}/g;
	$tmpl =~ s/<!-- sidebody -->/$side/;
	$tmpl =~ s/<!-- footer -->/$bot/;
	$tmpl =~ s/<!-- rss -->/$rss/;
	$tmpl =~ s/<!-- links -->/$link/;
	$tmpl =~ s/<!-- category -->/$cate/;
	$tmpl =~ s/!find!/$in{q}/g;
	$tmpl =~ s|!blog_cgi!|$cf{blog_cgi}|g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{htmlurl}/tool/$1" class="icon" alt="$1">|g;
	$tmpl =~ s|!css!|$cf{htmlurl}/style.css|;
	$tmpl =~ s|!top!|$cf{htmlurl}/index.html|;
	$tmpl =~ s|!rss!|$cf{htmlurl}/index.rdf|;
	$tmpl =~ s|<!-- pages -->|<p>$pbtn</p>|g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl);
	
	# カレンダ用にトップの記事
	my ($date) = (split(/\t/,$log[0]))[1];
	my ($y,$m) = $date =~ /^(\d+)\.(\d+)/ && ($1,$2);
	
	# 新着記事リンク/アーカイブ作成
	for ($head,$foot) {
		s|<!-- new_art -->|<ul>\n$newa</ul>|;
		s/<!-- archive -->/make_archv(%ym)/e;
		s/<!-- calendar -->/$cal{"$y$m"}/;
		s/<!-- tb_area -->.+<!-- tb_area -->//s;
		s/<!-- com_area -->.+<!-- com_area -->//s;
	}
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# 検索ヒット
	for (@log) {
		my ($no,$date,$time,$sub,$open,$cat,$tb,$cm) = split(/\t/);
		if ($cat eq '') { $cat = 0; }
		
		# 文字置き換え
		my $tmp = $loop;
		$tmp =~ s/!subject!/$sub/;
		$tmp =~ s/!date!/$date/;
		$tmp =~ s/!body!/read_body($no)/e;
		$tmp =~ s/!time!/$date $time/g;
		$tmp =~ s|!pmlink!|$cf{htmlurl}/archives/art/$no.html|g;
		$tmp =~ s|!cmlink!|$cf{htmlurl}/archives/art/$no.html#cm|g;
		$tmp =~ s|!tblink!|$cf{htmlurl}/archives/art/$no.html#tb|g;
		$tmp =~ s/!categ!/$$clnk{$cat}/g;
		
		if (!$tb) {
			$tmp =~ s/<!-- tblink -->.+?<!-- tblink -->//s;
		} else {
			$tmp =~ s/!tb_no!/$tb{$no} ? $tb{$no} : 0/e;
		}
		if (!$cm) {
			$tmp =~ s/<!-- cmlink -->.+?<!-- cmlink -->//s;
		} else {
			$tmp =~ s/!cm_no!/$cm{$no} ? $cm{$no} : 0/e;
		}
		
		print $tmp;
	}
	
	# フッター
	print make_foot($foot);
	exit;
}

#-----------------------------------------------------------
#  ページボタン作成
#-----------------------------------------------------------
sub make_btn {
	my ($i,$pg) = @_;
	
	# 引数
	my $param = 'q=' . url_encode($in{q});
	
	# ページ繰越数
	my $next = $pg + $cf{page_max};
	my $back = $pg - $cf{page_max};
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<li><b>$x</b></li>\n!);
			} else {
				push(@pg,qq!<li><a href="$cf{blog_cgi}?$param&amp;pg=$y">$x</a></li>\n!);
			}
			$x++;
			$y += $cf{page_max};
			$z -= $cf{page_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		$ret = qq!<li><a href="$cf{blog_cgi}?$param&amp;pg=$back">&laquo;</a></li>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<li><a href="$cf{blog_cgi}?$param&amp;pg=$next">&raquo;</a></li>\n!;
	}
	
	return $ret;
}

#-----------------------------------------------------------
#  URLエンコード
#-----------------------------------------------------------
sub url_encode {
	my $wd = shift;
	$wd =~ s/([^\w ])/'%' . unpack('H2',$1)/eg;
	$wd =~ tr/ /+/;
	return $wd;
}

#-----------------------------------------------------------
#  記事
#-----------------------------------------------------------
sub read_body {
	my $no = shift;
	
	# カテゴリデータ
	my %cat;
	open(IN,"$cf{datadir}/log/$no.txt");
	my $log = join('',<IN>);
	close(IN);
	
	$log = chg_tag($log);
	$log =~ s|\n|<br>|g;
	
	return $log;
}

#-----------------------------------------------------------
#  サイド・フッタ画面
#-----------------------------------------------------------
sub read_side {
	my %cat = @_;
	
	# サイドデータ
	open(IN,"$cf{datadir}/side.dat") or error('open err: side.dat');
	my $side = join('',<IN>);
	close(IN);
	
	# フッタデータ
	open(IN,"$cf{datadir}/foot.dat") or error('open err: foot.dat');
	my $foot = join('',<IN>);
	close(IN);
	
	# リンクデータ
	my $link;
	open(IN,"$cf{datadir}/link.dat") or error('open err: link.dat');
	while(<IN>) {
		chomp;
		my ($no,$nam,$url) = split(/\t/);
		
		$link .= qq|<li><a href="$url" target="_blank">$nam</a></li>\n|;
	}
	close(IN);
	
	$link = qq|<ul>\n$link</ul>\n|;
	
	# カテゴリ未分類
	my ($cate,%clnk);
	if (defined($cat{0})) {
		$cate .= qq|<li><a href="$cf{htmlurl}/archives/cat/0-1.html">未分類 ($cat{0})</a></li>\n|;
		$clnk{0} = qq|<a href="$cf{htmlurl}/archives/cat/0-1.html">未分類</a>|;
	} else {
		$cate .= qq|<li>未分類 (0)</li>\n|;
		$clnk{0} = "未分類";
	}
	
	# カテゴリデータ
	open(IN,"$cf{datadir}/cate.dat") or error('open err: cate.dat');
	while(<IN>) {
		chomp;
		my ($no,$nam) = split(/\t/);
		
		if (defined($cat{$no})) {
			$cate .= qq|<li><a href="$cf{htmlurl}/archives/cat/$no-1.html">$nam ($cat{$no})</a></li>\n|;
			$clnk{$no} = qq|<a href="$cf{htmlurl}/archives/cat/$no-1.html">$nam</a>|;
		} else {
			$cate .= qq|<li>$nam (0)</li>\n|;
			$clnk{$no} = $nam;
		}
	}
	close(IN);
	
	$cate = qq|<ul>\n$cate</ul>\n|;
	
	# タグ/改行
	$side = chg_tag($side);
	$foot = chg_tag($foot);
	$side =~ s|\n|<br>|g;
	$foot =~ s|\n|<br>|g;
	
	# RSSアイコン
	my $rss = qq|<a href="$cf{htmlurl}/index.xml"><img src="$cf{htmlurl}/tool/rss.png" class="icon" alt="RSS 2.0"></a> RSS 2.0|;
	
	# 結果を返す
	return ($side,$foot,$rss,$link,$cate,\%clnk);
}

#-----------------------------------------------------------
#  月間アーカイブ作成
#-----------------------------------------------------------
sub make_archv {
	my %mon = @_;
	
	my $ret = "<ul>\n";
	for ( sort{ $b <=> $a }keys %mon ) {
		/^(\d{4})(\d{2})/;
		
		$ret .= qq|<li><a href="$cf{htmlurl}/archives/mon/$1$2-1.html">$1年$2月 ($mon{$_})</a></li>\n|;
	}
	
	return "$ret</ul>\n";
}

#-----------------------------------------------------------
#  タグ復元
#-----------------------------------------------------------
sub chg_tag {
	local($_) = @_;
	
	s/&amp;/&/g;
	s/&quot;/"/g;
	s/&lt;/</g;
	s/&gt;/>/g;
	$_;
}


1;

