#┌─────────────────────────────────
#│ CafeLog : page_mgr.pl - 2021/04/13
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  ページ管理
#-----------------------------------------------------------
sub page_mgr {
	# POP-UP（TB送信履歴）
	if ($in{pop_tb}) { popup_tb(); }
	
	# 新規
	if ($in{job_new}) {
		# 新規作成
		if ($in{add}) { make_page(); }
		
		# フォーム
		new_form();
	
	# 修正実行
	} elsif ($in{job_edit}) {
		edit_page();
	}
	
	# ボタン押下認識
	my ($edit,$chg,$dele);
	for ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		} elsif (/^del:(\d+)/) {
			$dele = $1;
			last;
		} elsif (/^chg:(\d+)/) {
			$chg = $1;
			last;
		}
	}
	# 修正フォーム
	if ($edit) {
		my $log;
		open(IN,"$cf{datadir}/page.dat");
		while(<IN>) {
			my ($no) = (split(/\t/))[0];
			if ($edit == $no) {
				chomp;
				$log = $_;
				last;
			}
		}
		close(IN);
		
		# 修正フォーム
		new_form($log);
	
	# 公開/非公開
	} elsif ($chg) {
		chg_page($chg);
	
	# 削除
	} elsif ($dele) {
		del_page($dele);
	}
	
	# 画面表示
	header("ページ管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/apl_edit.png" class="icon"> ページ管理</p>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="page_mgr" value="1">
<div class="cat-sel">
カテゴリ：
<select name="cate">
<option value="">[全表示]
EOM

	my %cat;
	$cat{0} = '未分類';
	if ($in{cate} eq '0') {
		print qq|<option value="0" selected>未分類\n|;
	} else {
		print qq|<option value="0">未分類\n|;
	}
	
	# カテゴリ情報
	open(IN,"$cf{datadir}/cate.dat");
	while(<IN>) {
		chomp;
		my ($no,$cate) = split(/\t/);
		$cat{$no} = $cate;
		
		if ($in{cate} == $no) {
			print qq|<option value="$no" selected>$cate\n|;
		} else {
			print qq|<option value="$no">$cate\n|;
		}
	}
	close(IN);

	print <<EOM;
</select>
<input type="submit" value="絞込">
（カテゴリによる絞り込み表示のとき）
</div>
<input type="submit" name="job_new" value="新規作成">
<table class="list">
<tr>
	<th>日付</th>
	<th>公開設定</th>
	<th>カテゴリ</th>
	<th>タイトル</th>
	<th>記事編集</th>
</tr>
EOM

	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my %icon = (1 => 'ok.png', 0 => 'ng.png');
	my $i;
	open(IN,"$cf{datadir}/page.dat") or error('open err: page.dat');
	while(<IN>) {
		chomp;
		my ($no,$date,$time,$ttl,$open,$cat,$tb,$cm) = split(/\t/);
		$cat ||= 0;
		
		# カテゴリ分類
		next if ($in{cate} ne '' && $in{cate} != $cat);
		
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{list_max});
		
		# 文字カット
		$ttl = cut_str($ttl,26);
		
		print qq|<tr><td>$date-$time</td>|;
		print qq|<td><img src="$cf{htmlurl}/tool/$icon{$open}" class="icon">\n|;
		print qq|<input type="submit" name="chg:$no" value="変"></td>|;
		print qq|<td>$cat{$cat}</td>|;
		print qq|<td>$ttl</td>|;
		print qq|<td><input type="submit" name="edit:$no" value="修正">\n|;
		print qq|<input type="submit" name="del:$no" value="削除" onclick="return confirm('削除しますか？');"></td></tr>\n|;
	}
	close(IN);
	
	# 表示なし
	if (!$i) {
		print qq|<tr><td colspan="5" class="ta-c">該当カテゴリに属する記事はありません。</td></tr>\n|;
	}
	
	print qq|</table>\n</form>\n|;
	
	# 繰越ボタン
	print make_pgbtn($i,$pg,'page_mgr',$in{cate});
	
	print <<EOM;
</div>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  ページ作成フォーム
#-----------------------------------------------------------
sub new_form {
	my $log = shift;
	my ($no,$date,$time,$ttl,$open,$cat,$tb,$cm) = split(/\t/,$log);
	
	# 画面表示
	header("ページ作成フォーム");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/apl_edit.png" class="icon"> ページ作成フォーム</p>
<div class="ta-r">
<input type="button" value="&lt; 前画面に戻る" onclick="javascript:window.location='$cf{index_cgi}?page_mgr=1&sid=$in{sid}'">
</div>
<form action="$cf{index_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="page_mgr" value="1">
EOM

	my $body;
	if ($log) {
		open(IN,"$cf{datadir}/log/$no.txt");
		$body = join('', <IN>);
		close(IN);
		
		print qq|<input type="hidden" name="job_edit" value="1">\n|;
		print qq|<input type="hidden" name="no" value="$no">\n|;
	} else {
		my ($min,$hr,$day,$mon,$yr) = (localtime())[1..5];
		$date = sprintf("%04d.%02d.%02d",$yr+1900,$mon+1,$day);
		$time = sprintf("%02d:%02d",$hr,$min);
		
		print qq|<input type="hidden" name="job_new" value="1">\n|;
	}

	print <<EOM;
<table class="list">
<tr>
	<th>日付</th>
	<td>
		[月日] <input type="text" name="date" value="$date" size="15">
		&nbsp;
		[時分] <input type="text" name="time" value="$time" size="10">
	</td>
</tr><tr>
	<th>タイトル</th>
	<td><input type="text" name="ttl" value="$ttl" size="40"></td>
</tr><tr>
	<th>カテゴリ</th>
	<td>
		<select name="cate">
		<option value="">[分類なし]
EOM

	# カテゴリ情報
	open(IN,"$cf{datadir}/cate.dat");
	while(<IN>) {
		chomp;
		my ($no,$cate) = split(/\t/);
		
		if ($cat == $no) {
			print qq|<option value="$no" selected>$cate\n|;
		} else {
			print qq|<option value="$no">$cate\n|;
		}
	}
	close(IN);
	
	print <<EOM;
		</select>
	</td>
</tr><tr>
	<th>公開</th>
	<td>
EOM

	if ($open eq '') { $open = 1; }
	my %ox = (0 => '非公開', 1 => '公開');
	for (1,0) {
		if ($open == $_) {
			print qq|<input type="radio" name="open" value="$_" checked>$ox{$_} &nbsp;\n|;
		} else {
			print qq|<input type="radio" name="open" value="$_">$ox{$_} &nbsp;\n|;
		}
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th>内容</th>
	<td><input type="button" value="画像貼付" onclick="window.open('$cf{index_cgi}?img_pop=1&sid=$in{sid}','sub','width=480,height=480,scrollbars=1');return false;">
		&nbsp;
		<input type="checkbox" onclick="toggleHtmlEditor(this.checked,'myArea3','full')">エディタ
		<span class="red">（※画像貼付するときはエディタを解除してから行ってください）</span><br>
		<textarea name="body" style="width:700px;height:500px;" id="myArea3">$body</textarea>
	</td>
</tr><tr>
	<th>トラックバック<br>送信先URL</th>
	<td>
		<input type="text" name="tb_send" size="45" value="http://" style="margin-right:1.5em">
EOM

	if ($no) {
		print qq|<input type="button" value="送信履歴" onclick="window.open('$cf{index_cgi}?page_mgr=1&pop_tb=$no&sid=$in{sid}','pop','width=500,height=450,scrollbars=1');">\n|;
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>トラックバック</th>
	<td>
EOM

	my %ox = (1 => '受け入れる', 0 => '受け入れない');
	for (1,0) {
		if ($tb == $_) {
			print qq|<input type="radio" name="tb" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="tb" value="$_">$ox{$_}\n|;
		}
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>コメント機能</th>
	<td>
EOM

	for (1,0) {
		if ($cm == $_) {
			print qq|<input type="radio" name="cm" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="cm" value="$_">$ox{$_}\n|;
		}
	}

	print <<EOM;
	</td>
</tr>
</table>
<input type="submit" name="add" value="更新する" class="bigbtn">
</form>
</div>
</div>
EOM

	# nicEdit実行タグ
	nic_edit();
	
	footer();
}

#-----------------------------------------------------------
#  ページ新規
#-----------------------------------------------------------
sub make_page {
	# 内容チェック
	check_input();
	
	# 採番
	open(DAT,"+< $cf{datadir}/num.dat") or error('open err: num.dat');
	my $num = <DAT> + 1;
	seek(DAT,0,0);
	print DAT $num;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 最低5桁
	$num = sprintf("%05d",$num);
	
	# 新記事用
	my $new = $in{date} . $in{time};
	$new =~ s/\D//g;
	
	my (@tmp,@log);
	open(DAT,"+< $cf{datadir}/page.dat") or error('open err: page.dat');
	while(<DAT>) {
		my ($date,$time) = (split(/\t/))[1,2];
		my $tmp = $date . $time;
		$tmp =~ s/\D//g;
		
		push(@tmp,$tmp);
		push(@log,$_);
	}
	
	if ($in{tb} eq '0') { $in{tb} = ''; }
	if ($in{cm} eq '0') { $in{cm} = ''; }
	
	# 新記事
	push(@tmp,$new);
	push(@log,"$num\t$in{date}\t$in{time}\t$in{ttl}\t$in{open}\t$in{cate}\t$in{tb}\t$in{cm}\t\n");
	
	# ソート
	@log = @log[sort{$tmp[$b] <=> $tmp[$a]} 0 .. $#log];
	
	# 保存
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# ログ生成
	open(DAT,"> $cf{datadir}/log/$num.txt") or error("write err: log/$num.txt");
	print DAT $in{body};
	close(DAT);
	
	# TB送信
	if ($in{tb_send} && $in{tb_send} ne 'http://') {
		require './lib/trackback.pl';
		tb_send($num,$in{tb_send},$cf{title},$in{ttl},"$cf{htmlurl}/archives/art/$num.html",$in{body});
	}
	
	# 完了画面
	echo_msg('新規ページを作成しました','page_mgr');
}

#-----------------------------------------------------------
#  ページ修正
#-----------------------------------------------------------
sub edit_page {
	# 内容チェック
	check_input();
	
	my ($flg,@tmp,@log);
	open(DAT,"+< $cf{datadir}/page.dat") or error('open err: page.dat');
	while(<DAT>) {
		chomp;
		my ($no,$date,$time,$ttl,$open,$cate,$tb,$cm) = split(/\t/);
		
		if ($in{no} == $no) {
			$_ = "$no\t$in{date}\t$in{time}\t$in{ttl}\t$in{open}\t$in{cate}\t$in{tb}\t$in{cm}\t";
			$date = $in{date};
			$time = $in{time};
		}
		my $tmp = $date . $time;
		$tmp =~ s/\D//g;
		push(@tmp,$tmp);
		push(@log,"$_\n");
	}
	
	# ソート
	@log = @log[sort{$tmp[$b] <=> $tmp[$a]} 0 .. $#log];
	
	# 保存
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
	
	# ログ生成
	open(DAT,"> $cf{datadir}/log/$in{no}.txt") or error("write err: $in{no}.txt");
	print DAT $in{body};
	close(DAT);
	
	# TB送信
	if ($in{tb_send} && $in{tb_send} ne 'http://') {
		require './lib/trackback.pl';
		tb_send($in{no},$in{tb_send},$cf{title},$in{ttl},"$cf{htmlurl}/archives/art/$in{no}.html",$in{body});
	}
	
	# 完了画面
	echo_msg('ページの修正を完了しました','page_mgr');
}

#-----------------------------------------------------------
#  ページ削除
#-----------------------------------------------------------
sub del_page {
	my $del = shift;
	
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/page.dat") or error('open err: page.dat');
	while(<DAT>) {
		my ($no,$date,$time,$ttl,$open,$cate,$tb,$cm) = split(/\t/);
		next if ($del == $no);
		
		push(@log,$_);
	}
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
	
	# ログ削除
	unlink("$cf{datadir}/log/$del.txt");
	unlink("$cf{datadir}/com/$del.txt") if (-f "$cf{datadir}/com/$del.txt");
	unlink("$cf{datadir}/tb/$del.txt")  if (-f "$cf{datadir}/tb/$del.txt");
	unlink("$cf{datadir}/tb/$del.dat")  if (-f "$cf{datadir}/tb/$del.dat");
}

#-----------------------------------------------------------
#  公開/非公開
#-----------------------------------------------------------
sub chg_page {
	my $chg = shift;
	
	my @log;
	open(DAT,"+< $cf{datadir}/page.dat") or error('open err: page.dat');
	while(<DAT>) {
		chomp;
		my ($no,$date,$time,$ttl,$open,$cate,$tb,$cm) = split(/\t/);
		
		if ($chg == $no) {
			my $ch = $open == 1 ? 0 : 1;
			$_ = "$no\t$date\t$time\t$ttl\t$ch\t$cate\t$tb\t$cm\t";
		}
		push(@log,"$_\n");
	}
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_input {
	# 不要コード削除
	$in{date} =~ s/[\r\n]//g;
	$in{time} =~ s/[\r\n]//g;
	$in{ttl}  =~ s/[\r\n]//g;
	$in{cate} =~ s/\D//g;
	$in{open} =~ s/\D//g;
	$in{body} =~ s/\r\n/\n/g;
	$in{body} =~ s/\r/\n/g;
	
	# 内容チェック
	my $err;
	if ($in{date} !~ /^\d{4}\.\d{2}\.\d{2}$/) { $err .= "年月日は数字4桁+ドット+数字2桁+ドット+数字2桁で記入して下さい<br>"; }
	if ($in{time} !~ /^\d{2}:\d{2}$/) { $err .= "時分は数字2桁+:+数字2桁で記入して下さい<br>"; }
	if ($in{ttl} eq '') { $err .= "タイトルが未入力です<br>"; }
	if ($in{body} eq '') { $err .= "内容が未入力です<br>"; }
	error($err) if ($err);
}

#-----------------------------------------------------------
#  POP-UP画面
#-----------------------------------------------------------
sub popup_tb {
	# 画面表示
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{htmlurl}/tool/admin.css" rel="stylesheet">
<title>送信履歴</title>
</head>
<div id="main">
<p class="ttl">送信履歴</p>
<table class="list">
<tr>
	<th>送信日時</th>
	<th>送信先</th>
	<th nowrap>結果</th>
</tr>
EOM

	my $i;
	open(IN,"$cf{datadir}/tb/$in{pop_tb}.dat");
	while(<IN>) {
		$i++;
		chomp;
		my ($time,$url,$err,$msg) = split(/\t/);
		$time = chg_date_mini($time);
		my $res = $err eq '0' ? '成功' : '失敗';
		
		print qq|<tr><td class="small">$time</td>|;
		print qq|<td class="small">$url</td>|;
		print qq|<td class="small ta-c" nowrap>$res</td></tr>\n|;
	}
	close(IN);
	
	if (!$i) { print qq|<tr><td colspan="3">履歴なし</td></tr>\n|; }
	
	print <<EOM;
</table>
<p><input type="button" value="閉じる" onclick="window.close()"></p>
</div>
EOM
	footer();
}

#-----------------------------------------------------------
#  日時変換
#-----------------------------------------------------------
sub chg_date_mini {
	my $time = shift;
	
	my ($min,$hr,$day,$mon,$yr) = (localtime($time))[1..5];
	sprintf("%04d/%02d/%02d-%02d:%02d",$yr+1900,$mon+1,$day,$hr,$min);
}



1;

