#┌─────────────────────────────────
#│ CafeLog : pass_mgr.pl - 2021/04/16
#│ copyright (c) kentweb, 1997-2021
#│ http://www.kent-web.com/
#└─────────────────────────────────

#-----------------------------------------------------------
#  パスワード管理
#-----------------------------------------------------------
sub pass_mgr {
	# 追加
	if ($in{add} && $in{id} ne '' && $in{pw} ne '') {
		if ($in{id} =~ /\W/ or $in{pw} =~ /\W/) {
			error("ID又はパスワードに英数字・アンダーバー以外が含まれています");
		}
		# 暗号化
		my $crypt = encrypt($in{pw});
		
		my ($flg,@log);
		open(DAT,"+< $cf{datadir}/pass.dat");
		while(<DAT>) {
			my ($id,$pw) = split(/\t/);
			
			# ID重複
			if ($in{id} eq $id) {
				$flg++;
				last;
			}
			push(@log,$_);
		}
		if ($flg) {
			close(DAT);
			error("このIDはすでに作成されてます");
		}
		push(@log,"$in{id}\t$crypt\n");
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	my ($chg,$del);
	for ( keys %in ) {
		if (/^chg:(\w+)/) {
			$chg = $1;
			last;
		} elsif (/^del:(\w+)/) {
			$del = $1;
			last;
		}
	}
	# パス変更
	if ($chg) {
		if ($in{"pwd:$chg"} eq '') {
			error("パスワードが未入力です");
		} elsif ($in{"pwd:$chg"} =~ /\W/) {
			error("パスワードに英数字・アンダーバー以外が含まれています");
		}
		
		# 暗号化
		my $crypt = encrypt($in{"pwd:$chg"});
		
		my @log;
		open(DAT,"+< $cf{datadir}/pass.dat");
		while(<DAT>) {
			my ($id,$pw) = split(/\t/);
			
			if ($chg eq $id) {
				$_ = "$id\t$crypt\n";
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# 削除
	} elsif ($del) {
		my @log;
		open(DAT,"+< $cf{datadir}/pass.dat");
		while(<DAT>) {
			my ($id,$pw) = split(/\t/);
			next if ($del eq $id);
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	# 画面表示
	header("パスワード管理");
	menu_btn();
	print <<EOM;
<div id="body">
<div id="main">
<p class="ttl"><img src="$cf{htmlurl}/tool/lock.png" class="icon"> パスワード管理</p>
<p>・ 管理用ID/パスワードの追加を行います（ID/パスワードともに「英数字及びアンダーバー」で指定）。</p>
<form action="$cf{index_cgi}" method="post" name="selform">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="pass_mgr" value="1">
<table class="list">
<tr>
	<th class="ta-c">ログインID</th>
	<th class="ta-c">パスワード</th>
</tr><tr>
	<td><input type="text" name="id" size="20"></td>
	<td>
		<input type="text" name="pw" size="20">
		<input type="submit" name="add" value="追加">
	</td>
</tr>
</table>
<p>・ 管理用ID/パスワードの削除・変更を行います（パスワードは「英数字及びアンダーバー」で指定）。</p>
<table class="list">
<tr>
	<th class="ta-c"></th>
	<th class="ta-c">ログインID</th>
	<th class="ta-c">パスワード</th>
</tr>
EOM

	open(IN,"$cf{datadir}/pass.dat");
	while(<IN>) {
		my ($id,$pw) = split(/\t/);
		
		print qq|<tr><td><input type="submit" name="del:$id" value="削除" onclick="return confirm('よろしいですか？');"></td>|;
		print qq|<td class="ta-c">$id</td>|;
		print qq|<td><input type="text" name="pwd:$id" size="20">\n|;
		print qq|<input type="submit" name="chg:$id" value="変更"></td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</div>
</div>
EOM
	
	footer();
}



1;

