#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ WEB CALEN : admin.cgi - 2022/02/06
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
cgi_err('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 管理モード
if ($in{data_mng}) { data_mng(); }
if ($in{data_mon}) { data_mon(); }
if ($in{pass_mgr}) { pass_mgr(); }
menu_form();

#-----------------------------------------------------------
#  管理モードTOP
#-----------------------------------------------------------
sub menu_form {
	header();
	print <<EOM;
<div class="ttl">■ 管理モードTOP</div>
<div id="main">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<p>
	・ 処理するボタンを選択してください。<br>
	・ ログオフをクリックすると、カレンダへ戻ります。</p>
<table class="form-tbl">
<tr>
	<th></th>
	<th style="width:220px;">処理モード</th>
</tr><tr>
	<td><input type="submit" name="data_mng" value="選択"></td>
	<td>記事管理</td>
</tr><tr>
	<td><input type="submit" name="data_mon" value="選択"></td>
	<td>月次データ</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  記事管理
#-----------------------------------------------------------
sub data_mng {
	# 更新
	if ($in{update}) { data_update(); }
	
	# ボタン押下認識
	my $sel;
	for ( keys %in ) {
		if (/^sel:(\d+)/) {
			$sel = $1;
			last;
		}
	}
	if ($sel) { edit_form($sel); }
	
	# 週定義
	my @week = qw(日 月 火 水 木 金 土);
	
	# 今年
	my ($mon,$year) = (localtime())[4,5];
	$year += 1900;
	$mon = sprintf("%02d",++$mon);
	
	# 年月分解
	if (!$in{ym}) { $in{ym} = $year . $mon; }
	my ($y,$m) = $in{ym} =~ /^(\d{4})(\d{2})/ && ($1,$2);
	
	# 1日の曜日を求める
	my $week = get_week($y,$m,1);
	
	# 末日を求める
	my $last = last_day($y,$m);
	
	header();
	back_btn();
	print <<EOM;
<div class="ttl">■ 記事管理</div>
<div id="main">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_mng" value="1">
年月：
<select name="ym">
EOM

	for my $y ($year-$cf{old_log} .. $year, $year+1) {
		for my $m (1 .. 12) {
			$m = sprintf("%02d",$m);
			
			if ($in{ym} == "$y$m") {
				print qq|<option value="$y$m" selected>$y年$m月\n|;
			} else {
				print qq|<option value="$y$m">$y年$m月\n|;
			}
		}
	}
	
	print <<EOM;
</select>
<input type="submit" value="切替">
<table class="form-tbl">
<tr>
	<th></th>
	<th>年月日</th>
	<th>タイトル</th>
</tr>
EOM

	my %log;
	open(IN,"$cf{datadir}/log/$in{ym}.txt");
	while(<IN>) {
		my ($day,$sub,$msg,$ico,$wico,$img1,$img2,$img3) = split(/<>/);
		next if ($msg eq '');
		
		$log{$day} = $_;
	}
	close(IN);
	
	my $w = $week;
	for my $d (1 .. $last) {
		$d = sprintf("%02d",$d);
		
		my ($day,$sub,$msg,$ico,$wico,$img1,$img2,$img3) = split(/<>/,$log{$d});
		
		print qq|<tr><td><input type="submit" name="sel:$y$m$d" value="選択"></td>|;
		print qq|<td>$y.$m.$d （$week[$w]）</td>|;
		print qq|<td>$sub</td></tr>\n|;
		
		$w = $w == 6 ? 0 : ++$w;
	}
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  編集フォーム
#-----------------------------------------------------------
sub edit_form {
	my $sel = shift;
	my ($y,$m,$d) = $sel =~ /^(\d{4})(\d{2})(\d{2})/ && ($1,$2,$3);
	
	my $log;
	open(IN,"$cf{datadir}/log/$y$m.txt");
	while(<IN>) {
		my ($day,$sub,$msg,$ico,$wico,$img1,$img2,$img3) = split(/<>/);
		
		if ($day == $d) {
			chomp;
			$log = $_;
			last;
		}
	}
	close(IN);
	
	my ($day,$sub,$msg,$ico,$wico,$img1,$img2,$img3) = split(/<>/,$log);
	$msg =~ s|<br( /)?>|\n|g;
	
	header();
	back_btn('data_mng',"$y$m");
	print <<EOM;
<div class="ttl">■ 記事管理 &gt; 編集フォーム</div>
<div id="main">
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_mng" value="1">
<input type="hidden" name="y" value="$y">
<input type="hidden" name="m" value="$m">
<input type="hidden" name="d" value="$d">
<table class="form-tbl">
<tr>
	<th>年月日</th>
	<td>$y年$m月$d日</td>
</tr><tr>
	<th>タイトル</th>
	<td><input type="text" name="sub" value="$sub" size="40"></td>
</tr><tr>
	<th>内容</th>
	<td><textarea name="body" cols="60" rows="10">$msg</textarea></td>
</tr><tr>
	<th>カレンダ表示</th>
	<td>
EOM

	# カレンダアイコン
	$wico ||= 0;
	for (0 .. $#{$cf{w_icon}}) {
		if ($wico == $_) {
			print qq|<input type="radio" name="wico" value="$_" checked="checked">|;
		} else {
			print qq|<input type="radio" name="wico" value="$_">|;
		}
		print qq|<img src="$cf{cmnurl}/$cf{w_icon}[$_]" alt="">&nbsp;\n|;
	}
	
	print <<EOM;
		</select>
	</td>
</tr><tr>
	<th>本文アイコン</th>
	<td>
		<select name="icon">
		<option value="">▼なし
EOM

	for (0 .. $#{$cf{icon}}) {
		my ($fnam,$nam) = split(/,/,$cf{icon}[$_]);
		if ($ico eq $fnam) {
			print qq|<option value="$fnam" selected="selected">$nam</option>\n|;
		} else {
			print qq|<option value="$fnam">$nam</option>\n|;
		}
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th>画像</th>
	<td>
EOM

	# アップファイル
	my $i;
	for my $img ($img1,$img2,$img3) {
		$i++;
		print qq|[$i] <input type="file" name="upfile$i" size="38">\n|;
		
		my ($ex,$w,$h) = split(/:/, $img);
		if ($ex) {
			print qq|[<a href="$cf{uplurl}/$y$m$d-$i$ex" target="_blank">添付</a>]\n|;
			print qq|<input type="checkbox" name="imgdel$i" value="1">削除\n|;
		}
		print "<br>\n";
	}
	
	print <<EOM;
	</td>
</tr>
</table>
<input type="submit" name="update" value="送信する" class="bigbtn">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  記事更新
#-----------------------------------------------------------
sub data_update {
	# 画像アップ
	my (%ex,%w,%h);
	if ($in{upfile1} || $in{upfile2} || $in{upfile3}) {
		($ex{1},$w{1},$h{1},$ex{2},$w{2},$h{2},$ex{3},$w{3},$h{3}) = upload("$in{y}$in{m}$in{d}");
	}
	
	# 画像削除
	my %imgdel;
	$imgdel{1} = $in{imgdel1};
	$imgdel{2} = $in{imgdel2};
	$imgdel{3} = $in{imgdel3};
	
	# 新規データのとき
	if (! -f "$cf{datadir}/log/$in{y}$in{m}.txt") {
		
		# 末日を求める
		my $last = last_day($in{y},$in{m});
		
		my @log;
		for my $i (1 .. $last) {
			$i = sprintf("%02d",$i);
			push(@log,"$i<><><><><><><><>\n");
		}
		
		open(DAT,"> $cf{datadir}/log/$in{y}$in{m}.txt");
		print DAT @log;
		close(DAT);
		
		chmod(0666,"$cf{datadir}/log/$in{y}$in{m}.txt");
	}
	
	my @log;
	open(DAT,"+< $cf{datadir}/log/$in{y}$in{m}.txt");
	while(<DAT>) {
		chomp;
		my ($day,$sub,$msg,$ico,$wico,$img1,$img2,$img3) = split(/<>/);
		my %img;
		($img{1},$img{2},$img{3}) = ($img1,$img2,$img3);
		
		if ($in{d} == $day) {
			my $n;
			for my $img ($img1,$img2,$img3) {
				$n++;
				my ($ex,$w,$h) = split(/:/,$img);
				
				if ($imgdel{$n}) {
					unlink("$cf{upldir}/$in{y}$in{m}$in{d}-$n$ex");
					$img{$n} = "";
				}
				if ($ex{$n}) {
					$img{$n} = "$ex{$n}:$w{$n}:$h{$n}";
					
					if ($ex && $ex ne $ex{$n}) {
						unlink("$cf{upldir}/$in{y}$in{m}$in{d}-$n$ex");
					}
				}
			}
			$_ = "$day<>$in{sub}<>$in{body}<>$in{icon}<>$in{wico}<>$img{1}<>$img{2}<>$img{3}<>";
		}
		push(@log,"$_\n");
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	message('更新を完了しました','data_mng',"$in{y}$in{m}");
}

#-----------------------------------------------------------
#  月次データ管理
#-----------------------------------------------------------
sub data_mon {
	$in{del} =~ s/\D//g;
	
	# 一括削除
	if ($in{del}) {
		
		# 画像削除
		opendir(DIR,"$cf{upldir}") or cgi_err("open err: $cf{upldir}");
		while( defined( $_ = readdir(DIR) ) ) {
			if (/^($in{del}\d{2}\-[1-3]\.\w+)$/) {
				unlink("$cf{upldir}/$1");
			}
		}
		closedir(DIR);
		
		# ログ削除
		unlink("$cf{datadir}/log/$in{del}.txt");
		
		# 新着ログより削除記事を排除
		if ($cf{new_data} > 0) {
			
			my ($flg,@log);
			open(DAT,"+< $cf{datadir}/log/new.dat") or cgi_err("open err: new.dat");
			eval "flock(DAT, 2);";
			while (<DAT>) {
				my ($ymd,$sub,$msg,$w,$icon) = split(/<>/);
				
				# 該当記事あり
				if ($ymd =~ /^$in{del}/) {
					$flg++;
					next;
				}
				push(@log,$_);
			}
			# 削除対象あり
			if ($flg) {
				seek(DAT,0,0);
				print DAT @log;
				truncate(DAT,tell(DAT));
			}
			close(DAT);
		}
		message("削除しました",'data_mon');
	}
	
	header();
	back_btn();
	print <<EOM;
<div class="ttl">■ 月次データ</div>
<div id="main">
<p>- チェックを入れて「削除する」を押すと月次ファイル全体を削除します -
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_mon" value="1">
<input type="submit" value="削除する">
<table class="form-tbl">
<tr>
	<th>削除</th>
	<th>年月</th>
	<th>容量</th>
</tr>
EOM

	# ログディレクトリ読み取り
	opendir(DIR,"$cf{datadir}/log") or cgi_err("open err: $cf{datadir}/log");
	my @dir = readdir(DIR);
	closedir(DIR);
	
	my ($all,$size) = (0, 0);
	foreach (@dir) {
		if (/^(\d{4})(\d{2})\.txt$/) {
			
			# ファイルサイズ
			$size = -s "$cf{datadir}/log/$_";
			$size = int($size / 1024 * 10) / 10 .'KB';
			
			print qq|<tr><td class="ta-c"><input type="radio" name="del" value="$1$2"></td>|;
			print qq|<td>$1年$2月</td>|;
			print qq|<td class="ta-r">$size</td></tr>\n|;
			
			$all += $size;
		}
	}
	
	print <<EOM;
</table>
</form>
<p>ログサイズ計：<b>$all</b> Bytes</p>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/css/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div align="center">
<hr width="350">
<h3>ERROR!</h3>
<p class="err">$err</p>
<hr width="350">
<input type="button" value="前画面に戻る" onclick="history.back()">
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg,$mode,$ym) = @_;
	
	header("完了");
	print <<EOM;
<div class="ta-c">
<div id="box">
<p class="msg">$msg</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
EOM

	if ($mode) {
		print qq|<input type="hidden" name="$mode" value="1">\n|;
		print qq|<input type="hidden" name="ym" value="$ym">\n|;
	}
	
	print <<EOM;
<input type="submit" value="戻る" class="bigbtn">
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my ($mode,$ym) = @_;
	
	print <<EOM;
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
EOM

	if ($mode) {
		print qq|<input type="hidden" name="$mode" value="1">\n|;
		print qq|<input type="hidden" name="ym" value="$ym">\n|;
	}
	
	print <<EOM;
<input type="submit" value="▲戻る">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  アップロード
#-----------------------------------------------------------
sub upload {
	my $no = shift;
	
	# サムネイル機能
	require './lib/thumb.pl' if ($cf{thumbnail});
	
	my @ret;
	for my $i (1 .. 3) {
		
		# ファイル名
		my $fname = $cgi->param_filename("upfile$i");
		if ($fname =~ /(\.jpe?g|\.png|\.gif)$/i) {
			my $ex = $1;
			$ex =~ tr/A-Z/a-z/;
			if ($ex eq '.jpeg') { $ex = '.jpg'; }
			
			# アップファイル定義
			my $imgfile = "$cf{upldir}/$no-$i$ex";
			
			# 書き込み
			open(OUT,"> $imgfile") or error("画像アップ失敗");
			binmode(OUT);
			print OUT $in{"upfile$i"};
			close(OUT);
			
			# 画像サイズ取得
			my ($w,$h);
			if ($ex eq ".jpg") { ($w,$h) = j_size($imgfile); }
			elsif ($ex eq ".gif") { ($w,$h) = g_size($imgfile); }
			elsif ($ex eq ".png") { ($w,$h) = p_size($imgfile); }
			
			# サムネイル作成
			if ($cf{thumbnail}) {
				($w,$h) = resize($w,$h);
				my $thumb = "$cf{upldir}/$no-s-$i$ex";
				make_thumb($imgfile,$thumb,$w,$h);
			}
			
			push(@ret,($ex,$w,$h));
		} else {
			push(@ret,('','',''));
		}
	}
	# 返り値
	return @ret;
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h, $w, $t);
	open(IMG,"$jpg");
	binmode(IMG);
	read(IMG, $t, 2);
	while (1) {
		read(IMG, $t, 4);
		my ($m, $c, $l) = unpack("a a n", $t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG, $t, 5);
			($h, $w) = unpack("xnn", $t);
			last;
		} else {
			read(IMG, $t, ($l - 2));
		}
	}
	close(IMG);
	
	return ($w, $h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,"$gif");
	binmode(IMG);
	sysread(IMG, $data, 10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data, -4); }
	my $w = unpack("v", substr($data, 0, 2));
	my $h = unpack("v", substr($data, 2, 2));
	
	return ($w, $h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,"$png");
	binmode(IMG);
	read(IMG, $data, 24);
	close(IMG);
	
	my $w = unpack("N", substr($data, 16, 20));
	my $h = unpack("N", substr($data, 20, 24));
	
	return ($w, $h);
}

