# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ WEB CALEN : init.cgi - 2022/03/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'WebCalen v6.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# タイトル
$cf{cgi_title} = "Web Calendar";

# サムネイル画像を作成する（要：Image::Magick）
# → 縮小画像を自動生成し、画像記事の表示速度を軽くする機能
# 0=no 1=yes
$cf{thumbnail} = 0;

# カレンダー本体（フレーム）【URLパス】
$cf{calen_html} = './calen.html';

# 本体CGIプログラム【URLパス】
$cf{calen_cgi} = './calen.cgi';

# 登録CGIプログラム【URLパス】
$cf{regist_cgi} = './regist.cgi';

# 管理CGIプログラム【URLパス】
$cf{admin_cgi} = './admin.cgi';

# 戻り先【URLパス】
$cf{homepage} = '../index.html';

# ログファイルディレクトリ【サーバパス】
$cf{datadir} = './data';

# アップロードディレクトリ【サーバパス】
$cf{upldir} = './upl';

# アップロードディレクトリ【URLパス】
$cf{uplurl} = './upl';

# アイコン用ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 新着情報の表示件数
$cf{new_data} = 3;

# 月次一括表示のときのページ当たり表示件数
$cf{max_page} = 3;

# 過去データの編集範囲（何年前までか）
$cf{old_log} = 2;

# カレンダーの色指定
# → 順に、日～土、祝日、本日
$cf{week_col} = [
	'red',
	'black',
	'black',
	'black',
	'black',
	'black',
	'blue',
	'#f20da2',
	'#ffcae4',
	];

# 書き込み案内アイコン（カレンダ上に表示されるアイコン）
$cf{w_icon} = ['pen.gif','heart.png','user_m.png','user_f.png','user_green.png','thumb_up.png','thumb_dn.png'];

# 週表示
$cf{week} = ['日','月','火','水','木','金','土'];

# 任意アイコン（記事中に表示されるアイコン）
# → 前にファイル名、後にアイコン名をコンマで区切る
$cf{icon} = [
	'hare.gif,晴れ',
	'kumori.gif,くもり',
	'ame.gif,雨',
	'yuki.gif,雪',
	'acchi.gif,あっち',
	'kocchi.gif,こっち',
	'kouji.gif,工事中',
	'mail.gif,メール',
	'puri.gif,ぷりぷり1',
	'puri2.gif,ぷりぷり2',
	'box.gif,たまげ～',
	'akubi.gif,あくび',
	'panda.gif,これパンだ',
	];

# アップ画像の最大表示の大きさ（単位：ピクセル）
# → これを超える画像は縮小表示します
$cf{img_max_w} = 200;   # 横幅
$cf{img_max_h} = 150;   # 縦幅

# 最大受理サイズ
$cf{maxdata} = 512000;

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	foreach ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		if ($_ !~ /^upfile[1-3]$/) {
			# 無効化
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/'/&#39;/g;
			
			# 改行処理
			$val =~ s|\r\n|<br>|g;
			$val =~ s|[\r\n]|<br>|g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h) = @_;
	
	# 画像表示縮小
	if ($w > $cf{img_max_w} || $h > $cf{img_max_h}) {
		
		my $w2 = $cf{img_max_w} / $w;
		my $h2 = $cf{img_max_h} / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; }
		else { $key = $h2; }
		
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	return ($w,$h);
}

#-----------------------------------------------------------
#  月の末日
#-----------------------------------------------------------
sub last_day {
	my ($yy,$mm) = @_;
	
	return (31,28,31,30,31,30,31,31,30,31,30,31) [$mm - 1]
		+ ($mm == 2 && (($yy % 4 == 0 && $yy % 100 != 0) || $yy % 400 == 0));
}

#-----------------------------------------------------------
#  週算出
#-----------------------------------------------------------
sub get_week {
	my ($yy,$mm,$dd) = @_;
	
	if ($mm == 1 || $mm == 2) {
		$yy--;
		$mm += 12;
	}
	int( $yy + int($yy / 4) - int($yy / 100) + int($yy / 400) + int((13 * $mm + 8) / 5) + $dd ) % 7;
}


1;

