#!/usr/local/bin/perl

#┌──────────────────────────────
#│ HAPPY CART : index.cgi - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Session;

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
%in = parse_form();

# 処理分岐
if ($in{mode_addr}) { addr_form(); }
if ($in{mode_conf}) { conf_form(); }
if ($in{mode_send}) { send_form(); }
if ($in{refer_act}) { refer_act(); }
if ($in{chck_cart}) { chck_cart(); }
main_cart();

#-----------------------------------------------------------
#  メニュー表示
#-----------------------------------------------------------
sub main_cart {
	require './lib/main_cart.pl';
	main_cart_pl();
}

#-----------------------------------------------------------
#  カート中身
#-----------------------------------------------------------
sub chck_cart {
	require './lib/chck_cart.pl';
	chck_cart_pl();
}

#-----------------------------------------------------------
#  住所入力画面
#-----------------------------------------------------------
sub addr_form {
	require './lib/addr_form.pl';
	addr_form_pl();
}

#-----------------------------------------------------------
#  確認画面
#-----------------------------------------------------------
sub conf_form {
	require './lib/conf_form.pl';
	conf_form_pl();
}

#-----------------------------------------------------------
#  注文確定
#-----------------------------------------------------------
sub send_form {
	require './lib/send_form.pl';
	send_form_pl();
}

#-----------------------------------------------------------
#  特定商取引法の表記
#-----------------------------------------------------------
sub refer_act {
	require './lib/refer_act.pl';
	refer_act_pl();
}

#-----------------------------------------------------------
#  進行テーブル
#-----------------------------------------------------------
sub prog_tbl {
	my $key = shift;
	
	open(IN,"$cf{tmpldir}/prog-$key.html");
	my $prog = join('',<IN>);
	close(IN);
	
	return $prog;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="https://www.kent-web.com/" target="_top">HappyCart</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_input {
	my %er;
	if ($in{date} ne '' && $in{date} !~ m|^(\d{4})/(\d{2})/(\d{2})|) {
		$er{date} = '配達日は「数字4桁+数字2桁+数字2桁」です';
	}
	if ($in{kana} eq '') { $er{kana} = 'ふりがなが未入力です'; }
	if ($in{name} eq '') { $er{name} = '名前が未入力です'; }
	if ($in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) { $er{email} = 'E-mailが不正です'; }
	if ($in{zip} !~ /^\d{3}-?\d{4}$/) { $er{zip} = '郵便番号は「数字7桁」か「数字3桁-4桁」です'; }
	if ($in{pref} eq '' || $in{addr} eq '') { $er{addr} = '住所が未入力です'; }
	if ($in{tel} eq '') { $er{tel} = '電話番号が未入力です'; }
	
	# 別配送
	if ($in{ship} == 2) {
		if ($in{kana2} eq '') { $er{kana2} = '配送先ふりがなが未入力です'; }
		if ($in{name2} eq '') { $er{name2} = '配送先名前が未入力です'; }
		if ($in{zip2} !~ /^\d{3}-?\d{4}$/) { $er{zip2} = '配送先郵便番号は「数字7桁」か「数字3桁-4桁」です'; }
		if ($in{pref2} eq '' || $in{addr2} eq '') { $er{addr2} = '配送先住所が未入力です'; }
		if ($in{tel2} eq '') { $er{tel2} = '配送先電話番号が未入力です'; }
	}
	return %er;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  消費税計算
#-----------------------------------------------------------
sub calc_tax {
	my ($all,$red) = @_;
	
	my $kei = $all;
	my ($tar,$tax1,$tax2);
	if ($cf{tax_per} > 0) {
		$tar  = $all - $red;
		$tax1 = int($tar * $cf{tax_per} / 100);
		$tax2 = int($red * $cf{red_per} / 100);
		
		$all = $kei + $tax1 + $tax2;
	}
	return ($kei,$tax1,$tax2,$all,$tar);
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN,$buf,$ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	for ( split(/&/,$buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/[\r\n]//g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}

