#┌──────────────────────────────
#│ HAPPY CART : conf_form.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;

#-----------------------------------------------------------
#  確認画面
#-----------------------------------------------------------
sub conf_form_pl {
	# 入力チェック
	my %er = check_input();
	my $erflg;
	for ( keys %er ) {
		if (defined $er{$_}) { $erflg++; last; }
	}
	require './lib/addr_form.pl';
	addr_form_pl($erflg,\%er) if ($erflg);
	
	# 在庫
	my %zan = read_stock() if ($cf{stock} == 1);
	
	# 支払方法
	my ($pay,$cost) = split(/,/,$cf{payment}[$in{payment}]);
	
	# 配達日
	my $haiso;
	if ($in{date} =~ m|^(\d{4})/(\d{2})/(\d{2})|) {
		$haiso = "$1年$2月$3日";
	}
	
	# 時間帯
	my $deli = $cf{deli}[$in{deli}];
	
	# 都道府県
	my ($pref,$soryo)   = split(/,/,$cf{pref}[$in{pref}]);
	my ($pref2,$soryo2) = split(/,/,$cf{pref}[$in{pref2}]) if ($in{ship} == 2);
	
	# セッション読み取り
	my $ses = CGI::Session->new(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
	
	# セッション保管
	$ses->param("addr","$in{payment}<>$in{date}<>$in{deli}<>$in{ship}<>$in{corp}<>$in{kana}<>$in{name}<>$in{email}<>$in{zip}<>$in{pref}<>$in{addr}<>$in{adds}<>$in{tel}<>$in{fax}<>$in{memo}");
	if ($in{ship} == 2) {
		$ses->param("addr2","$in{corp2}<>$in{kana2}<>$in{name2}<>$in{zip2}<>$in{pref2}<>$in{addr2}<>$in{adds2}<>$in{tel2}<>$in{fax2}");
	}
	
	# 買物情報
	my $id = $ses->param('id');
	my ($i,$flg,$eitem,@cart);
	for (1 .. $id) {
		my $cart = $ses->param("cart:$_");
		next if ($cart eq '');
		$i++;
		my ($no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/,$cart);
		
		# 在庫チェック
		if ($cf{stock} == 1 && $zan{$no} < $num) { $flg++; $eitem = $item; last; }
		
		push(@cart,$cart);
	}
	if (!$i) {
		my $msg = "買物カゴの中身が空ですので、リストに戻って商品を選択してください。\n";
		$msg .= qq|<p><a href="$cf{index_cgi}">リストTOP画面</a></p>\n|;
		error($msg);
	
	} elsif ($flg) {
		my $msg = qq|<p>大変申し訳ありません。<br>$eitemはたった今別注文により在庫不足となりました。</p>\n|;
		$msg .= qq|買物カートから商品を削除する場合：<a href="$cf{index_cgi}?chck_cart=1&amp;sid=$in{sid}">買物カゴ画面へ</a><br>\n|;
		$msg .= qq|リストTOP画面に戻る場合：<a href="$cf{index_cgi}?sid=$in{sid}">リストTOP画面</a>\n|;
		error($msg);
	}
	
	# 決済手段
	my $payflg;
	if (($cf{zeus_serv} == 1 && $in{payment} == $#{$cf{payment}})
			or ($cf{zeus_serv} == 2 && $in{payment} == $#{$cf{payment}}-1)
			or ($cf{zeus_serv} == 3 && $in{payment} == $#{$cf{payment}}-1)
			or ($cf{zeus_serv} == 4 && $in{payment} == $#{$cf{payment}}-2)) { # クレジット
		$payflg = 'c';
	
	} elsif (($cf{zeus_serv} == 2 && $in{payment} == $#{$cf{payment}})
			or ($cf{zeus_serv} == 4 && $in{payment} == $#{$cf{payment}}-1)) { # 銀行
		$payflg = 'b';
	
	} elsif (($cf{zeus_serv} == 3 && $in{payment} == $#{$cf{payment}})
			or ($cf{zeus_serv} == 4 && $in{payment} == $#{$cf{payment}})) { # コンビニ
		$payflg = 'v';
	}
	
	# 基本データ
	my %top = read_base();
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/conf.html") or error("open err: conf.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 税区分
	if (!$cf{tax_per}) { $tmpl =~ s|<!-- tax -->.+?<!-- /tax -->||s; }
	
	# 文字置き換え
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!sid!/$in{sid}/g;
	$tmpl =~ s/!payment!/$pay/g;
	$tmpl =~ s/!haiso!/$haiso/g;
	$tmpl =~ s/!deli!/$deli/g;
	$tmpl =~ s/!pref!/$pref/g;
	$tmpl =~ s/!pref2!/$pref2/g;
	$tmpl =~ s/!(corp2?|kana2?|name2?|email|zip2?|addr2?|adds2?|tel2?|fax2?)!/$in{$1}/g;
	$tmpl =~ s/!memo!/$in{memo} ne '' ? $in{memo} : '<br>'/e;
	$tmpl =~ s/!top-(\w+)!/$top{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/!prog_table!/$payflg ? prog_tbl('3p') : prog_tbl(3)/e;
	
	# 別配送なし
	if ($in{ship} == 1) {
		$tmpl =~ s|<!-- ship_addr -->.+?<!-- /ship_addr -->||s;
	}
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	my $all = 0;
	my $red = 0;
	for (@cart) {
		my ($no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/);
		my ($ex,$w,$h) = split(/,/,$img);
		my $kei = $pri * $num;
		$all += $kei;
		
		my $opt;
		$opt .= "[$cf{op1}]$size<br>" if ($size);
		$opt .= "[$cf{op2}]$col<br>" if ($col);
		
		# 軽減税率
		if ($cf{tax_per} > 0 && $rtax == 1) {
			$red += $kei;
			$opt .= "[軽減税率対象]";
		}
		
		my $tmp = $loop;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!code!/$code/g;
		$tmp =~ s/!num!/$num/g;
		$tmp =~ s/!price!/comma($pri)/eg;
		$tmp =~ s/!kei!/comma($kei)/eg;
		$tmp =~ s/!option!/$opt/g;
		$tmp =~ s|<!-- image -->|<img src="$cf{imgurl}/$no-1$ex" alt="" width="100" class="icon">|;
		
		print $tmp;
	}
	
	# 送料
	if ($in{name2} && $in{addr2}) {
		$soryo = $soryo2;
	}
	if ($cf{cari_serv} && $cf{cari_serv} <= $all) {
		$soryo = 0;
	}
	$soryo ||= 0;
	
	# 消費税算出
	my ($kei,$tax1,$tax2,$all,$tar) = calc_tax($all + $cost + $soryo,$red);
	
	$foot =~ s/!kei!/comma($kei)/eg;
	$foot =~ s/!tax1!/comma($tax1)/eg;
	$foot =~ s/!tax2!/comma($tax2)/eg;
	$foot =~ s/!all!/comma($all)/eg;
	$foot =~ s/!cost!/comma($cost)/eg;
	$foot =~ s/!soryo!/comma($soryo)/eg;
	$foot =~ s/!(tax_per|red_per)!/$cf{$1}/g;
	$foot =~ s/!tax_tar!/comma($tar)/eg;
	$foot =~ s/!red_tar!/comma($red)/eg;
	
	# フッタ
	footer($foot);
}


1;

