# モジュール宣言
use strict;
#┌─────────────────────────────────
#│ HAPPY CART : init.cgi - 2023/07/08
#│ copyright (c) kentweb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'HAPPY CART v11.02';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理者メールアドレス
$cf{mailto} = 'xxx@xxx.xx';

# SSL領域での設置
# 0 : なし
# 1 : あり
$cf{ssl_mode} = 0;

# カートCGIファイル【URLパス】
$cf{index_cgi} = './index.cgi';

# 管理CGIファイル【URLパス】
$cf{admin_cgi} = './admin.cgi';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# データディレクトリ
$cf{datadir} = './data';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# 画像アップディレクトリ
$cf{imgurl} = './img'; # 【URLパス】
$cf{imgdir} = './img'; # 【サーバパス】

# 買物カート/入力情報の有効時間
# → 入力情報は一時ファイルに記録するためセキィリティ上の措置
# → 例: 分単位の場合 '+45m'  時間単位の場合 '+2h'
$cf{ses_expire} = '+60m';

# sendmailパス【サーバパス】
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailの -fコマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# 暗号化キー（適当な英数字を指定）
# → 注文者情報をクッキー保存する際の暗号化キー
$cf{passphrase} = "passphrase";

# 投稿受理最大サイズ (bytes)
# → 例 : 102400 = 100KB
$cf{maxdata} = 1024000;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# クッキーID
$cf{cookie_id} = 'cart_cookie';

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

# --- [ ここより下はゼウス (ZEUS) クレジット決済の設定 ]
#
# [ ゼウスサービスを利用する ]
#  0 : しない
#  1 : クレジット利用【ゼウス社との契約必要】
#  2 : クレジット＋銀行決済サービスを利用【ゼウス社との契約必要】
#  3 : クレジット＋コンビニ決済サービスを利用【ゼウス社との契約必要】
#  4 : クレジット＋銀行決済＋コンビニ決済サービスを利用【ゼウス社との契約必要】
$cf{zeus_serv} = 0;

# ゼウス契約NO (クレジット決済用IPコード) 
# → $cf{zeus_serv} が 1, 2, 3, 4 の場合必須
$cf{zeus_num} = '11111';

# ゼウス契約NO (銀行決済用IPコード) 
# → $cf{zeus_serv} が 2, 4 の場合必須
$cf{zeus_bip} = '22222';

# ゼウス契約NO (コンビニ決済用IPコード) 
# → $cf{zeus_serv} が 3, 4 の場合必須
$cf{zeus_cip} = '33333';

#===========================================================
# ■ 設定完了
#===========================================================

# 再定義
if ($cf{zeus_serv} >= 1) { push(@{$cf{payment}},"クレジット [連携して決済],0"); }
if ($cf{zeus_serv} == 2 or $cf{zeus_serv} == 4) { push(@{$cf{payment}},"銀行決済 [連携して決済],0"); }
if ($cf{zeus_serv} >= 3) { push(@{$cf{payment}},"コンビニ決済 [連携して決済],0"); }

# 外部設定ファイル
read_base();

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  コンマ区切
#-----------------------------------------------------------
sub comma {
	local($_) = @_;
	
	1 while s/(.*\d)(\d\d\d)/$1,$2/;
	$_;
}

#-----------------------------------------------------------
#  在庫情報認識
#-----------------------------------------------------------
sub read_stock {
	my %zan;
	open(IN,"$cf{datadir}/stock.dat") or error("open err: stock.dat");
	while(<IN>) {
		chomp;
		my ($no,$zan) = split(/,/);
		
		$zan{$no} = $zan;
	}
	close(IN);
	
	return %zan;
}

#-----------------------------------------------------------
#  基本設定認識
#-----------------------------------------------------------
sub read_base {
	open(IN,"$cf{datadir}/base.dat") or error("open err: base.dat");
	while(<IN>) {
		chomp;
		my ($key,$val) = split(/\t/);
		
		$cf{$key} = $val;
	}
	close(IN);
	
	$cf{category} = [];
	my $i = 0;
	for ( split(/<>/,$cf{categ}) ) {
		$cf{category}->[$i] = $_;
		$i++;
	}
	
	$cf{payment} = [];
	$i = 0;
	for ( split(/<>/,$cf{pay}) ) {
		$cf{payment}->[$i] = $_;
		$i++;
	}
	$cf{pref} = [];
	$i = 0;
	for ( split(/<>/,$cf{prefect}) ) {
		$i++;
		$cf{pref}->[$i] = $_;
	}
	$cf{deli} = [];
	$i = 0;
	for ( split(/,/,$cf{delitime}) ) {
		$cf{deli}->[$i] = $_;
		$i++;
	}
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h,$wr,$hr) = @_;
	if (!$wr) { $wr = $cf{img_max_w}; }
	if (!$hr) { $hr = $cf{img_max_h}; }
	
	# サイズ縮小
	if ($w > $wr || $h > $hr) {
		
		my $w2 = $wr / $w;
		my $h2 = $hr / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; }
		else { $key = $h2; }
		
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	return ($w,$h);
}


1;

