#┌──────────────────────────────
#│ HAPPY CART : addr_form.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;
use Crypt::RC4;

#-----------------------------------------------------------
#  住所入力画面
#-----------------------------------------------------------
sub addr_form_pl {
	my ($erflg,$err) = @_;
	
	# セッション読み取り
	my $ses = CGI::Session->load(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
	my $ses_addr  = $ses->param("addr");
	my $ses_addr2 = $ses->param("addr2");
	
	# 買物情報
	my $id = $ses->param('id');
	my ($i,@cart);
	for (1 .. $id) {
		my $cart = $ses->param("cart:$_");
		if ($cart ne '') { $i++; }
	}
	if (!$i) {
		my $msg = "買物カゴの中身が空ですので、リストに戻って商品を選択してください。\n";
		$msg .= qq|<p><a href="$cf{index_cgi}">リストTOP画面</a></p>\n|;
		error($msg);
	}
	
	my %ck;
	if ($erflg) {
		%ck = %in;
	} elsif ($ses_addr) {
		($ck{payment},$ck{date},$ck{deli},$ck{ship},$ck{corp},$ck{kana},$ck{name},$ck{email},$ck{zip},$ck{pref},$ck{addr},$ck{adds},$ck{tel},$ck{fax},$ck{memo}) = split(/<>/,$ses_addr);
		($ck{corp2},$ck{kana2},$ck{name2},$ck{zip2},$ck{pref2},$ck{addr2},$ck{adds2},$ck{tel2},$ck{fax2}) = split(/<>/,$ses_addr2);
	} else {
		%ck = get_cookie();
	}
	
	# 支払方法
	my $payment;
	for (0 .. $#{$cf{payment}}) {
		my ($pay,undef) = split(/,/,$cf{payment}[$_]);
		
		if ($ck{payment} == $_) {
			$payment .= qq|<input type="radio" name="payment" value="$_" checked>$pay<br>\n|;
		} else {
			$payment .= qq|<input type="radio" name="payment" value="$_">$pay<br>\n|;
		}
	}
	# 時間帯
	my $op_deli;
	for (0 .. $#{$cf{deli}}) {
		if ($ck{deli} == $_) {
			$op_deli .= qq|<option value="$_" selected>$cf{deli}->[$_]</option>\n|;
		} else {
			$op_deli .= qq|<option value="$_">$cf{deli}->[$_]</option>\n|;
		}
	}
	
	# 都道府県
	my ($op_pref,$op_pref2);
	for (1 .. $#{$cf{pref}}) {
		my ($pref,undef) = split(/,/,$cf{pref}[$_]);
		
		if ($ck{pref} eq $_ or $ck{pref} eq $_) {
			$op_pref .= qq|<option value="$_" selected>$pref</option>\n|;
			if ($ck{pref2} eq $_ or $ck{pref2} eq $_) {
				$op_pref2 .= qq|<option value="$_" selected>$pref</option>\n|;
			} else {
				$op_pref2 .= qq|<option value="$_">$pref</option>\n|;
			}
		} elsif ($ck{pref2} eq $_ or $ck{pref2} eq $_) {
			$op_pref2 .= qq|<option value="$_" selected>$pref</option>\n|;
			if ($ck{pref} eq $_ or $ck{pref} eq $_) {
				$op_pref .= qq|<option value="$_" selected>$pref</option>\n|;
			} else {
				$op_pref .= qq|<option value="$_">$pref</option>\n|;
			}
		} else {
			$op_pref .= qq|<option value="$_">$pref</option>\n|;
			$op_pref2 .= qq|<option value="$_">$pref</option>\n|;
		}
	}
	
	# 基本データ
	my %top = read_base();
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/addr.html") or error("open err: addr.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!sid!/$in{sid}/g;
	$tmpl =~ s/!payment!/$payment/g;
	$tmpl =~ s/<!-- op_deli -->/$op_deli/g;
	$tmpl =~ s/<!-- op_pref -->/$op_pref/g;
	$tmpl =~ s/<!-- op_pref2 -->/$op_pref2/g;
	$tmpl =~ s/<!-- err:(\w+) -->/errmsg($$err{$1})/eg;
	$tmpl =~ s/!top-(\w+)!/$top{$1}/g;
	$tmpl =~ s/!(date|memo|corp2?|kana2?|name2?|email|zip2?|addr2?|adds2?|tel2?|fax2?)!/$ck{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/<!-- shipping -->/ship_btn($ck{ship})/e;
	$tmpl =~ s/!prog_table!/prog_tbl(2)/e;
	
	# 配送先フォーム
	if ($ck{ship} == 2) {
		$tmpl =~ s/!disp!/block/g;
	} else {
		$tmpl =~ s/!disp!/none/g;
	}
	
	# 表示
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  注文者情報クッキー抽出
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	$ENV{HTTP_COOKIE} =~ /$cf{cookie_id}=([a-f0-9n]+);?/i;
	my $data = $1;
	
	# 復号
	my $text = decrypt($data);
	
	my @cook = split(/\t/,$text);
	my @addr = qw(corp kana name email zip pref addr adds tel fax corp2 kana2 name2 zip2 pref2 addr2 adds2 tel2 fax2);
	my %ret;
	for (0 .. $#cook) {
		$ret{$addr[$_]} = $cook[$_];
	}
	return %ret;
}

#-----------------------------------------------------------
#  RC4 復号
#-----------------------------------------------------------
sub decrypt {
	my ($crypt) = @_;
	
	# バイナリへ戻す
	$crypt =~ s/n/\n/g;
	$crypt =~ s/([0-9A-Fa-f]{2})/pack('H2', $1)/eg;
	
	# RC4暗号変換
	return RC4($cf{passphrase}, $crypt);
}

#-----------------------------------------------------------
#  エラーメッセージ
#-----------------------------------------------------------
sub errmsg {
	my $msg = shift;
	
	if ($msg) {
		return qq|<span style="color:red">$msg</span><br>|;
	} else {
		return;
	}
}

#-----------------------------------------------------------
#  配送先選択
#-----------------------------------------------------------
sub ship_btn {
	my $sel = shift;
	if (!$sel) { $sel = 1; }
	
	my %sel = (1 => '上記に同じ', 2 => '別の場所に配送');
	my $ret;
	for (1,2) {
		if ($sel == $_) {
			$ret .= qq|<input type="radio" name="ship" value="$_" checked onclick="shipbtn()">$sel{$_}<br>\n|;
		} else {
			$ret .= qq|<input type="radio" name="ship" value="$_" onclick="shipbtn()">$sel{$_}<br>\n|;
		}
	}
	return $ret;
}


1;

