#┌──────────────────────────────
#│ HAPPY CART : chck_cart.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;

#-----------------------------------------------------------
#  カート中身
#-----------------------------------------------------------
sub chck_cart_pl {
	# 買物継続
	main_cart() if ($in{main_cart});
	
	# 変更 or 削除
	my ($del,$chg);
	for ( keys %in ) {
		if (/^del:(\d+)$/) {
			$del = $1;
			last;
		} elsif (/^chg:(\d+)$/) {
			$chg = $1;
			if ($in{"num:$chg"} == 0) { $del = $1; }
			last;
		}
	}
	
	# セッション読み取り
	my $ses = CGI::Session->new(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
	
	# カートID取得
	my $id = $ses->param('id');
	
	# 削除
	if ($del) {
		$ses->clear(["cart:$del"]);
	
	# 変更
	} elsif ($chg && $in{"num:$chg"} >= 1) {
		
		# 在庫情報
		my %zan = read_stock() if ($cf{stock} == 1);
		
		my $cart = $ses->param("cart:$chg");
		my ($no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/,$cart);
		
		# 在庫チェック
		if ($cf{stock} == 1 && $zan{$no} < $in{"num:$chg"}) {
			error("「$item」の在庫数は$zan{$no}個のため変更できません.");
		}
		
		# 新セッション設定
		$ses->param("cart:$chg","$no<>$in{\"num:$chg\"}<>$size<>$col<>$item<>$pri<>$code<>$cat<>$img<>$rtax");
	}
	
	my @cart;
	if ($id >= 1) {
		foreach (1 .. $id) {
			# 削除
			next if ($del == $_);
			
			my $cart = $ses->param("cart:$_");
			next if ($cart eq '');
			push(@cart,"$_<>$cart");
		}
	}
	
	# 基本データ
	my %top = read_base();
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/cart-in.html") or error("open err: cart-in.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 税区分
	if (!$cf{tax_per}) { $tmpl =~ s|<!-- tax -->.+?<!-- /tax -->||s; }
	
	# 文字置き換え
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!sid!/$in{sid}/g;
	$tmpl =~ s/!top-(\w+)!/$top{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/!prog_table!/prog_tbl(1)/e;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	my $all = 0;
	my $red = 0;
	for (@cart) {
		my ($id,$no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/);
		my ($ex,$w,$h) = split(/,/,$img);
		my $kei = $pri * $num;
		$all += $kei;
		
		my $opt;
		$opt .= "[$cf{op1}]$size<br>" if ($size);
		$opt .= "[$cf{op2}]$col<br>" if ($col);
		
		# 軽減税率
		if ($cf{tax_per} > 0 && $rtax == 1) {
			$red += $kei;
			$opt .= "[軽減税率対象]";
		}
		if ($opt eq '') { $opt .= "<br>"; }
		
		my $tmp = $loop;
		$tmp =~ s/!id!/$id/g;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!code!/$code/g;
		$tmp =~ s/!nos!/$num/g;
		$tmp =~ s/!price!/comma($pri)/eg;
		$tmp =~ s/!kei!/comma($kei)/eg;
		$tmp =~ s/!option!/$opt/g;
		$tmp =~ s|<!-- image -->|<img src="$cf{imgurl}/$no-1$ex" alt="" width="100" class="icon">|;
		
		print $tmp;
	}
	
	# 消費税計算
	my ($kei,$tax1,$tax2,$all,$tar) = calc_tax($all,$red);
	
	$foot =~ s/!kei!/comma($kei)/eg;
	$foot =~ s/!tax1!/comma($tax1)/eg;
	$foot =~ s/!tax2!/comma($tax2)/eg;
	$foot =~ s/!all!/comma($all)/eg;
	$foot =~ s/!(tax_per|red_per)!/$cf{$1}/g;
	$foot =~ s/!tax_tar!/comma($tar)/eg;
	$foot =~ s/!red_tar!/comma($red)/eg;
	
	# カートの中身が空のとき
	if (@cart == 0) { $foot =~ s|<!-- gobtn -->.+?<!-- /gobtn -->||s; }
	
	# フッタ
	footer($foot);
}


1;

