#┌──────────────────────────────
#│ HAPPY CART : refer_act.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;

#-----------------------------------------------------------
#  特定商取引法の表記
#-----------------------------------------------------------
sub refer_act_pl {
	# 基本データ
	my %top = read_base();
	
	# データ読み取り
	open(IN,"$cf{datadir}/law.dat") or error("open err: law.dat");
	my @log = <IN>;
	close(IN);
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/act.html") or error("open err: act.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!sid!/$in{sid}/g;
	$tmpl =~ s/!top-(\w+)!/$top{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (@log) {
		my ($no,$item,$data) = split(/\t/);
		
		my $tmp = $loop;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!data!/$data/g;
		
		print $tmp;
	}
	
	# フッタ
	print $foot;
	exit;
}


1;

