#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ HAPPY CART : check.cgi - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%cf);

# 外部ファイル取り込み
require './init.cgi';
%cf = set_init();

print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
<li>Perlバージョン : $]
EOM

# ディレクトリ
for ( $cf{datadir}, "$cf{datadir}/log", "$cf{datadir}/ses", "$cf{datadir}/pwd", "$cf{datadir}/db", "$cf{datadir}/detail" ) {
	if (-d $_) {
		print "<li>$_ ディレクトリパス : OK\n";
		
		if (-r $_ && -w $_ && -x $_) {
			print "<li>$_ ディレクトリパーミッション : OK\n";
		} else {
			print "<li>$_ ディレクトリパーミッション : NG\n";
		}
	} else {
		print "<li>$_ ディレクトリパス : NG\n";
	}
}

# ファイルチェック
for (qw(law.dat base.dat index.dat key.dat pass.dat stock.dat index.dat)) {
	if (-f "$cf{datadir}/$_") {
		print "<li>$_ ファイルパス : OK\n";
		
		if (-r "$cf{datadir}/$_" && -w "$cf{datadir}/$_") {
			print "<li>$_ ファイルパーミッション : OK\n";
		} else {
			print "<li>$_ ファイルパーミッション : NG\n";
		}
	} else {
		print "<li>$_ ファイルパス : NG\n";
	}
}

# sendmail
if (-e $cf{sendmail}) {
	print "<li>sendmailパス : OK\n";
} else {
	print "<li>sendmailパス : NG\n";
}

# テンプレート
for (qw(act addr cart cart-in conf detail prog-1 prog-2 prog-3 prog-3p prog-4 prog-4p error act send send-bank send-credit send-conv)) {
	if (-f "$cf{tmpldir}/$_.html") {
		print "<li>テンプレート( $_.html ) : OK\n";
	} else {
		print "<li>テンプレート( $_.html ) : NG\n";
	}
}
for (qw(mail reply)) {
	if (-f "$cf{tmpldir}/$_.txt") {
		print "<li>テンプレート( $_.txt ) : OK\n";
	} else {
		print "<li>テンプレート( $_.txt ) : NG\n";
	}
}

# Image-Magick動作確認
eval { require Image::Magick; };
if ($@) {
	print "<li>Image-Magick動作: NG\n";
} else {
	print "<li>Image-Magick動作: OK\n";
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;


