#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ WEB MART : admin.cgi - 2019/09/29
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル取り込み
require './init.cgi';
my %cf = set_init();

# データ受け取り
my %in = parse_form();

# 認証
check_passwd();

# 処理分岐
if ($in{data_new}) { data_new(); }
if ($in{data_men}) { data_men(); }
if ($in{look_log}) { look_log(); }

# メニュー画面
&menu_html;

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	
	print <<EOM;
<div align="center">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>新規商品データ作成</td>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>商品データメンテナンス（修正・削除）</td>
</tr><tr>
	<td><input type="submit" name="look_log" value="選択"></td>
	<td>ログデータ閲覧</td>
</tr><tr>
	<td><input type="button" value="選択" onclick="javascript:window.location='$cf{admin_cgi}'"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  新規記事作成
#-----------------------------------------------------------
sub data_new {
	my ($d_code,$d_item,$d_price,$d_red,$d_zai) = @_;
	
	# 新規記事追加
	if ($in{job} eq "new") { data_add(); }
	
	# パラメータ指定
	my ($mode,$job,$input_code);
	if ($in{data_new}) {
		$mode = "data_new";
		$job = "new";
		$input_code = qq|<input type="text" name="code" size="20"> （英数字のみ）|;
	} else {
		$mode = "data_men";
		$job = "edit2";
		$input_code .= qq|<b>$d_code</b> （変更不可）\n|;
		$input_code .= qq|<input type="hidden" name="code" value="$d_code">|;
	}
	
	&header("メニューTOP ＞ 登録フォーム");
	&back_btn;
	print <<EOM;
<div class="ttl">■ 商品登録フォーム</div>
<blockquote>
<p>必要項目を入力して、送信ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="$mode" value="1">
<input type="hidden" name="job" value="$job">
<table class="form-tbl">
<tr>
	<th nowrap>商品コード</th>
	<td>$input_code</td>
</tr><tr>
	<th nowrap>商品名</th>
	<td><input type="text" name="item" size="40" value="$d_item"></td>
</tr><tr>
	<th nowrap>商品単価</th>
	<td>
		<input type="text" name="price" size="20" value="$d_price"> 円<br>
EOM

	if ($cf{tax_per} > 0) {
		if ($d_red == 1) {
			print qq|<input type="checkbox" name="red" value="1" checked>|;
		} else {
			print qq|<input type="checkbox" name="red" value="1">|;
		}
		print qq|軽減税率対象\n|;
	}
	
	print <<EOM;
	</td>
</tr>
</table>
<input type="submit" value="送信する">
</form>
</blockquote>
</body>
</html>
EOM
	exit;
}
#-----------------------------------------------------------
#  データ追加
#-----------------------------------------------------------
sub data_add {
	# 入力チェック
	my ($q_code,$q_item,$q_price,$q_red,$q_zai) = check_input();
	
	# データ追加
	my ($flg,@data);
	open(DAT,"+< $cf{datfile}") or cgi_err("open err: $cf{datfile}");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($code,$item,$price,$red) = split(/<>/);
		
		if ($q_code eq $code) {
			$flg++;
			last;
		}
		push(@data,$_);
	}
	
	# コード重複
	if ($flg) {
		close(DAT);
		cgi_err("商品コード（$q_code）が重複しています");
	}
	
	seek(DAT,0,0);
	print DAT @data;
	print DAT "$q_code<>$q_item<>$q_price<>$q_red<>\n";
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 在庫数
	if ($cf{stock}) {
		open(DAT,">> $cf{stkfile}") or cgi_err("write err: $cf{stkfile}");
		eval "flock(DAT, 2);";
		print DAT "$q_code<>$q_zai<>\n";
		close(DAT);
	}
	
	# 元画面フォーム
	my $btn = <<EOM;
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_new" value="1">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" value="投稿フォームに戻る" style="width:140px">
</form>
EOM

	# 完了メッセージ
	message("新規商品データを追加しました", $btn);
}

#-----------------------------------------------------------
#  商品データメンテナンス
#-----------------------------------------------------------
sub data_men {
	# 指示フラグ
	my $job = $in{job};
	
	# 修正フォーム
	if ($job eq "edit" && $in{code}) {
		
		my @data;
		open(IN,"$cf{datfile}") or cgi_err("open err: $cf{datfile}");
		while(<IN>) {
			my ($code,$item,$price,$red) = split(/<>/);
			
			if ($in{code} eq $code) {
				@data = ($code,$item,$price,$red);
				last;
			}
		}
		close(IN);
		
		# 在庫ファイル
		if ($cf{stock}) {
			open(IN,"$cf{stkfile}") or cgi_err("open err: $cf{stkfile}");
			while(<IN>) {
				my ($code,$zai) = split(/<>/);
				
				if ($in{code} eq $code) {
					@data = (@data,$zai);
					last;
				}
			}
			close(IN);
		}
		
		# 修正フォーム
		data_new(@data);
	
	# 修正実行
	} elsif ($job eq "edit2") {
		
		# 入力チェック
		my ($q_code,$q_item,$q_price,$q_red,$q_zai) = check_input();
		
		# 商品データ修正
		my @data;
		open(DAT,"+< $cf{datfile}") or cgi_err("write err: $cf{datfile}");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($code,$item,$price,$red) = split(/<>/);
			
			if ($q_code eq $code) {
				$_ = "$code<>$q_item<>$q_price<>$q_red<>\n";
			}
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 在庫数更新
		if ($cf{stock}) {
			my ($flg,@data);
			open(DAT,"+< $cf{stkfile}") or cgi_err("write err: $cf{stkfile}");
			eval "flock(DAT, 2);";
			while(<DAT>) {
				my ($code,$zai) = split(/<>/);
				
				if ($q_code eq $code) {
					$flg++;
					$_ = "$code<>$q_zai<>\n";
				}
				push(@data,$_);
			}
			if (!$flg) { push(@data,"$q_code<>$q_zai<>\n"); }
			seek(DAT,0,0);
			print DAT @data;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
	
	# 削除
	} elsif ($job eq "dele" && $in{code}) {
		
		my @data;
		open(DAT,"+< $cf{datfile}") or cgi_err("write err: $cf{datfile}");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($code,$item,$price,$red) = split(/<>/);
			next if ($in{code} eq $code);
			
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 在庫数更新
		if ($cf{stock}) {
			my @data;
			open(DAT,"+< $cf{stkfile}") or cgi_err("write err: $cf{stkfile}");
			eval "flock(DAT,2);";
			while(<DAT>) {
				my ($code,$zai) = split(/<>/);
				next if ($in{code} eq $code);
				
				push(@data,$_);
			}
			seek(DAT,0,0);
			print DAT @data;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
	}
	
	# 在庫データ認識
	my %zai;
	if ($cf{stock}) {
		open(DAT,"$cf{stkfile}") or cgi_err("open err: $cf{stkfile}");
		while(<DAT>) {
			my ($code,$zai) = split(/<>/);
			$zai{$code} = $zai;
		}
		close(DAT);
	}
	
	header("メニューTOP ＞ 商品データメンテナンス");
	back_btn();
	print <<EOM;
<div class="ttl">■ 商品データメンテナンス</div>
<blockquote>
<p>処理を選択し、送信ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="data_men" value="1">
処理：
<select name="job">
<option value="edit">修正
<option value="dele">削除
</select>
<input type="submit" value="送信">
<table class="form-tbl">
<tr>
	<th nowrap>選択</th>
	<th nowrap>商品コード</th>
	<th nowrap>商品名</th>
	<th nowrap>金額</th>
EOM

	print qq|<th nowrap>在庫</th>| if ($cf{stock});
	print qq|</tr>\n|;
	
	open(IN,"$cf{datfile}") or cgi_err("open err: $cf{datfile}");
	while(<IN>) {
		my ($code,$item,$price,$red) = split(/<>/);
		$price = comma($price);
		
		print qq|<tr><td class="ta-c"><input type="radio" name="code" value="$code"></td>|;
		print qq|<td nowrap>$code</td>|;
		print qq|<td nowrap>$item</td>|;
		print qq|<td nowrap align="right">￥$price</td>|;
		print qq|<td nowrap align="right">$zai{$code}<br></td>| if ($cf{stock});
		print qq|</tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</blockquote>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  ログデータ閲覧
#-----------------------------------------------------------
sub look_log {
	# 閲覧ボタン確認
	my $look_num;
	for ( keys %in ) {
		if (/^look:(\d+)$/) {
			$look_num = $1;
			last;
		}
	}
	# 個別閲覧
	if ($look_num) { look_num($look_num); }
	
	# 年月データ
	my $q_ym = $in{ym};
	
	# 入力内容が規定外の場合は現在の年月
	if ($q_ym !~ /^\d{6}$/) {
		my ($m,$y) = (localtime())[4,5];
		$q_ym = sprintf("%04d%02d", $y+1900,$m+1);
	}
	
	header("メニューTOP ＞ ログデータ閲覧");
	back_btn();
	print <<EOM;
<div class="ttl">■ ログデータ閲覧</div>
<blockquote>
<p>年月を切り替えて閲覧することができます。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="look_log" value="1">
年月：
<select name="ym">
EOM

	opendir(DIR,"$cf{logdir}") or cgi_err("open err: $cf{logdir}");
	while( my $file = readdir(DIR) ) {
		
		if ($file =~ /^(\d{4})(\d{2})\.cgi$/) {
			if ($q_ym == "$1$2") {
				print qq|<option value="$1$2" selected>$1年$2月\n|;
			} else {
				print qq|<option value="$1$2">$1年$2月\n|;
			}
		}
	}
	closedir(DIR);
	
	print <<EOM;
</select>
<input type="submit" value="切替">
<table class="form-tbl">
<tr>
	<th nowrap>選択</th>
	<th nowrap>注文日時</th>
	<th nowrap>注文番号</th>
</tr>
EOM

	open(IN,"$cf{logdir}/$q_ym.cgi");
	while(<IN>) {
		my ($date,$num,$log) = split(/<>/);
		
		print qq|<tr><td><input type="submit" name="look:$num" value="閲覧"></td>\n|;
		print qq|<td nowrap>$date</td>\n|;
		print qq|<td nowrap align="center">$num</td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</blockquote>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  個別ログ閲覧
#-----------------------------------------------------------
sub look_num {
	my $look_num = shift;
	
	# ログデータ名
	my $log = ($in{ym} =~ /^(\d{4})(\d{2})$/) && "$1$2.cgi";
	
	# ログオープン
	my %log;
	open(IN,"$cf{logdir}/$log") or cgi_err("open err: $log");
	while(<IN>) {
		my ($date,$num,$log) = split(/<>/);
		
		if ($look_num == $num) {
			($log{date},$log{num},$log{log}) = ($date,$num,$log);
			last;
		}
	}
	close(IN);
	
	$log{log} =~ s/\t/<br>/g;
	
	header("メニューTOP ＞ ログデータ閲覧 ＞ 個別ログ");
	back_btn('look_log');
	print <<EOM;
<div class="ttl">■ ログデータ閲覧 ＞ 個別ログ</div>
<p>
	・注文年月： <b>$log{date}</b><br>
	・注文番号： <b>$log{num}</b><br>
</p>
$log{log}
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_input {
	# 禁止文字
	$in{code} =~ s/\W//g;
	$in{item} =~ s/[<>&";]//g;
	$in{price} =~ s/\D//g;
	$in{red} =~ s/\D//g;
	$in{zai} =~ s/\D//g;
	
	# 入力チェック
	my $err;
	if ($in{code} eq "") { $err .= "商品コードが未入力です<br>"; }
	if ($in{item} eq "") { $err .= "商品名が未入力です<br>"; }
	if ($in{price} eq "") { $err .= "商品単価が未入力です<br>"; }
	if ($in{zai} eq "" && $cf{stock}) { $err .= "在庫数が未入力です<br>"; }
	if ($err) { cgi_err($err); }
	
	return ($in{code},$in{item},$in{price},$in{red},$in{zai});
}

#-----------------------------------------------------------
#  パスワード認証
#-----------------------------------------------------------
sub check_passwd {
	# パスワードが未入力の場合は入力フォーム画面
	if ($in{pass} eq "") {
		enter_form();
	
	# パスワード認証
	} elsif ($in{pass} ne $cf{password}) {
		cgi_err("認証できません");
	}
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	header("入室画面");
	print <<EOM;
<form action="$cf{admin_cgi}" method="post">
<div id="auth-box">
	<fieldset><legend> password </legend>
		<input type="password" name="pass" size="25">
		<input type="submit" value=" 認証 ">
	</fieldset>
</div>
</form>
<script>self.document.forms[0].pass.focus();</script>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<style type="text/css">
body { font-size:90%; background:#f0f0f0; font-family:Verdana,"MS PGothic","Osaka",Arial,sans-serif; }
table.form-tbl { border-collapse:collapse; margin:1em 0; }
table.form-tbl th, table.form-tbl td { border:1px solid #333; padding:6px; }
table.form-tbl th { background:#a6a6d2; }
table.form-tbl td { background:#fff; }
div.ttl { border-bottom:1px solid #003a75; color:#003a75; padding:4px; font-weight:bold; }
#auth-box { width:500px; margin:3em auto; text-align:center; }
#auth-box fieldset { margin:2em; padding:3em; }
.ta-c { text-align:center; }
.ta-l { text-align:left; }
.ta-r { text-align:right; }
</style>
<title>$ttl</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my $mode = shift;
	
	print <<EOM;
<div align="right">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
@{[ $mode ? qq|<input type="submit" name="$mode" value="&lt; 前画面">| : "" ]}
<input type="submit" value="&lt; メニュー">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $msg = shift;
	
	header("ERROR!");
	print <<EOM;
<div align="center">
<hr width="350">
<h3>ERROR!</h3>
<p style="color:#dd0000">$msg</p>
<hr width="350">
<form>
<input type="button" value="前画面に戻る" onclick="history.back()">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  メッセージ表示
#-----------------------------------------------------------
sub message {
	my ($msg,$btn) = @_;
	
	header("処理完了");
	print <<EOM;
<div class="ttl">■ 処理完了</div>
<blockquote>
<p style="color:#008000">$msg</p>
$btn
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" value="メニューに戻る" style="width:140px">
</form>
</blockquote>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		cgi_err('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	for ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		
		# 無効化
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/\r\n/\t/g;
		$val =~ s/\n/\t/g;
		$val =~ s/\r/\t/g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}


