# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ CartForm : cartform.cgi - 2020/05/18
#│ copyright (c) kentweb, 1997-2020
#│ http://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'CartForm v4.51';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問はお受けいたしておりません。
#└─────────────────────────────────

#===========================================================
#  ▼基本設定
#===========================================================

# 管理用パスワード
$cf{password} = '0123';

# 消費税方式
# 0     : 内税方式
# 0以外 : 外税方式にて%単位で指定
$cf{tax_per} = 10;

# 軽減税率（$cf{tax_per} が 0 以外で有効）
$cf{red_per} = 8;

# 送信先メールアドレス
$cf{mailto} = 'xxx@xxx.xx';

# sendmailのパス【サーバパス】
# → プロバイダの指定を確認のこと
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailへの-fコマンド（プロバイダの仕様確認）
# 0=no 1=yes
$cf{send_fcmd} = 0;

# フォームのname値の置き換えをする場合
# → 英字のname値を日本語に自動的に置き換えます。
# 例: 「email = xx@xx.xx」→「メールアドレス = xx@xx.xx」
$cf{replace} = {
	'name'  => 'お名前',
	'email' => 'メールアドレス',
	'pay'   => '支払方法',
	'deli'  => 'お届け月日',
	'time'  => 'お届け時間',
	'tel'   => '電話番号',
	'zip'   => '郵便番号',
	'pref'  => '都道府県',
	'addr'  => '住所',
	'memo'  => '備考',

	};

# 送信者へのメール返信
# 0=no 1=yes
$cf{auto_res} = 1;

# メールタイトル
$cf{subject} = 'ご注文フォーム';

# 返信向けメールタイトル
$cf{sub_reply} = 'ご注文内容の確認';

# 本体プログラム【URLパス】
$cf{cart_cgi} = './cartform.cgi';

# ログファイル【サーバパス】
$cf{logfile} = './data/log.cgi';

# 商品データファイル【サーバパス】
$cf{datfile} = './data/data.dat';

# 購入ログディレクトリ【サーバパス】
$cf{logdir} = './data/log';

# 通番ファイル【サーバパス】
$cf{numfile} = './data/num.dat';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 都道府県
# → 県別に送料を指定する時はコンマの後に送料を指定
# → 送料が不要な場合は送料部分を 0 とする
$cf{pref} = [
	'',
	'北海道,1080',
	'青森県,1080',
	'岩手県,1080',
	'宮城県,1080',
	'秋田県,1080',
	'山形県,1080',
	'福島県,1080',
	'茨城県,540',
	'栃木県,540',
	'群馬県,540',
	'埼玉県,540',
	'千葉県,540',
	'東京都,540',
	'神奈川県,540',
	'新潟県,864',
	'富山県,864',
	'石川県,864',
	'福井県,864',
	'山梨県,864',
	'長野県,864',
	'岐阜県,864',
	'静岡県,864',
	'愛知県,864',
	'三重県,864',
	'滋賀県,864',
	'京都府,864',
	'大阪府,864',
	'兵庫県,864',
	'奈良県,864',
	'和歌山県,864',
	'鳥取県,1080',
	'島根県,1080',
	'岡山県,1080',
	'広島県,1080',
	'山口県,1080',
	'徳島県,1080',
	'香川県,1080',
	'愛媛県,1080',
	'高知県,1080',
	'福岡県,1080',
	'佐賀県,1080',
	'長崎県,1080',
	'熊本県,1080',
	'大分県,1080',
	'宮崎県,1080',
	'鹿児島県,1080',
	'沖縄県,1080',
	];

# 送料の無料サービス
# → 一定金額以上で送料を無料にする場合
# → この機能を使用しない場合は「0」とする
$cf{deli_nocost} = 3000;

# 支払形態で手数料付加
# [例] 代引のときは+500円
# → 左（添え字）はname値「pay」の値を指定
# → 右（値）は手数料
$cf{pay_cost} = {
	'代引' => 500,
	};

# 送信後の戻り先【URLパス】
$cf{back_url} = '../index.html';

# フォームのname値の正当性をチェックする
# → 半角文字は英数字、アンダーバー、ハイフンはOK。全角は全てOK
# 0=no 1=yes
$cf{check_key} = 1;

# 最大受信サイズ（Byte）
# → 例 : 102400Bytes = 100KB
$cf{maxdata} = 102400;

# 同一IPアドレスからの連続送信制御
# → 許可する間隔を秒数で指定（0にするとこの機能は無効）
$cf{block_post} = 0;

# 送信は method=POST 限定 (セキュリティ対策)
# 0=no 1=yes
$cf{postonly} = 1;

# ホスト名取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# --- [ ここより下はゼウス (ZEUS) クレジット決済の設定 ]
#
# [ ゼウスサービスを利用する ]
#  0 : しない
#  1 : クレジット利用【ゼウス社との契約必要】
#  2 : クレジット＋銀行決済サービスを利用【ゼウス社との契約必要】
#  3 : クレジット＋コンビニ決済サービスを利用【ゼウス社との契約必要】
#  4 : クレジット＋銀行決済＋コンビニ決済サービスを利用【ゼウス社との契約必要】
$cf{zeus_serv} = 0;

# ゼウス契約NO (クレジット決済用IPコード) 
# → $cf{zeus_serv} が 1, 2, 3, 4 の場合必須
$cf{zeus_num} = '11111';

# ゼウス契約NO (銀行決済用IPコード) 
# → $cf{zeus_serv} が 2, 4 の場合必須
$cf{zeus_bip} = '22222';

# ゼウス契約NO (コンビニ決済用IPコード) 
# → $cf{zeus_serv} が 3, 4 の場合必須
$cf{zeus_cip} = '33333';

#===========================================================
#  ▲設定完了
#===========================================================

# 設定値を返す
sub set_init {
	return %cf;
}

#-----------------------------------------------------------
#  桁区切り
#-----------------------------------------------------------
sub comma {
	local($_) = @_;
	
	1 while s/(.*\d)(\d\d\d)/$1,$2/;
	$_;
}


1;

