#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ CLIP BOARD : admin.cgi - 2022/06/26
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
cgi_err('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{data_men}) { data_men(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	print <<EOM;
<div id="body">
<div class="menu-msg">選択ボタンを押してください。</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>記事データ管理</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ管理
#-----------------------------------------------------------
sub data_men {
	# 編集フォーム
	if ($in{mode_edit} && $in{no}) {
		my $log;
		open(DAT,"$cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
		while (<DAT>) {
			my ($no) = (split(/<>/))[0];
			
			if ($in{no} == $no) {
				$log = $_;
				last;
			}
		}
		close(DAT);
		
		# フォーム
		edit_form($log);
	
	# 編集実行
	} elsif ($in{mode_edit2} && $in{no}) {
		
		if ($in{url} eq 'http://') { $in{url} = ''; }
		
		my @log;
		open(DAT,"+< $cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$ex,$w,$h,$tim,$chk) = split(/<>/);
			
			if ($in{no} == $no) {
				# 添付削除
				if ($in{del}) {
					unlink("$cf{imgdir}/$no$ex");
					unlink("$cf{imgdir}/$no-s$ex") if (-f "$cf{imgdir}/$no-s$ex");
					$ex = $w = $h = '';
				}
				$_ = "$no<>$dat<>$in{name}<>$in{email}<>$in{sub}<>$in{comment}<>$in{url}<>$hos<>$pw<>$ex<>$w<>$h<>$tim<>$chk<>\n";
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# 画像許可
	} elsif ($in{mode_chk} && $in{no}) {
		my %chk;
		foreach ( $cgi->param('no') ) {
			$chk{$_}++;
		}
		
		# 削除情報をマッチング
		my @log;
		open(DAT,"+< $cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$ex,$w,$h,$tim,$chk) = split(/<>/);
			
			if (defined $chk{$no}) {
				if ($chk == 1) { $chk = 0; } else { $chk = 1; }
				$_ = "$no<>$dat<>$nam<>$eml<>$sub<>$com<>$url<>$hos<>$pw<>$ex<>$w<>$h<>$tim<>$chk<>\n";
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# 削除処理
	} elsif ($in{mode_del} && $in{no}) {
		my %del;
		foreach ( $cgi->param('no') ) {
			$del{$_}++;
		}
		
		# 削除情報をマッチング
		my @log;
		open(DAT,"+< $cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$ex,$w,$h,$tim,$chk) = split(/<>/);
			
			if (defined($del{$no})) {
				unlink("$cf{imgdir}/$no$ex") if ($ex);
				unlink("$cf{imgdir}/$no-s$ex") if (-f "$cf{imgdir}/$no-s$ex");
				next;
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	# 画面表示
	header("管理用画面");
	print <<"EOM";
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_men" value="1">
<input type="submit" name="mode_edit" value="修正">
<input type="submit" name="mode_del" value="削除">
EOM

	if ($cf{imgcheck}) {
		print qq|<input type="submit" name="mode_chk" value="添付許可">\n|;
	}
	
	open(IN,"$cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
	while (<IN>) {
		my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$ex,$w,$h,$tim,$chk) = split(/<>/);
		if ($eml) { $nam = qq|<a href="mailto:$eml">$nam</a>|; }
		
		print qq|<div class="log"><input type="checkbox" name="no" value="$no">|;
		print qq|<strong>$sub</strong> 投稿者：<b>$nam</b> 投稿日：$dat No.$no &lt;<span>$hos</span>&gt;|;
		print qq|<div class="com">| . cut_str($com,50) . qq|</div>\n|;
		
		if ($ex) {
			my $size = -s "$cf{imgdir}/$no$ex";
			print qq|<div class="ext">添付|;
			if ($cf{imgcheck}) {
				if ($chk == 1) { print "[○]"; } else { print "[×]"; }
			}
			print qq|：<a href="$cf{imgurl}/$no$ex" target="_blank">$no$ex</a> ($size bytes)</div>\n|;
		}
		print qq|</div>\n|;
	}
	close(IN);
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  編集フォーム
#-----------------------------------------------------------
sub edit_form {
	my $log = shift;
	my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$ex,$w,$h,$tim,$chk) = split(/<>/, $log);
	$com =~ s|<br( /)?>|\n|g;
	$url ||= 'http://';
	
	my $clip;
	if ($ex) {
		$clip .= qq|[<a href="$cf{imgurl}/$no$ex" target="_blank">添付</a>]\n|;
		$clip .= qq|<input type="checkbox" name="del" value="1">削除\n|;
	}
	
	header('管理TOP &gt; 編集フォーム');
	print <<EOM;
<div align="right">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_men" value="1">
<input type="submit" value="&lt; 前に戻る">
</form>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="mode_edit2" value="1">
<input type="hidden" name="no" value="$in{no}">
<table class="edit-fm">
<tr>
	<th>なまえ</th>
	<td><input type="text" name="name" size="30" value="$nam"></td>
</tr><tr>
	<th>e-mail</th>
	<td><input type="text" name="email" size="30" value="$eml"></td>
</tr><tr>
	<th>タイトル</th>
	<td><input type="text" name="sub" size="36" value="$sub"></td>
</tr><tr>
	<th>コメント</th>
	<td><textarea name="comment" cols="60" rows="7">$com</textarea></td>
</tr><tr>
	<th>参照先</th>
	<td><input type="text" name="url" size="55" value="$url"></td>
</tr><tr>
	<th>添付</th>
	<td>$clip</td>
</tr><tr>
	<th></th>
	<td><input type="submit" value="編集する"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="" class="icon">
	CLIPBOARD 管理画面
</div>
<div id="body">
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div class="ta-c">
<div id="err">
<h3>ERROR!</h3>
<p class="err">$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  件名文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br( /)?>||g;
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	my $i = 0;
	my $ret;
	while ($str =~ /($byte1|$byte2|$byte3|$byte4)/gx) {
		$i++;
		$ret .= $1;
		last if ($i >= $all);
	}
	return $ret;
}

