# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ DAY COUNTER-EX : init.cgi - 2023/07/08
#│ copyright (c) KentWeb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'DayX v6.0';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────
#
# [ タグの書き方の例 ]
#   総カウント     <img src="count/dayx.cgi?gif" alt="">
#   本日のカウント <img src="count/dayx.cgi?today" alt="">
#   昨日　　〃	   <img src="count/dayx.cgi?yes" alt="">

#===========================================================
# ■ 設定項目
#===========================================================

# 画像連結モジュール
# 0 : gifcat.pl
# 1 : Image-Magick（サーバにインストールされている必要あり）
$cf{image_pm} = 0;

# 集計リストタイトル
$cf{list_title} = 'アクセス集計一覧';

# 累計カウント最低桁数
$cf{digit1} = 6;

# 本/昨日カウント最低桁数
$cf{digit2} = 3;

# 累計ファイル【サーバパス】
$cf{logfile} = "./data/dayx.dat";

# 昨日/本日ファイル【サーバパス】
$cf{yesfile} = "./data/yes.dat";
$cf{todfile} = "./data/today.dat";

# 日次記録ファイル【サーバパス】
$cf{dayfile} = "./data/day.dat";

# 月次記録ファイル【サーバパス】
$cf{monfile} = "./data/mon.dat";

# テンプレートディレクトリ
$cf{tmpldir} = './tmpl';

# 累計カウントGIF画像ディレクトリ【サーバパス】
$cf{gifdir1} = "./img/gif1";

# 本/昨日カウントGIF画像ディレクトリ【サーバパス】
$cf{gifdir2} = "./img/gif2";

# カウンタの機能タイプ
# 0 : 総カウント数不要（昨日／本日のみ）
# 1 : 標準タイプ
$cf{type} = 1;

# IPアドレスの二重カウントチェック
# 0 : チェックしない
# 1 : チェックする
$cf{ip_check} = 0;

# gifcat.plのパス【サーバパス】
$cf{gifcat_pl} = './lib/gifcat.pl';

# magick.plのパス【サーバパス】
$cf{magick_pl} = './lib/magick.pl';

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }


1;

