# モジュール取込/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ WEB ENQUETE : init.cgi - 2021/02/13
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'WEB ENQUETE v6.01';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理用パスワード
$cf{password} = '0123';

# 本体プログラムURL【URLパス】
$cf{enq_cgi} = './enq.cgi';

# 管理プログラムURL【URLパス】
$cf{admin_cgi} = './admin.cgi';

# 共通部品ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# アクセスログの最大記録数
$cf{max_log} = 200;

# グラフ画像【サーバパス】
$cf{graph} = "./cmn/graph.gif";

# 戻り先【サーバパス】
$cf{homepage} = "../index.html";

# 受理最大サイズ（Bytes）
$cf{maxdata} = 1024;

# 投稿時は「method=POST」限定 (0=no 1=yes)
#  → セキュリティ対策
$cf{postonly} = 1;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		
		# 無効化
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/[\r\n]//g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  基本設定認識
#-----------------------------------------------------------
sub read_init {
	my %set;
	open(IN,"$cf{datadir}/init.dat") or error("open err: init.dat");
	while(<IN>) {
		chomp;
		my ($key,$val) = split(/\t/);
		
		$set{$key} = $val;
	}
	close(IN);
	
	return %set;
}

#-----------------------------------------------------------
#  ログ記録
#-----------------------------------------------------------
sub save_log {
	my ($type,$vote,$host) = @_;
	$vote =~ s/\s$//;
	
	# 時間
	my ($sec,$min,$hour,$mday,$mon,$year) = (localtime(time))[0..5];
	my $date = sprintf("%04d/%02d/%02d-%02d:%02d:%02d",
					$year+1900,$mon+1,$mday,$hour,$min,$sec);
	
	# ブラウザ情報
	my $agent = $ENV{HTTP_USER_AGENT};
	$agent =~ s/[<>&"'()+]//g;
	
	my ($i,@log);
	open(DAT,"+< $cf{datadir}/axs.cgi") or error("open err: axs.cgi");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		$i++;
		push(@log,$_);
		last if ($i >= $cf{max_log}-1);
	}
	seek(DAT, 0, 0);
	print DAT "$date\t$type\t$vote\t$host\t$agent\n";
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  ホスト名取得
#-----------------------------------------------------------
sub get_host {
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};
	
	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	if ($host eq "") { $host = $addr; }
	
	return ($addr,$host);
}


1;

