#!/usr/local/bin/perl

#
# E-PAD : regist.cgi - 2011/10/02
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use Jcode;

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# @
my %ag = &check_agent;

# f[^
my %in = &parse_form;

# 
if ($in{mode} eq 'popwin') { &popwin; }
if ($in{mode} eq 'find') { &find_data; }
if ($in{mode} eq 'form') { &mblform; }
if ($in{read}) { &read_log; }
if ($in{res}) { &resform; }
if ($in{del}) { &delform; }
&bbs_list;

#-----------------------------------------------------------
#  f\
#-----------------------------------------------------------
sub bbs_list {
	# y[W`
	my $pg = $in{pg} || 0;

	# \
	my $pgmax = $ag{type} eq 'p' ? $cf{pg_max} : $cf{pg_max_mb};

	# f[^I[v
	my ($i,@log,%res,%rno);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}", $ag{type});
	while (<IN>) {
		my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$typ,$res) = split(/<>/);

		++$i if (!$reno);
		next if ($i < $pg + 1);
		next if ($i > $pg + $pgmax);

		# XL
		if ($reno) {
			$res{$no} = $_;
			$rno{$reno} .= "$no,";

			next;
		}

		push(@log,$_);
	}
	close(IN);

	# gщ
	if ($ag{type} ne 'p') {
		&bbs_list_mb($i,$pg,@log);
	}

	# Jz{^쐬
	my $page_btn = &make_pgbtn($i,$pg);

	# NbL[擾
	my @cook = &get_cookie;
	$cook[2] ||= 'http://';

	# ev[gǍ
	open(IN,"$cf{tmpldir}/bbs.html") or &error("open err: bbs.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/res.html") or &error("open err: res.html", $ag{type});
	my $restmpl = join('', <IN>);
	close(IN);

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł", $ag{type});
	}

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
	} else {
		$head =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	foreach ($head,$foot) {
		s/!([a-z]+_cgi)!/$cf{$1}/g;
		s/!homepage!/$cf{homepage}/g;
		s/!page_btn!/$page_btn/g;
		s/!sub!//g;
		s/!name!/$cook[0]/;
		s/!email!/$cook[1]/;
		s/!url!/$cook[2]/;
		s/!bbs_title!/$cf{bbs_title}/g;
		s/!str_crypt!/$str_crypt/g;
	}

	# wb_\
	print "Content-type: text/html\n\n";
	print $head;

	# [v
	foreach (@log) {
		my ($no,$reno,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/);
		$eml = qq|<a href="mailto:$eml"><img src="$cf{imgurl}/mail.gif"></a>| if ($eml);
		$url = qq|<a href="$url"><img src="$cf{imgurl}/home.gif"></a>| if ($url);
		$com = &autolink($com) if ($cf{autolink});

		# G
		$sub = &o2p($sub);
		$nam = &o2p($nam);
		$com = &o2p($com);

		my $reslog;
		if ($res > 0) {
			foreach my $rno ( split(/,/, $rno{$no}) ) {
				my ($no,$no2,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/, $res{$rno});
				$eml = qq|<a href="mailto:$eml"><img src="$cf{imgurl}/mail.gif"></a>| if ($eml);
				$url = qq|<a href="$url"><img src="$cf{imgurl}/home.gif"></a>| if ($url);
				$com = &autolink($com) if ($cf{autolink});

				# G
				$sub = &o2p($sub);
				$nam = &o2p($nam);
				$com = &o2p($com);

				my $tmp = $restmpl;
				$tmp =~ s/!name!/$nam/g;
				$tmp =~ s/!date!/$date/g;
				$tmp =~ s/!num!/$no/g;
				$tmp =~ s/!sub!/$sub/g;
				$tmp =~ s/!url!/$url/g;
				$tmp =~ s/!email!/$eml/g;
				$tmp =~ s/!comment!/$com/g;
				$tmp =~ s|!icon!|<img src="$cf{imgurl}/$type.gif">|;
				$reslog .= $tmp;
			}
		}

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!email!/$eml/g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		$tmp =~ s|!icon!|<img src="$cf{imgurl}/$type.gif">|;
		$tmp =~ s/<!-- res -->/$reslog/;
		print $tmp;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  ԐMtH[
#-----------------------------------------------------------
sub resform {
	$in{res} =~ s/\D//g;

	# f[^I[v
	my ($data,$resub,@res,%res,%rno);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}", $ag{type});
	while (<IN>) {
		my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$typ,$res) = split(/<>/);

		# eL
		if ($in{res} == $no) {
			$data = $_;
			$resub = $sub =~ /^Re:/ ? $sub : "Re: $sub";
		}

		# XL
		if ($in{res} == $reno) {
			push(@res,$_);
			$rno{$reno} .= "$no,";
		}
	}
	close(IN);

	# NbL[擾
	my @cook = &get_cookie;
	$cook[2] ||= 'http://';

	# ev[gǍ
	open(IN,"$cf{tmpldir}/bbs.html") or &error("open err: bbs.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/res.html") or &error("open err: res.html", $ag{type});
	my $restmpl = join('', <IN>);
	close(IN);

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł", $ag{type});
	}

	# ԐM{^폜
	$loop =~ s/<!-- resbtn_begin -->.+<!-- resbtn_end -->//s;

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
	} else {
		$head =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	foreach ($head,$foot) {
		s/!([a-z]+_cgi)!/$cf{$1}/g;
		s/!homepage!/$cf{homepage}/g;
		s/!page_btn!//g;
		s/!name!/$cook[0]/;
		s/!email!/$cook[1]/;
		s/!url!/$cook[2]/;
		s/!sub!/$resub/;
		s/!sub!/$res{sub}/;
		s/!comment!/$res{com}/;
		s/!bbs_title!/$cf{bbs_title}/g;
		s/!str_crypt!/$str_crypt/g;
		s|<!-- hidden -->|<input type="hidden" name="resno" value="$in{res}">|;
	}

	my $reslog;
	foreach my $log (@res) {
		my ($no,$no2,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/, $log);
		$eml = qq|<a href="mailto:$eml"><img src="$cf{imgurl}/mail.gif"></a>| if ($eml);
		$url = qq|<a href="$url"><img src="$cf{imgurl}/home.gif"></a>| if ($url);
		$com = &autolink($com) if ($cf{autolink});

		# G
		$sub = &o2p($sub);
		$nam = &o2p($nam);
		$com = &o2p($com);

		my $tmp = $restmpl;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s/!email!/$eml/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s|!icon!|<img src="$cf{imgurl}/$type.gif">|;
		$reslog .= $tmp;
	}

	# wb_\
	print "Content-type: text/html\n\n";
	print $head;

	my ($no,$reno,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/, $data);
	$eml = qq|<a href="mailto:$eml"><img src="$cf{imgurl}/mail.gif"></a>| if ($eml);
	$url = qq|<a href="$url"><img src="$cf{imgurl}/home.gif"></a>| if ($url);
	$com = &autolink($com) if ($cf{autolink});

	# G
	$sub = &o2p($sub);
	$nam = &o2p($nam);
	$com = &o2p($com);

	$loop =~ s/!num!/$no/g;
	$loop =~ s/!sub!/$sub/g;
	$loop =~ s/!date!/$date/g;
	$loop =~ s/!name!/$nam/g;
	$loop =~ s/!email!/$eml/g;
	$loop =~ s/!url!/$url/g;
	$loop =~ s/!comment!/$com/g;
	$loop =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$loop =~ s|!icon!|<img src="$cf{imgurl}/$type.gif">|;
	$loop =~ s/<!-- res -->/$reslog/;
	print $loop;

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  [h
#-----------------------------------------------------------
sub find_data {
	# 
	$in{cond} =~ s/\D//g;

	# v_E
	my %op = (1 => 'AND', 0 => 'OR');
	my $op_cond;
	foreach (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected>$op{$_}\n|;
		} else {
			$op_cond .= qq|<option value="$_">$op{$_}\n|;
		}
	}

	# s
	Jcode::convert(\$in{word}, 'sjis');
	my @log = &search($in{word}, $in{cond}) if ($in{word} ne '');

	# ev[g
	open(IN,"$cf{tmpldir}/find.html") or &error("open err: find.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# 
	$tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s;
	my ($head, $loop, $foot) = ($1, $2, $3);

	foreach ($head, $foot) {
		s/!bbs_cgi!/$cf{bbs_cgi}/g;
		s/<!-- op_cond -->/$op_cond/;
		s/!word!/$in{word}/;
	}

	# wb_
	print "Content-type: text/html\n\n";
	print $head;

	# [v
	foreach my $log (@log) {
		my ($no,$reno,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/, $log);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
		$com  = &autolink($com) if ($cf{autolink});
		$url  = qq|<a href="$url" target="_blank">$url</a>| if ($url);

		# G
		$sub = &o2p($sub);
		$nam = &o2p($nam);
		$com = &o2p($com);

		my $tmp = $loop;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!home!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		print $tmp;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  s
#-----------------------------------------------------------
sub search {
	my ($word,$cond) = @_;

	# L[[hz
	$word =~ s/@/ /g;
	my @wd = split(/\s+/, $word);

	# 
	my @log;
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}", $ag{type});
	while (<IN>) {
		my ($no,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim) = split(/<>/);

		my $flg;
		foreach my $wd (@wd) {
			if (index("$nam $eml $sub $com $url", $wd) >= 0) {
				$flg++;
				if ($cond == 0) { last; }
			} else {
				if ($cond == 1) { $flg = 0; last; }
			}
		}
		next if (!$flg);

		push(@log,$_);
	}
	close(IN);

	# 
	return @log;
}

#-----------------------------------------------------------
#  |bvEBhE
#-----------------------------------------------------------
sub popwin {
	# ev[g
	my $tmpl = $in{pg} eq 'note' ? 'note.html' : 'emoji.html';

	# ʕ\
	open(IN,"$cf{tmpldir}/$tmpl") or &error("open err: $tmpl", $ag{type});
	print "Content-type: text/html\n\n";
	print <IN>;
	close(IN);
	exit;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">E-PAD</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  N
#-----------------------------------------------------------
sub autolink {
	local($_) = @_;

	s|(s?https?://[\w-.!~*'();/?:\@&=+\$,%#]+)|<a href="$1" target="_blank">$1</a>|g;
	$_;
}

#-----------------------------------------------------------
#  G j  Ǝ
#-----------------------------------------------------------
sub j2o {
	local($_) = @_;

	# ^O
	s/&amp;/&/g;
	s/&quot;/"/g;
	s/&lt;/</g;
	s/&gt;/>/g;

	s/\x1B\x24[E-GO-Q]([^\x0F]+)\x0F/$1/;
	s/\x1B\x24([E-GO-Q])([\x21-\x7A]+)/&j2o2($1,$2)/eg;
	$_;
}
sub j2o2 {
	my ($f1,$f2) = @_;

	$f2 =~ s/([\x21-\x7A])/'<j'.$f1.unpack('H2',$1).'>'/eg;
	$f2;
}

#-----------------------------------------------------------
#  G Ǝ  i,j,e
#-----------------------------------------------------------
sub o2ije {
	local($_) = @_;

	# i-mode
	s/<i(f)([89])(..)>/pack('H2H2', "$1$2", $3)/eg;

	# vodafone
	s/<j([E-GO-Q])(..)>/pack('H2H2','1B','24').$1.pack('H2',$2).pack('H2','0F')/eg;

	# EZweb
	s/<e(f)(.)(..)>/pack('H2H2', "$1$2", $3)/eg;

	$_;
}

#-----------------------------------------------------------
#  G Ǝ  PC
#-----------------------------------------------------------
sub o2p {
	local($_) = @_;

	# vodafone
	s|<j([E-GO-Q])(..)>|<img src=\"$cf{emo_j}/$1$2.gif\">|g;

	# i-mode
	s|<i(f)([89])(..)>|<img src=\"$cf{emo_i}/$1$2$3.gif\">|g;

	# EZweb
	s|<e(f)(...)>|<img src=\"$cf{emo_e}/$1$2$3.gif\">|g;

	$_;
}

#-----------------------------------------------------------
#  G i  j
#-----------------------------------------------------------
sub i2j {
	local($_) = @_;

	s/<i(f)([89])(..)>/&i2j2("$1$2$3")/eg;
	$_;
}
sub i2j2 {
	local($_) = @_;

	if (defined($cf{i2j}->{$_})) {
		my $e = $cf{i2j}->{$_};
		$e =~ s/(.)(..)/pack('H2H2','1B','24').$1.pack('H2',$2).pack('H2','0F')/eg;
		$e;
	} else {
		return "<img src=\"$cf{emo_i}/$_.png\">";
	}
}

#-------------------------------------------------
#  G i  e
#-------------------------------------------------
sub i2e {
	local($_) = @_;

	s/<i(f)([89])(..)>/&i2e2("$1$2$3")/eg;
	$_;
}
sub i2e2 {
	local($_) = @_;

	if (defined($cf{i2e}->{$_})) {
		return "<img localsrc=\"$cf{i2e}->{$_}\">";
	} else {
		return "<img src=\"$cf{emo_i}/$_.gif\">";
	}
}

#-------------------------------------------------
#  G j  i
#-------------------------------------------------
sub j2i {
	local($_) = @_;

	s/<j([E-GO-Q])(..)>/&j2i2($1,$2)/eg;
	$_;
}
sub j2i2 {
	my ($f1,$f2) = @_;

	if (defined($cf{j2i}->{"$f1$f2"})) {
		my $e = $cf{j2i}->{"$f1$f2"};
		$e =~ s/(..)(..)/pack('H2H2', $1, $2)/e;
		return $e;
	} else {
		return "<img src=\"$cf{emo_j}/$f1$f2.gif\">";
	}
}

#-------------------------------------------------
#  G j  e
#-------------------------------------------------
sub j2e {
	local($_) = @_;

	s|<j([E-GO-Q])(..)>|&j2e2("$1$2")|eg;
	$_;
}
sub j2e2 {
	local($_) = @_;

	if (defined($cf{j2e}->{$_})) {
		return "<img localsrc=\"$cf{j2e}->{$_}\">";
	} else {
		return "<img src=\"$cf{emo_j}/$_.gif\">";
	}
}

#-------------------------------------------------
#  G e  i
#-------------------------------------------------
sub e2i {
	local($_) = @_;

	s|<e(f)(...)>|&e2i2("$1$2")|eg;
	$_;
}
sub e2i2 {
	local($_) = @_;

	if (defined($cf{e2i2}->{$_})) {
		my $e = $cf{e2i2}->{$_};
		$e =~ s/(..)(..)/pack('H2H2', $1, $2)/e;
		return $e;
	} else {
		return "<img src=\"$cf{emo_e}/$_.gif\">";
	}
}

#-------------------------------------------------
#  G e  j
#-------------------------------------------------
sub e2j {
	local($_) = @_;

	s|<e(f)(...)>|&e2j2("$1$2")|eg;
	$_;
}
sub e2j2 {
	local($_) = @_;

	if (defined($cf{e2j2}->{$_})) {
		my $e = $cf{e2j2}->{$_};
		$e =~ s/(.)(..)/pack('H2H2','1B','24').$1.pack('H2',$2).pack('H2','0F')/eg;
		$e;
	} else {
		return "<img src=\"$cf{emo_e}/$_.png\">";
	}
}

#-----------------------------------------------------------
#  Jz{^쐬
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;

	# y[WJz`
	$cf{pg_max} ||= 10;
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x, $y) = (1, 0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq(| <b>$x</b> );
			} else {
				$pg_btn .= qq(| <a href="$cf{bbs_cgi}?pg=$y">$x</a> );
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
		$pg_btn .= "|";
	}
	return qq|<div class="pg-btn">$pg_btn</div>|;
}

#-----------------------------------------------------------
#  Jz{^쐬igсj
#-----------------------------------------------------------
sub make_pgbtn_mb {
	my ($i,$pg) = @_;

	# y[WJz`
	$cf{pg_max_mb} ||= 5;
	my $next = $pg + $cf{pg_max_mb};
	my $back = $pg - $cf{pg_max_mb};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0) {
		$pg_btn .= qq|$ag{4}<a href="$cf{bbs_cgi}?pg=$back" accesskey="4">O$cf{pg_max_mb}</a><br />\n|;
	}
	if ($next < $i) {
		$pg_btn .= qq|$ag{6}<a href="$cf{bbs_cgi}?pg=$next" accesskey="6">$cf{pg_max_mb}</a><br />|;
	}
	return qq|<div style="text-align:right;">$pg_btn</div>|;
}

#-----------------------------------------------------------
#  f\igсj
#-----------------------------------------------------------
sub bbs_list_mb {
	my ($i,$pg,@log) = @_;

	# Jz{^쐬
	my $page_btn = &make_pgbtn_mb($i,$pg);

	# NbL[擾
	my @cook = &get_cookie;
	$cook[2] ||= 'http://';

	# ev[gǍ
	open(IN,"$cf{tmpldir}/mbl.html") or &error("open err: mbl.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!pg!/$pg/g;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł", $ag{type});
	}

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
	} else {
		$head =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	foreach ($head,$foot) {
		s/!([a-z]+_cgi)!/$cf{$1}/g;
		s/!homepage!/$cf{mbl_page}/g;
		s/!page_btn!/$page_btn/g;
		s/!bbs_title!/$cf{bbs_title}/g;
		s/!str_crypt!/$str_crypt/g;
		s/!(\d)!/$ag{$1}/g;
	}

	# wb_\
	print "Content-type: text/html\n\n";
	print $head;

	# [v
	foreach (@log) {
		my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$type,$res) = split(/<>/);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
		$url = qq|<a href="$url">URL</a>| if ($url);
		$com = &autolink($com) if ($cf{autolink});
		my $date = &mbl_date($tim);

		# G
		if ($ag{type} eq 'j') {
			$sub = &i2j($sub);
			$nam = &i2j($nam);
			$com = &i2j($com);
			$sub = &e2j($sub);
			$nam = &e2j($nam);
			$com = &e2j($com);
		} elsif ($ag{type} eq 'e') {
			$sub = &j2e($sub);
			$nam = &j2e($nam);
			$com = &j2e($com);
			$sub = &i2e($sub);
			$nam = &i2e($nam);
			$com = &i2e($com);
		} else {
			$sub = &j2i($sub);
			$nam = &j2i($nam);
			$com = &j2i($com);
			$sub = &e2i($sub);
			$nam = &e2i($nam);
			$com = &e2i($com);
		}
		$sub = &o2ije($sub);
		$nam = &o2ije($nam);
		$com = &o2ije($com);

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		$tmp =~ s/!res!/$res/;
		print $tmp;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  ԐMtH[igсj
#-----------------------------------------------------------
sub mblform {
	$in{pg} ||= 0;
	$in{res} =~ s/\D//g;

	# ԐM̂Ƃ
	my $resub;
	if ($in{res} > 0) {
		open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}", $ag{type});
		while (<IN>) {
			my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$typ,$res) = split(/<>/);
			next if ($reno);

			if ($in{res} == $no) {
				$resub = $sub =~ /^Re: / ? $sub : "Re: $sub";
			}
		}
		close(IN);
	}

	# ev[gǂݍ
	open(IN,"$cf{tmpldir}/mbl-form.html") or &error("open err: mbl-form.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
		$tmpl =~ s/!str_crypt!/$str_crypt/g;
	} else {
		$tmpl =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	$tmpl =~ s/!(\d)!/$ag{$1}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!pg!/$in{pg}/g;
	$tmpl =~ s/!sub!/$resub/g;
	if ($in{res}) {
		$tmpl =~ s|<!-- hidden -->|<input type="hidden" name="resno" value="$in{res}" />|;
	}

	# ʕ\
	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  Xbh\igсj
#-----------------------------------------------------------
sub read_log {
	$in{pg} ||= 0;

	my @log;
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}", $ag{type});
	while (<IN>) {
		my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$typ,$res) = split(/<>/);

		if ($in{read} == $no || $in{read} == $reno) {
			push(@log,$_);
		}
	}
	close(IN);

	# ev[gǂݍ
	open(IN,"$cf{tmpldir}/mbl-read.html") or &error("open err: mbl-read.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!(\d)!/$ag{$1}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!read!/$in{read}/g;
	$tmpl =~ s/!pg!/$in{pg}/g;

	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ڰĂsł", $ag{type});
	}

	# ʕ\
	print "Content-type: text/html\n\n";
	print $head;

	foreach (@log) {
		my ($no,$reno,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$typ,$res) = split(/<>/);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
		$url = qq|<a href="$url">URL</a>| if ($url);
		$com = &autolink($com) if ($cf{autolink});
		my $date = &mbl_date($tim);

		my $tmp = $loop;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!num!/$no/g;
		print $tmp;
	}

	print $foot;
	exit;
}

#-----------------------------------------------------------
#  폜tH[igсj
#-----------------------------------------------------------
sub delform {
	$in{del} =~ s/\D//g;
	$in{pg} ||= 0;

	# ev[gǂݍ
	open(IN,"$cf{tmpldir}/mbl-del.html") or &error("open err: mbl-del.html", $ag{type});
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!(\d)!/$ag{$1}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!num!/$in{del}/g;
	$tmpl =~ s/!pg!/$in{pg}/g;

	# ʕ\
	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  gїp
#-----------------------------------------------------------
sub mbl_date {
	my $time = shift;

	my ($min,$hour,$day,$mon,$year) = (localtime($time))[1..5];
	return sprintf("%02d/%02d/%02d-%02d:%02d", $year-100,$mon+1,$day,$hour,$min);
}

