#!/usr/local/bin/perl

#
# Midnight Fox Chat : init.cgi - 2011/09/17
# Copyright(C) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# f[^
my %in = &parse_form;

# F
&check_passwd;

# 
if ($in{mode} eq 'form') { &form; }
if ($in{mode} eq 'into') { &form2; }
if ($in{mode} eq 'data') { &chat_data; }
if ($in{mode} eq 'out')  { &room_out; }
if ($in{mode} eq 'regist') { &regist; }
&frame;

#-----------------------------------------------------------
#  tH[ : 
#-----------------------------------------------------------
sub form {
	# NbL[擾
	my ($ck_nam,$ck_eml,$ck_col,$ck_ret,$ck_lin) = &get_cookie;
	$ck_col = $ck_col ne '' ? $ck_col : 0;
	$ck_ret = $ck_ret ne '' ? $ck_ret : $cf{retime_defo};
	$ck_lin = $ck_lin ne '' ? $ck_lin : $cf{lines_defo};

	my ($op_retime,$op_lines,$colors);
	foreach (@{$cf{retime}}) {
		if ($ck_ret == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($ck_lin == $_) {
			$op_lines .= qq|<option value="$_" selected>$_s\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_s\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my ($col,undef) = split(/,/, $cf{colors}->[$_]);
		if ($ck_col == $_) {
			$colors .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$colors .= qq|<input type="radio" name="color" value="$_">|;
		}
		$colors .= qq|<span style="color:$col"></span>\n|;

		if ($_ == int(@{$cf{colors}}/2)-1) { $colors .= "<br>\n"; }
	}

	open(IN,"$cf{tmpldir}/form.html") or &error("open err: form.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;
	$tmpl =~ s/!colors!/$colors/g;
	$tmpl =~ s/!name!/$ck_nam/g;
	$tmpl =~ s/!email!/$ck_eml/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tH[
#-----------------------------------------------------------
sub form2 {
	my $err;
	if ($in{name} eq '') { $err .= "O͂ł<br>"; }
	if ($in{email} && $in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,}$/) { $err .= "e-mailsł<br>"; }
	&error($err) if ($err);

	# bZ[W
	&regist('into');

	# NbL[i[
	&set_cookie($in{name},$in{email},$in{color},$in{retime},$in{lines});

	my ($op_retime,$op_lines,$op_colors,$op_faces);
	foreach (@{$cf{retime}}) {
		if ($in{retime} == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($in{lines} == $_) {
			$op_lines .= qq|<option value="$_" selected>$_s\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_s\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my (undef,$nam) = split(/,/, $cf{colors}->[$_]);
		if ($in{color} == $_) {
			$op_colors .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_colors .= qq|<option value="$_">$nam\n|;
		}
	}
	foreach (@{$cf{faces}}) {
		$op_faces .= qq|<option value="$_">$_\n|;
	}

	open(IN,"$cf{tmpldir}/form2.html") or &error("open err: form2.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# OGR[h
	my $enam = &url_encode($in{name});

	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;
	$tmpl =~ s/<!-- op_colors -->/$op_colors/g;
	$tmpl =~ s/<!-- op_faces -->/$op_faces/g;
	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s/!email!/$in{email}/g;
	$tmpl =~ s/!enam!/$enam/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  L\
#-----------------------------------------------------------
sub chat_data {
	my $job = shift;

	if ($in{retime} eq '') { $in{retime} = $cf{retime_defo}; }
	my ($retime,$meta);
	if ($in{retime} == 0) {
		$retime = '蓮';
	} else {
		$retime = "$in{retime}b";
		my $enam = &url_encode($in{name});
		$in{lines} ||= $cf{lines_defo};
		$meta = qq|<meta http-equiv="refresh" content="$in{retime}; url=$cf{chat_cgi}?mode=data&name=$enam&retime=$in{retime}&id=$in{id}&pw=$in{pw}&line=$in{lines}">|;
	}
	$in{lines} ||= $cf{lines_defo};

	# ݎǗ
	my ($num,$member) = &member($job);

	open(IN,"$cf{tmpldir}/data.html") or &error("open err: data.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!member!/$member/g;
	$tmpl =~ s/!num!/$num/g;
	$tmpl =~ s/!retime!/$retime/g;
	$tmpl =~ s/!lines!/$in{lines}/g;
	$tmpl =~ s/<!-- meta_refresh -->/$meta/;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł");
	}

	print "Content-type: text/html\n\n";
	print $head;

	my $i;
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		my ($date,$name,$eml,$com,$col,undef,undef) = split(/<>/);

		my $tmp = $loop;
		$tmp =~ s|!name!|<span style="color:$col">$name</span>|g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|g;
		$tmp =~ s/!date!/$date/g;
		print $tmp;

		# \
		last if ($i >= $in{lines});
	}
	close(IN);

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  O
#-----------------------------------------------------------
sub regist {
	my $job = shift;

	# [ĥ
	&chat_data('reload') if (!$job && $in{comment} eq '');

	# 
	my ($name,$color);
	if ($job eq 'into') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_in}";
		$name  = $cf{master_name};
		$color = $cf{rep_color};
		$in{email} = '';

	# ޏo
	} elsif ($job eq 'out') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_out}";
		$name  = $cf{master_name};
		$color = $cf{rep_color};
		$in{email} = '';

	# 
	} else {
		$name = $in{email} ? qq|<a href="mailto:$in{email}">$cf{pointer}</a> <b>$in{name}</b>| : "$cf{pointer} <b>$in{name}</b>";
		($color,undef) = split(/,/, $cf{colors}->[$in{color}]);
	}

	# 擾
	my ($sec,$min,$hour,$mday,$mon) = (localtime(time))[0..4];
	my $date = sprintf("%02d/%02d-%02d:%02d:%02d",$mon+1,$mday,$hour,$min,$sec);

	# zXg
	my $host = &get_host;

	# 當
	$in{comment} .= " $in{face}" if ($in{face});

	# OJ
	my ($i,@log);
	open(DAT,"+< $cf{logfile}") or &error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		$i++;
		push(@log,$_);

		last if ($i >= $cf{maxlog});
	}

	# ǉL
	unshift (@log,"$date<>$name<>$in{email}<>$in{comment}<>$color<>$host<>$in{id}<>\n");

	# XV
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	# ͋Lʂ
	&chat_data('regist') if (!$job);
}

#-----------------------------------------------------------
#  ގ
#-----------------------------------------------------------
sub room_out {
	&regist('out');
	&member('out');

	open(IN,"$cf{tmpldir}/out.html") or &error("open err: out.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  F
#-----------------------------------------------------------
sub check_passwd {
	# tH[͂̃`FbN
	if ($in{id} eq "" || $in{pw} eq "") {
		&enter_form;
	}

	# F
	my $flg;
	foreach (@{$cf{passwd}}) {
		my ($id,$pw) = split(/:/);

		if ($in{id} eq $id && $in{pw} eq $pw) {
			$flg++;
			last;
		}
	}
	&error("F؂ł܂") if (!$flg);
}

#-----------------------------------------------------------
#  t[
#-----------------------------------------------------------
sub frame {
	# t[o
	open(IN,"$cf{tmpldir}/frame.html") or &error("open err: frame.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  
#-----------------------------------------------------------
sub enter_form {
	open(IN,"$cf{tmpldir}/enter.html") or &error("open err: enter.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;

	print "Content-type: text/html\n\n";
	&footer($tmpl);
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2.5em;text-align:center;font-family:verdana,helvetica,arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">MidnightFoxChat</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  ݎǗ
#-----------------------------------------------------------
sub member {
	my $job = shift;

	# /IP擾
	my $now = time;
	my $addr = $ENV{REMOTE_ADDR};

	my ($i,$member,$flg,@log);
	open(DAT,"+< $cf{memfile}") or &error("open err: $cf{memfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		my ($time,$name,$ip) = split(/<>/);

		# 60bȏ㔭̂Ȃ҂͍폜
		if ($now - 60 > $time) {
			$flg = 1;
			next;
		}

		if ($addr eq $ip) {
			$flg = 2;

			# ގҍ폜
			if ($job eq 'out') {
				next;

			# /OXV
			} else {
				$name = $in{name};
				$_ = "$now<>$name<>$addr<>\n";
			}
		}

		# XVpzɒǉ
		push(@log,$_);

		# Qҕ\p쐬
		if ($i % 2) {
			$member .= "$name";
			$i++;
		} else {
			$member .= "$name";
			$i++;
		}
	}

	# VKQҒǉ
	if (!$flg && $job ne 'out' && $in{name} ne '') {
		$flg = 3;
		push(@log,"$now<>$in{name}<>$addr<>\n");
		$member = $i % 2 ? "$member$in{name}" : "$member$in{name}";
	}

	# QҐ
	my $num = @log;

	# t@CXV
	if ($job || $flg) {
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
	}
	close(DAT);

	return ($num,$member);
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  URLGR[h
#-----------------------------------------------------------
sub url_encode {
	my $str = shift;

	$str =~ s/([^\w ])/'%'.unpack('H2', $1)/eg;
	$str =~ tr/ /+/;
	return $str;
}

#-----------------------------------------------------------
#  zXg擾
#-----------------------------------------------------------
sub get_host {
	# IP/zXg擾
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	$host ||= $addr;
	return $host;
}

#-----------------------------------------------------------
#  NbL[s
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLGR[h
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: fox_chat=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{fox_chat}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

