# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Happy Gallery : init.cgi - 2022/04/21
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Happy Gallery v1.0';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 設定項目
#===========================================================

# 本体CGI【URLパス】
$cf{index_cgi} = './index.cgi';

# 管理CGI【URLパス】
$cf{admin_cgi} = './admin.cgi';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# 画像ディレクトリ
# → 順に、【サーバパス】【URLパス】
$cf{imgdir} = './img';
$cf{imgurl} = './img';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init {
	open(IN,"$cf{datadir}/set.dat");
	while(<IN>) {
		chomp;
		my ($key,$val) = split(/\t/);
		
		$cf{$key} = $val;
	}
	close(IN);
	
	return %cf;
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	for ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		if ($_ ne 'upfile') {
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/'/&#39;/g;
			$val =~ s/[\r\n]//g;
		}
		$in{$_} = $val;
	}
	return %in;
}


1;

