#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Happy Gallery : admin.cgi - 2022/04/21
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);
use File::ReadBackwards;

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{upl_imgs}) { upl_imgs(); }
if ($in{set_base}) { set_base(); }
if ($in{data_new}) { data_new(); }
if ($in{data_mgr}) { data_mgr(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("管理メニュー");
	print <<EOM;
<div id="body">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th></th>
	<th class="w-16">管理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>画像新規登録</td>
</tr><tr>
	<td><input type="submit" name="data_mgr" value="選択"></td>
	<td>画像データ管理</td>
</tr><tr>
	<td><input type="submit" name="set_base" value="選択"></td>
	<td>基本設定</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  画像登録
#-----------------------------------------------------------
sub data_new {
	# 表示開始
	header("登録フォーム");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 画像登録</div>
<p>
	・画像は一度に複数登録できます（JPG/PNG/GIF）。<br>
	・登録後、「画像データ管理」でカテゴリ分け・コメント付与してください。
</p>
<div id="drag-drop-area"></div>
<button id="uppy-select-files">フォームを表示</button>
<script src="https://transloadit.edgly.net/releases/uppy/v1.2.0/uppy.min.js"></script>
<script src="https://transloadit.edgly.net/releases/uppy/locales/v1.4.0/ja_JP.min.js"></script>
<script>
var uppy = Uppy.Core({debug:true,
		restrictions: {
		//maxNumberOfFiles: 5,
		maxFileSize: $cf{maxdata},
		allowedFileTypes:['image/jpeg','image/png','image/gif'] }
		}).
		use(Uppy.Dashboard,{
			target: '#drag-drop-area',
			trigger: '#uppy-select-files',
			locale: Uppy.locales.ja_JP }
		).
		use(Uppy.XHRUpload,{
			endpoint: '$cf{admin_cgi}',
			fieldName: 'upfile',
			formData: true,
		}).
		setMeta({ sid: '$in{sid}', upl_imgs: 1 });
</script>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  画像アップロード
#-----------------------------------------------------------
sub upl_imgs {
	my $ext = $cgi->param_filename('upfile') =~ /\.([^\\\/:\.]+)$/ ? $1 : return;
	$ext =~ tr/A-Z/a-z/;
	if ($ext eq 'jpeg') { $ext = 'jpg'; }
	
	open(DAT,"+< $cf{datadir}/num.dat") or error("open err: num.dat");
	eval "flock(DAT,2);";
	my $num = <DAT> + 1;
	seek(DAT,0,0);
	print DAT $num;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 添付ファイル定義
	my $upfile;
	if ($cf{thumbnail}) {
		require './lib/resize.pl';
		$upfile = "$cf{imgdir}/tmp-$$.$ext";
	} else {
		$upfile = "$cf{imgdir}/$num.$ext";
	}
	
	# アップロード書き込み
	open(UP,"> $upfile") or error("up err: $upfile");
	binmode(UP);
	print UP $in{upfile};
	close(UP);
	
	# 画像サイズ取得
	my ($w,$h);
	if ($ext eq "jpg") { ($w,$h) = j_size($upfile); }
	elsif ($ext eq "gif") { ($w,$h) = g_size($upfile); }
	elsif ($ext eq "png") { ($w,$h) = p_size($upfile); }
	
	# サムネイル作成
	if ($cf{thumbnail}) {
		($w,$h) = resize($w,$h,$cf{img_max_w},$cf{img_max_h});
		$ext = 'jpg';
		my $thumb = "$cf{imgdir}/$num.$ext";
		img_resize($upfile,$thumb,$w,$h);
		unlink($upfile);
	}
	
	# 日付
	my ($d,$m,$y) = (localtime())[3..5];
	my $date = sprintf("%04d/%02d/%02d",$y+1900,$m+1,$d);
	
	# データ更新
	open(DAT,">> $cf{datadir}/data.dat") or error("write err: data.dat");
	eval "flock(DAT,2);";
	print DAT "$num\t\t$ext\t\t$date\n";
	close(DAT);
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print "1\n";
	exit;
}

#-----------------------------------------------------------
#  画像データ管理
#-----------------------------------------------------------
sub data_mgr {
	my $page = 0;
	my %txt;
	for ( $cgi->param() ) {
		if (/^page:(\d+)/) {
			$page = $1;
		} elsif (/^text:(\d+)/) {
			$txt{$1}++;
		}
	}
	if ($in{job_edit}) {
		$page = $in{page};
		
		my @log;
		open(DAT,"+< $cf{datadir}/data.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			chomp;
			my ($no,$cat,$ex,$text,$date) = split(/\t/);
			
			if (defined $txt{$no}) {
				$_ = qq|$no\t$in{"cate:$no"}\t$ex\t$in{"text:$no"}\t$date|;
			}
			push(@log,"$_\n");
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	} elsif ($in{job_del}) {
		my %del;
		for ( $cgi->param('del') ) { $del{$_}++; }
		
		my @log;
		open(DAT,"+< $cf{datadir}/data.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($no,$cat,$ex,$text,$date) = split(/\t/);
			
			if (defined $del{$no}) {
				unlink("$cf{imgdir}/$no.$ex");
				next;
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	my (@cat,%cat);
	for ( split(/,/,$cf{categ}) ) {
		my ($no,$cat) = split(/:/);
		$cat{$no} = $cat;
		push(@cat,$no);
	}
	
	header("画像データ管理");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 画像データ管理</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_mgr" value="1">
<input type="hidden" name="page" value="$page">
<input type="submit" name="job_edit" value="データ更新" class="update-btn">
[カテゴリ・コメント更新]
<table class="form-tbl">
<tr>
	<th><input type="submit" name="job_del" value="削除"></th>
	<th>画像</th>
	<th>日時</th>
	<th>カテゴリ</th>
	<th>コメント</th>
</tr>
EOM

	my $logs = 30; # ページ当たり表示件数
	my $bw = File::ReadBackwards->new("$cf{datadir}/data.dat");
	my $i = 0;
	while( defined( my $log = $bw->readline ) ) {
		$i++;
		next if ($i < $page + 1);
		last if ($i > $page + $logs);
		
		my ($no,$cat,$ex,$text,$date) = split(/\t/,$log);
		
		print qq |<tr><td class="ta-c"><input type="checkbox" name="del" value="$no"></td>|;
		print qq |<td><img src="$cf{imgurl}/$no.$ex" alt="" width="80"></td>|;
		print qq |<td>$date</td>|;
		print qq |<td><select name="cate:$no">\n|;
		
		print qq|<option value="">未分類\n|;
		for my $key (@cat) {
			if ($cat == $key) {
				print qq|<option value="$key" selected>$cat{$key}\n|;
			} else {
				print qq|<option value="$key">$cat{$key}\n|;
			}
		}
		
		print qq |</select></td>|;
		print qq |<td><input type="text" name="text:$no" value="$text" size="20"></td></tr>\n|;
	}
	
	if ($i == 0) {
		print qq |<td colspan="6" class="ta-c">データがありません</td>|;
	}
	
	print "</table>\n";
	
	# ページ繰越定義
	my $next = $page + $logs;
	my $back = $page - $logs;
	if ($back >= 0) {
		print qq|<input type="submit" name="page:$back" value="前ページ">\n|;
	}
	if ($next < $i) {
		print qq|<input type="submit" name="page:$next" value="次ページ">\n|;
	}
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  基本設定
#-----------------------------------------------------------
sub set_base {
	# --- 更新
	if ($in{submit}) {
		
		my @sort;
		for ( keys %in ) {
			if (/^cat:(\d+)/) {
				push(@sort,$1);
			}
		}
		@sort = sort{ $b <=> $a } @sort;
		
		my $cate;
		for (@sort) {
			next if ($in{"del:$_"} == 1);
			
			$cate .= qq|$_:$in{"cat:$_"},|;
		}
		$cate =~ s/,$//;
		if ($in{cat_new}) {
			my $key = $sort[0] + 1;
			$cate = "$key:$in{cat_new}," . $cate;
		}
		$in{categ} = $cate;
		
		# ファイル上書き
		my @log;
		for (qw(title thumbnail maxdata max_page img_max_w img_max_h categ)) {
			push(@log,"$_\t$in{$_}\n");
		}
		open(DAT,"> $cf{datadir}/set.dat");
		print DAT @log;
		close(DAT);
		
		# 完了メッセージ
		message("基本設定を更新しました");
	}
	
	header("基本設定");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 基本設定</div>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="set_base" value="1">
<table class="form-tbl">
<tr>
	<th>サイト名称</th>
	<td><input type="text" name="title" size="40" value="$cf{title}"></td>
</tr><tr>
	<th>最大受信サイズ</th>
	<td>
		<input type="number" name="maxdata" size="12" value="$cf{maxdata}"> bytes<br>
		（例 : 102400 = 100KB）
	</td>
</tr><tr>
	<th>ページ当たり<br>表示記事数</th>
	<td><input type="tel" name="max_page" size="2" value="$cf{max_page}"> 件</td>
</tr><tr>
	<th>画像リサイズ</th>
	<td>
	最大幅：
	<input type="tel" name="img_max_w" size="5" value="$cf{img_max_w}"> pix<br>
	最大縦：
	<input type="tel" name="img_max_h" size="5" value="$cf{img_max_h}"> pix<br>
	自動サムネイル化：
EOM

	my %ox = (1 => 'あり', 0 => 'なし');
	for (1,0) {
		if ($cf{thumbnail} == $_) {
			print qq|<input type="radio" name="thumbnail" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="thumbnail" value="$_">$ox{$_}\n|;
		}
	}
	
	print <<EOM;
	（ImgResize.pm 使用）
	</td>
</tr><tr>
	<th>カテゴリー</th>
	<td>
		<input type="text" name="cat_new" size="20">
		[追加] ← 新規に追加する場合<br>
EOM

	for ( split(/,/,$cf{categ}) ) {
		my ($key,$val) = split(/:/);
		
		print qq|<input type="text" name="cat:$key" value="$val" size="20">\n|;
		print qq|<input type="checkbox" name="del:$key" value="1">削除<br>\n|;
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th></th>
	<td><input type="submit" name="submit" value="更新する" class="big-btn"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダ
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<link href="https://transloadit.edgly.net/releases/uppy/v1.2.0/uppy.min.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="star" class="icon">
	Happy Gallery 管理画面 :: </div>
EOM
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	header("エラー");
	print <<EOM;
<div id="err-box">
<p>$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了画面
#-----------------------------------------------------------
sub message {
	my $msg = shift;
	
	header("完了メッセージ");
	print <<EOM;
<div id="msg-box">
<p>$msg</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
EOM

	for (qw(set_base data_new data_mgr come_new come_mgr)) {
		if ($in{$_}) {
			print qq|<input type="hidden" name="$_" value="1">\n|;
			last;
		}
	}
	
	print <<EOM;
<p><input type="submit" value="元の画面へ戻る"></p>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br>||g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h,$wr,$hr) = @_;
	if (!$wr) { $wr = $cf{img_max_w}; }
	if (!$hr) { $hr = $cf{img_max_h}; }
	
	# サイズ縮小
	if ($w > $wr || $h > $hr) {
		
		my $w2 = $wr / $w;
		my $h2 = $hr / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; }
		else { $key = $h2; }
		
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	return ($w,$h);
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h,$w,$t);
	open(IMG,$jpg);
	binmode(IMG);
	read(IMG,$t,2);
	while (1) {
		read(IMG,$t,4);
		my ($m,$c,$l) = unpack("a a n",$t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG,$t,5);
			($h, $w) = unpack("xnn", $t);
			last;
		} else {
			read(IMG,$t,($l - 2));
		}
	}
	close(IMG);
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,$gif);
	binmode(IMG);
	sysread(IMG,$data,10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data,-4); }
	my $w = unpack("v",substr($data,0,2));
	my $h = unpack("v",substr($data,2,2));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,$png);
	binmode(IMG);
	read(IMG,$data,24);
	close(IMG);
	
	my $w = unpack("N",substr($data,16,20));
	my $h = unpack("N",substr($data,20,24));
	
	return ($w,$h);
}

