#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Happy Gallery : index.cgi - 2022/04/21
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use CGI::Minimal;
use File::ReadBackwards;

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
my %in = parse_form($cgi);

album_page();

#-----------------------------------------------------------
#  トップページ
#-----------------------------------------------------------
sub album_page {
	$in{sort} =~ s/\D//g;
	$in{cate} =~ s/\D//g;
	$in{pg} =~ s/\D//g;
	
	# ページ数定義
	my $pg = $in{pg} || 0;
	
	# キーワードを配列化
	$in{word} =~ s/　/ /g;
	my @wd = split(/\s+/,$in{word});
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	my ($i,@log);
	if ($in{sort} == 1) {
		my $bw = File::ReadBackwards->new("$cf{datadir}/data.dat");
		while( defined( my $log = $bw->readline ) ) {
			
			$i++;
			next if ($i < $pg + 1);
			next if ($i > $pg + $cf{max_page});
			
        	push(@log,$log);
    	}
	} else {
		open(IN,"$cf{datadir}/data.dat");
		while(<IN>) {
			my ($no,$cat,$ex,$text,$time) = split(/\t/);
			
			# カテゴリ分類
			if ($in{cate}) {
				next if ($in{cate} != $cat);
			
			# 検索
			} elsif ($in{find} && $in{word} ne '') {
				my $flg;
				for my $wd (@wd) {
					if ($text =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
						$flg++;
					} else {
						$flg = 0;
						last;
					}
				}
				next if (!$flg);
			}
			
			$i++;
			next if ($i < $pg + 1);
			next if ($i > $pg + $cf{max_page});
			
			push(@log,$_);
		}
		close(IN);
	}
	
	# 繰越ボタン作成
	my $page_btn = make_pager($i,$pg);
	
	open(IN,"$cf{tmpldir}/index.html") or error("open err: index.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(title|index_cgi|cmnurl)!/$cf{$1}/g;
	$tmpl =~ s/!word!/$in{word}/g;
	$tmpl =~ s/<!-- pager -->/$page_btn/g;
	$tmpl =~ s/<!-- op_sort -->/op_sort()/e;
	$tmpl =~ s/<!-- op_cate -->/op_cate()/e;
	$tmpl =~ s|<!-- loop -->(.+?)<!-- /loop -->|list_log($1,\@log)|se;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  セレクト：並び順
#-----------------------------------------------------------
sub op_sort {
	my @sort = qw(昇順 降順);
	my $ret;
	for (0,1) {
		if ($in{sort} == $_) {
			$ret .= qq|<option value="$cf{index_cgi}?sort=$_" selected>$sort[$_]\n|;
		} else {
			$ret .= qq|<option value="$cf{index_cgi}?sort=$_">$sort[$_]\n|;
		}
	}
	return $ret;
}

#-----------------------------------------------------------
#  セレクト：カテゴリ
#-----------------------------------------------------------
sub op_cate {
	my $ret = qq|<option value="$cf{index_cgi}">[全表示]\n|;
	for ( split(/,/,$cf{categ}) ) {
		my ($no,$cat) = split(/:/);
		
		if ($in{cate} == $_) {
			$ret .= qq|<option value="$cf{index_cgi}?cate=$no" selected>$cat\n|;
		} else {
			$ret .= qq|<option value="$cf{index_cgi}?cate=$no">$cat\n|;
		}
	}
	return $ret;
}

#-----------------------------------------------------------
#  表示データ
#-----------------------------------------------------------
sub list_log {
	my ($loop,$log) = @_;
	chomp $loop;
	
	my $ret;
	for (@$log) {
		my ($no,$cat,$ex,$text,$time) = split(/\t/);
		
		my $tmp = $loop;
		$tmp =~ s|!image!|$cf{imgurl}/$no.$ex|g;
		$tmp =~ s/!text!/$text/g;
		$ret .= $tmp;
	}
	return $ret;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2.5em;text-align:center;font-size:10px;">
	- <a href="https://www.kent-web.com/">Happy Gallery</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  ページ送り作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$pg) = @_;
	
	# 繰越数定義
	$cf{max_page} ||= 10;
	my $next = $pg + $cf{max_page};
	my $back = $pg - $cf{max_page};
	
	# パラメータ
	my $param;
	if ($in{sort}) {
		$param .= "&amp;sort=$in{sort}";
	}
	if ($in{cate} ne '') {
		$param .= "&amp;cate=$in{cate}";
	}
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<li><a href="#" class="active"><span>$x</span></a></li>\n!);
			} else {
				push(@pg,qq!<li><a href="$cf{index_cgi}?pg=$y$param"><span>$x</span></a></li>\n!);
			}
			$x++;
			$y += $cf{max_page};
			$z -= $cf{max_page};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		$ret = qq!<li class="pre"><a href="$cf{index_cgi}?pg=$back$param"><span>&laquo;</span></a></li>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<li class="next"><a href="$cf{index_cgi}?pg=$next$param"><span>&raquo;</span></a></li>\n!;
	}
	
	# 結果を返す
	return $ret ? qq|<div class="pager">\n<ul class="pagination">\n$ret</ul></div>| : '';
}

