#!/usr/local/bin/perl

#
# G-BOOK : gbook.cgi - 2013/03/10
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use Jcode;

# ݒt@CF
require "./init.cgi";
my %cf = init();

# f[^
my %in = parse_form();

# 
if ($in{mode} eq 'find') { find_data(); }
if ($in{mode} eq 'note') { note_page(); }
if ($in{mode} eq 'icon') { icon_page(); }
if ($in{mode} eq 'regist') { regist(); }
if ($in{mode} eq 'del_log') { del_log(); }
if ($in{mode} eq "past" && $cf{pastkey}) { past_log(); }
bbs_list();

#-----------------------------------------------------------
#  fXg
#-----------------------------------------------------------
sub bbs_list {
	# y[W`
	my $pg = $in{pg} || 0;

	my ($i,@log);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});

		push(@log,$_);
	}
	close(IN);

	# Jz{^쐬
	my $page_btn = &make_pgbtn($i,$pg);

	# NbL[擾
	my ($ck_nam,$ck_eml,$ck_url,$ck_are,$ck_ico) = get_cookie();
	$ck_url ||= 'http://';

	# n
	my %op;
	my @area = split(/,/, $cf{area});
	foreach (0 .. $#area) {
		if ($ck_are == $_) {
			$op{area} .= qq|<option value="$_" selected>$area[$_]\n|;
		} else {
			$op{area} .= qq|<option value="$_">$area[$_]\n|;
		}
	}

	# ACR
	foreach (0 .. $#{$cf{icon}}) {
		my ($file,$name) = split(/,/, $cf{icon}->[$_]);
		if ($ck_ico == $_) {
			$op{icon} .= qq|<option value="$_" selected>$name\n|;
		} else {
			$op{icon} .= qq|<option value="$_">$name\n|;
		}
	}

	# JE^
	my $counter = counter() if ($cf{counter});

	# ev[gǍ
	open(IN,"$cf{tmpldir}/bbs.html") or error("open err: bbs.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# ߋOȂ
	if ($cf{pastkey} == 0) {
		$tmpl =~ s/<!-- past_begin -->.+<!-- past_end -->//s;
	}
	# Ȃ
	if ($cf{subjectkey} == 0) {
		$tmpl =~ s/<!-- subject_begin -->.+<!-- subject_end -->//s;
	}

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
	} else {
		$tmpl =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!page_btn!/$page_btn/g;
	$tmpl =~ s/!fm_name!/$ck_nam/g;
	$tmpl =~ s/!fm_email!/$ck_eml/g;
	$tmpl =~ s/!fm_url!/$ck_url/g;
	$tmpl =~ s/!str_crypt!/$str_crypt/g;
	$tmpl =~ s/!bbs_title!/$cf{bbs_title}/g;
	$tmpl =~ s/<!-- op_([a-z]+) -->/$op{$1}/g;
	$tmpl =~ s/!counter!/$counter/g;

	# ev[g
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s
			? ($1,$2,$3) : error("ev[gsł");

	# wb_\
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	# LWJ
	my $i;
	foreach (@log) {
		my ($no,$date,$name,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$sub,$tim) = split(/<>/);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com  = &autolink($com) if ($cf{autolink});
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{iconurl}/home.gif" class="home"></a>|;

		# ACR
		my $icon  = (split(/,/, $cf{icon}->[$ico]))[0];

		# X
		if ($res) {
			my $icon2 = (split(/,/, $cf{admin_icon}->[$ico2]))[0];
			$res = qq|<div class="res"><img src="$cf{iconurl}/$icon2">$res</div>|;
		}

		$i++;
		my $tmp = $loop;
		$tmp =~ s/<!-- subject -->/<b>$sub<\/b> -/g if ($cf{subjectkey});
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!area!/[$area[$area]]/g;
		$tmp =~ s|!icon!|<img src="$cf{iconurl}/$icon">|g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s|<!-- res -->|$res|g;
		print $tmp;
	}

	# tb^[
	footer($foot);
}

#-----------------------------------------------------------
#  L
#-----------------------------------------------------------
sub regist {
	# e`FbN
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("sȃNGXgł");
	}

	# svsJbg
	$in{sub}  =~ s/<br>//g;
	$in{name} =~ s/<br>//g;
	$in{pwd}  =~ s/<br>//g;
	$in{captcha} =~ s/<br>//g;
	$in{area} =~ s/<br>//g;
	$in{icon} =~ s/<br>//g;
	$in{comment} =~ s/(<br>)+$//g;

	# `FbN
	if ($cf{no_wd}) { &no_wd; }
	if ($cf{jp_wd}) { &jp_wd; }
	if ($cf{urlnum} > 0) { &urlnum; }

	# 摜F؃`FbN
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			error("摜F؂͕słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}

		# eL[`FbN
		# -1 : L[sv
		#  0 : ԃI[o[
		#  1 : L[v
		my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
		if ($chk == 0) {
			error("摜F؂Ԃ𒴉߂܂B<br>etH[ɖ߂čēǍ݌Aw̐ē͂Ă");
		} elsif ($chk == -1) {
			error("摜F؂słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}
	}

	# ͂̏ꍇ
	if ($in{url} eq "http://") { $in{url} = ""; }
	$in{sub} ||= '';

	# tH[e`FbN
	my $err;
	if ($in{name} eq "") { $err .= "O͂Ă܂<br>"; }
	if ($in{email} ne '' && $in{email}!~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,}$/) {
		$err .= "d[͓̓esł<br>";
	}
	if ($in{comment} eq "") { $err .= "Rg͂Ă܂<br>"; }
	if ($in{area} eq "") { $err .= "n悪Ił<br>"; }
	if ($in{icon} eq "") { $err .= "C[WIł<br>"; }
	if ($in{url} ne '' && $in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "QƐURL͓̓esł<br>";
	}
	if ($err) { error($err); }

	# R[hϊ
	Jcode::convert(\$in{name}, 'sjis');
	Jcode::convert(\$in{comment}, 'sjis');

	# zXg擾
	my ($host,$addr) = get_host();

	# 폜L[Í
	my $pwd = encrypt($in{pwd}) if ($in{pwd} ne "");

	# Ԏ擾
	my $time = time;
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	my @wk = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	my $date = sprintf("%04d/%02d/%02d(%s) %02d:%02d",
				$year+1900,$mon+1,$mday,$wk[$wday],$hour,$min);

	# 擪Lǂݎ
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my $top = <DAT>;

	# de`FbN
	my ($no,$dat,$nam,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/, $top);
	if ($in{name} eq $nam && $in{comment} eq $com) {
		close(DAT);
		error("de͋֎~ł");
	}

	# Ae`FbN
	my $flg;
	if ($cf{regCtl} == 1) {
		if ($host eq $hos && $time - $tim < $cf{wait}) { $flg = 1; }
	} elsif ($cf{regCtl} == 2) {
		if ($time - $tim < $cf{wait}) { $flg = 1; }
	}
	if ($flg) {
		close(DAT);
		error("ݓełB΂炭Ă瓊e肢܂");
	}

	# LNo̔
	$no++;

	# L
	my @old;
	my @data = ($top);
	my $i = 1;
	while (<DAT>) {
		$i++;

		if ($i <= $cf{maxlog} - 1) {
			push(@data,$_);
		} else {
			push(@old,$_);
		}
	}

	# XV
	seek(DAT, 0, 0);
	print DAT "$no<>$date<>$in{name}<>$in{email}<>$in{area}<>$in{icon}<><>$in{comment}<><>$in{url}<>$host<>$pwd<>$in{sub}<>$time<>\n";
	print DAT @data;
	truncate(DAT, tell(DAT));
	close(DAT);

	# ߋOXV
	if ($cf{pastkey} && @old > 0) {	make_pastlog(@old);	}

	# [ʒm
	mail_to($date,$host) if ($cf{mailing} == 1);

	# NbL[i[
	set_cookie($in{name},$in{email},$in{url},$in{area},$in{icon});

	# 
	message("肪Ƃ܂BL󗝂܂B");
}

#-----------------------------------------------------------
#  [h
#-----------------------------------------------------------
sub find_data {
	# 
	$in{cond} =~ s/\D//g;

	# v_E
	my %op = (1 => 'AND', 0 => 'OR');
	my $op_cond;
	foreach (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected>$op{$_}\n|;
		} else {
			$op_cond .= qq|<option value="$_">$op{$_}\n|;
		}
	}

	# s
	Jcode::convert(\$in{word}, 'sjis');
	my ($hit,@log) = search($in{word},$in{cond},$cf{logfile}) if ($in{word} ne '');

	# ev[g
	open(IN,"$cf{tmpldir}/find.html") or error("open err: find.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# 
	$tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s;
	my ($head,$loop,$foot) = ($1, $2, $3);

	foreach ($head, $foot) {
		s/!bbs_cgi!/$cf{bbs_cgi}/g;
		s/<!-- op_cond -->/$op_cond/;
		s/!word!/$in{word}/;
	}

	# wb_
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	# [v
	foreach my $log (@log) {
		my ($no,$date,$name,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/, $log);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com  = autolink($com) if ($cf{autolink});
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{iconurl}/home.gif" class="home"></a>|;
		$res &&= qq|<p class="res">$res</p>|;

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!home!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/<!-- res -->/$res/g;
		print $tmp;
	}

	# tb^
	footer($foot);
}

#-----------------------------------------------------------
#  s
#-----------------------------------------------------------
sub search {
	my ($word,$cond,$file,$list) = @_;

	# L[[hz
	$word =~ s/@/ /g;
	my @wd = split(/\s+/, $word);

	# 
	my ($i,@log);
	open(IN,"$file") or error("open err: $file");
	while (<IN>) {
		my ($no,$date,$name,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$sub,$tim) = split(/<>/);

		my $flg;
		foreach my $wd (@wd) {
			if (index("$name $eml $sub $com $url", $wd) >= 0) {
				$flg++;
				if ($cond == 0) { last; }
			} else {
				if ($cond == 1) { $flg = 0; last; }
			}
		}
		next if (!$flg);

		$i++;
		if ($list > 0) {
			next if ($i < $in{pg} + 1);
			next if ($i > $in{pg} + $list);
		}

		push(@log,$_);
	}
	close(IN);

	# 
	return ($i,@log);
}

#-----------------------------------------------------------
#  [UL폜
#-----------------------------------------------------------
sub del_log {
	# e`FbN
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("sȃNGXgł");
	}

	# ̓`FbN
	if ($in{num} eq '' || $in{pwd} eq '') {
		error("폜No܂͍폜L[̓ł");
	}

	my ($flg,$crypt,@log);
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while (<DAT>) {
		my ($no,$date,$name,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/);

		if ($in{num} == $no) {
			$flg++;
			$crypt = $pw;
			next;
		}
		push(@log,$_);
	}

	if (!$flg || $crypt eq '') {
		close(DAT);
		error("폜L[ݒ肳ĂȂ͋L܂");
	}

	# 폜L[ƍ
	if (&decrypt($in{pwd}, $crypt) != 1) {
		close(DAT);
		error("F؂ł܂");
	}

	# OXV
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	message("L폜܂");
}

#-----------------------------------------------------------
#  ӎ\
#-----------------------------------------------------------
sub note_page {
	open(IN,"$cf{tmpldir}/note.html") or &error("open err: note.html");
	print "Content-type: text/html\n\n";
	print <IN>;
	close(IN);
	exit;
}

#-----------------------------------------------------------
#  ACRꗗ
#-----------------------------------------------------------
sub icon_page {
	# 摜TCYĒ`
	$cf{max_img_w} = 40;
	$cf{max_img_h} = 40;

	# ev[gF
	open(IN,"$cf{tmpldir}/icon.html") or error("open err: icon.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# ev[g
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- photo_begin -->(.+)<!-- photo_end -->(.+)/s
			? ($1,$2,$3) : error("ev[gsł");

	# u
	foreach ($head, $foot) {
		s/!([a-z]+_cgi)!/$cf{$1}/g;
	}

	# ʓWJ
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	foreach (0 .. $#{$cf{icon}}) {
		my ($ico,$cap) = split(/,/, $cf{icon}->[$_]);

		my $tmp = $loop;
		$tmp =~ s|!image!|<img src="$cf{iconurl}/$ico">|g;
		$tmp =~ s/!caption!/$cap/g;
		print $tmp;
	}

	# tb^
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  ߋO
#-----------------------------------------------------------
sub past_log {
	$cf{pg_max} *= 2;

	# ߋOԍ
	open(IN,"$cf{nofile}") or error("open err: $cf{nofile}");
	my $pastnum = <IN>;
	close(IN);

	my $pastnum = sprintf("%04d", $pastnum);
	$in{pno} =~ s/\D//g;
	$in{pno} ||= $pastnum;

	# v_E^O쐬
	my $op_pno;
	for ( my $i = $pastnum; $i > 0; $i-- ) {
		$i = sprintf("%04d", $i);

		if ($in{pno} == $i) {
			$op_pno .= qq|<option value="$i" selected>$i\n|;
		} else {
			$op_pno .= qq|<option value="$i">$i\n|;
		}
	}

	# y[W
	my $pg = $in{pg} || 0;

	# 
	my ($hit,$page_btn,@log);

	# ΏۃO`
	my $file = "$cf{pastdir}/" . sprintf("%04d", $in{pno}) . ".cgi";

	# [h
	if ($in{find} && $in{word} ne '') {

		# 
		Jcode::convert(\$in{word}, 'sjis');
		($hit,@log) = search($in{word},$in{cond},$file,$in{list});

		# 
		$page_btn = "ʁF<b>$hit</b> &nbsp;&nbsp;" . pgbtn_old($hit,$in{pno},$pg,'past');

	# Oꗗ
	} else {

		# ߋOI[v
		my $i = 0;
		open(IN,"$file") or error("open err: $file");
		while(<IN>) {
			$i++;
			next if ($i < $pg + 1);
			next if ($i > $pg + $cf{pg_max});

			push(@log,$_);
		}
		close(IN);

		# Jz{^쐬
		$page_btn = pgbtn_old($i,$in{pno},$pg);
	}

	# v_E쐬ij
	my %op = make_op();

	# ev[gǂݍ
	my ($flg,$loop);
	open(IN,"$cf{tmpldir}/past.html") or error("open err: past.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# ev[g
	$tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s;
	my ($head,$loop,$foot) = ($1,$2,$3);

	if ($in{change}) { $in{word} = ''; }

	# u
	foreach ($head, $foot) {
		s/!past_num!/$in{pno}/g;
		s/!bbs_url!/$cf{html_url}\/index.html/g;
		s/!([a-z]+_cgi)!/$cf{$1}/g;
		s/<!-- op_pno -->/$op_pno/g;
		s/<!-- op_(\w+) -->/$op{$1}/g;
		s/!word!/$in{word}/g;
		s/!page_btn!/$page_btn/g;
	}

	# ʕ\
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;
	foreach (@log) {
		my ($no,$date,$nam,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$sub,$tim) = split(/<>/);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
		$com = &autolink($com) if ($cf{autolink});
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{iconurl}/home.gif" class="home"></a>|;

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		#$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		print $tmp;
	}

	# tb^
	print footer($foot);
	exit;
}

#-----------------------------------------------------------
#  ߋO
#-----------------------------------------------------------
sub make_pastlog {
	my @past = @_;

	# ߋONOt@C
	open(NO,"+< $cf{nofile}") or error("open err: $cf{nofile}");
	eval "flock(NO, 2);";
	my $num = <NO>;

	# ߋO`
	my $pastfile = "$cf{pastdir}/" . sprintf("%04d",$num) . ".cgi";

	# ߋOJ
	open(DAT,"+< $pastfile") or error("open err: $pastfile");
	eval "flock(DAT, 2);";
	my @data = <DAT>;

	# K̍sI[o[Ǝt@C
	if (@data >= $cf{max_line}) {

		# ߋO
		@data = ();
		close(DAT);

		# ߋNOXV
		seek(NO, 0, 0);
		print NO ++$num;
		truncate(NO, tell(NO));
		close(NO);

		$pastfile = "$cf{pastdir}/" . sprintf("%04d",$num) . ".cgi";

		open(DAT,"+> $pastfile");
		eval "flock(DAT, 2);";
		print DAT @past;
		close(DAT);

		chmod(0666, $pastfile);

	} else {

		close(NO);

		# ߋOXV
		seek(DAT, 0, 0);
		print DAT @past;
		print DAT @data;
		truncate(DAT, tell(DAT));
		close(DAT);
	}
}

#-----------------------------------------------------------
#  [M
#-----------------------------------------------------------
sub mail_to {
	my ($date,$host) = @_;

	# MIMEGR[h
	my $msub = Jcode->new("BBS: From $in{name}",'sjis')->mime_encode;

	# Rg̉s
	my $com = &tag($in{comment});
	$com =~ s/<br>/\n/g;
	$com =~ s/{ico:\d+}//g;

	# [{`
	my $mbody = <<"EOM";
fɓe܂B

eF$date
zXgF$host
OF$in{name}

$com
EOM

	# JISR[hϊ
	$mbody = Jcode->new($mbody,'sjis')->jis;

	# M
	my $from = $in{email} || $cf{mailto};

	# sendmailR}h
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) {
		$scmd .= " -f $from";
	}

	# M
	open(MAIL,"| $scmd") or error("Ms");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $from\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  bZ[W
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;

	open(IN,"$cf{tmpldir}/message.html") or error("open err: message.html");
	print "Content-type: text/html\n\n";
	while(<IN>) {
		s/!bbs_cgi!/$cf{bbs_cgi}/g;
		s/!message!/$msg/g;

		print;
	}
	close(IN);

	exit;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2.5em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">G-BOOK</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  Jz{^쐬
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;

	# y[WJz`
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x, $y) = (1, 0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq(| <b>$x</b> );
			} else {
				$pg_btn .= qq(| <a href="$cf{bbs_cgi}?pg=$y">$x</a> );
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
		$pg_btn .= "|";
	}
	return $pg_btn;
}

#-----------------------------------------------------------
#  N
#-----------------------------------------------------------
sub autolink {
	my $text = shift;

	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  ֎~[h`FbN
#-----------------------------------------------------------
sub no_wd {
	my $flg;
	foreach ( split(/,/, $cf{no_wd}) ) {
		if (index("$in{name} $in{comment}", $_) >= 0) {
			$flg = 1;
			last;
		}
	}
	if ($flg) { error("֎~[h܂܂Ă܂"); }
}

#-----------------------------------------------------------
#  {`FbN
#-----------------------------------------------------------
sub jp_wd {
	if ($in{comment} !~ /[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]/) {
		error("bZ[Wɓ{ꂪ܂܂Ă܂");
	}
}

#-----------------------------------------------------------
#  URL`FbN
#-----------------------------------------------------------
sub urlnum {
	my $com = $in{comment};
	my ($num) = ($com =~ s|(https?://)|$1|ig);
	if ($num > $cf{urlnum}) {
		error("RgURLAhX͍ő$cf{urlnum}܂łł");
	}
}

#-----------------------------------------------------------
#  ANZX
#-----------------------------------------------------------
sub get_host {
	# IP&zXg擾
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}

	# IP`FbN
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;

		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		error("ANZXĂ܂");

	# zXg`FbN
	} elsif ($host) {

		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;

			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			error("ANZXĂ܂");
		}
	}
	if ($host eq "") { $host = $addr; }
	return ($host,$addr);
}

#-----------------------------------------------------------
#  cryptÍ
#-----------------------------------------------------------
sub encrypt {
	my $in = shift;

	my @wd = ('a'..'z', 'A'..'Z', '0'..'9', '.', '/');
	srand;
	my $salt = $wd[int(rand(@wd))] . $wd[int(rand(@wd))];
	crypt($in, $salt) || crypt ($in, '$1$' . $salt);
}

#-----------------------------------------------------------
#  cryptƍ
#-----------------------------------------------------------
sub decrypt {
	my ($in, $dec) = @_;

	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec, 0, 2);
	if (crypt($in, $salt) eq $dec || crypt($in, '$1$' . $salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  ^O
#-----------------------------------------------------------
sub tag {
	local($_) = @_;

	s/&lt;/</g;
	s/&gt;/>/g;
	s/&quot;/"/g;
	s/&amp;/&/g;
	s/&#39;/'/g;
	$_;
}

#-----------------------------------------------------------
#  v_E쐬 [  ]
#-----------------------------------------------------------
sub make_op {
	my %op;
	my %cond = (1 => 'AND', 0 => 'OR');
	foreach (1,0) {
		if ($in{cond} eq $_) {
			$op{cond} .= qq|<option value="$_" selected>$cond{$_}\n|;
		} else {
			$op{cond} .= qq|<option value="$_">$cond{$_}\n|;
		}
	}
	for ( my $i = 10; $i <= 30; $i += 5 ) {
		if ($in{list} == $i) {
			$op{list} .= qq|<option value="$i" selected>$i\n|;
		} else {
			$op{list} .= qq|<option value="$i">$i\n|;
		}
	}
	return %op;
}

#-----------------------------------------------------------
#  Jz{^쐬 [ ߋO ]
#-----------------------------------------------------------
sub pgbtn_old {
	my ($i, $pno, $pg, $stat) = @_;

	# y[WJz`
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	my $link;
	if ($stat eq 'past') {
		my $wd = &url_enc($in{word});
		$link = "$cf{bbs_cgi}?mode=$in{mode}&pno=$pno&find=1&word=$wd";
	} else {
		$link = "$cf{bbs_cgi}?mode=$in{mode}&pno=$pno";
	}

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x,$y) = (1,0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq(| <b>$x</b> );
			} else {
				$pg_btn .= qq(| <a href="$link&pg=$y">$x</a> );
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
		$pg_btn .= "|";
	}
	return $pg_btn;
}

#-----------------------------------------------------------
#  URLGR[h
#-----------------------------------------------------------
sub url_enc {
	local($_) = @_;

	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

#-----------------------------------------------------------
#  JE^
#-----------------------------------------------------------
sub counter {
	# IP擾
	my $addr = $ENV{REMOTE_ADDR};

	# {̂݃JEgAbv
	my $cntup;
	if ($in{mode} eq '') { $cntup = 1; } else { $cntup = 0; }

	# JEgt@Cǂ݂
	open(LOG,"+< $cf{cntfile}") or error("open err: $cf{cntfile}");
	eval "flock(LOG, 2);";
	my $count = <LOG>;

	# IP`FbNƃOj`FbN
	my ($cnt, $ip) = split(/:/, $count);
	if ($addr eq $ip || $cnt eq "") { $cntup = 0; }

	# JEgAbv
	if ($cntup) {
		$cnt++;
		seek(LOG, 0, 0);
		print LOG "$cnt:$addr";
		truncate(LOG, tell(LOG));
	}
	close(LOG);

	# 
	while(length($cnt) < $cf{mini_fig}) { $cnt = '0' . $cnt; }
	my @cnts = split(//, $cnt);

	# GIFJE^\
	my $counter;
	if ($cf{counter} == 2) {
		foreach (0 .. $#cnts) {
			$counter .= qq|<img src="$cf{gif_path}/$cnts[$_].gif" alt="$cnts[$_]">|;
		}

	# eLXgJE^\
	} else {
		$counter = qq|<span style="color:$cf{cntcol};font-family:Verdana,Helvetica,Arial">$cnt</span>\n|;
	}
	return $counter;
}

#-----------------------------------------------------------
#  NbL[s
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLGR[h
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: $cf{cookie_id}=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

