#!/usr/local/bin/perl

#
# Gateway Board : gwbbs.cgi - 2014/01/26
# copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use Crypt::RC4;

# ݒt@CF
require "./init.cgi";
my %cf = init();

# f[^
my %in = parse_form();

# F
check_passwd();

# 
if ($in{mode_dele}) { dele_data(); }
if ($in{mode_regi}) { regi_data(); }
if ($in{mode_find}) { find_data(); }
if ($in{mode_note}) { note_page(); }
bbs_list();

#-----------------------------------------------------------
#  L\
#-----------------------------------------------------------
sub bbs_list {
	# X
	my ($res,$pg,%res);
	foreach ( keys %in ) {
		if (/^res:(\d+)$/) {
			$res = $1;
			last;
		} elsif (/^pg:(\d+)$/) {
			$pg = $1;
			last;
		}
	}
	if ($res) {
		my $flg;
		open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
		while (<IN>) {
			my ($no,$sub,$com) = (split(/<>/))[0,4,5];
			if ($res == $no) {
				$flg++;
				$res{sub} = $sub;
				$res{com} = $com;
				last;
			}
		}
		close(IN);

		if (!$flg) { error("YL܂"); }

		$res{sub} =~ s/^Re://g;
		$res{sub} =~ s/\[\d+\]\s?//g;
		$res{sub} = "Re:[$res] $res{sub}";
		$res{com} = "&gt; $res{com}";
		$res{com} =~ s|<br />|\n&gt; |g;
	}

	# y[W`
	$pg ||= 0;

	# f[^I[v
	my ($i,@log);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});

		push(@log,$_);
	}
	close(IN);

	# Jz{^쐬
	my $page_btn = make_pgbtn($i,$pg);

	# NbL[擾
	my @cook = get_cookie();
	$cook[2] ||= 'http://';

	# ev[gǍ
	open(IN,"$cf{tmpldir}/bbs.html") or error("open err: bbs.html");
	my $tmpl = join('', <IN>);
	close(IN);
	
	# u
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/<!-- page_btn -->/$page_btn/g;
	$tmpl =~ s/!name!/$cook[0]/;
	$tmpl =~ s/!email!/$cook[1]/;
	$tmpl =~ s/!url!/$cook[2]/;
	$tmpl =~ s/!sub!/$res{sub}/;
	$tmpl =~ s/!comment!/$res{com}/;
	$tmpl =~ s/!bbs_title!/$cf{bbs_title}/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;
	
	# ev[g
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s
		? ($1,$2,$3) : error("ev[gs");

	# wb_\
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	# [v
	foreach (@log) {
		my ($no,$date,$name,$eml,$sub,$com,$url,$host,$pw,$tim,$id) = split(/<>/);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com = autolink($com) if ($cf{autolink});
		$com =~ s/([>]|^)(&gt;[^<]*)/$1<span style="color:$cf{ref_col}">$2<\/span>/g if ($cf{ref_col});
		if ($url) {
			$url = "http://$url" if ($url !~ /^http:/);
			$com .= qq|<p class="url"><a href="$url" target="_blank">$url</a></p>|;
		}

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		$tmp =~ s/!id!/$id/g;
		print $tmp;
	}

	# tb^
	footer($foot);
}

#-----------------------------------------------------------
#  L
#-----------------------------------------------------------
sub regi_data {
	# e`FbN
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("sȃNGXgł");
	}

	# svsJbg
	$in{sub}  =~ s|<br />||g;
	$in{name} =~ s|<br />||g;
	$in{pwd}  =~ s|<br />||g;
	$in{comment} =~ s|(<br />)+$||g;

	# `FbN
	if ($cf{no_wd}) { no_wd(); }
	if ($cf{jp_wd}) { jp_wd(); }
	if ($cf{urlnum} > 0) { urlnum(); }

	# ͂̏ꍇ
	if ($in{url} eq "http://") { $in{url} = ""; }
	$in{sub} ||= '';

	# tH[e`FbN
	my $err;
	if ($in{name} eq "") { $err .= "O͂Ă܂<br />"; }
	if ($in{comment} eq "") { $err .= "Rg͂Ă܂<br />"; }
	if ($in{email} ne '' && $in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) {
		$err .= "d[͓̓esł<br />";
	}
	if ($in{url} ne '' && $in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "QƐURL͓̓esł<br />";
	}
	if ($err) { error($err); }

	# R[hϊ
	if ($cf{chg_code} == 1) {
		require './lib/Jcode.pm';
		$in{name} = Jcode->new($in{name})->sjis;;
		$in{sub}  = Jcode->new($in{sub})->sjis;
		$in{comment} = Jcode->new($in{comment})->sjis;
	}
	
	# zXg擾
	my ($host,$addr) = get_host();

	# 폜L[Í
	my $pwd = encrypt($in{pwd}) if ($in{pwd} ne "");

	# Ԏ擾
	my $time = time;
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	my @wk = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	my $date = sprintf("%04d/%02d/%02d(%s) %02d:%02d",
				$year+1900,$mon+1,$mday,$wk[$wday],$hour,$min);

	# 擪Lǂݎ
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my $top = <DAT>;

	# de`FbN
	my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$id) = split(/<>/,$top);
	if ($in{name} eq $nam && $in{comment} eq $com) {
		close(DAT);
		error("de͋֎~ł");
	}

	# Ae`FbN
	my $flg;
	if ($cf{regCtl} == 1) {
		if ($host eq $hos && $time - $tim < $cf{wait}) { $flg = 1; }
	} elsif ($cf{regCtl} == 2) {
		if ($time - $tim < $cf{wait}) { $flg = 1; }
	}
	if ($flg) {
		close(DAT);
		error("ݓełB΂炭Ă瓊e肢܂");
	}

	# LNo̔
	$no++;

	# L
	my @data = ($top);
	my $i = 0;
	while (<DAT>) {
		$i++;
		push(@data,$_);
		last if ($i >= $cf{maxlog} - 1);
	}

	# XV
	seek(DAT, 0, 0);
	print DAT "$no<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{comment}<>$in{url}<>$host<>$pwd<>$time<>$in{id}<>\n";
	print DAT @data;
	truncate(DAT, tell(DAT));
	close(DAT);

	# NbL[i[
	set_cookie($in{name},$in{email},$in{url}) if ($in{cookie} == 1);

	# [ʒm
	mail_to($date,$host) if ($cf{mailing} == 1);

	# 
	message("肪Ƃ܂BL󗝂܂B");
}

#-----------------------------------------------------------
#  [h
#-----------------------------------------------------------
sub find_data {
	# 
	$in{cond} =~ s/\D//g;

	# v_E
	my %op = (1 => 'AND', 0 => 'OR');
	my $op_cond;
	foreach (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected="selected">$op{$_}\n|;
		} else {
			$op_cond .= qq|<option value="$_">$op{$_}\n|;
		}
	}

	# s
	if ($cf{chg_code} == 1) {
		require './lib/Jcode.pm';
		$in{word} = Jcode->new($in{word})->sjis;
	}
	my @log = search($in{word},$in{cond}) if ($in{word} ne '');

	# ev[g
	open(IN,"$cf{tmpldir}/find.html") or error("open err: find.html");
	my $tmpl = join('', <IN>);
	close(IN);
	
	$tmpl =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$tmpl =~ s/<!-- op_cond -->/$op_cond/;
	$tmpl =~ s/!word!/$in{word}/;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;
	
	# 
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s
			? ($1,$2,$3) : error('ev[gs');

	# wb_
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	# [v
	foreach (@log) {
		my ($no,$date,$name,$eml,$sub,$com,$url,$host,$pw,$tim,$id) = split(/<>/);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com = autolink($com) if ($cf{autolink});
		$com =~ s/([>]|^)(&gt;[^<]*)/$1<span style="color:$cf{ref_col}">$2<\/span>/g if ($cf{ref_col});
		if ($url) {
			$url = "http://$url" if ($url !~ /^http:/);
			$com .= qq|<p class="url"><a href="$url" target="_blank">$url</a></p>|;
		}

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!home!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!id!/$id/g;
		print $tmp;
	}

	# tb^
	footer($foot);
}

#-----------------------------------------------------------
#  s
#-----------------------------------------------------------
sub search {
	my ($word,$cond) = @_;

	# L[[hz
	$word =~ s/\x81\x40/ /g;
	my @wd = split(/\s+/,$word);

	# L[[hiShift-JIS`j
	my $ascii = '[\x00-\x7F]';
	my $hanka = '[\xA1-\xDF]';
	my $kanji = '[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]';

	# 
	my @log;
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$id) = split(/<>/);

		my $flg;
		foreach my $wd (@wd) {
			if ("$nam $eml $sub $com $url" =~ /^(?:$ascii|$hanka|$kanji)*?\Q$wd\E/i) {
				$flg++;
				if ($cond == 0) { last; }
			} else {
				if ($cond == 1) { $flg = 0; last; }
			}
		}
		next if (!$flg);

		push(@log,$_);
	}
	close(IN);

	# 
	return @log;
}

#-----------------------------------------------------------
#  ӎ\
#-----------------------------------------------------------
sub note_page {
	open(IN,"$cf{tmpldir}/note.html") or error("open err: note.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  [UL폜
#-----------------------------------------------------------
sub dele_data {
	# ̓`FbN
	if ($in{num} eq '' || $in{pwd} eq '') {
		error("폜No܂͍폜L[̓ł");
	}

	my ($flg,$crypt,@log);
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while (<DAT>) {
		my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim,$id) = split(/<>/);
		if ($in{num} == $no) {
			$flg++;
			$crypt = $pw;
			next;
		}
		push(@log,$_);
	}

	if (!$flg || $crypt eq '') {
		close(DAT);
		error("폜L[ݒ肳ĂȂ͋L܂");
	}

	# 폜L[ƍ
	if (decrypt($in{pwd},$crypt) != 1) {
		close(DAT);
		error("F؂ł܂");
	}

	# OXV
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	message("L폜܂");
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  [M
#-----------------------------------------------------------
sub mail_to {
	my ($date,$host) = @_;

	# MIMEGR[h
	if ($cf{chg_code} == 0) {
		require './lib/Jcode.pm';
	}
	my $msub = Jcode->new("BBS : $in{sub}",'sjis')->mime_encode;

	# Rg̉s
	my $com = $in{comment};
	$com =~ s/<br>/\n/g;
	$com =~ s/&lt;/>/g;
	$com =~ s/&gt;/</g;
	$com =~ s/&quot;/"/g;
	$com =~ s/&amp;/&/g;
	$com =~ s/&#39;/'/g;

	# [{`
	my $mbody = <<"EOM";
fɓe܂B

eF$date
zXgF$host

  F$in{sub}
OF$in{name}
E-mailF$in{email}
URL   F$in{url}

$com
EOM

	# JISR[hϊ
	$mbody = Jcode->new($mbody,'sjis')->jis;

	# [AhXȂꍇ͊Ǘ҃[ɒu
	$in{email} ||= $cf{mailto};

	# sendmailR}h
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) {
		$scmd .= " -f $in{email}";
	}

	# M
	open(MAIL,"| $scmd") or error("Ms");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $in{email}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">GatewayBoard</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  N
#-----------------------------------------------------------
sub autolink {
	my $text = shift;

	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  ֎~[h`FbN
#-----------------------------------------------------------
sub no_wd {
	my $flg;
	foreach ( split(/,/, $cf{no_wd}) ) {
		if (index("$in{name} $in{sub} $in{comment}", $_) >= 0) {
			$flg = 1;
			last;
		}
	}
	if ($flg) { error("֎~[h܂܂Ă܂"); }
}

#-----------------------------------------------------------
#  {`FbN
#-----------------------------------------------------------
sub jp_wd {
	if ($in{comment} !~ /[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]/) {
		error("bZ[Wɓ{ꂪ܂܂Ă܂");
	}
}

#-----------------------------------------------------------
#  URL`FbN
#-----------------------------------------------------------
sub urlnum {
	my $com = $in{comment};
	my ($num) = ($com =~ s|(https?://)|$1|ig);
	if ($num > $cf{urlnum}) {
		error("RgURLAhX͍ő$cf{urlnum}܂łł");
	}
}

#-----------------------------------------------------------
#  ANZX
#-----------------------------------------------------------
sub get_host {
	# IP&zXg擾
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}

	# IP`FbN
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;

		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		error("ANZXĂ܂");

	# zXg`FbN
	} elsif ($host) {

		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;

			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			error("ANZXĂ܂");
		}
	}
	if ($host eq "") { $host = $addr; }
	return ($host,$addr);
}

#-----------------------------------------------------------
#  cryptÍ
#-----------------------------------------------------------
sub encrypt {
	my $in = shift;

	my @wd = (0 .. 9, 'a'..'z', 'A'..'Z', '.', '/');
	srand;
	my $salt = $wd[int(rand(@wd))] . $wd[int(rand(@wd))];
	crypt($in,$salt) || crypt ($in,'$1$'.$salt);
}

#-----------------------------------------------------------
#  cryptƍ
#-----------------------------------------------------------
sub decrypt {
	my ($in,$dec) = @_;

	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec,0,2);
	if (crypt($in,$salt) eq $dec || crypt($in,'$1$'.$salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  bZ[W
#-----------------------------------------------------------
sub message {
	my $msg = shift;

	open(IN,"$cf{tmpldir}/message.html") or error("open err: message.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$tmpl =~ s/!message!/$msg/g;
	$tmpl =~ s/!id!/$in{id}/g;
	$tmpl =~ s/!pw!/$in{pw}/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  Jz{^쐬
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;

	# y[WJz`
	$cf{pg_max} ||= 10;
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x, $y) = (1, 0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq|<input type="button" value="$x" disabled="disabled">\n|;
			} else {
				$pg_btn .= qq|<input type="submit" name="pg:$y" value="$x">\n|;
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
	}
	return $pg_btn;
}

#-----------------------------------------------------------
#  NbL[s
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLGR[h
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: $cf{cookie_id}=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  F
#-----------------------------------------------------------
sub check_passwd {
	# tH[̓`FbN
	if ($in{id} eq "" || $in{pw} eq "") { enter_form();	}

	# F
	my $flg;
	foreach (@{$cf{passwd}}) {
		my ($id,$pw) = split(/:/);

		if ($in{id} eq $id && $in{pw} eq $pw) {
			$flg++;
			last;
		}
	}
	error("F؂ł܂") if (!$flg);
	
	# NbL[L
	if ($in{login} == 1) { set_entcook(); }
}

#-----------------------------------------------------------
#  
#-----------------------------------------------------------
sub enter_form {
	# NbL[擾
	my ($id,$pw) = get_entcook();

	open(IN,"$cf{tmpldir}/enter.html") or error("open err: enter.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$tmpl =~ s/!id!/$id/;
	$tmpl =~ s/!pw!/$pw/;
	if ($id ne '' && $pw ne '') {
		$tmpl =~ s|<input type="checkbox" name="cook"([^<>]+)>|<input type="checkbox" name="cook" checked="checked" $1>|;
	}

	print "Content-type: text/html; charset=shift_jis\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  pX[h擾
#-----------------------------------------------------------
sub get_entcook {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}
	$cook{$cf{entcok_id}} =~ s/\W//g;
	
	# oCi֖߂
	$cook{$cf{entcok_id}} =~ s/n/\n/g;
	$cook{$cf{entcok_id}} =~ s/([0-9A-Fa-f]{2})/pack('H2',$1)/eg;
	
	# RC4
	my $plain = RC4($cf{crypt_key},$cook{$cf{entcok_id}});
	
	return split(/:/,$plain);
}

#-----------------------------------------------------------
#  pX[hL
#-----------------------------------------------------------
sub set_entcook {
	if ($in{cook} != 1) {
		print "Set-Cookie: $cf{entcok_id}=; expires=Thu, 1-Jan-1970 00:00:00 GMT;\n";
		
	} else {
		# RC4Íϊ
		my $crypt = RC4($cf{crypt_key},"$in{id}:$in{pw}");

		# oCi16i
		$crypt =~ s/(.)/unpack('H2',$1)/eg;
		$crypt =~ s/\n/n/g;

		# 60ԗL
		my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
		my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
		my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

		# tH[}bg
		my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
						$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

		print "Set-Cookie: $cf{entcok_id}=$crypt; expires=$gmt\n";
	}
}

