#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ WEB MART : admin.cgi - 2021/07/25
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw($cgi %in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル取り込み
require './init.cgi';
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
$cgi = CGI::Minimal->new;
cgi_err('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{data_new}) { data_new(); }
if ($in{data_men}) { data_men(); }
if ($in{look_log}) { look_log(); }
if ($in{data_law}) { data_law(); }
if ($in{data_csv}) { data_csv(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	print <<EOM;
<div id="body">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>新規商品データ作成</td>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>商品データメンテナンス（修正・削除）</td>
</tr><tr>
	<td><input type="submit" name="data_csv" value="選択"></td>
	<td>CSVダウン/アップロード</td>
</tr><tr>
	<td><input type="submit" name="look_log" value="選択"></td>
	<td>ログデータ閲覧</td>
</tr><tr>
	<td><input type="submit" name="data_law" value="選択"></td>
	<td>特商法ページメンテナンス</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  新規記事作成
#-----------------------------------------------------------
sub data_new {
	# コード,商品名,価格,オプション
	my @log = @_;
	
	# 新規商品追加
	if ($in{job} eq "new") { data_add(); }
	
	# 在庫/軽減税率
	my %zai = read_stock()  if ($cf{stock} and @log > 0);
	my %red = read_redtax() if ($cf{tax_per} and @log > 0);
	
	# パラメータ指定
	my ($mode,$job,$input_code);
	if ($in{data_new}) {
		$mode = "data_new";
		$job = "new";
		$input_code .= qq|（英数字及びアンダーバーのみ）<br>\n|;
		$input_code .= qq|<input type="text" name="code" size="20">|;
	} else {
		$mode = "data_men";
		$job = "edit2";
		$input_code .= qq|<b>$log[0]</b> （変更不可）\n|;
		$input_code .= qq|<input type="hidden" name="code" value="$log[0]">|;
	}
	
	# 税表記
	my $tax = $cf{tax_per} == 0 ? $cf{tax_class}[0] : $cf{tax_class}[1];
	
	header("商品登録フォーム");
	back_btn();
	print <<EOM;
<div class="ttl">■ 商品登録フォーム</div>
<p>
	・ 必要項目を入力して、送信ボタンを押してください。<br>
	・ 「備考」及び「戻り先URL」は検索結果画面で使用。
</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="$mode" value="1">
<input type="hidden" name="job" value="$job">
<table class="form-tbl items">
<tr>
	<th nowrap>商品コード</th>
	<td>$input_code</td>
</tr><tr>
	<th nowrap>商品名</th>
	<td><input type="text" name="item" size="40" value="$log[1]"></td>
</tr><tr>
	<th nowrap>商品単価</th>
	<td><input type="text" name="price" size="20" value="$log[2]"> 円 &nbsp; [$tax]<br>
EOM

	if ($cf{tax_per} > 0) {
		if (defined $red{$log[0]}) {
			print qq|<input type="checkbox" name="rtax" value="1" checked>\n|;
		} else {
			print qq|<input type="checkbox" name="rtax" value="1">\n|;
		}
		print qq|軽減税率対象\n|;
	}
	print "</td>\n";
	
	# 在庫管理オプション
	if ($cf{stock}) {
		print qq|</tr><tr>\n|;
		print qq|<th nowrap>在庫数</th>\n|;
		print qq|<td><input type="text" name="zai" size="4" value="$zai{$log[0]}"> 個</td>|;
	}
	
	print <<EOM;
</tr>
</table>
<p>以下は検索画面（機能）に必要（検索機能を使用しない場合は入力不要）。</p>
<table class="form-tbl items">
<tr>
EOM

	# 属性情報
	my $i = 4;
	for (@{$cf{options}}) {
		$i++;
		my ($key,$nam) = split(/,/);
		
		print qq|</tr><tr>\n|;
		print qq|<th nowrap>属性指定<br>[$nam]</th>\n|;
		print qq|<td>（複数をスペースで区切る。例：青 赤 黄）<br>\n|;
		print qq|<input type="text" name="op:$key" size="40" value="$log[$i]"></td>|;
	}
	
	print <<EOM;
</tr><tr>
	<th nowrap>備考</th>
	<td><input type="text" name="memo" size="40" value="$log[3]"></td>
</tr><tr>
	<th nowrap>戻り先URL</th>
	<td>（http://から記述）<br>
		<input type="text" name="back" size="40" value="$log[4]">
	</td>
</tr>
</table>
<input type="submit" value="送信する">
</form>
</div>
</body>
</html>
EOM
	exit;
}
#-----------------------------------------------------------
#  データ追加
#-----------------------------------------------------------
sub data_add {
	# 入力チェック
	check_input();
	
	# データ追加
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/mart.dat") or cgi_err("open err: mart.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($code) = (split(/<>/))[0];
		
		if ($in{code} eq $code) {
			$flg++;
			last;
		}
		push(@log,$_);
	}
	
	# コード重複のときはエラー
	if ($flg) {
		close(DAT);
		cgi_err("商品コード（$in{code}）が重複しています");
	}
	
	# オプション
	my $ops;
	foreach (@{$cf{options}}) {
		my ($key,undef) = split(/,/);
		
		$ops .= qq|$in{"op:$key"}<>|;
	}
	
	seek(DAT,0,0);
	print DAT @log;
	print DAT "$in{code}<>$in{item}<>$in{price}<>$in{memo}<>$in{back}<>$ops\n";
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 軽減税率
	if ($cf{tax_per} > 0 and $in{rtax}) {
		open(DAT,">> $cf{datadir}/rtax.dat") or cgi_err("write err: rtax.dat");
		eval "flock(DAT,2);";
		print DAT "$in{code}\n";
		close(DAT);
	}
	
	# 在庫数
	if ($cf{stock}) {
		open(DAT,">> $cf{datadir}/stock.dat") or cgi_err("write err: stock.dat");
		eval "flock(DAT,2);";
		print DAT "$in{code}<>$in{zai}<>\n";
		close(DAT);
	}
	
	# 元画面フォーム
	my $btn = <<EOM;
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_new" value="1">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="投稿フォームに戻る" style="width:140px">
</form>
EOM

	# 完了メッセージ
	message("新規商品データを追加しました", $btn);
}

#-----------------------------------------------------------
#  商品データメンテナンス
#-----------------------------------------------------------
sub data_men {
	# 指示フラグ
	my $job = $in{job};
	
	# --- 修正フォーム
	if ($job eq "edit" && $in{code}) {
		
		my @log;
		open(IN,"$cf{datadir}/mart.dat") or cgi_err("open err: mart.dat");
		while(<IN>) {
			my @data = split(/<>/);
			
			if ($in{code} eq $data[0]) {
				chomp(@data);
				@log = @data;
				last;
			}
		}
		close(IN);
		
		# 修正フォーム
		data_new(@log);
	
	# --- 修正実行
	} elsif ($job eq "edit2") {
		
		# 入力チェック
		check_input();
		
		# 更新データ
		my $new = "$in{code}<>$in{item}<>$in{price}<>$in{memo}<>$in{back}<>";
		foreach (@{$cf{options}}) {
			my ($key,undef) = split(/,/);
			
			$new .= qq|$in{"op:$key"}<>|;
		}
		
		# 商品データ修正
		my @log;
		open(DAT,"+< $cf{datadir}/mart.dat") or cgi_err("open err: mart.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my @data = split(/<>/);
			
			if ($in{code} eq $data[0]) { $_ = "$new\n"; }
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 軽減税率
		if ($cf{tax_per} > 0) {
			my ($flg,@log);
			open(DAT,"+< $cf{datadir}/rtax.dat") or cgi_err("open err: rtax.dat");
			eval "flock(DAT,2);";
			while(<DAT>) {
				chomp;
				
				if ($in{code} eq $_) {
					$flg++;
					next if (!$in{rtax});
				}
				push(@log,"$_\n");
			}
			if ($in{rtax} and !$flg) {
				push(@log,"$in{code}\n");
			}
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
		
		# 在庫更新
		if ($cf{stock}) {
			my ($flg,@log);
			open(DAT,"+< $cf{datadir}/stock.dat") or cgi_err("open err: stock.dat");
			eval "flock(DAT,2);";
			while(<DAT>) {
				my ($code,$zai) = split(/<>/);
				
				if ($in{code} eq $code) {
					$flg++;
					$_ = "$code<>$in{zai}<>\n";
				}
				push(@log,$_);
			}
			
			# 新規追加のとき
			if (!$flg) { push(@log,"$in{code}<>$in{zai}<>\n"); }
			
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
	
	# --- 削除
	} elsif ($job eq "dele" && $in{code}) {
		
		my @log;
		open(DAT,"+< $cf{datadir}/mart.dat") or cgi_err("open err: mart.dat");
		eval "flock(DAT, 2);";
		while(<DAT>) {
			my ($code) = (split(/<>/))[0];
			
			next if ($in{code} eq $code);
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 軽減税率
		if ($cf{tax_per} > 0) {
			my @log;
			open(DAT,"+< $cf{datadir}/rtax.dat") or cgi_err("open err: rtax.dat");
			eval "flock(DAT,2);";
			while(<DAT>) {
				chomp;
				
				next if ($in{code} eq $_);
				push(@log,"$_\n");
			}
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
		
		# 在庫更新
		if ($cf{stock}) {
			my @log;
			open(DAT,"+< $cf{datadir}/stock.dat") or cgi_err("open err: stock.dat");
			eval "flock(DAT,2);";
			while(<DAT>) {
				my ($code,$zai) = split(/<>/);
				
				next if ($in{code} eq $code);
				push(@log,$_);
			}
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
	}
	
	# 在庫データ認識
	my %zai = read_stock() if ($cf{stock});
	
	header("メニューTOP ＞ 商品データメンテナンス");
	back_btn();
	print <<EOM;
<div class="ttl">■ 商品データメンテナンス</div>
<p>処理を選択し、送信ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_men" value="1">
処理：
<select name="job">
<option value="edit">修正
<option value="dele">削除
</select>
<input type="submit" value="送信">
<table class="form-tbl">
<tr>
	<th nowrap>選択</th>
	<th nowrap>商品コード</th>
	<th nowrap>商品名</th>
	<th nowrap>金額</th>
EOM

	print qq|<th nowrap>在庫</th>| if ($cf{stock});
	print qq|</tr>\n|;
	
	open(IN,"$cf{datadir}/mart.dat") or cgi_err("open err: mart.dat");
	while(<IN>) {
		my ($code,$item,$price,$memo,$back,@op) = split(/<>/);
		$price = comma($price);
		
		print qq|<tr><td class="ta-c"><input type="radio" name="code" value="$code"></td>|;
		print qq|<td nowrap>$code</td>|;
		print qq|<td nowrap>$item</td>|;
		print qq|<td nowrap class="ta-r">￥$price</td>|;
		print qq|<td nowrap class="ta-r">$zai{$code}<br></td>| if ($cf{stock});
		print qq|</tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  ログデータ閲覧
#-----------------------------------------------------------
sub look_log {
	# 閲覧ボタン確認
	my $look;
	for ( keys %in ) {
		if (/^look:(\d+)$/) {
			$look = $1;
			last;
		}
	}
	# 個別閲覧
	if ($look) { look_num($look); }
	
	# 年月データ
	my $q_ym = $in{ym};
	
	# 入力内容が規定外の場合は現在の年月
	if ($q_ym !~ /^\d{6}$/) {
		my ($m,$y) = (localtime())[4,5];
		$q_ym = sprintf("%04d%02d", $y+1900,$m+1);
	}
	
	my @dir;
	opendir(DIR,"$cf{datadir}/log") or cgi_err("open err: $cf{datadir}/log");
	while( my $dir = readdir(DIR) ) {
		if ($dir =~ /^(\d+)\.cgi$/) {
			push(@dir,$1);
		}
	}
	closedir(DIR);
	
	header("メニューTOP ＞ ログデータ閲覧");
	back_btn();
	print <<EOM;
<div class="ttl">■ ログデータ閲覧</div>
<p>年月を切り替えて閲覧することができます。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="look_log" value="1">
年月：
<select name="ym">
EOM

	my ($i,$top);
	for ( sort{ $b <=> $a } @dir ) {
		if (/^(\d{4})(\d{2})/) {
			if ($q_ym == "$1$2") {
				print qq|<option value="$1$2" selected>$1年$2月\n|;
			} else {
				print qq|<option value="$1$2">$1年$2月\n|;
			}
		}
		$i++;
		if ($i == 1) { $top = $_; }
	}
	
	print <<EOM;
</select>
<input type="submit" value="切替">
<table class="form-tbl">
<tr>
	<th nowrap>選択</th>
	<th nowrap>注文日時</th>
	<th nowrap>注文番号</th>
</tr>
EOM

	open(IN,"$cf{datadir}/log/$q_ym.cgi");
	while(<IN>) {
		my ($date,$num,$log) = split(/<>/);
		
		print qq|<tr><td><input type="submit" name="look:$num" value="閲覧"></td>\n|;
		print qq|<td nowrap>$date</td>\n|;
		print qq|<td nowrap class="ta-c">$num</td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  個別ログ閲覧
#-----------------------------------------------------------
sub look_num {
	my $look = shift;
	
	# ログデータ名
	my $log = ($in{ym} =~ /^(\d{4})(\d{2})$/) && "$1$2.cgi";
	
	# ログオープン
	my $data;
	open(IN,"$cf{datadir}/log/$log") or cgi_err("open err: $log");
	while(<IN>) {
		my ($date,$num,$body) = split(/<>/);
		
		if ($look == $num) {
			$data = $_;
			last;
		}
	}
	close(IN);
	
	my ($date,$num,$body) = split(/<>/,$data);
	$body =~ s/\t/<br>/g;
	
	header("メニューTOP ＞ ログデータ閲覧 ＞ 個別ログ");
	back_btn('look_log');
	print <<EOM;
<div class="ttl">■ ログデータ閲覧 ＞ 個別ログ</div>
<p>
	・注文年月： <b>$date</b><br>
	・注文番号： <b>$num</b><br>
</p>
$body
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  特商法メンテ
#-----------------------------------------------------------
sub data_law {
	# 新規
	if ($in{add} && $in{key} && $in{val}) {
		$in{key} =~ s/\t//g;
		$in{val} =~ s/\t//g;
		
		my $i = 0;
		open(DAT,"+< $cf{datadir}/law.dat") or cgi_err("open err: law.dat");
		while(<DAT>) {
			my ($no,$key,$val) = split(/\t/);
			if ($i < $no) { $i = $no; }
		}
		$i++;
		seek(DAT,0,2);
		print DAT "$i\t$in{key}\t$in{val}\n";
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# ソート
	} elsif ($in{sort}) {
		my (@tmp,@log);
		open(DAT,"+< $cf{datadir}/law.dat") or cgi_err("open err: law.dat");
		while(<DAT>) {
			my ($no,$key,$val) = split(/\t/);
			
			push(@tmp,$in{"sort:$no"});
			push(@log,$_);
		}
		@log = @log[sort{$tmp[$a] <=> $tmp[$b]} 0..$#tmp];
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	my ($chg,$del);
	for ( keys %in ) {
		if (/^chg:(\d+)/) {
			$chg = $1;
			last;
		} elsif (/^del:(\d+)/) {
			$del = $1;
			last;
		}
	}
	# 修正
	if ($chg) {
		my @log;
		open(DAT,"+< $cf{datadir}/law.dat") or cgi_err("open err: law.dat");
		while(<DAT>) {
			my ($no,$key,$val) = split(/\t/);
			
			if ($chg == $no) {
				$in{"key:$no"} =~ s/\t//g;
				$in{"val:$no"} =~ s/\t//g;
				$_ = qq|$no\t$in{"key:$no"}\t$in{"val:$no"}\n|;
			}
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		message("修正を完了しました");
	
	# 削除
	} elsif ($del) {
		my @log;
		open(DAT,"+< $cf{datadir}/law.dat") or cgi_err("open err: law.dat");
		while(<DAT>) {
			my ($no,$key,$val) = split(/\t/);
			next if ($del == $no);
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("メニューTOP ＞ 特商法メンテナンス");
	back_btn();
	print <<EOM;
<div class="ttl">■ 特商法メンテナンス</div>
<p>改行は無効です。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_law" value="1">
<table class="form-tbl">
<tr>
	<th><input type="submit" name="sort" value="並替"></th>
	<th>項目</th>
	<th>内容</th>
	<th>操作</th>
</tr><tr>
	<td></td>
	<td><textarea name="key" cols="20" rows="3"></textarea></td>
	<td><textarea name="val" cols="50" rows="3"></textarea></td>
	<td><input type="submit" name="add" value="追加"></td>
</tr>
EOM

	# データ読み取り
	my $i;
	open(IN,"$cf{datadir}/law.dat");
	while(<IN>) {
		chomp;
		my ($no,$key,$val) = split(/\t/);
		
		$i++;
		print qq|<tr><td><input type="text" name="sort:$no" value="$i" size="2"></td>\n|;
		print qq|<td><textarea name="key:$no" cols="20" rows="3">$key</textarea></td>\n|;
		print qq|<td><textarea name="val:$no" cols="50" rows="3">$val</textarea></td>\n|;
		print qq|<td><input type="submit" name="chg:$no" value="修正">\n|;
		print qq|<input type="submit" name="del:$no" value="削除" onclick="return confirm('削除しますか？');"></td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  CSVダウン/アップロード
#-----------------------------------------------------------
sub data_csv {
	# ダウンロード
	if ($in{downld}) {
		require "./lib/jacode.pl";
		
		open(DAT,"$cf{datadir}/mart.dat") or error("open err: mart.dat");
		
		# ダウンロード用ヘッダ
		print "Content-type: application/octet-stream\n";
		print "Content-Disposition: attachment; filename=data.csv\n\n";
		
		# バイナリ出力 (Windowsサーバ環境)
		binmode(STDOUT);
		
		while ( my $log = <DAT> ) {
			chomp($log);
			jcode::convert(\$log,'sjis','utf8');
			
			my $csv;
			foreach ( split(/<>/,$log) ) {
				$csv .= "$_,";
			}
			print "$csv\r\n";
		}
		close(DAT);
		exit;
	
	# ダウンロード
	} elsif ($cf{stock} && $in{downld2}) {
		
		open(DAT,"$cf{datadir}/stock.dat") or error("open err: stock.dat");
		
		# ダウンロード用ヘッダ
		print "Content-type: application/octet-stream\n";
		print "Content-Disposition: attachment; filename=stock.csv\n\n";
		
		# バイナリ出力 (Windowsサーバ環境)
		binmode(STDOUT);
		
		while (<DAT>) {
			my ($no,$zai) = split(/<>/);
			print "$no,$zai\r\n";
		}
		close(DAT);
		exit;
	
	# ダウンロード
	} elsif ($cf{tax_per} > 0 && $in{downld3}) {
		
		open(DAT,"$cf{datadir}/rtax.dat") or error("open err: rtax.dat");
		
		# ダウンロード用ヘッダ
		print "Content-type: application/octet-stream\n";
		print "Content-Disposition: attachment; filename=rtax.csv\n\n";
		
		# バイナリ出力 (Windowsサーバ環境)
		binmode(STDOUT);
		
		while (<DAT>) {
			chomp;
			print "$_\r\n";
		}
		close(DAT);
		exit;
	
	# アップロード
	} elsif ($in{upload} && $in{upfile}) {
		require "./lib/jacode.pl";
		
		# ファイル名
		my $fname = $cgi->param_filename("upfile");
		if ($fname !~ /\.csv$/i) { error('CSVファイルのみアップロードできます。'); }
		
		my @log;
		foreach my $log ( split(/\r\n|\r|\n/,$in{upfile}) ) {
			jcode::convert(\$log,'utf8','sjis');
			
			my $csv;
			foreach ( split(/,/,$log) ) {
				$csv .= "$_<>";
			}
			push(@log,"$csv\n");
		}
		
		# 上書き
		open(DAT,"> $cf{datadir}/mart.dat") or error("write err: mart.dat");
		print DAT @log;
		close(DAT);
		
		message('CSVをアップ更新しました');
	
	# アップロード
	} elsif ($cf{stock} && $in{upload2} && $in{upfile2}) {
		
		# ファイル名
		my $fname = $cgi->param_filename("upfile2");
		if ($fname !~ /\.csv$/i) { error('CSVファイルのみアップロードできます。'); }
		
		my $i;
		my @log;
		for ( split(/\r\n|\r|\n/,$cgi->param('upfile2')) ) {
			$i++;
			my ($no,$zai) = split(/,/);
			push(@log,"$no<>$zai<>\n");
		}
		
		# 上書き
		open(DAT,"> $cf{datadir}/stock.dat") or error("write err: stock.dat");
		print DAT @log;
		close(DAT);
		
		message("在庫データを$i個アップ更新しました");
	
	# アップロード
	} elsif ($cf{tax_per} > 0 && $in{upload3} && $in{upfile3}) {
		
		# ファイル名
		my $fname = $cgi->param_filename("upfile3");
		if ($fname !~ /\.csv$/i) { error('CSVファイルのみアップロードできます。'); }
		
		my $i;
		my @log;
		for ( split(/\r\n|\r|\n/,$cgi->param('upfile3')) ) {
			$i++;
			push(@log,"$_\n");
		}
		
		# 上書き
		open(DAT,"> $cf{datadir}/rtax.dat") or error("write err: rtax.dat");
		print DAT @log;
		close(DAT);
		
		message("軽減税率データを$i個アップ更新しました");
	}
	
	header("メニューTOP ＞ CSVダウン/アップロード");
	back_btn();
	print <<EOM;
<div class="ttl">■ CSVダウン/アップロード</div>
<p>データをCSV形式でダウンロードすることができます。</p>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_csv" value="1">
<table class="form-tbl">
<tr>
	<th>CSVダウンロード</th>
	<td>
		<p>商品ファイル <input type="submit" name="downld" value="ダウンロード"></p>
EOM

	if ($cf{stock}) {
		print qq|<p>在庫ファイル <input type="submit" name="downld2" value="ダウンロード"></p>\n|;
	}
	if ($cf{tax_per} > 0) {
		print qq|<p>軽減税率ファイル <input type="submit" name="downld3" value="ダウンロード"></p>\n|;
	}
	
	print <<EOM;
	</td>
</tr>
</table>
<p>データをCSV形式でアップロードすることができます。</p>
<table class="form-tbl">
<tr>
	<th>CSVアップロード</th>
	<td>
		<p>商品ファイル <input type="file" name="upfile" size="32">
			<input type="submit" name="upload" value="アップロード"></p>
EOM

	if ($cf{stock}) {
		print qq|<p>在庫ファイル <input type="file" name="upfile2" size="25">\n|;
		print qq|<input type="submit" name="upload2" value="アップロード"></p>\n|;
	}
	if ($cf{tax_per} > 0) {
		print qq|<p>軽減税率ファイル <input type="file" name="upfile3" size="25">\n|;
		print qq|<input type="submit" name="upload3" value="アップロード"></p>\n|;
	}
	
	print <<EOM;
	</td>
</tr>
</table>
<p>
	【参考】 商品データCSVフォーマット<br>
	<span style="letter-spacing:1px;color:red">商品コード,商品名,単価,備考,戻り先,属性情報1,属性情報2, ... [改行]</span><br>
	↑上記で、属性情報とは「サイズ,カラー」等で、init.cgiで指定する\$cf{options}の個数分が続く。<br>
	（例）属性情報が「サイズ,カラー」であれば、<span style="letter-spacing:1px;color:red">商品コード,商品名,単価,備考,戻り先,サイズ,カラー [改行]</span>
</p>
EOM

	if ($cf{stock}) {
		print qq|<p>【参考】 在庫データCSVフォーマット<br>\n|;
		print qq|<span style="letter-spacing:1px;color:red">商品コード,在庫数 [改行]</span></p>\n|;
	}
	if ($cf{tax_per} > 0) {
		print qq|<p>【参考】 軽減税率CSVフォーマット<br>\n|;
		print qq|<span style="letter-spacing:1px;color:red">商品コード [改行]</span></p>\n|;
	}
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_input {
	# 禁止文字排除
	$in{code}  =~ s/\W//g;
	$in{price} =~ s/\D//g;
	
	# 在庫のとき
	if ($cf{stock}) {
		$in{zai} =~ s/\D//g;
		if ($in{zai} eq "") { $in{zai} = 0; }
	}
	
	# 入力チェック
	my $err;
	if ($in{code} eq "") { $err .= "商品コードが未入力です<br>"; }
	if ($in{item} eq "") { $err .= "商品名が未入力です<br>"; }
	if ($in{price} eq "") { $err .= "商品単価が未入力です<br>"; }
	if ($err) { cgi_err($err); }
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head"></div>
EOM
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my $mode = shift;
	
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
@{[ $mode ? qq|<input type="submit" name="$mode" value="&lt; 前画面">| : "" ]}
<input type="submit" value="&lt; メニュー">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $msg = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="body">
<div class="ta-c">
<hr width="350">
<h3>ERROR!</h3>
<p style="color:#dd0000">$msg</p>
<hr width="350">
<input type="button" value="前画面に戻る" onclick="history.back()">
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  メッセージ表示
#-----------------------------------------------------------
sub message {
	my ($msg,$btn) = @_;
	
	header("処理完了");
	print <<EOM;
<div id="body">
<div class="ttl">■ 処理完了</div>
<p style="color:#008000">$msg</p>
$btn
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="メニューに戻る" style="width:140px">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  在庫数
#-----------------------------------------------------------
sub read_stock {
	my %ret;
	open(IN,"$cf{datadir}/stock.dat");
	while(<IN>) {
		my ($code,$file) = split(/<>/);
		
		$ret{$code} = $file;
	}
	close(IN);
	
	return %ret;
}


