#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ WEB MART : check.cgi - 2021/04/25
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定データ認識
require "./init.cgi";
my %cf = set_init();

print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
EOM

# ディレクトリ
for ( $cf{datadir}, "$cf{datadir}/log", "$cf{datadir}/ses", "$cf{datadir}/pwd" ) {
	if (-d $_) {
		print "<li>$_ ディレクトリパス : OK\n";
		
		if (-r $_ && -w $_ && -x $_) {
			print "<li>$_ ディレクトリパーミッション : OK\n";
		} else {
			print "<li>$_ ディレクトリパーミッション : NG\n";
		}
	} else {
		print "<li>$_ ディレクトリパス : NG\n";
	}
}

# ファイルチェック
for (qw(law.dat mart.dat num.dat pass.dat rtax.dat ses.dat stock.dat)) {
	if (-f "$cf{datadir}/$_") {
		print "<li>$cf{datadir}/$_ ファイルパス : OK\n";
		
		if (-r "$cf{datadir}/$_" && -w "$cf{datadir}/$_") {
			print "<li>$_ ファイルパーミッション : OK\n";
		} else {
			print "<li>$_ ファイルパーミッション : NG\n";
		}
	} else {
		print "<li>$_ ファイルパス : NG\n";
	}
}

# テンプレート
for (qw(mart.html addr.html conf.html send.html send-credit.html send-bank.html send-conv.html error.html law.html find.html reply.txt order.txt)) {
	if (-f "$cf{tmpldir}/$_") {
		print "<li>$_ テンプレートパス : OK\n";
	} else {
		print "<li>$_ テンプレートパス : NG\n";
	}
}

# sendmailパス
if (-e $cf{sendmail}) {
	print "<li>sendmailパス : OK\n";
} else {
	print "<li>sendmailパス : NG\n";
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;

