#!/usr/local/bin/perl

#
# MESSAGE ENQUETE : msgenq.cgi - 2011/09/28
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use Jcode;

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# f[^
my %in = &parse_form;

# 
if ($in{mode} eq 'regist') { &regist; }
&enq_list;

#-----------------------------------------------------------
#  
#-----------------------------------------------------------
sub enq_list {
	# AP[gf[^
	my $count = 0;
	my ($op_item,@sort,@data);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	my $top = <IN>;
	while (<IN>) {
		my ($no,$item,$cnt,$hos) = split(/<>/);

		push(@sort,$cnt);
		push(@data,$_);
		$count += $cnt;

		$op_item .= qq|<option value="$no">$item\n|;
	}
	close(IN);

	# \[g
	@data = @data[sort {$sort[$b] <=> $sort[$a]} 0 .. $#sort];

	# y[W`
	my $pg = $in{pg} || 0;

	# ff[^
	my $pg = $in{pg} || 0;
	my ($i,@log);
	open(IN,"$cf{msgfile}") or &error("open err: $cf{msgfile}");
	while (<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});

		push(@log,$_);
	}
	close(IN);

	# Jz{^쐬
	my $page_btn = &make_pgbtn($i, $pg);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/enq.html") or &error("open err: enq.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# 摜F؍쐬
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
		$tmpl =~ s/!str_crypt!/$str_crypt/g;
	} else {
		$tmpl =~ s/<!-- captcha_begin -->.+<!-- captcha_end -->//s;
	}

	# u
	$tmpl =~ s/!enq_title!/$cf{enq_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!count!/$count/g;
	$tmpl =~ s/<!-- op_item -->/$op_item/;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!page-btn!/<p>$page_btn<\/p>/g;
	$tmpl =~ s/!message!/$cf{message}/g;

	my ($head,$loop,$mid,$bbs,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)<!-- bbs_begin -->(.+)<!-- bbs_end -->(.+)/s) {
		($head,$loop,$mid,$bbs,$foot) = ($1,$2,$3,$4,$5);
	} else {
		&error("ev[gsł");
	}

	# ʕ\
	print "Content-type: text/html\n\n";
	print $head;

	# AP[g
	my ($i,$bf_c,$bf_r) = (0,0,1);
	foreach (@data) {
		$i++;
		my ($no,$item,$cnt) = split(/<>/);

		my ($per,$wid);
		if ($cnt == 0) {
			$per = '0.0';
			$wid = 1;
		} else {
			$per = int(($cnt*1000 / $count) + 0.5) / 10;
			$per = sprintf("%.1f", $per);
			$wid = int($per * 3) < 1 ? 1 : int($per * 3);
		}
		my $rank = $bf_c == $cnt ? $bf_r : $i;

		my $tmp = $loop;
		$tmp =~ s/!rank!/$rank/g;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!vote!/$cnt/g;
		$tmp =~ s/!graph!/<img src="$cf{graph}" width="$wid" height="10"> $per%/g;
		print $tmp;

		$bf_c = $cnt;
		$bf_r = $rank;
	}

	print $mid;

	# ff[^WJ
	foreach (@log) {
		my ($date,$item,$com) = split(/<>/);

		my $tmp = $bbs;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!comment!/$com/g;
		print $tmp;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  [
#-----------------------------------------------------------
sub regist {
	# e`FbN
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		&error("sȃNGXgł");
	}

	# ̓`FbN
	my $err;
	if ($in{item} eq "") { $err .= "ڂ̑I܂<br>"; }
	if (length($in{comment}) > $cf{msg_max} * 2) {
		$err .= "Rg܂BSp$cf{msg_max}ȓŋLqĉ<br>";
	}
	&error($err) if ($err);

	# 摜F؃`FbN
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			&error("摜F؂͕słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}

		# eL[`FbN
		# -1 : L[sv
		#  0 : ԃI[o[
		#  1 : L[v
		my $chk = cap::check($in{captcha}, $in{str_crypt}, $cf{captcha_key}, $cf{cap_time}, $cf{cap_len});
		if ($chk == 0) {
			&error("摜F؂Ԃ𒴉߂܂B<br>etH[ɖ߂čēǍ݌Aw̐ē͂Ă");
		} elsif ($chk == -1) {
			&error("摜F؂słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}
	}

	# zXg擾
	my ($host,$addr) = &get_host;

	my ($ans,@log);
	open(DAT,"+< $cf{logfile}") or &error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my $top = <DAT>;
	while (<DAT>) {
		chomp;
		my ($no,$item,$count,$host) = split(/<>/);

		if ($in{item} == $no) {
			$ans = $item;
			$count++;
			$_ = "$no<>$item<>$count<>$host<>";
		}
		push(@log,"$_\n");
	}

	chomp($top);
	my $match;
	my $new_top = "$addr ";
	my $i = 0;
	foreach ( split(/\s+/, $top) ) {
		$i++;
		if ($cf{ipmax} && $addr eq $_) {
			$match = 1;
			last;
		}
		if ($i < $cf{ipmax}) { $new_top .= "$_ "; }
	}
	if ($match) {
		close(DAT);
		&error("A[͂ł܂");
	}
	$new_top =~ s/\s$//;

	# XV
	unshift(@log,"$new_top\n");
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	# RgL^
	if ($in{comment} ne "") {

		# R[hϊ
		Jcode::convert(\$in{comment}, 'sjis');

		# 
		my $date = &get_time;

		# LǍ
		open(DAT,"+< $cf{msgfile}") or &error("open err: $cf{msgfile}");
		eval "flock(DAT, 2);";
		my @data = <DAT>;

		# XV
		while ($cf{maxlog} <= @data) { pop(@data); }
		unshift(@data,"$date<>$ans<>$in{comment}<>$host<>\n");
		seek(DAT, 0, 0);
		print DAT @data;
		truncate(DAT, tell(DAT));
		close(DAT);
	}

	# bZ[W
	&message("񓚂肪Ƃ܂");
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">Message Enq</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "<body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	print "Content-type: text/html\n\n";
	while(<IN>) {
		s/!error!/$err/g;

		print;
	}
	close(IN);

	exit;
}

#-----------------------------------------------------------
#  bZ[W
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;

	open(IN,"$cf{tmpldir}/message.html") or &error("open err: message.html");
	print "Content-type: text/html\n\n";
	while(<IN>) {
		s/!enq_cgi!/$cf{enq_cgi}/g;
		s/!message!/$msg/g;

		print;
	}
	close(IN);

	exit;
}

#-----------------------------------------------------------
#  ؂
#-----------------------------------------------------------
sub comma {
	local($_) = @_;

	1 while s/(.*\d)(\d\d\d)/$1,$2/;
	$_;
}

#-----------------------------------------------------------
#  Ԏ擾
#-----------------------------------------------------------
sub get_time {
	# 擾
	$ENV{TZ} = "JST-9";
	my ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0..6];

	# ̃tH[}bg
	my @week = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	sprintf("%04d/%02d/%02d(%s) %02d:%02d:%02d",
			$year+1900,$mon+1,$mday,$week[$wday],$hour,$min,$sec);
}

#-----------------------------------------------------------
#  ANZX
#-----------------------------------------------------------
sub get_host {
	# IP&zXg擾
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}

	# IP`FbN
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;

		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		&error("ANZXĂ܂");

	# zXg`FbN
	} elsif ($host) {

		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;

			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			&error("ANZXĂ܂");
		}
	}
	if ($host eq "") { $host = $addr; }
	return ($host,$addr);
}

#-----------------------------------------------------------
#  Jz{^쐬
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i, $pg) = @_;

	# y[WJz`
	$cf{pg_max} ||= 10;
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x, $y) = (1, 0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq(| <b>$x</b> );
			} else {
				$pg_btn .= qq(| <a href="$cf{enq_cgi}?pg=$y">$x</a> );
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
		$pg_btn .= "|";
	}
	return $pg_btn;
}
