#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Cosmo Navigator : navi.cgi - 2023/12/24
#│ copyright (c) kentweb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
%in = parse_form();

# 条件分岐
if ($in{mode} eq 'note') { note_page(); }
if ($in{mode} eq 'form') { form_page(); }
if ($in{mode} eq 'find') { find_data(); }
if ($in{mode} eq 'news') { news_list(); }
if ($in{mode} eq 'regi') { regi_data(); }
error("不明な処理です");

#-----------------------------------------------------------
#  新着ページ
#-----------------------------------------------------------
sub news_list {
	my ($i,@list);
	open(IN,"$cf{datadir}/data.dat");
	while (<IN>) {
		$i++;
		last if ($i > $cf{new_site});
		
		push(@list,$_);
	}
	close(IN);
	
	# カテゴリ情報
	my %cat = categ();
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/list.html") or error("open err: list.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s|<!-- cat_menu -->.+?<!-- /cat_menu -->||s;
	$tmpl =~ s|<!-- search -->.+?<!-- /search -->||s;
	$tmpl =~ s/!navi-ttl!/新着ページ/;
	$tmpl =~ s/!(title|cmnurl|new_mark|[a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" class="icon" alt="$1">|g;
	$tmpl =~ s/!word!//;
	$tmpl =~ s|<!-- keyword -->.+?<!-- /keyword -->||s;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3) : error("テンプレート不正");
	
	# 時間取得
	my $now = time;
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (@list) {
		my ($no,$cat,$scat,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		$msg =~ s/\t/<br>/g;
		
		my $tmp = $loop;
		$tmp =~ s|!site-name!|<a href="$url" target="_blank">$sub</a>|g;
		$tmp =~ s|!cate!|<a href="$cf{rooturl}/html/$cat-1.html">$cat{$cat}{0}</a>|g;
		$tmp =~ s|!sub!|<a href="$cf{rooturl}/html/$cat/$scat-1.html">$cat{$cat}{$scat}</a>|g;
		$tmp =~ s|!comment!|$msg|g;
		$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
		$tmp =~ s|!num!|$no|g;
		$tmp =~ s|<!-- recom -->|<img src="$cf{cmnurl}/cool.gif" class="icon" alt="Cool">|g if ($rec == 1);
		$tmp =~ s/!name!/$nam/;
		$tmp =~ s/!date!/chg_date($tim)/e;
		$tmp =~ s/!new!/chg_date($tim,'new')/e;
		
		print $tmp;
	}
	
	# フッタ
	print footer($foot);
	exit;
}

#-----------------------------------------------------------
#  留意事項
#-----------------------------------------------------------
sub note_page {
	# テンプレート読込
	open(IN,"$cf{tmpldir}/note.html") or error("open err: note.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s/!([a-z]+_cgi|cmnurl|new_mark|title)!/$cf{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  登録フォーム
#-----------------------------------------------------------
sub form_page {
	if ($cf{reg_type} != 1) { error("不正な要求です"); }
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/form.html") or error("open err: form.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 画像認証作成
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain,$str_crypt) = cap::make($cf{captcha_key},$cf{cap_len});
		$tmpl =~ s/!str_crypt!/$str_crypt/g;
	} else {
		$tmpl =~ s|<!-- captcha -->.+?<!-- /captcha_end -->||s;
	}
	
	# 文字置き換え
	$tmpl =~ s/!(title|[a-z]+_cgi|cmnurl|com_limit)!/$cf{$1}/g;
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
	$tmpl =~ s/<!-- op_cate -->/op_cate()/e;
	$tmpl =~ s/!mode!/acpt/g;
	$tmpl =~ s/!fm-url!/http:\/\//g;
	$tmpl =~ s/!fm-\w+!//g;
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  検索実行ページ
#-----------------------------------------------------------
sub find_data {
	return if ($in{word} eq '');
	
	# ページ数
	$in{pg} =~ s/\D//g;
	my $pg = $in{pg} || 0;
	
	# 表示件数
	$in{list} =~ s/\D//g;
	if ($in{list} <= 0) { $in{list} = 10; }
	
	# 検索実行
	my ($i,@find) = find_db($pg);
	
	# プルダウン
	my ($op_cond,$op_list) = pulldown();
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/list.html") or error("open err: list.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s/!(title|cmnurl|new_mark|[a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s|<!-- cat_menu -->.+?<!-- /cat_menu -->||s;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" class="icon" alt="">|g;
	$tmpl =~ s/!navi-ttl!/検索結果/;
	$tmpl =~ s/!word!/$in{word}/g;
	$tmpl =~ s/!keyword!/$in{word}/g;
	$tmpl =~ s/<!-- op_cond -->/$op_cond/g;
	$tmpl =~ s/<!-- op_list -->/$op_list/g;
	$tmpl =~ s/!hit!/$i/g;
	$tmpl =~ s/<!-- pager -->/make_pager($i,$pg,$in{list})/e;
	$tmpl =~ s/!mode!/$in{mode}/g;
	if ($in{cat1}) {
		$tmpl =~ s|!cat1!|$in{cat1}|s;
	} else {
		$tmpl =~ s|<input type="hidden" name="cat1" value="!cat1!">\s?||s;
	}
	if ($in{cat2}) {
		$tmpl =~ s|<!-- cat2 -->|<input type="hidden" name="cat2" value="$in{cat2}">|s;
	} else {
		$tmpl =~ s|<!-- cat2 -->\s?||s;
	}
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3) : error("テンプレート不正");
	
	# カテゴリ情報
	my %cat = categ();
	
	# 時間取得
	my $now = time;
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (@find) {
		my ($no,$cat,$scat,$sub,$url,$nam,$eml,$msg,$tim,$rec) = split(/<>/);
		$msg =~ s/\t/<br>/g;
		
		my $tmp = $loop;
		$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
		$tmp =~ s|!site-name!|<a href="$url" target="_blank">$sub</a>|g;
		$tmp =~ s#!cate!#<a href="$cf{rooturl}/html/$cat-1.html">$cat{$cat}{0}</a>#g;
		$tmp =~ s#!sub!#<a href="$cf{rooturl}/html/$cat/$scat-1.html">$cat{$cat}{$scat}</a>#g;
		$tmp =~ s|!comment!|$msg|g;
		$tmp =~ s|!num!|$no|g;
		$tmp =~ s|<!-- recom -->|<img src="$cf{cmnurl}/cool.gif" class="icon" alt="Cool">|g if ($rec == 1);
		$tmp =~ s/!name!/$nam/;
		$tmp =~ s/!date!/chg_date($tim)/e;
		
		print $tmp;
	}
	
	# フッタ
	print footer($foot);
	exit;
}

#-----------------------------------------------------------
#  ペイジャー作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$pg,$pgmax) = @_;
	
	# 引数
	my $param = "&amp;mode=$in{mode}";
	if ($in{word} ne '') {
		my $word = url_enc($in{word});
		$param .= "&amp;word=$word&amp;cond=$in{cond}&amp;list=$pgmax";
	}
 	$param .= "&amp;cat=$in{cat}";
	$param .= "&amp;sub=$in{sub}" if ($in{sub} ne '');
	
	# 繰越数定義
	$pgmax ||= 10;
	my $next = $pg + $pgmax;
	my $back = $pg - $pgmax;
	
	# ペイジャー作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<a href="#" class="page active">$x</a>\n!);
			} else {
				push(@pg,qq!<a href="$cf{bbs_cgi}?pg=$y$param" class="page gradient">$x</a>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while(@pg >= 11) { shift(@pg); }
	my $ret = join('',@pg);
	if ($back >= 0) {
		$ret = qq!<a href="$cf{bbs_cgi}?pg=$back$param" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<a href="$cf{bbs_cgi}?pg=$next$param" class="page gradient">&raquo;</a>\n!;
	}
	
	# 結果を返す
	return $ret ? qq|<div class="pagination">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  検索実行
#-----------------------------------------------------------
sub find_db {
	my ($pg) = @_;
	if ($in{list} eq '') { $in{list} = 10; }
	if ($in{cond} eq '') { $in{cond} = 1; }
	
	# 入力内容調整
	$in{word} =~ s/　/ /g;
	my @wd = split(/\s+/,$in{word});
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# 検索
	my $i = 0;
	my @find;
	open(IN,"$cf{datadir}/data.dat");
	while (<IN>) {
		my (undef,$cat1,$cat2,$sub,$url,undef,undef,$msg,undef,undef) = split(/<>/);
		
		# 大カテ
		next if ($in{cat1} ne '' && $in{cat1} != $cat1);
		
		# 小カテ
		next if ($in{cat2} ne '' && $in{cat2} != $cat2);
		
		my $flg;
		for my $wd (@wd) {
			if ("$sub $url $msg" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
				$flg = 1;
				if ($in{cond} == 0) { last; }
			} else {
				if ($in{cond} == 1) { $flg = 0; last; }
			}
		}
		if ($flg) {
			$i++;
			next if ($i < $pg + 1);
			next if ($i > $pg + $in{list});
			
			push(@find,$_);
		}
	}
	close(IN);
	
	# 検索結果
	return ($i,@find);
}

#-----------------------------------------------------------
#  プルダウン作成
#-----------------------------------------------------------
sub pulldown {
	my @cond = qw(OR AND);
	my ($op_cond,$op_list);
	for (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected>$cond[$_]\n|;
		} else {
			$op_cond .= qq|<option value="$_">$cond[$_]\n|;
		}
	}
	for ( split(/,/,$cf{op_list}) ) {
		if ($in{list} eq $_) {
			$op_list .= qq|<option value="$_" selected>$_件\n|;
		} else {
			$op_list .= qq|<option value="$_">$_件\n|;
		}
	}
	return ($op_cond,$op_list);
}

#-----------------------------------------------------------
#  URLエンコード
#-----------------------------------------------------------
sub url_enc {
	local($_) = @_;
	
	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

#-----------------------------------------------------------
#  新規登録
#-----------------------------------------------------------
sub regi_data {
	if ($cf{reg_type} != 1) { error("不正な要求です"); }
	
	# 投稿チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正なリクエストです");
	}
	
	# 入力チェック
	input_check();
	
	# 画像認証チェック
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			error("画像認証が入力不備です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
		
		# 投稿キーチェック
		# -1 : キー不一致
		#  0 : 制限時間オーバー
		#  1 : キー一致
		my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
		if ($chk == 0) {
			error("画像認証が制限時間を超過しました。<br>投稿フォームに戻って再読込み後、指定の数字を再入力してください");
		} elsif ($chk == -1) {
			error("画像認証が不正です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
	}
	
	my ($cat1,$cat2) = split(/:/,$in{cate});
	my $time = time;
	my ($host,$addr) = get_host();
	
	# カテゴリ情報
	my %cat = categ();
	
	my $c1num = 1;
	my $c2num = 1;
	my $all = 1;
	my ($flg,@log,@clog,%clnk,%tlnk);
	open(DB,"$cf{datadir}/data.dat") or error("open err: data");
	while(<DB>) {
		my ($no,$cat,$scat,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		
		# 重複チェック
		if ($in{url} eq $url) {
			$flg++;
			last;
		}
	}
	close(DB);
	
	# 重複エラー
	if ($flg) {	error("このURLは登録済です"); }
	
	open(DB,">> $cf{datadir}/tmp.dat");
	eval "flock(DB,2);";
	print DB "$cat1<>$cat2<>$in{sub}<>$in{url}<>$in{name}<>$in{email}<>$in{comment}<>$time<>0<>$host<>\n";
	close(DB);
	
	# メール通知
	mailing($host) if ($cf{mailing} == 1);
	
	# 完了
	message("登録ありがとうございます。管理者の検証後に掲載されます。");
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub input_check {
	for (qw(name email url cate sub)) {
		$in{$_} =~ s/\t//g;
	}
	
	my $err;
	if ($in{name} eq "") { $err .= "名前が未入力です<br>"; }
	if ($in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) {
	 	$err .= "メールアドレスが不正です<br>";
	}
	if ($in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "URLの入力内容が不正です<br>";
	}
	if ($in{cate} eq "") { $err .= "分類が未選択です<br>"; }
	if ($in{sub} eq "") { $err .= "ページ名が未入力です<br>"; }
	if ($in{comment} eq "") { $err .= "紹介文が未入力です<br>"; }
	elsif (count_str($in{comment},$cf{com_limit}) == 1) {
		$err .= "紹介文は$cf{com_limit}文字以内です<br>";
	}
	
	# 禁止ワード
	my $flg;
	for ( split(/,/,$cf{ng_word}) ) {
		if (index($in{comment},$_) >= 0) {
			$flg++;
			last;
		}
	}
	if ($flg) { $err .= "使用禁止用語が含まれています<br>"; }
	
	# エラー
	if ($err) { error($err); }
}

#-----------------------------------------------------------
#  文字カウント for UTF-8
#-----------------------------------------------------------
sub count_str {
	my ($str,$lmt) = @_;
	$str =~ s/\t//g;
	
	my ($i,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		if ($i >= $lmt) {
			$flg++;
			last;
		}
	}
	
	return $flg;
}

#-----------------------------------------------------------
#  ホスト名取得
#-----------------------------------------------------------
sub get_host {
	my $host = $ENV{'REMOTE_HOST'};
	my $addr = $ENV{'REMOTE_ADDR'};
	
	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	if ($host eq "") { $host = $addr; }
	
	return ($host,$addr);
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;
	
	open(IN,"$cf{tmpldir}/mesg.html") or error("open err: mesg.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s/!(title|navi_cgi|admin_cgi|cmnurl)!/$cf{$1}/g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s/!message!/$msg/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" class="icon" alt="$1">|g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s/!(title|cmnurl|navi_cgi|admin_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" class="icon" alt="$1">|g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  メール通知
#-----------------------------------------------------------
sub mailing {
	my ($host) = @_;
	my $date = chg_date(time);
	
	# 件名をMIMEエンコード
	require "./lib/jacode.pl";
	my $msub = mime_unstructured_header("BBS : $in{sub}");
	
	# コメント内の改行復元
	my $com = $in{comment};
	$com =~ s/\t/\n/g;
	$com =~ s/&lt;/>/g;
	$com =~ s/&gt;/</g;
	$com =~ s/&quot;/"/g;
	$com =~ s/&amp;/&/g;
	$com =~ s/&#39;/'/g;
	
	# メール本文を定義
	my $body = <<EOM;
$cf{title} に登録申請がありました。

投稿日：$date
ホスト：$host

件名  ：$in{sub}
お名前：$in{name}
E-mail：$in{email}
URL   ：$in{url}

$com
EOM

	# JISコード変換
	my $mbody;
	for my $tmp ( split(/\n/,$body) ) {
		jcode::convert(\$tmp,'jis','utf8');
		$mbody .= "$tmp\n";
	}
	
	# メールアドレスがない場合は管理者メールに置き換え
	$in{email} ||= $cf{mailto};
	
	# sendmailコマンド
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) { $scmd .= " -f $in{email}"; }
	
	# 送信
	open(MAIL,"| $scmd") or error("送信失敗");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $in{email}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  mimeエンコード
#  [quote] http://www.din.or.jp/~ohzaki/perl.htm#JP_Base64
#-----------------------------------------------------------
sub mime_unstructured_header {
  my $oldheader = shift;
  jcode::convert(\$oldheader,'euc','utf8');
  my ($header,@words,@wordstmp,$i);
  my $crlf = $oldheader =~ /\n$/;
  $oldheader =~ s/\s+$//;
  @wordstmp = split /\s+/, $oldheader;
  for ($i = 0; $i < $#wordstmp; $i++) {
    if ($wordstmp[$i] !~ /^[\x21-\x7E]+$/ and
	$wordstmp[$i + 1] !~ /^[\x21-\x7E]+$/) {
      $wordstmp[$i + 1] = "$wordstmp[$i] $wordstmp[$i + 1]";
    } else {
      push(@words, $wordstmp[$i]);
    }
  }
  push(@words, $wordstmp[-1]);
  foreach my $word (@words) {
    if ($word =~ /^[\x21-\x7E]+$/) {
      $header =~ /(?:.*\n)*(.*)/;
      if (length($1) + length($word) > 76) {
	$header .= "\n $word";
      } else {
	$header .= $word;
      }
    } else {
      $header = add_encoded_word($word, $header);
    }
    $header =~ /(?:.*\n)*(.*)/;
    if (length($1) == 76) {
      $header .= "\n ";
    } else {
      $header .= ' ';
    }
  }
  $header =~ s/\n? $//mg;
  $crlf ? "$header\n" : $header;
}
sub add_encoded_word {
  my ($str, $line) = @_;
  my $result;
  my $ascii = '[\x00-\x7F]';
  my $twoBytes = '[\x8E\xA1-\xFE][\xA1-\xFE]';
  my $threeBytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';
  while (length($str)) {
    my $target = $str;
    $str = '';
    if (length($line) + 22 +
	($target =~ /^(?:$twoBytes|$threeBytes)/o) * 8 > 76) {
      $line =~ s/[ \t\n\r]*$/\n/;
      $result .= $line;
      $line = ' ';
    }
    while (1) {
      my $encoded = '=?ISO-2022-JP?B?' .
      b64encode(jcode::jis($target,'euc','z')) . '?=';
      if (length($encoded) + length($line) > 76) {
	$target =~ s/($threeBytes|$twoBytes|$ascii)$//o;
	$str = $1 . $str;
      } else {
	$line .= $encoded;
	last;
      }
    }
  }
  $result . $line;
}
# [quote] http://www.tohoho-web.com/perl/encode.htm
sub b64encode {
    my $buf = shift;
    my ($mode,$tmp,$ret);
    my $b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                . "abcdefghijklmnopqrstuvwxyz"
                . "0123456789+/";
	
    $mode = length($buf) % 3;
    if ($mode == 1) { $buf .= "\0\0"; }
    if ($mode == 2) { $buf .= "\0"; }
    $buf =~ s/(...)/{
        $tmp = unpack("B*", $1);
        $tmp =~ s|(......)|substr($b64, ord(pack("B*", "00$1")), 1)|eg;
        $ret .= $tmp;
    }/eg;
    if ($mode == 1) { $ret =~ s/..$/==/; }
    if ($mode == 2) { $ret =~ s/.$/=/; }
    
    return $ret;
}

