#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Cosmo Navigator : admin.cgi - 2022/05/14
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use DBI;
use vars qw(%in %cf);
use lib "./lib";
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
%in = parse_form();

# 認証
require "./lib/login.pl";
auth_login();

# 管理モード
if ($in{data_new}) { data_new(); }
if ($in{data_men}) { data_men(); }
if ($in{set_base}) { set_base(); }
if ($in{upd_html}) { upd_html(); }
if ($in{pass_mgr}) { pass_mgr(); }
if ($in{app_data}) { app_data(); }
menu_top();

#-----------------------------------------------------------
#  管理トップ
#-----------------------------------------------------------
sub menu_top {
	header("メニューTOP");
	print <<EOM;
<ul>
<li>選択ボタンを押してください。
</ul>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th></th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>新規データ登録</td>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>登録データ管理</td>
</tr>
EOM

	if ($cf{reg_type} == 1) {
		print qq|<tr><td><input type="submit" name="app_data" value="選択"></td>\n|;
		print qq|<td>データ承認</td></tr>\n|;
	}
	
	print <<EOM;
<tr>
	<td><input type="submit" name="set_base" value="選択"></td>
	<td>基本設定</td>
</tr><tr>
	<td><input type="submit" name="upd_html" value="選択"></td>
	<td>HTML再構築</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ管理
#-----------------------------------------------------------
sub data_men {
	# 推薦
	if ($in{job} eq "reco" && $in{no}) { reco_db(); }
	
	# 削除
	elsif ($in{job} eq "dele" && $in{no}) { dele_db(); }
	
	# 修正画面
	elsif ($in{job} eq "form" && $in{no}) { form_db(); }
	
	# 修正実行
	elsif ($in{job} eq "edit") { edit_db(); }
	
	# ページ数
	my $page = 0;
	for ( keys %in ) {
		if (/^page:(\d+)/) {
			$page = $1;
			last;
		}
	}
	
	# 最大表示件数
	my $logs = 30;
	
	header("管理モード");
	back_btn();
	print <<EOM;
<div id="body">
<p class="ttl">■登録データ管理</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="sid" value="$in{sid}">
分類：
<select name="cat">
EOM

	if ($in{cate1} ne '') { $in{cat} = $in{cate1}; }
	my @categ = split(/;/,$cf{categ});
	for my $i (0 .. $#categ) {
		my @part = split(/,/,$categ[$i]);
		
		if ($in{cat} == $i) {
			print qq|<option value="$i" selected>$part[0]\n|;
		} else {
			print qq|<option value="$i">$part[0]\n|;
		}
	}
	
	# カテゴリ情報
	my %cat = categ();
	
	print <<EOM;
</select>
<input type="submit" value="切替"><br>
処理：
<select name="job">
<option value="">▼選択
<option value="form">修正
<option value="reco">推薦
<option value="dele">削除
</select>
<input type="submit" value="送信する">
<dl>
EOM

	my $i;
	open(IN,"$cf{datadir}/data.dat");
	while(<IN>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		next if ($in{cat} != $cat1);
		
		$i++;
		next if ($i < $page + 1);
		last if ($i > $page + $logs);
		
		my $date = get_time($tim);
		print qq|<dt><hr><input type="radio" name="no" value="$no">\n|;
		print qq|<span class="red">[推薦]</span>\n| if ($rec == 1);
		print qq|<b>$sub</b> [ $cat{$cat1}{0} &gt; $cat{$cat1}{$cat2} ]\n|;
		print qq|管理者：$nam 【$ip】登録日：$date|;
		print qq|<dd>[参照] <a href="$url">$url</a>|;
		print qq|<dd>[内容] <span style="font-size:12px">$msg</span>\n|;
	}
	close(IN);
	
	print <<EOM;
<dt><hr>
</dl>
EOM

	# ページ繰越定義
	my $next = $page + $logs;
	my $back = $page - $logs;
	if ($back >= 0) {
		print qq|<input type="submit" name="page:$back" value="前ページ">\n|;
	}
	if ($next < $i) {
		print qq|<input type="submit" name="page:$next" value="次ページ">\n|;
	}
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  オススメマーク
#-----------------------------------------------------------
sub reco_db {
	# カテゴリ情報
	my %cat = categ();
	
	my $c1num = 0;
	my $c2num = 0;
	my ($cate1,$cate2,@log,@clog,%clnk,%tlnk);
	open(DAT,"+< $cf{datadir}/data.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		
		# カテゴリ情報を取得
		if ($in{no} == $no) {
			$cate1 = $cat1;
			$cate2 = $cat2;
			last;
		}
	}
	
	# 巻き戻す
	seek(DAT,0,0);
	
	# 再度展開
	while(<DAT>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		if ($in{no} == $no) {
			$rec = $rec == 1 ? 0 : 1;
			$_ = "$no<>$cat1<>$cat2<>$sub<>$url<>$nam<>$eml<>$msg<>$tim<>$rec<>$ip<>\n";
		}
		
		$tlnk{$cat1}++;
		$tlnk{"$cat1-$cat2"}++;
		if ($cate1 == $cat1) {
			$c1num++;
			push(@clog,$_);
			if ($cate2 == $cat2) { $c2num++; }
			$clnk{"$cat1-$cat2"}++;
		}
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	my $all = @log;
	
	# HTML更新
	make_html($cate1,\%cat,$c1num,\@clog,$all,\%clnk,\%tlnk);
}

#-----------------------------------------------------------
#  削除
#-----------------------------------------------------------
sub dele_db {
	# カテゴリ情報
	my %cat = categ();
	
	my $c1num = 0;
	my $c2num = 0;
	my ($cate1,$cate2,@log,@clog,%clnk,%tlnk);
	open(DAT,"+< $cf{datadir}/data.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		
		# カテゴリ情報を取得
		if ($in{no} == $no) {
			$cate1 = $cat1;
			$cate2 = $cat2;
			last;
		}
	}
	
	# 巻き戻す
	seek(DAT,0,0);
	
	# 再度展開
	while(<DAT>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		next if ($in{no} == $no);
		
		$tlnk{$cat1}++;
		$tlnk{"$cat1-$cat2"}++;
		if ($cate1 == $cat1) {
			$c1num++;
			push(@clog,$_);
			if ($cate2 == $cat2) { $c2num++; }
			$clnk{"$cat1-$cat2"}++;
		}
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	my $all = @log;
	
	# HTML更新
	make_html($cate1,\%cat,$c1num,\@clog,$all,\%clnk,\%tlnk);
}

#-----------------------------------------------------------
#  修正指示
#-----------------------------------------------------------
sub form_db {
	if ($in{no} =~ /\0/) { error('複数の修正指定があります'); }
	
	my $log;
	open(IN,"$cf{datadir}/data.dat");
	while(<IN>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		
		if ($in{no} == $no) {
			$log = $_;
			last;
		}
	}
	close(IN);
	
	my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/,$log);
	
	# 修正フォーム
	reg_form($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip);
}

#-----------------------------------------------------------
#  登録フォーム
#-----------------------------------------------------------
sub reg_form {
	my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = @_;
	$msg =~ s/\t/\n/g;
	
	my ($hidden,$catsel,$mode);
	if ($in{no}) {
		$hidden .= qq|<input type="hidden" name="data_men" value="1">\n|;
		$hidden .= qq|<input type="hidden" name="job" value="edit">\n|;
		$hidden .= qq|<input type="hidden" name="no" value="$in{no}">\n|;
		$hidden .= qq|<input type="hidden" name="cate1" value="$cat1">\n|;
		$hidden .= qq|<input type="hidden" name="cate2" value="$cat2">\n|;
		$mode = 'data_men';
		
		my %cat = categ();
		$catsel .= qq|$cat{$cat1}{0} &gt; $cat{$cat1}{$cat2}\n|;
	} else {
		$hidden .= qq|<input type="hidden" name="data_new" value="1">\n|;
		$hidden .= qq|<input type="hidden" name="job" value="reg">\n|;
		$catsel .= qq|<select name="cate" size="8">| . op_cate() . "</select>\n";
	}
	
	header("登録フォーム");
	back_btn($mode);
	print <<EOM;
<p class="ttl">■登録フォーム</p>
<ul>
<li>内容を入力してください。
<li>「メールアドレス」は任意です。
</ul>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
$hidden
<table class="form-tbl">
<tr>
	<th>お名前</th>
	<td><input type="text" name="name" size="30" value="$nam"></td>
</tr><tr>
	<th>e-mail</th>
	<td><input type="text" name="email" size="30" value="$eml"></td>
</tr><tr>
	<th>URL</th>
	<td><input type="text" name="url" size="50" value="$url"></td>
</tr><tr>
	<th>分類</th>
	<td>$catsel</td>
</tr><tr>
	<th>タイトル</th>
	<td><input type="text" name="sub" size="50" value="$sub"></td>
</tr><tr>
	<th>内容</td>
	<td><textarea name="msg" cols="50" rows="4">$msg</textarea></td>
</tr><tr>
	<th></td>
	<td><input type="submit" value="送信する"></td>
</tr>
</table>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  修正実行
#-----------------------------------------------------------
sub edit_db {
	# カテゴリ情報
	my %cat = categ();
	
	$in{msg} =~ s/\t+$//;
	
	my $c1num = 0;
	my $c2num = 0;
	my ($cate1,$cate2,@log,@clog,%clnk,%tlnk);
	open(DAT,"+< $cf{datadir}/data.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($no,$cat1,$cat2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		if ($in{no} == $no) {
			$_ = "$no<>$cat1<>$cat2<>$in{sub}<>$in{url}<>$in{name}<>$in{email}<>$in{msg}<>$tim<>$rec<>$ip<>\n";
		}
		
		$tlnk{$cat1}++;
		$tlnk{"$cat1-$cat2"}++;
		if ($in{cate1} == $cat1) {
			$c1num++;
			push(@clog,$_);
			if ($in{cate2} == $cat2) { $c2num++; }
			$clnk{"$cat1-$cat2"}++;
		}
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	my $all = @log;
	
	# HTML更新
	make_html($in{cate1},\%cat,$c1num,\@clog,$all,\%clnk,\%tlnk);
	
	message("修正完了しました","data_men");
}

#-----------------------------------------------------------
#  新規登録
#-----------------------------------------------------------
sub data_new {
	if ($in{job} eq 'reg') {
		if ($in{name} eq '' or $in{url} eq '' or $in{sub} eq '' or $in{msg} eq '') {
			error("入力内容に不備があります");
		}
		$in{msg} =~ s/\t+$//;
		
		# カテゴリ情報
		my %cat = categ();
		my ($cat1,$cat2) = split(/:/,$in{cate});
		my $time = time;
		my $host = 'admin';
		
		# データNo
		open(DAT,"+< $cf{datadir}/num.dat") or error("open err: num.dat");
		eval "flock(DAT,2);";
		my $num = <DAT> + 1;
		seek(DAT,0,0);
		print DAT $num;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		my $c1num = 1;
		my $c2num = 1;
		my ($flg,@log,@clog,%clnk,%tlnk);
		open(DB,"+< $cf{datadir}/data.dat") or error("open err: data");
		eval "flock(DB,2);";
		while(<DB>) {
			my ($no,$cat,$scat,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
			
			# 重複チェック
			if ($in{url} eq $url) {
				$flg++;
				last;
			}
			
			$tlnk{$cat}++;
			$tlnk{"$cat-$scat"}++;
			
			if ($cat1 == $cat) {
				$c1num++;
				push(@clog,$_);
				if ($cat2 == $scat) { $c2num++; }
				$clnk{"$cat-$scat"}++;
			}
			push(@log,$_);
		}
		
		# 重複エラー
		if ($flg) {
			close(DB);
			error("このURLは登録済です");
		}
		
		# 新規追加
		unshift(@log,"$num<>$cat1<>$cat2<>$in{sub}<>$in{url}<>$in{name}<>$in{email}<>$in{msg}<>$time<>0<>$host<>\n");
		unshift(@clog,"$num<>$cat1<>$cat2<>$in{sub}<>$in{url}<>$in{name}<>$in{email}<>$in{msg}<>$time<>0<>$host<>\n");
		
		# 更新
		seek(DB,0,0);
		print DB @log;
		truncate(DB,tell(DB));
		close(DB);
		
		$tlnk{$cat1}++;
		$tlnk{"$cat1-$cat2"}++;
		$clnk{"$cat1-$cat2"}++;
		my $all = @log;
		
		# HTML生成
		make_html($cat1,\%cat,$c1num,\@clog,$all,\%clnk,\%tlnk);
		
		message("登録完了しました","data_new");
	}
	
	# 新規フォーム
	reg_form();
}

#-----------------------------------------------------------
#  基本設定
#-----------------------------------------------------------
sub set_base {
	# --- 更新
	if ($in{submit}) {
		
		$in{top_msg} =~ s/\t+$//g;
		$in{top_msg} =~ s/\t/<br>/g;
		$in{categ} =~ s/\t+$//g;
		$in{categ} =~ s/\t/;/g;
		
		# ファイル上書き
		my @log;
		for (qw(title reg_type op_list pg_max new_mark com_limit new_site top_msg ng_word categ)) {
			push(@log,"$_\t$in{$_}\n");
		}
		open(DAT,"> $cf{datadir}/set.dat");
		print DAT @log;
		close(DAT);
		
		# 完了メッセージ
		message("基本設定を更新しました","set_base","upd");
	}
	$cf{top_msg} =~ s/<br>/\n/g;
	$cf{categ} =~ s/;/\n/g;
	
	header("基本設定");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 基本設定</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="set_base" value="1">
<table class="form-tbl">
<tr>
	<th>サイト名称</th>
	<td><input type="text" name="title" size="40" value="$cf{title}"></td>
</tr><tr>
	<th>登録モード</th>
	<td>
EOM

	my %ox = (0 => '管理者限定', 1 => 'ユーザ及び管理者');
	for (0,1) {
		if ($cf{reg_type} = $_) {
			print qq|<input type="radio" name="reg_type" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="reg_type" value="$_">$ox{$_}\n|;
		}
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th>検索時件数候補<br>(プルダウン)</th>
	<td>
		<input type="text" name="op_list" size="20" value="$cf{op_list}">
		（コンマで区切る）
	</td>
</tr><tr>
	<th>ページ当たり<br>表示数</th>
	<td><input type="number" name="pg_max" size="2" value="$cf{pg_max}"> 件</td>
</tr><tr>
	<th>NEWマーク</th>
	<td><input type="number" name="new_mark" size="2" value="$cf{new_mark}"> 日間表示</td>
</tr><tr>
	<th>紹介コメント</th>
	<td><input type="number" name="com_limit" size="2" value="$cf{com_limit}"> 文字まで</td>
</tr><tr>
	<th>新着情報の表示</th>
	<td><input type="number" name="new_site" size="2" value="$cf{new_site}"> 件</td>
</tr><tr>
	<th>TOPお知らせ</th>
	<td><textarea name="top_msg" cols="60" rows="2">$cf{top_msg}</textarea></td>
</tr><tr>
	<th>禁止ワード</th>
	<td><input type="text" name="ng_word" size="40" value="$cf{ng_word}"> （コンマで区切る）</td>
</tr><tr>
	<th>カテゴリー</th>
	<td>
		内容をコンマで区切り、先頭が「主カテゴリ」以降が「副カテゴリ」<br>
		<textarea name="categ" cols="80" rows="11">$cf{categ}</textarea></td>
</tr><tr>
	<th></th>
	<td><input type="submit" name="submit" value="更新する" class="big-btn"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTML再構築
#-----------------------------------------------------------
sub upd_html {
	# --- 更新
	if ($in{submit}) {
		update_html();
		
		# 完了メッセージ
		message("全画面を再構築しました");
	}
	$cf{top_msg} =~ s/<br>/\n/g;
	$cf{categ} =~ s/;/\n/g;
	
	header("HTML再構築");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ HTML再構築</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="upd_html" value="1">
<table class="form-tbl">
<tr>
	<td>
		<p>
		・全画面を再構築します。<br>
		・登録件数が多い場合、サーバに過負荷がかかることがあります。
		</p>
		<p class="ta-c"><input type="submit" name="submit" value="再構築する" class="big-btn"></p>
	</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ承認
#-----------------------------------------------------------
sub app_data {
	my ($ok,$ng);
	for ( keys %in ) {
		if (/^ok:(\d+)/) {
			$ok = $1;
			last;
		} elsif (/^ng:(\d+)/) {
			$ng = $1;
			last;
		}
	}
	if ($ok) { add_data($ok); }
	elsif ($ng) {
		my @log;
		open(DAT,"+< $cf{datadir}/tmp.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($cat,$scat,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/);
			next if ($ng == $time);
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	# --- 更新
	if ($in{submit}) {
		
		$in{top_msg} =~ s/\t+$//g;
		$in{top_msg} =~ s/\t/<br>/g;
		$in{categ} =~ s/\t+$//g;
		$in{categ} =~ s/\t/;/g;
		
		# ファイル上書き
		my @log;
		for (qw(title op_list pg_max new_mark com_limit top_msg ng_word categ)) {
			push(@log,"$_\t$in{$_}\n");
		}
		open(DAT,"> $cf{datadir}/set.dat");
		print DAT @log;
		close(DAT);
		
		# 完了メッセージ
		message("基本設定を更新しました","set_base");
	}
	my %cat = categ();
	
	header("データ承認");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ データ承認</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="app_data" value="1">
<table class="form-tbl">
<tr>
	<th>判定</th>
	<th>日時</th>
	<th>タイトル/カテゴリ</th>
	<th class="w-30">URL/内容</th>
	<th>名前/ホスト</th>
</tr>
EOM

	my $i;
	open(DB,"$cf{datadir}/tmp.dat");
	while(<DB>) {
		$i++;
		my ($cat,$scat,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/);
		$url = qq|<a href="$url" target="_blank">$url</a>|;
		
		print qq|<tr><td><input type="submit" name="ok:$time" value="承認">\n|;
		print qq|<input type="submit" name="ng:$time" value="削除"></td>|;
		print qq|<td>| . get_time($time) . qq|</td>|;
		print qq|<td><b>$sub</b><br>$cat{$cat}{0} &gt; $cat{$cat}{$scat}</td>|;
		print qq|<td class="small w-25">$url<br>$msg</td>|;
		print qq|<td><b>$name</b><br>$ip</td></tr>\n|;
	}
	close(DB);
	
	if (!$i) {
		print qq|<tr><td colspan="5" class="ta-c">承認待ちデータはありません</td></tr>\n|;
	}
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ追加
#-----------------------------------------------------------
sub add_data {
	my $ok = shift;
	
	my ($add,@log);
	open(DAT,"+< $cf{datadir}/tmp.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($cat,$scat,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/);
		if ($ok == $time) {
			$add = $_;
			next;
		}
		
		push(@log,$_);
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	open(DAT,"+< $cf{datadir}/num.dat");
	eval "flock(DAT,2);";
	my $num = <DAT> + 1;
	seek(DAT,0,0);
	print DAT $num;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	my ($cat1,$cat2,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/,$add);
	
	my %cat = categ();
	my $c1num = 1;
	my $c2num = 1;
	my (@log,@clog,%clnk,%tlnk);
	open(DAT,"+< $cf{datadir}/data.dat");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($no,$cat,$scat,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/);
		
		$tlnk{$cat}++;
		$tlnk{"$cat-$scat"}++;
		
		if ($cat1 == $cat) {
			$c1num++;
			push(@clog,$_);
			if ($cat2 == $scat) { $c2num++; }
			$clnk{"$cat-$scat"}++;
		}
		push(@log,$_);
	}
	unshift(@log,"$num<>$add");
	unshift(@clog,"$num<>$add");
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	$tlnk{$cat1}++;
	$tlnk{"$cat1-$cat2"}++;
	$clnk{"$cat1-$cat2"}++;
	my $all = @log;
	
	# HTML更新
	make_html($cat1,\%cat,$c1num,\@clog,$all,\%clnk,\%tlnk);
}

#-----------------------------------------------------------
#  再構築
#-----------------------------------------------------------
sub update_html {
	my %cate = categ();
	my ($all,@clog,%clnk,%tlnk,%cat);
	open(DAT,"$cf{datadir}/data.dat");
	while(<DAT>) {
		$all++;
		my ($no,$cat,$scat,$sub,$url,$name,$eml,$msg,$time,$rec,$ip) = split(/<>/);
		
		$tlnk{$cat}++;
		$tlnk{"$cat-$scat"}++;
		$cat{$cat}++;
		$clnk{$cat}{"$cat-$scat"}++;
		
		push(@{$clog[$cat]},$_);
	}
	close(DAT);
	
	my $i = 0;
	for my $cat1 ( keys %cat ) {
		my %clnk2;
		for ( keys %{$clnk{$cat1}} ) {
			$clnk2{$_} = $clnk{$cat1}{$_};
		}
		make_html($cat1,\%cate,$cat{$cat1},\@{$clog[$cat1]},$all,\%clnk2,\%tlnk,$i);
		$i++;
	}
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!DOCTYPE html>
<head>
<meta charset="utf-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="star" class="icon">
	CosmoNavi 管理画面 ::
</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="err">
<p><b>ERROR!</b></p>
<p class="err">$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg,$mode,$upd) = @_;
	
	header("処理完了");
	print <<EOM;
<div id="msg">
<p class="msg">$msg</p>
<p>
	<form action="$cf{admin_cgi}" method="post">
	<input type="hidden" name="sid" value="$in{sid}">
	<input type="submit" value="管理画面に戻る" class="big-btn">
	<input type="hidden" name="$mode" value="1">
	</form>
</p>
EOM

	if ($upd eq 'upd') {
		print qq|<p>全画面に反映させるため、HTMLを再構築する場合は以下のボタンを押します。</p>\n|;
		print qq|<p><form action="$cf{admin_cgi}" method="post">\n|;
		print qq|<input type="hidden" name="sid" value="$in{sid}">\n|;
		print qq|<input type="hidden" name="upd_html" value="1">\n|;
		print qq|<input type="submit" name="submit" value="全画面を再構築" class="big-btn">\n|;
		print qq|</form></p>\n|;
	}
	
	print <<EOM;
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  時間取得
#-----------------------------------------------------------
sub get_time {
	my ($time) = @_;
	
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	sprintf("%04d/%02d/%02d-%02d:%02d",$year+1900,$mon+1,$mday,$hour,$min);
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my $mode = shift;
	
	print <<EOM;
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
@{[ $mode ? qq|<input type="submit" name="$mode" value="&lt; 前画面">| : "" ]}
<input type="submit" value="メニュー">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  HTML生成
#-----------------------------------------------------------
sub make_html {
	my ($cat1,$cat,$c1num,$clog,$all,$clnk,$tlnk,$upd) = @_;
	
	my @categ = split(/;/,$cf{categ});
	
	# テンプレート
	open(IN,"$cf{tmpldir}/list.html") or error("open err: list.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||gs if ($cf{reg_type} != 1);
	$tmpl =~ s/!(title|navi_cgi|cmnurl|new_mark|admin_cgi)!/$cf{$1}/g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" class="icon" alt="$1">|g;
	$tmpl =~ s/<!-- op_cond -->/op_cond()/e;
	$tmpl =~ s/<!-- op_list -->/op_list()/e;
	$tmpl =~ s/!cat1!/$cat1/g;
	$tmpl =~ s/!word!//g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3) : error("テンプレート不正");
	
	# 更新前HTMLを覚えておく
	my @old1 = glob("$cf{rootdir}/html/$cat1-*.html");
	my @old2 = glob("$cf{rootdir}/html/$cat1/*.html");
	
	# 大カテゴリ展開
	my ($i,$n,$html,%tmp,%new1,%new2);
	for (@{$clog}) {
		my ($no,$ct1,$ct2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
		$msg =~ s/\t/<br>/g;
		$i++;
		$tmp{$ct2} .= "$_\0";
		
		if ($i % $cf{pg_max} == 1) {
			$n++;
			$html = $head;
		}
		
		my $tmp = $loop;
		$tmp =~ s|!name!|$nam|g;
		$tmp =~ s|!comment!|$msg|g;
		$tmp =~ s|!site-name!|<a href="$url">$sub</a>|g;
		$tmp =~ s/!date!/chg_date($tim)/e;
		$tmp =~ s/!cate!/$$cat{$ct1}{0}/;
		$tmp =~ s/!sub!/$$cat{$ct1}{$ct2}/;
		$tmp =~ s/!num!/$no/;
		$tmp =~ s/!new!/chg_date($tim,'new')/e;
		$tmp =~ s|<!-- recom -->|<img src="$cf{cmnurl}/cool.gif" class="icon" alt="Cool">|g if ($rec == 1);
		
		$html .= $tmp;
		
		if ($i % $cf{pg_max} == 0) {
			$html .= $foot;
			$html =~ s/!hit!/$c1num/;
			$html =~ s/!navi-ttl!/$$cat{$cat1}{0}/;
			$html =~ s/!keyword!/$$cat{$cat1}{0}/;
			$html =~ s/<!-- pager -->/make_pager($c1num,$n,$cat1,undef)/e;
			$html =~ s|<!-- cat_cell -->(.+?)<!-- /cat_cell -->|cat_cell($1,$categ[$cat1],$cat1,$clnk)|se;
			
			# HTML生成 [大カテゴリ]
			open(DAT,"> $cf{rootdir}/html/$cat1-$n.html");
			print DAT $html;
			close(DAT);
			
			$new1{"$cf{rootdir}/html/$cat1-$n.html"}++;
		}
	}
	
	# ページ端数処理
	if ($i % $cf{pg_max} != 0) {
		$html .= $foot;
		$html =~ s/!hit!/$c1num/;
		$html =~ s/!navi-ttl!/$$cat{$cat1}{0}/;
		$html =~ s/!keyword!/$$cat{$cat1}{0}/;
		$html =~ s/<!-- pager -->/make_pager($c1num,$n,$cat1,undef)/e;
		$html =~ s|<!-- cat_cell -->(.+?)<!-- /cat_cell -->|cat_cell($1,$categ[$cat1],$cat1,$clnk)|se;
		
		# HTML生成 [大カテゴリ]
		open(DAT,"> $cf{rootdir}/html/$cat1-$n.html");
		print DAT $html;
		close(DAT);
		
		$new1{"$cf{rootdir}/html/$cat1-$n.html"}++;
	}
	
	# 小カテゴリ展開
	while( my ($key,$val) = each %tmp ) {
		my $cat2 = $key;
		my @tmp = split(/\0/,$val);
		my $c2num = @tmp;
		
		if (!-d "$cf{rootdir}/html/$cat1") { mkdir("$cf{rootdir}/html/$cat1",0755); }
		my ($i,$n,$html);
		for (@tmp) {
			my ($no,$ct1,$ct2,$sub,$url,$nam,$eml,$msg,$tim,$rec,$ip) = split(/<>/);
			$msg =~ s/\t/<br>/g;
			$i++;
			if ($i % $cf{pg_max} == 1) {
				$n++;
				$html = $head;
			}
			
			my $tmp = $loop;
			$tmp =~ s|!name!|$nam|g;
			$tmp =~ s|!comment!|$msg|g;
			$tmp =~ s|!site-name!|<a href="$url">$sub</a>|g;
			$tmp =~ s/!date!/chg_date($tim)/e;
			$tmp =~ s/!cate!/$$cat{$ct1}{0}/;
			$tmp =~ s/!sub!/$$cat{$ct1}{$ct2}/;
			$tmp =~ s/!num!/$no/;
			$tmp =~ s/!new!/chg_date($tim,'new')/e;
			$tmp =~ s|<!-- recom -->|<img src="$cf{cmnurl}/cool.gif" class="icon" alt="Cool">|g if ($rec == 1);
			
			$html .= $tmp;
			
			if ($i % $cf{pg_max} == 0) {
				$html .= $foot;
				$html =~ s/!hit!/$c2num/;
				$html =~ s/!navi-ttl!/$$cat{$cat1}{$cat2}/;
				$html =~ s/!keyword!/$$cat{$cat1}{0} : $$cat{$cat1}{$cat2}/;
				$html =~ s|<!-- navi_nest -->|<a href="$cf{rooturl}/html/$cat1-1.html">$$cat{$cat1}{0}</a> &gt;|;
				$html =~ s/<!-- pager -->/make_pager($c2num,$n,$cat1,$cat2)/e;
				$html =~ s|<!-- cat_cell -->.+?<!-- /cat_cell -->||s;
				$html =~ s/<!-- cat2 -->/<input type="hidden" name="cat2" value="$cat2">/;
				
				# HTML生成 [小カテゴリ]
				open(DAT,"> $cf{rootdir}/html/$cat1/$cat2-$n.html");
				print DAT $html;
				close(DAT);
				
				$new2{"$cf{rootdir}/html/$cat1/$cat2-$n.html"}++;
			}
		}
		if ($i % $cf{pg_max} != 0) {
			$html .= $foot;
			$html =~ s/!hit!/$c2num/;
			$html =~ s/!navi-ttl!/$$cat{$cat1}{$cat2}/;
			$html =~ s/!keyword!/$$cat{$cat1}{0} : $$cat{$cat1}{$cat2}/;
			$html =~ s|<!-- navi_nest -->|<a href="$cf{rooturl}/html/$cat1-1.html">$$cat{$cat1}{0}</a> &gt;|;
			$html =~ s/<!-- pager -->/make_pager($c2num,$n,$cat1,$cat2)/e;
			$html =~ s|<!-- cat_cell -->.+?<!-- /cat_cell -->||s;
			$html =~ s/<!-- cat2 -->/<input type="hidden" name="cat2" value="$cat2">/;
			
			# HTML生成 [小カテゴリ]
			open(DAT,"> $cf{rootdir}/html/$cat1/$cat2-$n.html");
			print DAT $html;
			close(DAT);
			
			$new2{"$cf{rootdir}/html/$cat1/$cat2-$n.html"}++;
		}
	}
	
	# 不要HTML整理
	for (@old1) {
		if (!defined $new1{$_}) { unlink($_); }
	}
	for (@old2) {
		if (!defined $new2{$_}) { unlink($_); }
	}
	
	# トップページ生成
	make_top($all,$tlnk) if (!$upd);
}

#-----------------------------------------------------------
#  ページ送り作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$n,$cat1,$cat2) = @_;
	my $pg = ($n - 1) * $cf{pg_max};
	
	# ページ繰越数定義
	$cf{pg_max} ||= 10;
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};
	
	# ページ繰越ボタン作成
	my ($cur,@pg);
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$cur = $x;
				$flg++;
				push(@pg,qq!<a href="#" class="page active">$x</a>\n!);
			} else {
				my $page = $cat2 eq '' ? "$cat1-$x" : "$cat1/$cat2-$x";
				push(@pg,qq!<a href="$cf{rooturl}/html/$page.html" class="page gradient">$x</a>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while(@pg >= 11) { shift(@pg); }
	my $ret = join('',@pg);
	if ($back >= 0) {
		my $key = ($back / $cf{pg_max}) + 1;
		my $page = $cat2 eq '' ? "$cat1-$key" : "$cat1/$cat2-$key";
		$ret = qq!<a href="$cf{rooturl}/html/$page.html" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		my $key = ($next / $cf{pg_max}) + 1;
		my $page = $cat2 eq '' ? "$cat1-$key" : "$cat1/$cat2-$key";
		$ret .= qq!<a href="$cf{rooturl}/html/$page.html" class="page gradient">&raquo;</a>\n!;
	}
	
	# 結果を返す
	return $ret ? qq|<div class="pagination">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  小カテゴリリンク
#-----------------------------------------------------------
sub cat_cell {
	my ($loop,$cat,$cat1,$clnk) = @_;
	$loop =~ s/[\r\n]//g;
	my @cat = split(/,/,$cat);
	
	my ($i,$ret);
	for (1 .. $#cat) {
		$i++;
		my $tmp = $loop;
		if (defined $$clnk{"$cat1-$_"}) {
			$tmp =~ s|!cat_name!|<a href="$cf{rooturl}/html/$cat1/$_-1.html">$cat[$_]</a>\n|;
		} else {
			$tmp =~ s|!cat_name!|$cat[$_]\n|;
		}
		
		# 1行は4セル
		if ($i > 1 && $i % 4 == 1) { $ret .= "</tr><tr>\n"; }
		
		$ret .= $tmp;
	}
	
	return $ret;
}

#-----------------------------------------------------------
#  TOP画面
#-----------------------------------------------------------
sub make_top {
	my ($all,$tlnk) = @_;
	
	my @categ = split(/;/,$cf{categ});
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/index.html") or error("open err: index.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- add_form -->.+?<!-- /add_form -->||sg if ($cf{reg_type} != 1);
	$tmpl =~ s/!(title|cmnurl|top_msg|[a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s|!topurl!|$cf{rooturl}/index.html|g;
	$tmpl =~ s/!all!/$all/g;
	$tmpl =~ s/<!-- op_cond -->/op_cond()/e;
	$tmpl =~ s/<!-- op_list -->/op_list()/e;
	$tmpl =~ s/!message!/$cf{top_msg}/;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3) : error("テンプレート不正");
	
	# ヘッダ
	my $html = $head;
	
	# カテゴリ展開
	my ($i,$tmp);
	for (0 .. $#categ) {
		$i++;
		my @cat = split(/,/,$categ[$_]);
		my $sub;
		for my $s (1 .. $#cat) {
			if (defined $$tlnk{"$_-$s"}) {
				$sub .= qq|<a href="$cf{rooturl}/html/$_/$s-1.html">$cat[$s]</a>,|;
			} else {
				$sub .= qq|$cat[$s],|;
			}
		}
		$sub =~ s/[,\s]+$//;
		
		$tmp = $loop;
		$tmp =~ s|!cate!|defined $$tlnk{$_} ? qq!<a href="$cf{rooturl}/html/$_-1.html">$cat[0]</a>! : $cat[0]|e;
		$tmp =~ s|!sub!|$sub|;
		$html .= $tmp;
	}
	
	# フッタ
	$html .= footer($foot);
	
	# HTML生成
	open(DAT,"> $cf{rootdir}/index.html");
	print DAT $html;
	close(DAT);
}

#-----------------------------------------------------------
#  件数プルダウン
#-----------------------------------------------------------
sub op_list {
	my $ret;
	for ( split(/,/,$cf{op_list}) ) {
		$ret .= qq|<option value="$_">$_件\n|;
	}
	return $ret;
}

#-----------------------------------------------------------
#  条件プルダウン
#-----------------------------------------------------------
sub op_cond {
	my %cond = (1 => 'AND', 0 => 'OR');
	my $ret;
	for (1,0) {
		$ret .= qq|<option value="$_">$cond{$_}\n|;
	}
	return $ret;
}

