# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Cosmo Navigator : init.cgi - 2023/12/24
#│ copyright (c) kentweb, 1997-2023
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'CosmoNavi v6.01';
#┌─────────────────────────────────
#│[ 注意事項 ]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。メール
#│    による質問はご遠慮ください。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# naviフォルダ
# 上段：URLパス（http(s)から指定）
# 下段：サーバパス
$cf{rooturl} = 'http://www.example.com/navi';
$cf{rootdir} = '..';

# sysディレクトリ【URLパス】（http(s)から指定）
$cf{sysurl} = 'http://www.example.com/navi/sys';

# 本体CGIファイル（URLパス）
$cf{navi_cgi} = "$cf{sysurl}/navi.cgi";

# 管理CGIファイル（URLパス）
$cf{admin_cgi} = "$cf{sysurl}/admin.cgi";

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = "$cf{rooturl}/cmn";

# ユーザ登録時メール通知
# → 0=no  1=yes
$cf{mailing} = 0;

# メール通知先アドレス（メール通知する場合）
$cf{mailto} = 'xxx@xxx.xx';

# sendmailのパス（メール通知する場合）
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailの -fコマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# 記事の更新は method=POST 限定する場合（セキュリティ対策）
# → 0=no 1=yes
$cf{postonly} = 1;

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

# -------------------------------------------------------------- #
# [ 以下は「画像認証機能」機能（スパム対策）を使用する場合の設定 ]
#
# 画像認証機能の使用
# 0 : しない
# 1 : ライブラリ版（pngren.pl）
# 2 : モジュール版（GD::SecurityImage + Image::Magick）→ Image::Magick必須
$cf{use_captcha} = 1;

# 認証用画像生成ファイル【URLパス】
$cf{captcha_cgi} = './captcha.cgi';

# 画像認証プログラム【サーバパス】
$cf{captcha_pl} = './lib/captcha.pl';
$cf{captsec_pl} = './lib/captsec.pl';
$cf{pngren_pl}  = './lib/pngren.pl';

# 画像認証機能用暗号化キー（暗号化/復号化をするためのキー）
# → 適当に変更してください。
$cf{captcha_key} = 'captchakey';

# 投稿キー許容時間（分単位）
# → 投稿フォーム表示後、送信ボタンが押されるまでの可能時間。
$cf{cap_time} = 30;

# 投稿キーの文字数
# ライブラリ版 : 4～8文字で設定
# モジュール版 : 6～8文字で設定
$cf{cap_len} = 6;

# 画像/フォント格納ディレクトリ【サーバパス】
$cf{bin_dir} = './lib/bin';

# [ライブラリ版] 画像ファイル [ ファイル名のみ ]
$cf{si_png} = "casual.png";

# [モジュール版] 画像フォント [ ファイル名のみ ]
$cf{font_ttl} = "tempest.ttf";

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init {
	open(IN,"$cf{datadir}/set.dat");
	while(<IN>) {
		chomp;
		my ($key,$val) = split(/\t/);
		
		$cf{$key} = $val;
	}
	close(IN);
	
	return %cf;
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $buf;
	if ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN,$buf,$ENV{'CONTENT_LENGTH'});
	} else {
		$buf = $ENV{'QUERY_STRING'};
	}
	my %in;
	for ( split(/&/,$buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2",$1)/eg;
		
		# タグ等処理
		$val =~ s/&/&amp;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/\r\n/\t/g;
		$val =~ s/[\r\n]/\t/g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  日付
#-----------------------------------------------------------
sub chg_date {
	my ($time,$new) = @_;
	
	my ($d,$m,$y) = (localtime($time))[3..5];
	return $new eq 'new'
			? sprintf("%04d,%02d,%02d",$y+1900,$m+1,$d)
			: sprintf("%04d/%02d/%02d",$y+1900,$m+1,$d);
}

#-----------------------------------------------------------
#  カテゴリ情報
#-----------------------------------------------------------
sub categ {
	my @categ = split(/;/,$cf{categ});
	my %cat;
	for (0 .. $#categ) {
		my @cat = split(/,/,$categ[$_]);
		
		# 大カテ
		$cat{$_}{0} = $cat[0];
		
		# 小カテ
		for my $c (1 .. $#cat) {
			$cat{$_}{$c} = $cat[$c];
		}
	}
	return %cat;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<div style="margin-top:2.6em;text-align:center;font-size:10px;">
	- <a href="https://www.kent-web.com/">Cosmo Navi</a> -
</div>
EOM

	my $ret;
	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		$ret .= "$1$copy$2\n";
	} else {
		$ret .= "$foot$copy\n";
		$ret .= "</body></html>\n";
	}
	return $ret;
}

#-----------------------------------------------------------
#  カテゴリプルダウン
#-----------------------------------------------------------
sub op_cate {
	my @categ = split(/;/,$cf{categ});
	my $ret;
	for (0 .. $#categ) {
		my @cat = split(/,/,$categ[$_]);
		
		$ret .= qq|<optgroup label="$cat[0]">\n|;
		for my $c (1 .. $#cat) {
			$ret .= qq|<option value="$_:$c">$cat[$c]\n|;
		}
		$ret .= qq|</optgroup>\n|;
	}
	return $ret;
}


1;

