#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Pie Chart : admin.cgi - 2013/08/14
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = init();

# データ受理
my %in = parse_form();

# 認証
check_passwd();

# 管理モード
if ($in{base_init}) { base_init(); }
if ($in{edit_item}) { edit_item(); }
if ($in{edit_vote}) { edit_vote(); }
base_init();

#-----------------------------------------------------------
#  基本設定
#-----------------------------------------------------------
sub base_init {
	# 更新
	if ($in{submit}) {
		open(DAT,"+> $cf{datadir}/init.dat") or error('erite err: init.dat');
		print DAT "title\t$in{ttl}\n";
		print DAT "subttl\t$in{subttl}\n";
		print DAT "wait\t$in{wait}\n";
		print DAT "sel\t$in{sel}\n";
		print DAT "solid\t$in{solid}\n";
		close(DAT);

		doc_msg('更新しました','base_init');
	}

	# 基本設定
	my %set = read_init();

	# 画面表示
	header('基本設定');
	menu_btn();
	print <<EOM;
<div class="body">
<p class="ttl">■ 基本設定</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="base_init" value="1">
<table class="form-tbl">
<tr>
	<th>タイトル</th>
	<td><input type="text" name="ttl" value="$set{title}" size="40"></td>
</tr><tr>
	<th>サブタイトル</th>
	<td><input type="text" name="subttl" value="$set{subttl}" size="40"></td>
</tr><tr>
	<th>回答方式</th>
	<td>
EOM

	my @sel = qw(単一回答のみ 複数回答可能);
	foreach (0,1) {
		if ($set{sel} == $_) {
			print qq|<input type="radio" name="sel" value="$_" checked>$sel[$_]<br>\n|;
		} else {
			print qq|<input type="radio" name="sel" value="$_">$sel[$_]<br>\n|;
		}
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>グラフ表示</th>
	<td>
EOM

	if ($set{solid} == 1) {
		print qq|<input type="checkbox" name="solid" value="1" checked>|;
	} else {
		print qq|<input type="checkbox" name="solid" value="1">|;
	}

	print <<EOM;
	3D表示する</td>
</tr><tr>
	<th>投票制限</th>
	<td>
		<input type="text" name="wait" value="$set{wait}" size="3"> 時間
		（前回投票からの制限時間）
	</td>
</tr>
</table>
<input type="submit" name="submit" value="送信する">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  アンケート項目管理
#-----------------------------------------------------------
sub edit_item {
	my ($edit,$dele);
	foreach ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		} elsif (/^dele:(\d+)/) {
			$dele = $1;
			last;
		}
	}

	# --- 修正
	if ($edit && $in{"name:$edit"} ne '') {
		my @log;
		open(DAT,"+< $cf{datadir}/item.dat");
		while(<DAT>) {
			my ($no,$item) = split(/\t/);

			if ($edit == $no) {
				$_ = qq|$no\t$in{"name:$edit"}\n|;
			}
			push(@log,$_);
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

		doc_msg('項目を修正しました','edit_item');

	# --- 削除
	} elsif ($dele) {
		my @log;
		open(DAT,"+< $cf{datadir}/item.dat");
		while(<DAT>) {
			my ($no,$item) = split(/\t/);
			next if ($dele == $no);

			push(@log,$_);
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

		my @log;
		open(DAT,"+< $cf{datadir}/vote.dat");
		while(<DAT>) {
			my ($no,$vote) = split(/\t/);
			next if ($dele == $no);

			push(@log,$_);
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

	# --- 新規
	} elsif ($in{add} && $in{item} ne '') {
		my ($new,@log);
		open(DAT,"+< $cf{datadir}/item.dat");
		while(<DAT>) {
			my ($no,$item) = split(/\t/);

			if ($new < $no) { $new = $no; }
			push(@log,$_);
		}
		$new++;
		seek(DAT, 0, 0);
		print DAT @log;
		print DAT "$new\t$in{item}\n";
		truncate(DAT, tell(DAT));
		close(DAT);

		open(DAT,">> $cf{datadir}/vote.dat");
		eval "flock(DAT, 2);";
		print DAT "$new\t0\n";
		close(DAT);

		doc_msg('項目を追加しました','edit_item');
	}

	# 画面表示
	header('アンケート項目管理');
	menu_btn();
	print <<EOM;
<div class="body">
<p class="ttl">■ アンケート項目管理</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="edit_item" value="1">
<table class="form-tbl">
<tr>
	<th>新規項目</th>
</tr><tr>
	<td>
		<input type="text" name="item" size="30">
		<input type="submit" name="add" value="追加">
	</td>
</tr>
</table>

<table class="form-tbl">
<tr>
	<th>項目</th>
	<th>操作</th>
</tr>
EOM

	open(IN,"$cf{datadir}/item.dat");
	while(<IN>) {
		chomp;
		my ($no,$item) = split(/\t/);

		print qq|<tr><td><input type="text" name="name:$no" value="$item" size="30"></td>|;
		print qq|<td><input type="submit" name="edit:$no" value="修正">\n|;
		print qq|<input type="submit" name="dele:$no" value="削除"></td></tr>\n|;
	}
	close(IN);

	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  投票データ管理
#-----------------------------------------------------------
sub edit_vote {
	my $edit;
	foreach ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		}
	}
	if ($edit && $in{"vote:$edit"}) {
		my @log;
		open(DAT,"+< $cf{datadir}/vote.dat");
		eval "flock(DAT, 2);";
		while(<DAT>) {
			my ($no,$vote) = split(/\t/);

			if ($edit == $no) {
				$_ = qq|$no\t$in{"vote:$edit"}\n|;
			}
			push(@log,$_);
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

		doc_msg('投票数を修正しました','edit_vote');
	}

	my %item;
	open(IN,"$cf{datadir}/item.dat");
	while(<IN>) {
		chomp;
		my ($no,$item) = split(/\t/);

		$item{$no} = $item;
	}
	close(IN);

	# 画面表示
	header('投票データ管理');
	menu_btn();
	print <<EOM;
<div class="body">
<p class="ttl">■ 投票データ管理</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="edit_vote" value="1">
<table class="form-tbl">
<tr>
	<th>項目名</th>
	<th>投票数</th>
</tr>
EOM

	open(IN,"$cf{datadir}/vote.dat");
	while(<IN>) {
		chomp;
		my ($no,$vote) = split(/\t/);

		print qq|<tr><td>$item{$no}</td>|;
		print qq|<td><input type="text" name="vote:$no" value="$vote" size="4">\n|;
		print qq|<input type="submit" name="edit:$no" value="修正"></td></tr>\n|;
	}
	close(IN);

	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;

	print <<EOM;
Content-type: text/html; charset=utf-8

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta http-equiv="content-style-type" content="text/css">
<style type="text/css">
<!--
body,td,th { font-size:80%; background:#f0f0f0; font-family:Verdana,Helvetica,Arial; }
p.ttl { font-weight:bold; color:#004080; border-bottom:1px solid #004080; padding:2px; width:100%; }
table.form-tbl { border-collapse:collapse; margin:1em 0; }
table.form-tbl th { border:1px solid #333; background:#d2e9ff; padding:4px; }
table.form-tbl td { border:1px solid #333; background:#fff; padding:4px; }
table.form-tbl span { color:green; }
table.menu-btn { border-collapse:collapse; width:190px; }
table.menu-btn th { border:1px solid #383872; background:#cccce6; padding:4px; height:38px; }
table.menu-btn input { width:140px; }
div.menu { float:left; width:200px; padding:1.5em; }
div.body { float:left; padding:1.5em; }
.ta-c { text-align:center; }
.err { color:#dd0000; }
-->
</style>
<title>$ttl</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  パスワード認証
#-----------------------------------------------------------
sub check_passwd {
	# パスワードが未入力の場合は入力フォーム画面
	if ($in{pass} eq "") {
		enter_form();

	# パスワード認証
	} elsif ($in{pass} ne $cf{password}) {
		error("認証できません");
	}
}

#-----------------------------------------------------------
#  メニューボタン
#-----------------------------------------------------------
sub menu_btn {
	my %menu = (
		edit_init => '基本設定',
		edit_item => 'アンケート項目管理',
		edit_vote => '投票データ管理',
	);

	print <<EOM;
<div class="menu">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<table class="menu-btn">
EOM

	foreach ( 'edit_init','edit_item','edit_vote' ) {
		if ($in{$_}) {
			print qq|<tr><th><input type="submit" name="$_" value="$menu{$_}" disabled></th></tr>\n|;
		} else {
			print qq|<tr><th><input type="submit" name="$_" value="$menu{$_}"></th></tr>\n|;
		}
	}

	print <<EOM;
<tr>
	<th><input type="button" value="チャート画面" onclick="window.open('$cf{chart_cgi}','_self')"></th>
</tr><tr>
	<th><input type="button" value="ログオフ" onclick="window.open('$cf{admin_cgi}','_self')"></th>
</tr>
</table>
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub doc_msg {
	my ($msg,$job) = @_;

	header($msg);
	print <<EOM;
<div align="center" style="margin-top:3em;">
<hr width="350">
<p style="color:green">$msg</p>
<hr width="350">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="$job" value="1">
<input type="submit" value="一覧画面に戻る">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $msg = shift;

	header("ERROR!");
	print <<EOM;
<div align="center">
<hr width="350">
<h3>ERROR!</h3>
<p class="err">$msg</p>
<hr width="350">
<form>
<input type="button" value="前画面に戻る" onclick="history.back()">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	header("入室画面");
	print <<EOM;
<div align="center">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="look_log" value="1">
<table width="380" style="margin-top:50px">
<tr>
	<td height="40" align="center">
		<fieldset><legend>パスワード入力</legend><br>
		<input type="password" name="pass" value="" size="20">
		<input type="submit" value=" 認証 "><br><br>
		</fieldset>
	</td>
</tr>
</table>
</form>
<script language="javascript">
<!--
self.document.forms[0].pass.focus();
//-->
</script>
</div>
</body>
</html>
EOM
	exit;
}

