#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Pie Chart : check.cgi - 2013/08/14
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 外部ファイル取込み
require './init.cgi';
my %cf = init();

print <<EOM;
Content-type: text/html; charset=utf-8

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
EOM

# データ
my %log = (
	'item.dat' => '項目ファイル',
	'vote.dat' => '投票ファイル',
	'init.dat' => '設定ファイル',
	);
foreach ( keys %log ) {
	if (-f "$cf{datadir}/$_") {
		print "<li>$log{$_}パス : OK\n";

		if (-r "$cf{datadir}/$_" && -w "$cf{datadir}/$_") {
			print "<li>$log{$_}パーミッション : OK\n";
		} else {
			print "<li>$log{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$log{$_}パス : NG\n";
	}
}

# テンプレート
for (qw(chart form mesg)) {
	if (-e "$cf{tmpldir}/$_.html") {
		print "<li>テンプレート( $_.html ) : OK\n";
	} else {
		print "<li>テンプレート( $_.html ) : NG\n";
	}
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;


