#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Web Quiz : admin.cgi - 2014/11/16
#│ copyright (c) KentWeb, 1997-2014
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use CGI::Minimal;

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
my %in = parse_form($cgi);

# 認証
enter_auth();

# 管理モード
if ($in{quiz_add})  { quiz_add(); }
if ($in{quiz_edit}) { quiz_edit(); }
if ($in{look_logs}) { look_logs(); }
quiz_edit();

#-----------------------------------------------------------
#  設問データ追加
#-----------------------------------------------------------
sub quiz_add {
	my $log = shift;
	my ($no,$mon,$op,$kai,$img) = split(/<>/,$log);
	$mon =~ s|<br />|\n|g;
	my @op = split(/\s+/,$op) if ($op);
	
	# 追加
	if ($in{add}) {
		# チェック
		check_form();
		
		# 採番
		open(DAT,"+< $cf{datadir}/quiz.num") or error('open err: quiz.num');
		my $num = <DAT> + 1;
		seek(DAT, 0, 0);
		print DAT $num;
		truncate(DAT, tell(DAT));
		close(DAT);
		
		# 画像アップ
		my $ex = upload_img($num) if ($in{upfile} ne '');
		
		# 選択肢
		my $op = join(' ',$cgi->param('op'));
		
		# データ追加
		my $img = $ex ne '' ? "$num.$ex" : "";
		my $i = 0;
		open(DAT,"+>> $cf{datadir}/quiz.dat") or error('open err: quiz.dat');
		print DAT "$num<>$in{mon}<>$op<>$in{kai}<>$img<>\n";
		seek(DAT,0,0);
		++$i while(<DAT>);
		close(DAT);
		
		# index更新
		open(DAT,"> $cf{datadir}/quiz.idx") or error('open err: quiz.idx');
		print DAT $i;
		close(DAT);
		
		# 完了
		doc_msg('設問を追加しました','quiz_add');
	}
	
	my $mode = $log eq '' ? 'quiz_add' : 'quiz_edit';
	
	# 画面表示
	header('設問データ追加');
	menu_btn();
	print <<EOM;
<div class="body">
<div class="cont">
<p class="ttl">■ 設問データ追加</p>
<p>・ 必要情報をしてください。画像以外は入力必須です。</p>
EOM

	if ($log) {
		print qq|<div class="ta-r">\n|;
		print qq|<form action="$cf{admin_cgi}" method="post">\n|;
		print qq|<input type="hidden" name="pass" value="$in{pass}" />\n|;
		print qq|<input type="hidden" name="quiz_edit" value="1" />\n|;
		print qq|<input type="submit" name="add" value="&lt; 一覧へ戻る" />\n|;
		print qq|</form></div>\n|;
	}

	print <<EOM;
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="pass" value="$in{pass}" />
<input type="hidden" name="$mode" value="1" />
<input type="hidden" name="job_edit" value="$no" />
<table class="form-tbl">
<tr>
	<th>設問</th>
	<td><textarea name="mon" cols="50" rows="6">$mon</textarea></td>
</tr><tr>
	<th>画像</th>
	<td>
		<span>（対応画像：JPEG/GIF/PNG）</span><br />
		<input type="file" name="upfile" size="35" />
EOM

	if ($img) {
		print qq|&nbsp; [<a href="$cf{imgurl}/$img" target="_blank">画像</a>]\n|;
		print qq|<input type="checkbox" name="del" value="1" />削除\n|;
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>選択肢</th>
	<td>
		<span>（半角スペースは使用禁止）</span><br />
EOM

	my $sel_kai;
	for ( 1 .. $cf{quiz_op} ) {
		print qq|[$_] <input type="text" name="op" size="40" value="$op[$_-1]" /><br />\n|;
		
		if ($kai == $_) {
			$sel_kai .= qq|<input type="radio" name="kai" value="$_" checked="checked">[$_]&nbsp;\n|;
		} else {
			$sel_kai .= qq|<input type="radio" name="kai" value="$_" />[$_]&nbsp;\n|;
		}
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>正解</th>
	<td>$sel_kai</td>
</tr>
</table>
<input type="submit" name="add" value="送信する" />
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  設問データ管理
#-----------------------------------------------------------
sub quiz_edit {
	# --- 修正実行
	if ($in{job_edit}) { edit_data(); }
	
	# 操作認識
	my ($edit,$dele);
	for ( keys %in ) {
		if (/^edit:(\d+)/) {
			$edit = $1;
			last;
		} elsif (/^dele:(\d+)/) {
			$dele = $1;
			last;
		}
	}

	# --- 修正フォーム
	if ($edit) {
		my $log;
		open(DAT,"$cf{datadir}/quiz.dat");
		while(<DAT>) {
			my ($no) = (split(/\t/))[0];
			if ($edit == $no) {
				$log = $_;
				last;
			}
		}
		close(DAT);
		
		quiz_add($log);

	# --- 削除
	} elsif ($dele) {
		my @log;
		open(DAT,"+< $cf{datadir}/quiz.dat");
		while(<DAT>) {
			my ($no,$mon,$op,$kai,$img) = split(/<>/);
			
			if ($dele == $no) {
				unlink("$cf{imgdir}/$img") if ($img);
				next;
			}
			push(@log,$_);
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);
		
		# index更新
		my $i = @log;
		open(DAT,"> $cf{datadir}/quiz.idx") or error('open err: quiz.idx');
		print DAT $i;
		close(DAT);
	}

	# 画面表示
	header('設問データ管理');
	menu_btn();
	print <<EOM;
<div class="body">
<div class="cont">
<p class="ttl">■ 設問データ管理</p>
<p>・ 修正又は削除ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}" />
<input type="hidden" name="quiz_edit" value="1" />
<table class="form-tbl">
<tr>
	<th>操作</th>
	<th>設問</th>
	<th>画像</th>
</tr>
EOM

	open(IN,"$cf{datadir}/quiz.dat");
	while(<IN>) {
		my ($no,$mon,$op,$kai,$img) = split(/<>/);
		$mon = cut_str($mon);
		$img = qq|<a href="$cf{imgurl}/$img" target="_blank">$img</a>| if ($img);

		print qq|<tr><td><input type="submit" name="edit:$no" value="修正">\n|;
		print qq|<input type="submit" name="dele:$no" value="削除" onclick="return confirm('削除しますか？');" />\n|;
		print qq|<td>$mon</td>|;
		print qq|<td>$img</td></tr>\n|;
	}
	close(IN);

	print <<EOM;
</table>
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  ログ管理
#-----------------------------------------------------------
sub look_logs {
	# 削除
	if ($in{job_del}) { del_log(); }

	# 画面表示
	header('ログ管理');
	menu_btn();
	print <<EOM;
<div class="body">
<div class="cont">
<p class="ttl">■ ログ管理</p>
<p>・ ログを削除する場合は、該当ログにチェックを入れ削除ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<p>
種別： <select name="type">
EOM

	my %op = (log => 'ログデータ', rank => 'ランキング');
	for (qw(log rank)) {
		if ($in{type} eq $_) {
			print qq|<option value="$_" selected="selected">$op{$_}\n|;
		} else {
			print qq|<option value="$_">$op{$_}\n|;
		}
	}

	print <<EOM;
<input type="submit" value="切替" />
</select>
</p>
<input type="hidden" name="pass" value="$in{pass}" />
<input type="hidden" name="look_logs" value="1" />
<input type="submit" name="job_del" value="削除" onclick="return confirm('削除しますか？');" />
EOM

	my $log = $in{type} eq 'rank' ? 'rank.dat' : 'log.dat';

	open(IN,"$cf{datadir}/$log");
	while(<IN>) {
		chomp;
		my ($time,$name,$pt,$cid,$chal,$ans,$ptm,$ip) = split(/\t/);
		my $date = chg_date($time);

		print qq|<div class="log"><input type="checkbox" name="del" value="$time" />|;
		print qq|$date &nbsp; 名前：<b>$name</b> &nbsp; 得点：<b>$pt</b>\n|;
		print qq|<div class="hos">[IP] $ip [挑戦回数] $chal</div></div>\n|;
	}
	close(IN);

	print <<EOM;
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  修正実行
#-----------------------------------------------------------
sub edit_data {
	# チェック
	check_form();
	
	# 選択肢
	my $op = join(' ',$cgi->param('op'));

	# 画像アップ
	my $ex = upload_img($in{job_edit}) if ($in{upfile} ne '');
	
	my @log;
	open(DAT,"+< $cf{datadir}/quiz.dat");
	while(<DAT>) {
		my ($no,$mon,$opt,$kai,$img) = split(/<>/);
		
		if ($in{job_edit} == $no) {
		
			# 画像削除のとき
			if ($in{del}) {
				unlink("$cf{imgdir}/$img");
				$img = '';
			}
			if ($ex) {
				if ($img && $img ne "$no.$ex") {
					unlink("$cf{imgdir}/$img");
				}
				$img = "$no.$ex";
			}
			# 画像アップ
			$_ = "$no<>$in{mon}<>$op<>$in{kai}<>$img<>\n";
		}
		push(@log,$_);
	}
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  ログ削除
#-----------------------------------------------------------
sub del_log {
	my %del;
	for ( $cgi->param('del') ) { $del{$_}++; }
	
	my $log = $in{type} eq 'rank' ? 'rank.dat' : 'log.dat';
	
	my @log;
	open(DAT,"+< $cf{datadir}/$log");
	eval "flock(DAT,2);";
	while(<DAT>) {
		my ($time) = (split(/\t/))[0];
		next if (defined($del{$time}));
		
		push(@log,$_);
	}
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;

	print <<EOM;
Content-type: text/html; charset=utf-8

<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="content-style-type" content="text/css" />
<style type="text/css">
<!--
body { font-size:80%; background:#dfd4be; font-family:Verdana,"MS PGothic",Osaka,Arial,sans-serif; }
p.ttl { font-weight:bold; color:#6b3636; border-bottom:1px dotted #6b3636; padding:5px; }
table.form-tbl { border-collapse:collapse; margin:1em 0; }
table.form-tbl th, table.form-tbl td { border:1px solid #535353; padding:5px; }
table.form-tbl th { background:#dbdbdb; }
table.form-tbl td { background:#fff; }
table.form-tbl span { color:darkgreen; }
table.menu-btn { border-collapse:collapse; width:160px; margin:0 auto; }
table.menu-btn th { border:1px solid #666; background:#eee; padding:4px; height:38px; }
table.menu-btn input { width:130px; }
div.menu { float:left; width:180px; }
div.body { margin-left:180px; }
div.navi { padding:1em; text-align:center; }
div.cont { padding:0.5em 1em; }
.ta-c { text-align:center; }
.ta-r { text-align:right; }
.err { color:#dd0000; }
p.msg { color:darkgreen; margin:3em; }
div.log { border-top:1px dotted #333; padding:4px; margin-top:5px; }
div.log b { color:#006f00; }
div.hos { margin-left:2em; font-size:90%; color:#666; }
div#enter-box { width:400px; margin:5em auto; }
div#enter-box fieldset { width:300px; padding:3em; }
div.msg-box { border-top:1px dashed #381d1d; border-bottom:1px dashed #381d1d; margin:4em auto; width:30em; }
-->
</style>
<title>$ttl</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  パスワード認証
#-----------------------------------------------------------
sub enter_auth {
	# パスワードが未入力の場合は入力フォーム画面
	if ($in{pass} eq "") {
		enter_form();

	# パスワード認証
	} elsif ($in{pass} ne $cf{password}) {
		error("認証できません");
	}
}

#-----------------------------------------------------------
#  メニューボタン
#-----------------------------------------------------------
sub menu_btn {
	my @menu = (
		'quiz_add:設問データ追加',
		'quiz_edit:設問データ編集',
		'look_logs:ログ管理',
	);

	print <<EOM;
<div class="menu">
<div class="navi">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}" />
<table class="menu-btn">
EOM

	for (@menu) {
		my ($key,$val) = split(/:/);
		if ($in{$key} ne '') {
			print qq|<tr><th><input type="submit" name="$key" value="$val" disabled="disabled" /></th></tr>\n|;
		} else {
			print qq|<tr><th><input type="submit" name="$key" value="$val" /></th></tr>\n|;
		}
	}

	print <<EOM;
<tr>
	<th><input type="button" value="クイズ画面" onclick="window.open('$cf{quiz_cgi}?','_self')" /></th>
</tr><tr>
	<th><input type="button" value="ログオフ" onclick="window.open('$cf{admin_cgi}','_self')" /></th>
</tr>
</table>
</form>
</div>
</div>
EOM
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub doc_msg {
	my ($msg,$job) = @_;

	header($msg);
	print <<EOM;
<div class="ta-c">
<div class="msg-box">
<p class="msg">$msg</p>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}" />
<input type="hidden" name="$job" value="1" />
<input type="submit" value="一覧画面に戻る" />
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $msg = shift;

	header("ERROR!");
	print <<EOM;
<div class="ta-c">
<div class="msg-box">
<h3>ERROR!</h3>
<p class="err">$msg</p>
</div>
<input type="button" value="前画面に戻る" onclick="history.back()" />
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	header("入室画面");
	print <<EOM;
<div class="ta-c">
<form action="$cf{admin_cgi}" method="post">
<div id="enter-box">
	<fieldset>
		<legend>管理パスワード入力</legend>
		<input type="password" name="pass" size="26" />
		<input type="submit" value=" 認証 " />
	</fieldset>
</div>
</form>
<script type="text/javascript">
//<![CDATA[
self.document.forms[0].pass.focus();
//]]>
</script>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;

	my %in;
	foreach ( $cgi->param() ) {
		my $val = $cgi->param($_);

		if ($_ ne 'upfile') {
			# 無効化
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/'/&#39;/g;

			# 改行処理
			$val =~ s|\r\n|<br />|g;
			$val =~ s|[\r\n]|<br />|g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  添付アップロード
#-----------------------------------------------------------
sub upload_img {
	my $no = shift;
	
	# 拡張子取得
	my $ext = $cgi->param_filename('upfile') =~ /\.(jpe?g|gif|png)$/i ? $1 : return;
	$ext =~ tr/A-Z/a-z/;
	if ($ext eq 'jpeg') { $ext = 'jpg'; }

	# 添付ファイル定義
	my $upfile = "$cf{imgdir}/$no.$ext";

	# アップロード書き込み
	open(UP,"+> $upfile") or error("up err: $upfile");
	binmode(UP);
	print UP $in{upfile};
	close(UP);

	chmod(0666, $upfile);

	# 結果を返す
	return $ext;
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_form {
	my $err;
	if ($in{mon} eq '') { $err .= "設問が未入力です<br />\n"; }
	my $flg;
	for ( $cgi->param('op') ) {
		if ($_ eq '') { $flg++; last; }
	}
	if ($flg) { $err .= "選択肢に未入力があります<br />\n"; }
	if ($in{kai} eq '') { $err .= "正解が未選択です<br />\n"; }
	error($err) if ($flg);
}

#-----------------------------------------------------------
#  件名文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my $str = shift;
	$str =~ s|<br />||g;

	my $i = 0;
	my $ret;
	while($str =~ /([0-9a-zA-Z_-]|[\xE0-\xEF][\x80-\xBF]{2})/gx) {
		$i++;
		$ret .= $1;
		last if ($i >= 30);
	}
	return $ret;
}

