#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Web Quiz : check.cgi - 2014/11/16
#│ copyright (c) KentWeb, 1997-2014
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 外部ファイル取込み
require './init.cgi';
my %cf = set_init();

print <<EOM;
Content-type: text/html; charset=utf-8

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
<li>Perlバージョン : $]
EOM

# ログファイル
my %log = (
		'ip.dat'   => 'IPファイル',
		'log.dat'  => 'ログファイル',
		'quiz.dat' => 'クイズデータ',
		'quiz.idx' => 'クイズindexデータ',
		'quiz.num' => 'クイズ通番データ',
		'rank.dat' => 'ランクデータ',
		'rank.idx' => 'ランクindexデータ',
	);
foreach ( keys %log ) {
	if (-e "$cf{datadir}/$_") {
		print "<li>$log{$_}パス : OK\n";
		if (-r "$cf{datadir}/$_" && -w "$cf{datadir}/$_") {
			print "<li>$log{$_}パーミッション : OK\n";
		} else {
			print "<li>$log{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$log{$_}パス : NG\n";
	}
}

# ディレクトリ
my %dir = (
		$cf{imgdir}  => '画像ディレクトリ',
		"$cf{datadir}/ses"  => 'セッションディレクトリ',
	);
foreach ( keys %dir ) {
	if (-d $_) {
		print "<li>$dir{$_}パス : OK\n";
		if (-r $_ && -w $_ && -x $_) {
			print "<li>$dir{$_}パーミッション : OK\n";
		} else {
			print "<li>$dir{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$dir{$_}パス : NG\n";
	}
}

# テンプレート
foreach (qw(quiz form result error rank record)) {
	if (-e "$cf{tmpldir}/$_.html") {
		print "<li>テンプレート( $_.html ) : OK\n";
	} else {
		print "<li>テンプレート( $_.html ) : NG\n";
	}
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;


